/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.graphql.dataFetchers;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.admin.application.web.TenantApplicationService;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.domain.tenant.model.TenantInvitation;
import de.justsoftware.admin.graphql.dataFetchers.util.ModelConverterKt;
import de.justsoftware.admin.graphql.generated.types.Tenant;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import graphql.schema.DataFetchingEnvironment;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DgsComponent
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0012\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0017J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0017J&\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\bH\u0017J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\nH\u0017J&\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\n\b\u0001\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lde/justsoftware/admin/graphql/dataFetchers/TenantSettingsFetcher;", "", "applicationService", "Lde/justsoftware/admin/application/web/TenantApplicationService;", "(Lde/justsoftware/admin/application/web/TenantApplicationService;)V", "getApplicationService", "()Lde/justsoftware/admin/application/web/TenantApplicationService;", "deeplKey", "", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "globalHighlightColorByTenant", "logoId", "setTenantInvitationActive", "Lde/justsoftware/admin/graphql/generated/types/Tenant;", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "isInvitationActive", "", "setTenantLogo", "tenantInvitation", "Lde/justsoftware/admin/graphql/generated/types/TenantInvitation;", "updateDeeplKey", "admin-service"})
public class TenantSettingsFetcher {
    @NotNull
    private final TenantApplicationService applicationService;

    public TenantSettingsFetcher(@NotNull TenantApplicationService applicationService) {
        Intrinsics.checkNotNullParameter((Object)applicationService, (String)"applicationService");
        this.applicationService = applicationService;
    }

    @NotNull
    public TenantApplicationService getApplicationService() {
        return this.applicationService;
    }

    @DgsData(parentType="Tenant", field="deeplKey")
    @Nullable
    public String deeplKey(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Tenant tenant = (Tenant)dfe.getSource();
        return this.getApplicationService().getTenantSettings(tenant.getId(), (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)).getDeeplKey();
    }

    @DgsData(parentType="Tenant", field="globalHighlightColor")
    @NotNull
    public String globalHighlightColorByTenant(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Tenant tenant = (Tenant)dfe.getSource();
        return this.getApplicationService().getTenantSettings(tenant.getId(), (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)).getGlobalHighlightColor().toString();
    }

    @DgsData(parentType="Tenant", field="logoId")
    @Nullable
    public String logoId(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Tenant tenant = (Tenant)dfe.getSource();
        Object object = this.getApplicationService().getTenantSettings(tenant.getId(), (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)).getLogoId();
        return object != null && (object = object.getId()) != null ? ((UUID)object).toString() : null;
    }

    @DgsData(parentType="Tenant", field="tenantInvitation")
    @Nullable
    public de.justsoftware.admin.graphql.generated.types.TenantInvitation tenantInvitation(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Tenant tenant = (Tenant)dfe.getSource();
        TenantInvitation tenantInvitation = this.getApplicationService().getTenantInvitation(tenant.getId(), (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        return tenantInvitation != null ? ModelConverterKt.toGql((TenantInvitation)tenantInvitation) : null;
    }

    @DgsMutation(field="setTenantInvitationActive")
    @NotNull
    public Tenant setTenantInvitationActive(@NotNull DgsDataFetchingEnvironment dfe, @InputArgument @NotNull TenantId tenantId, @InputArgument boolean isInvitationActive) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.getApplicationService().setTenantInvitationActive(tenantId, isInvitationActive, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsMutation(field="setTenantLogo")
    @NotNull
    public Tenant setTenantLogo(@NotNull DgsDataFetchingEnvironment dfe, @InputArgument @NotNull TenantId tenantId, @InputArgument @Nullable String logoId) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.getApplicationService().setLogo(tenantId, logoId, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsMutation(field="updateDeeplKey")
    @NotNull
    public Tenant updateDeeplKey(@NotNull DgsDataFetchingEnvironment dfe, @InputArgument @NotNull TenantId tenantId, @InputArgument @Nullable String deeplKey) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.getApplicationService().updateDeeplKey(tenantId, deeplKey, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }
}

