/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.graphql.dataFetchers;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.DgsQuery;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.admin.application.web.TenantApplicationService;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.graphql.dataFetchers.util.FetcherUtilsKt;
import de.justsoftware.admin.graphql.dataFetchers.util.ModelConverterKt;
import de.justsoftware.admin.graphql.generated.types.ColorThemeInput;
import de.justsoftware.admin.graphql.generated.types.Tenant;
import de.justsoftware.admin.graphql.generated.types.TenantPermission;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DgsComponent
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\u001a\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u001a\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\u0010\u001a\u00020\u000eH\u0017J\u001a\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\u0010\u001a\u00020\u000eH\u0017J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\b\u0001\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0017J$\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\u0010\u001a\u00020\u000e2\b\b\u0001\u0010\u0016\u001a\u00020\u0017H\u0017J$\u0010\u0018\u001a\u00020\u00062\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/admin/graphql/dataFetchers/TenantFetcher;", "", "applicationService", "Lde/justsoftware/admin/application/web/TenantApplicationService;", "(Lde/justsoftware/admin/application/web/TenantApplicationService;)V", "createTenant", "Lde/justsoftware/admin/graphql/generated/types/Tenant;", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "name", "", "deleteTenant", "", "id", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "resetAppColors", "tenantId", "resetGlobalHighlightColor", "tenant", "tenants", "", "updateColorTheme", "input", "Lde/justsoftware/admin/graphql/generated/types/ColorThemeInput;", "updateTenant", "admin-service"})
@SourceDebugExtension(value={"SMAP\nTenantFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TenantFetcher.kt\nde/justsoftware/admin/graphql/dataFetchers/TenantFetcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n1549#2:118\n1620#2,3:119\n*S KotlinDebug\n*F\n+ 1 TenantFetcher.kt\nde/justsoftware/admin/graphql/dataFetchers/TenantFetcher\n*L\n59#1:118\n59#1:119,3\n*E\n"})
public class TenantFetcher {
    @NotNull
    private final TenantApplicationService applicationService;

    public TenantFetcher(@NotNull TenantApplicationService applicationService) {
        Intrinsics.checkNotNullParameter((Object)applicationService, (String)"applicationService");
        this.applicationService = applicationService;
    }

    @DgsQuery(field="tenant")
    @Nullable
    public Tenant tenant(@InputArgument @NotNull TenantId id, @NotNull DgsDataFetchingEnvironment dfe) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        if (FetcherUtilsKt.isIdOnlyQuery((DataFetchingEnvironment)((DataFetchingEnvironment)dfe))) {
            object = new Tenant.Builder().withId(id).build();
        } else {
            de.justsoftware.admin.domain.tenant.model.Tenant tenant = this.applicationService.findOne(id, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
            object = tenant != null ? ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)tenant) : null;
        }
        return object;
    }

    @DgsData(parentType="TenantPermission", field="tenant")
    @NotNull
    public Tenant tenant(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        TenantId tenantId = ((TenantPermission)dfe.getSource()).getTenantId();
        return FetcherUtilsKt.isIdOnlyQuery((DataFetchingEnvironment)((DataFetchingEnvironment)dfe)) ? new Tenant.Builder().withId(tenantId).build() : ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.applicationService.getOne(tenantId, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    /*
     * WARNING - void declaration
     */
    @DgsQuery(field="tenants")
    @NotNull
    public List<Tenant> tenants(@NotNull DgsDataFetchingEnvironment dfe) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Iterable $this$map$iv = this.applicationService.getAllTenants((AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            de.justsoftware.admin.domain.tenant.model.Tenant tenant = (de.justsoftware.admin.domain.tenant.model.Tenant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)it));
        }
        return (List)destination$iv$iv;
    }

    @DgsMutation(field="createTenant")
    @NotNull
    public Tenant createTenant(@NotNull DgsDataFetchingEnvironment dfe, @InputArgument @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.applicationService.createTenant(name, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsMutation(field="updateTenant")
    @NotNull
    public Tenant updateTenant(@InputArgument @NotNull TenantId id, @InputArgument @NotNull String name, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.applicationService.updateTenantName(id, name, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsMutation(field="deleteTenant")
    public boolean deleteTenant(@InputArgument @NotNull TenantId id, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        this.applicationService.deleteTenant(id, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        return true;
    }

    @DgsMutation(field="resetAppColors")
    @NotNull
    public Tenant resetAppColors(@NotNull DgsDataFetchingEnvironment dfe, @InputArgument @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.applicationService.resetAppColors(tenantId, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsMutation(field="resetGlobalHighlightColor")
    @NotNull
    public Tenant resetGlobalHighlightColor(@NotNull DgsDataFetchingEnvironment dfe, @InputArgument @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.applicationService.resetGlobalHighlightColor(tenantId, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsMutation(field="updateColorTheme")
    @NotNull
    public Tenant updateColorTheme(@NotNull DgsDataFetchingEnvironment dfe, @InputArgument @NotNull TenantId tenantId, @InputArgument @NotNull ColorThemeInput input) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.applicationService.updateColorTheme(tenantId, ModelConverterKt.toDomain((ColorThemeInput)input), (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }
}

