/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.user;

import de.justsoftware.admin.domain.user.UserService;
import de.justsoftware.admin.domain.user.model.Grantee;
import de.justsoftware.admin.domain.user.model.Profile;
import de.justsoftware.admin.domain.user.model.UserGroup;
import de.justsoftware.admin.domain.user.persistence.ProfileDao;
import de.justsoftware.admin.domain.user.persistence.ProfileTenantDao;
import de.justsoftware.admin.domain.user.persistence.UserGroupDao;
import de.justsoftware.admin.model.itemid.impl.GranteeId;
import de.justsoftware.admin.model.itemid.impl.GranteeType;
import de.justsoftware.admin.model.itemid.impl.ProfileId;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import de.justsoftware.admin.model.itemid.impl.UserGroupId;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0012H\u0016J\u0018\u0010 \u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lde/justsoftware/admin/domain/user/UserService;", "", "profileDao", "Lde/justsoftware/admin/domain/user/persistence/ProfileDao;", "userGroupDao", "Lde/justsoftware/admin/domain/user/persistence/UserGroupDao;", "profileTenantDao", "Lde/justsoftware/admin/domain/user/persistence/ProfileTenantDao;", "(Lde/justsoftware/admin/domain/user/persistence/ProfileDao;Lde/justsoftware/admin/domain/user/persistence/UserGroupDao;Lde/justsoftware/admin/domain/user/persistence/ProfileTenantDao;)V", "deleteProfile", "Lde/justsoftware/admin/model/itemid/impl/ProfileId;", "profileId", "deleteProfileTenantRelation", "", "deleteUserGroup", "Lde/justsoftware/admin/model/itemid/impl/UserGroupId;", "userGroupId", "findProfile", "Lde/justsoftware/admin/domain/user/model/Profile;", "findUserGroup", "Lde/justsoftware/admin/domain/user/model/UserGroup;", "getAllTenantUsersGroup", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "getAllUserGroups", "", "getOne", "Lde/justsoftware/admin/domain/user/model/Grantee;", "id", "Lde/justsoftware/admin/model/itemid/impl/GranteeId;", "saveProfile", "profile", "saveProfileTenantRelation", "saveUserGroup", "userGroup", "admin-service"})
public class UserService {
    @NotNull
    private final ProfileDao profileDao;
    @NotNull
    private final UserGroupDao userGroupDao;
    @NotNull
    private final ProfileTenantDao profileTenantDao;

    public UserService(@NotNull ProfileDao profileDao, @NotNull UserGroupDao userGroupDao, @NotNull ProfileTenantDao profileTenantDao) {
        Intrinsics.checkNotNullParameter((Object)profileDao, (String)"profileDao");
        Intrinsics.checkNotNullParameter((Object)userGroupDao, (String)"userGroupDao");
        Intrinsics.checkNotNullParameter((Object)profileTenantDao, (String)"profileTenantDao");
        this.profileDao = profileDao;
        this.userGroupDao = userGroupDao;
        this.profileTenantDao = profileTenantDao;
    }

    @NotNull
    public Profile saveProfile(@NotNull Profile profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        this.profileDao.save(profile);
        return profile;
    }

    @NotNull
    public UserGroup saveUserGroup(@NotNull UserGroup userGroup) {
        Intrinsics.checkNotNullParameter((Object)userGroup, (String)"userGroup");
        this.userGroupDao.save$admin_service(userGroup);
        return userGroup;
    }

    public void saveProfileTenantRelation(@NotNull ProfileId profileId, @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.profileTenantDao.save(profileId, tenantId);
    }

    public void deleteProfileTenantRelation(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.profileTenantDao.deleteByProfile(profileId);
    }

    @NotNull
    public ProfileId deleteProfile(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.profileDao.delete(profileId);
        this.profileTenantDao.deleteByProfile(profileId);
        return profileId;
    }

    @NotNull
    public UserGroupId deleteUserGroup(@NotNull UserGroupId userGroupId) {
        Intrinsics.checkNotNullParameter((Object)userGroupId, (String)"userGroupId");
        this.userGroupDao.delete(userGroupId);
        return userGroupId;
    }

    @Nullable
    public Profile findProfile(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        return this.profileDao.findOne(profileId);
    }

    @Nullable
    public UserGroup findUserGroup(@NotNull UserGroupId userGroupId) {
        Intrinsics.checkNotNullParameter((Object)userGroupId, (String)"userGroupId");
        return this.userGroupDao.findOne(userGroupId);
    }

    @NotNull
    public List<UserGroup> getAllUserGroups() {
        return this.userGroupDao.getAll();
    }

    @NotNull
    public Grantee getOne(@NotNull GranteeId id) {
        Grantee grantee;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        switch (WhenMappings.$EnumSwitchMapping$0[GranteeType.Companion.fromGranteeId(id.asItemId()).ordinal()]) {
            case 1: {
                grantee = (Grantee)this.profileDao.getOne((ProfileId)id);
                break;
            }
            case 2: {
                grantee = (Grantee)this.userGroupDao.getOne$admin_service((UserGroupId)id);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return grantee;
    }

    @NotNull
    public UserGroup getAllTenantUsersGroup(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.userGroupDao.getAllTenantUsersGroup(tenantId);
    }
}

