/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.tenant;

import de.justsoftware.admin.domain.tenant.model.TenantPermission;
import de.justsoftware.admin.domain.tenant.persistence.TenantPermissionRepository;
import de.justsoftware.admin.model.Role;
import de.justsoftware.admin.model.itemid.impl.GranteeId;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0012J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J+\u0010\u0011\u001a\u00020\u00062!\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00060\u0013H\u0016J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\nH\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J2\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/justsoftware/admin/domain/tenant/TenantPermissionService;", "", "tenantPermissionRepo", "Lde/justsoftware/admin/domain/tenant/persistence/TenantPermissionRepository;", "(Lde/justsoftware/admin/domain/tenant/persistence/TenantPermissionRepository;)V", "checkRemainingManagers", "", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "add", "", "Lde/justsoftware/admin/model/itemid/impl/GranteeId;", "remove", "deleteAllFor", "Lde/justsoftware/admin/domain/tenant/model/TenantPermission;", "granteeId", "findBy", "forEachPermission", "consumer", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "tenantPermission", "save", "tenantPermissions", "savePermission", "update", "adds", "", "removes", "admin-service"})
@SourceDebugExtension(value={"SMAP\nTenantPermissionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TenantPermissionService.kt\nde/justsoftware/admin/domain/tenant/TenantPermissionService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1549#2:127\n1620#2,3:128\n766#2:131\n857#2,2:132\n1549#2:134\n1620#2,3:135\n766#2:138\n857#2,2:139\n1549#2:141\n1620#2,3:142\n1855#2:145\n766#2:146\n857#2,2:147\n1855#2,2:149\n1856#2:151\n1855#2,2:152\n1549#2:154\n1620#2,3:155\n1774#2,4:158\n*S KotlinDebug\n*F\n+ 1 TenantPermissionService.kt\nde/justsoftware/admin/domain/tenant/TenantPermissionService\n*L\n35#1:127\n35#1:128,3\n66#1:131\n66#1:132,2\n66#1:134\n66#1:135,3\n67#1:138\n67#1:139,2\n67#1:141\n67#1:142,3\n70#1:145\n75#1:146\n75#1:147,2\n76#1:149,2\n70#1:151\n92#1:152,2\n108#1:154\n108#1:155,3\n110#1:158,4\n*E\n"})
public class TenantPermissionService {
    @NotNull
    private final TenantPermissionRepository tenantPermissionRepo;

    public TenantPermissionService(@Qualifier(value="TenantPermissionRepository") @NotNull TenantPermissionRepository tenantPermissionRepo) {
        Intrinsics.checkNotNullParameter((Object)tenantPermissionRepo, (String)"tenantPermissionRepo");
        this.tenantPermissionRepo = tenantPermissionRepo;
    }

    @NotNull
    public TenantPermission savePermission(@NotNull TenantPermission tenantPermission) {
        Intrinsics.checkNotNullParameter((Object)tenantPermission, (String)"tenantPermission");
        this.tenantPermissionRepo.upsert(tenantPermission.getTenantId(), tenantPermission.getGranteeId().asItemId(), tenantPermission.getRole());
        return tenantPermission;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<TenantPermission> save(@NotNull List<TenantPermission> tenantPermissions) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(tenantPermissions, (String)"tenantPermissions");
        Iterable $this$map$iv = tenantPermissions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TenantPermission tenantPermission = (TenantPermission)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            this.tenantPermissionRepo.upsert(it.getTenantId(), it.getGranteeId().asItemId(), it.getRole());
            collection.add(it);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public List<TenantPermission> findBy(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.tenantPermissionRepo.findByTenantId(tenantId);
    }

    public void forEachPermission(@NotNull Function1<? super TenantPermission, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.tenantPermissionRepo.forEach(consumer);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<TenantPermission> update(@NotNull TenantId tenantId, @NotNull Set<TenantPermission> adds, @NotNull Set<TenantPermission> removes) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        TenantPermission it;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter(adds, (String)"adds");
        Intrinsics.checkNotNullParameter(removes, (String)"removes");
        Iterable $this$filter$iv = adds;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (TenantPermission)element$iv$iv;
            boolean bl = false;
            if (!(it.getRole() == Role.MANAGER)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (TenantPermission)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getGranteeId());
        }
        List addManagers = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = removes;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TenantPermission it2 = (TenantPermission)element$iv$iv;
            boolean bl = false;
            if (!(it2.getRole() == Role.MANAGER)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TenantPermission it2 = (TenantPermission)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it2.getGranteeId());
        }
        List removeManagers = (List)destination$iv$iv2;
        this.checkRemainingManagers(tenantId, addManagers, removeManagers);
        Iterable $this$forEach$iv = adds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TenantPermission it3 = (TenantPermission)element$iv;
            boolean bl = false;
            if (it3.getRole().isVsl()) {
                void $this$forEach$iv2;
                void $this$filterTo$iv$iv3;
                Iterable $this$filter$iv3;
                Set origins = this.tenantPermissionRepo.findByTenantIdAndGranteeId(it3.getTenantId(), it3.getGranteeId().asItemId());
                Iterable it4 = origins;
                boolean $i$f$filter3 = false;
                Iterator iterator = $this$filter$iv3;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                    TenantPermission origin = (TenantPermission)element$iv$iv;
                    boolean bl2 = false;
                    if (!origin.getRole().isVsl()) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                $this$filter$iv3 = (List)destination$iv$iv3;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    TenantPermission origin = (TenantPermission)element$iv2;
                    boolean bl3 = false;
                    this.tenantPermissionRepo.deleteOne(origin.getTenantId(), origin.getGranteeId().asItemId(), origin.getRole());
                }
            }
            this.tenantPermissionRepo.upsert(it3.getTenantId(), it3.getGranteeId().asItemId(), it3.getRole());
        }
        $this$forEach$iv = removes;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TenantPermission it5 = (TenantPermission)element$iv;
            boolean bl = false;
            this.tenantPermissionRepo.deleteOne(it5.getTenantId(), it5.getGranteeId().asItemId(), it5.getRole());
        }
        return this.tenantPermissionRepo.findByTenantId(tenantId);
    }

    /*
     * WARNING - void declaration
     */
    private void checkRemainingManagers(TenantId tenantId, List<? extends GranteeId> add, List<? extends GranteeId> remove) {
        int remaining;
        int n;
        void $this$count$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        if (remove.isEmpty()) {
            return;
        }
        Iterable iterable = this.tenantPermissionRepo.findByTenantIdAndPermission(tenantId, Role.MANAGER);
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TenantPermission tenantPermission = (TenantPermission)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getGranteeId());
        }
        $this$map$iv = CollectionsKt.union((Iterable)((List)destination$iv$iv), (Iterable)add);
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                GranteeId it = (GranteeId)element$iv;
                boolean bl = false;
                if (!(!remove.contains(it)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = remaining = count$iv;
        }
        if (remaining < 1) {
            throw new IllegalArgumentException("Cant delete the last Manager of a Tenant!");
        }
    }

    @NotNull
    public List<TenantPermission> deleteAllFor(@NotNull GranteeId granteeId) {
        Intrinsics.checkNotNullParameter((Object)granteeId, (String)"granteeId");
        List permissions = this.tenantPermissionRepo.findBy(granteeId.asItemId());
        this.tenantPermissionRepo.deleteManyBy(granteeId.asItemId());
        return permissions;
    }
}

