/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.deletedtenant;

import de.justsoftware.admin.domain.deletedtenant.model.DeletedTenant;
import de.justsoftware.admin.domain.deletedtenant.persistence.DeletedTenantRepository;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/justsoftware/admin/domain/deletedtenant/DeletedTenantService;", "", "repository", "Lde/justsoftware/admin/domain/deletedtenant/persistence/DeletedTenantRepository;", "(Lde/justsoftware/admin/domain/deletedtenant/persistence/DeletedTenantRepository;)V", "create", "Lde/justsoftware/admin/domain/deletedtenant/model/DeletedTenant;", "deletedTenant", "findDeletedTenant", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "getAll", "", "admin-service"})
public class DeletedTenantService {
    @NotNull
    private final DeletedTenantRepository repository;

    public DeletedTenantService(@NotNull DeletedTenantRepository repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.repository = repository;
    }

    @NotNull
    public DeletedTenant create(@NotNull DeletedTenant deletedTenant) {
        Intrinsics.checkNotNullParameter((Object)deletedTenant, (String)"deletedTenant");
        this.repository.insert(deletedTenant.getTenantId(), deletedTenant.getTenantName(), deletedTenant.getDeletedBy());
        return deletedTenant;
    }

    @Nullable
    public DeletedTenant findDeletedTenant(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.repository.find(tenantId);
    }

    @NotNull
    public List<DeletedTenant> getAll() {
        return this.repository.getAll();
    }
}

