/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.appsettings;

import de.justsoftware.admin.domain.appsettings.AppDefaultsKt;
import de.justsoftware.admin.domain.appsettings.model.AppPermission;
import de.justsoftware.admin.domain.appsettings.model.AppSettings;
import de.justsoftware.admin.domain.appsettings.model.CoreApp;
import de.justsoftware.admin.domain.appsettings.model.PermissionChanges;
import de.justsoftware.admin.domain.appsettings.persistence.AppPermissionRepository;
import de.justsoftware.admin.domain.appsettings.persistence.AppSettingsRepository;
import de.justsoftware.admin.exceptions.NotFoundException;
import de.justsoftware.admin.model.HexColor;
import de.justsoftware.admin.model.itemid.impl.GranteeId;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J+\u0010\u0010\u001a\u00020\u00112!\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00110\u0013H\u0016J \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0019H\u0016J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\b2\u0006\u0010\f\u001a\u00020\r2\u000e\b\u0002\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\bH\u0016J \u0010 \u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"H\u0016J*\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00190\b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020&0%H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lde/justsoftware/admin/domain/appsettings/AppSettingsService;", "", "appPermissionRepo", "Lde/justsoftware/admin/domain/appsettings/persistence/AppPermissionRepository;", "appSettingsRepo", "Lde/justsoftware/admin/domain/appsettings/persistence/AppSettingsRepository;", "(Lde/justsoftware/admin/domain/appsettings/persistence/AppPermissionRepository;Lde/justsoftware/admin/domain/appsettings/persistence/AppSettingsRepository;)V", "deletePermissions", "", "Lde/justsoftware/admin/domain/appsettings/model/AppPermission;", "granteeId", "Lde/justsoftware/admin/model/itemid/impl/GranteeId;", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "app", "Lde/justsoftware/admin/domain/appsettings/model/CoreApp;", "forEachPermission", "", "consumer", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "appPermission", "getPermissions", "getSettings", "Lde/justsoftware/admin/domain/appsettings/model/AppSettings;", "getSettingsList", "resetAppColors", "save", "appSettings", "saveOrCreateDefault", "presentAppSettings", "setPermissions", "permissionChanges", "Lde/justsoftware/admin/domain/appsettings/model/PermissionChanges;", "updateAppColors", "appColors", "", "Lde/justsoftware/admin/model/HexColor;", "admin-service"})
@SourceDebugExtension(value={"SMAP\nAppSettingsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppSettingsService.kt\nde/justsoftware/admin/domain/appsettings/AppSettingsService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,167:1\n11335#2:168\n11670#2,2:169\n11672#2:172\n11335#2:182\n11670#2,3:183\n1#3:171\n1855#4:173\n766#4:174\n857#4,2:175\n1855#4,2:177\n1856#4:179\n1855#4,2:180\n1855#4,2:186\n215#5,2:188\n*S KotlinDebug\n*F\n+ 1 AppSettingsService.kt\nde/justsoftware/admin/domain/appsettings/AppSettingsService\n*L\n63#1:168\n63#1:169,2\n63#1:172\n146#1:182\n146#1:183,3\n79#1:173\n85#1:174\n85#1:175,2\n86#1:177,2\n79#1:179\n100#1:180,2\n147#1:186,2\n163#1:188,2\n*E\n"})
public class AppSettingsService {
    @NotNull
    private final AppPermissionRepository appPermissionRepo;
    @NotNull
    private final AppSettingsRepository appSettingsRepo;

    public AppSettingsService(@Qualifier(value="AppPermissionRepository") @NotNull AppPermissionRepository appPermissionRepo, @NotNull AppSettingsRepository appSettingsRepo) {
        Intrinsics.checkNotNullParameter((Object)appPermissionRepo, (String)"appPermissionRepo");
        Intrinsics.checkNotNullParameter((Object)appSettingsRepo, (String)"appSettingsRepo");
        this.appPermissionRepo = appPermissionRepo;
        this.appSettingsRepo = appSettingsRepo;
    }

    @NotNull
    public List<AppPermission> deletePermissions(@NotNull GranteeId granteeId) {
        Intrinsics.checkNotNullParameter((Object)granteeId, (String)"granteeId");
        List toDelete = this.appPermissionRepo.getAllForGrantee(granteeId);
        this.appPermissionRepo.deleteAllForGrantee(granteeId);
        return toDelete;
    }

    @NotNull
    public List<AppPermission> deletePermissions(@NotNull TenantId tenantId, @NotNull CoreApp app) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        List toDelete = this.appPermissionRepo.getMany(tenantId, app);
        this.appPermissionRepo.deleteAll(tenantId, app);
        return toDelete;
    }

    @NotNull
    public AppSettings save(@NotNull AppSettings appSettings) {
        Intrinsics.checkNotNullParameter((Object)appSettings, (String)"appSettings");
        this.appSettingsRepo.upsertAppSettings(appSettings.getTenantId(), appSettings.getApp(), appSettings.getColor().toString());
        return this.getSettings(appSettings.getTenantId(), appSettings.getApp());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<AppSettings> saveOrCreateDefault(@NotNull TenantId tenantId, @NotNull List<AppSettings> presentAppSettings) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter(presentAppSettings, (String)"presentAppSettings");
        CoreApp[] $this$map$iv = CoreApp.values();
        boolean $i$f$map = false;
        CoreApp[] coreAppArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            AppSettings appSettings;
            AppSettings appSettings2;
            Object v0;
            void it;
            Collection collection;
            block3: {
                void item$iv$iv;
                void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
                collection = destination$iv$iv;
                boolean bl = false;
                Iterable iterable = presentAppSettings;
                for (Object t : iterable) {
                    AppSettings appSettings3 = (AppSettings)t;
                    boolean bl2 = false;
                    if (!(appSettings3.getApp() == it)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            if ((appSettings2 = (appSettings = (AppSettings)v0)) == null) {
                appSettings2 = AppDefaultsKt.buildDefaultAppSettings((TenantId)tenantId, (CoreApp)it);
            }
            collection.add(this.save(appSettings2));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List saveOrCreateDefault$default(AppSettingsService appSettingsService, TenantId tenantId, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: saveOrCreateDefault");
        }
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return appSettingsService.saveOrCreateDefault(tenantId, list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public AppSettings setPermissions(@NotNull TenantId tenantId, @NotNull CoreApp app, @NotNull PermissionChanges permissionChanges) {
        AppPermission it;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)permissionChanges, (String)"permissionChanges");
        Iterable $this$forEach$iv = permissionChanges.getAddPermissions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AppPermission)element$iv;
            boolean bl = false;
            if (it.getRole().isVsl()) {
                void $this$forEach$iv2;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Set origins = this.appPermissionRepo.findByTenantIdAndAppAndGranteeId(it.getTenantId(), it.getApp(), it.getGranteeId());
                Iterable iterable = origins;
                boolean $i$f$filter = false;
                Iterator iterator = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    AppPermission origin = (AppPermission)element$iv$iv;
                    boolean bl2 = false;
                    if (!origin.getRole().isVsl()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    AppPermission origin = (AppPermission)element$iv2;
                    boolean bl3 = false;
                    this.appPermissionRepo.deleteOne(origin.getTenantId(), origin.getApp(), origin.getGranteeId(), origin.getRole());
                }
            }
            this.appPermissionRepo.upsert(it.getTenantId(), it.getApp(), it.getGranteeId(), it.getRole());
        }
        $this$forEach$iv = permissionChanges.getRemovePermissions();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AppPermission)element$iv;
            boolean bl = false;
            this.appPermissionRepo.deleteOne(it.getTenantId(), it.getApp(), it.getGranteeId(), it.getRole());
        }
        return this.getSettings(tenantId, app);
    }

    public void forEachPermission(@NotNull Function1<? super AppPermission, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.appPermissionRepo.forEach(consumer);
    }

    @NotNull
    public List<AppPermission> getPermissions(@NotNull TenantId tenantId, @Nullable CoreApp app) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return app != null ? this.appPermissionRepo.getMany(tenantId, app) : this.appPermissionRepo.findBy(tenantId);
    }

    @NotNull
    public AppSettings getSettings(@NotNull TenantId tenantId, @NotNull CoreApp app) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        AppSettings appSettings = this.appSettingsRepo.findAppSettings(tenantId, app);
        if (appSettings == null) {
            throw new NotFoundException("No app settings found for tenant with id '" + tenantId + "'!");
        }
        return appSettings;
    }

    @NotNull
    public List<AppSettings> getSettingsList(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.appSettingsRepo.getAllAppSettingsByTenantId(tenantId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<AppSettings> resetAppColors(@NotNull TenantId tenantId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        CoreApp[] $this$map$iv = CoreApp.values();
        boolean $i$f$map = false;
        CoreApp[] coreAppArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getSettings(tenantId, (CoreApp)it));
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AppSettings it = (AppSettings)element$iv;
            boolean bl = false;
            this.appSettingsRepo.upsertAppSettings(tenantId, it.getApp(), AppDefaultsKt.getDefaultAppSettings().getColor(it.getApp()).toString());
        }
        return this.getSettingsList(tenantId);
    }

    @NotNull
    public List<AppSettings> updateAppColors(@NotNull TenantId tenantId, @NotNull Map<CoreApp, HexColor> appColors) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter(appColors, (String)"appColors");
        Map<CoreApp, HexColor> $this$forEach$iv = appColors;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<CoreApp, HexColor>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<CoreApp, HexColor> element$iv;
            Map.Entry<CoreApp, HexColor> it = element$iv = iterator.next();
            boolean bl = false;
            this.appSettingsRepo.updateColor(tenantId, it.getKey(), it.getValue().toString());
        }
        return this.getSettingsList(tenantId);
    }
}

