/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.authorization;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.admin.authorization.exceptions.NoUserInSecurityContextException;
import de.justsoftware.admin.authorization.exceptions.NotAllowedException;
import de.justsoftware.admin.model.itemid.ItemId;
import de.justsoftware.admin.model.itemid.impl.GranteeId;
import de.justsoftware.admin.model.itemid.impl.ProfileId;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import de.justsoftware.permission.client.model.AuthorizationResult;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0006\u0010\u0010\u001a\u00020\fJ\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\fJ\u0006\u0010\u0015\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u0006\u0010\u001c\u001a\u00020\u001aJ\u000e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0018J\u0006\u0010\u001e\u001a\u00020\u001aJ\u000e\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0003J\u000e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lde/justsoftware/admin/authorization/AuthorizationContext;", "", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "user", "Lde/justsoftware/permission/client/model/Role;", "permissionRequestConnector", "Lde/justsoftware/permission/client/rest/PermissionRequestConnector;", "(Lde/justsoftware/admin/model/itemid/impl/TenantId;Lde/justsoftware/permission/client/model/Role;Lde/justsoftware/permission/client/rest/PermissionRequestConnector;)V", "getTenantId", "()Lde/justsoftware/admin/model/itemid/impl/TenantId;", "checkAllTenantReader", "", "granteeIds", "", "Lde/justsoftware/admin/model/itemid/impl/GranteeId;", "checkBackendAdmin", "checkRead", "itemId", "Lde/justsoftware/admin/model/itemid/ItemId;", "checkSuperAdmin", "checkTenantManager", "otherTenantId", "getUserProfileId", "Lde/justsoftware/admin/model/itemid/impl/ProfileId;", "hasRole", "", "role", "isSuperAdmin", "profileId", "isTenantManager", "mayRead", "admin-service"})
@SourceDebugExtension(value={"SMAP\nAuthorizationContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthorizationContext.kt\nde/justsoftware/admin/authorization/AuthorizationContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n1549#2:132\n1620#2,3:133\n*S KotlinDebug\n*F\n+ 1 AuthorizationContext.kt\nde/justsoftware/admin/authorization/AuthorizationContext\n*L\n68#1:132\n68#1:133,3\n*E\n"})
public final class AuthorizationContext {
    @Nullable
    private final TenantId tenantId;
    @NotNull
    private final Role user;
    @NotNull
    private final PermissionRequestConnector permissionRequestConnector;

    public AuthorizationContext(@Nullable TenantId tenantId, @NotNull Role user, @NotNull PermissionRequestConnector permissionRequestConnector) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)permissionRequestConnector, (String)"permissionRequestConnector");
        this.tenantId = tenantId;
        this.user = user;
        this.permissionRequestConnector = permissionRequestConnector;
    }

    @Nullable
    public final TenantId getTenantId() {
        return this.tenantId;
    }

    public final void checkRead(@NotNull ItemId itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        if (!this.mayRead(itemId)) {
            throw new NotAllowedException("'" + this.user + "' does not have the required role for this operation!");
        }
    }

    public final void checkBackendAdmin() {
        Role role = Role.create((String)"BACKENDADMIN");
        Intrinsics.checkNotNullExpressionValue((Object)role, (String)"create(\"BACKENDADMIN\")");
        if (!this.hasRole(role)) {
            throw new NotAllowedException("'" + this.user + "' does not have the required role for this operation!");
        }
    }

    public final void checkSuperAdmin() {
        if (!this.isSuperAdmin()) {
            throw new NotAllowedException("'" + this.user + "' does not have the required role for this operation!");
        }
    }

    public final void checkTenantManager() {
        if (!this.isSuperAdmin() && !this.isTenantManager()) {
            throw new NotAllowedException("'" + this.user + "' does not have the required role for this operation!");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void checkAllTenantReader(@NotNull Collection<? extends GranteeId> granteeIds) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(granteeIds, (String)"granteeIds");
        if (this.tenantId == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        Iterable $this$map$iv = granteeIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GranteeId granteeId = (GranteeId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Role.create((String)it.asItemId()));
        }
        Set granteeRoles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (!this.permissionRequestConnector.allHaveRole(Role.read((String)this.tenantId.asItemId()), granteeRoles)) {
            throw new NotAllowedException("Not all users are members of " + this.tenantId);
        }
    }

    public final void checkTenantManager(@NotNull TenantId otherTenantId) {
        Intrinsics.checkNotNullParameter((Object)otherTenantId, (String)"otherTenantId");
        if (!this.isSuperAdmin() && !this.isTenantManager(otherTenantId)) {
            throw new NotAllowedException("'" + this.user + "' does not have the required role for this operation!");
        }
    }

    public final boolean mayRead(@NotNull ItemId itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Role role = Role.read((String)itemId.asItemId());
        Intrinsics.checkNotNullExpressionValue((Object)role, (String)"read(itemId.asItemId())");
        return this.hasRole(role);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isTenantManager() {
        if (this.tenantId == null) return false;
        Role role = Role.manage((String)this.tenantId.asItemId());
        Intrinsics.checkNotNullExpressionValue((Object)role, (String)"manage(tenantId.asItemId())");
        if (!this.hasRole(role)) return false;
        return true;
    }

    public final boolean isTenantManager(@NotNull TenantId otherTenantId) {
        Intrinsics.checkNotNullParameter((Object)otherTenantId, (String)"otherTenantId");
        Role role = Role.manage((String)otherTenantId.asItemId());
        Intrinsics.checkNotNullExpressionValue((Object)role, (String)"manage(otherTenantId.asItemId())");
        return this.hasRole(role);
    }

    public final boolean isSuperAdmin() {
        Role role = Role.SUPERADMIN;
        Intrinsics.checkNotNullExpressionValue((Object)role, (String)"SUPERADMIN");
        return this.hasRole(role);
    }

    public final boolean isSuperAdmin(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Role role = Role.SUPERADMIN;
        ImmutableMap immutableMap = this.permissionRequestConnector.hasRoles((Iterable)SetsKt.setOf((Object)role), (Iterable)SetsKt.setOf((Object)Role.profileRole((long)profileId.getId())));
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"permissionRequestConnect\u2026ofileRole(profileId.id)))");
        ImmutableMap authResult = immutableMap;
        return authResult.get((Object)role) == AuthorizationResult.OK;
    }

    @NotNull
    public final ProfileId getUserProfileId() {
        Long profileId = (Long)this.user.getProfileId().orElseThrow(AuthorizationContext::getUserProfileId$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)profileId, (String)"profileId");
        return new ProfileId(profileId.longValue());
    }

    private final boolean hasRole(Role role) {
        ImmutableMap immutableMap = this.permissionRequestConnector.hasRoles((Iterable)SetsKt.setOf((Object)role), (Iterable)SetsKt.setOf((Object)this.user));
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"permissionRequestConnect\u2026setOf(role), setOf(user))");
        ImmutableMap authResult = immutableMap;
        return authResult.get((Object)role) == AuthorizationResult.OK;
    }

    private static final NoUserInSecurityContextException getUserProfileId$lambda$1() {
        return new NoUserInSecurityContextException("Cant get ProfileId from Role user!");
    }
}

