/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.web;

import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.connector.profile.InternalCreateProfileModel;
import de.justsoftware.admin.connector.profile.ProfileConnector;
import de.justsoftware.admin.domain.user.UserService;
import de.justsoftware.admin.domain.user.model.Grantee;
import de.justsoftware.admin.domain.user.model.UserGroup;
import de.justsoftware.admin.model.itemid.ItemId;
import de.justsoftware.admin.model.itemid.impl.GranteeId;
import de.justsoftware.admin.model.itemid.impl.ProfileId;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/justsoftware/admin/application/web/UserApplicationService;", "", "userService", "Lde/justsoftware/admin/domain/user/UserService;", "profileConnector", "Lde/justsoftware/admin/connector/profile/ProfileConnector;", "(Lde/justsoftware/admin/domain/user/UserService;Lde/justsoftware/admin/connector/profile/ProfileConnector;)V", "createProfile", "Lde/justsoftware/admin/model/itemid/impl/ProfileId;", "profileInput", "Lde/justsoftware/admin/connector/profile/InternalCreateProfileModel;", "authContext", "Lde/justsoftware/admin/authorization/AuthorizationContext;", "getAllTenantUsersGroup", "Lde/justsoftware/admin/domain/user/model/UserGroup;", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "getOne", "Lde/justsoftware/admin/domain/user/model/Grantee;", "id", "Lde/justsoftware/admin/model/itemid/impl/GranteeId;", "admin-service"})
public class UserApplicationService {
    @NotNull
    private final UserService userService;
    @NotNull
    private final ProfileConnector profileConnector;

    public UserApplicationService(@NotNull UserService userService, @NotNull ProfileConnector profileConnector) {
        Intrinsics.checkNotNullParameter((Object)userService, (String)"userService");
        Intrinsics.checkNotNullParameter((Object)profileConnector, (String)"profileConnector");
        this.userService = userService;
        this.profileConnector = profileConnector;
    }

    @NotNull
    public ProfileId createProfile(@NotNull InternalCreateProfileModel profileInput, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)profileInput, (String)"profileInput");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        TenantId tenantId = TenantId.Companion.parse(profileInput.getTenantId());
        authContext.checkTenantManager(tenantId);
        return this.profileConnector.createProfile(profileInput);
    }

    @NotNull
    public Grantee getOne(@NotNull GranteeId id, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkRead((ItemId)id);
        return this.userService.getOne(id);
    }

    @NotNull
    public UserGroup getAllTenantUsersGroup(@NotNull TenantId tenantId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager(tenantId);
        return this.userService.getAllTenantUsersGroup(tenantId);
    }
}

