/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.web;

import de.justsoftware.admin.application.util.TransactionSupport;
import de.justsoftware.admin.application.web.model.ColorThemeInput;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.authorization.exceptions.NotAllowedException;
import de.justsoftware.admin.config.ServerConfigService;
import de.justsoftware.admin.domain.appsettings.AppSettingsService;
import de.justsoftware.admin.domain.appsettings.model.AppSettings;
import de.justsoftware.admin.domain.appsettings.model.CoreApp;
import de.justsoftware.admin.domain.deletedtenant.DeletedTenantService;
import de.justsoftware.admin.domain.deletedtenant.model.DeletedTenant;
import de.justsoftware.admin.domain.tenant.TenantInvitationService;
import de.justsoftware.admin.domain.tenant.TenantPermissionService;
import de.justsoftware.admin.domain.tenant.TenantService;
import de.justsoftware.admin.domain.tenant.model.Tenant;
import de.justsoftware.admin.domain.tenant.model.TenantInvitation;
import de.justsoftware.admin.domain.tenant.model.TenantPermission;
import de.justsoftware.admin.domain.tenant.model.TenantSettings;
import de.justsoftware.admin.kafka.publisher.Publisher;
import de.justsoftware.admin.model.HexColor;
import de.justsoftware.admin.model.itemid.impl.GranteeId;
import de.justsoftware.admin.model.itemid.impl.ProfileId;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0012J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0017J\u0018\u0010\"\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0017JN\u0010#\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010$\u001a\u00020\u001d2\b\b\u0002\u0010%\u001a\u00020&2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001b0*2\u000e\b\u0002\u0010+\u001a\b\u0012\u0004\u0012\u00020,0*H\u0012J@\u0010-\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010$\u001a\u00020\u001d2\b\b\u0002\u0010%\u001a\u00020&2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(2\u000e\b\u0002\u0010+\u001a\b\u0012\u0004\u0012\u00020,0*H\u0012J\u001a\u0010.\u001a\u0004\u0018\u00010\u001d2\u0006\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u00020!H\u0016J\u001e\u00101\u001a\b\u0012\u0004\u0012\u0002020*2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0016J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u001d0*2\u0006\u00100\u001a\u00020!H\u0016J\u0018\u00104\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u00020!H\u0016J\u001a\u00105\u001a\u0004\u0018\u00010(2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00100\u001a\u00020!H\u0016J\u0018\u00106\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00100\u001a\u00020!H\u0016J\u0018\u00107\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0017J\u0018\u00108\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0017J\"\u00109\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010:\u001a\u0004\u0018\u00010\u001f2\u0006\u00100\u001a\u00020!H\u0017J \u0010;\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010<\u001a\u00020=2\u0006\u00100\u001a\u00020!H\u0017J \u0010>\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010?\u001a\u00020@2\u0006\u0010 \u001a\u00020!H\u0017J\"\u0010A\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010B\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0016J4\u0010C\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010D\u001a\b\u0012\u0004\u0012\u0002020E2\f\u0010F\u001a\b\u0012\u0004\u0012\u0002020E2\u0006\u0010 \u001a\u00020!H\u0017J \u0010G\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00100\u001a\u00020!H\u0017R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lde/justsoftware/admin/application/web/TenantApplicationService;", "", "deletedTenantService", "Lde/justsoftware/admin/domain/deletedtenant/DeletedTenantService;", "tenantService", "Lde/justsoftware/admin/domain/tenant/TenantService;", "tenantPermissionService", "Lde/justsoftware/admin/domain/tenant/TenantPermissionService;", "tenantInvitationService", "Lde/justsoftware/admin/domain/tenant/TenantInvitationService;", "permissionRequestConnector", "Lde/justsoftware/permission/client/rest/PermissionRequestConnector;", "appSettingsService", "Lde/justsoftware/admin/domain/appsettings/AppSettingsService;", "publisher", "Lde/justsoftware/admin/kafka/publisher/Publisher;", "serverConfigService", "Lde/justsoftware/admin/config/ServerConfigService;", "transactionSupport", "Lde/justsoftware/admin/application/util/TransactionSupport;", "(Lde/justsoftware/admin/domain/deletedtenant/DeletedTenantService;Lde/justsoftware/admin/domain/tenant/TenantService;Lde/justsoftware/admin/domain/tenant/TenantPermissionService;Lde/justsoftware/admin/domain/tenant/TenantInvitationService;Lde/justsoftware/permission/client/rest/PermissionRequestConnector;Lde/justsoftware/admin/domain/appsettings/AppSettingsService;Lde/justsoftware/admin/kafka/publisher/Publisher;Lde/justsoftware/admin/config/ServerConfigService;Lde/justsoftware/admin/application/util/TransactionSupport;)V", "checkAllGranteesAreMemberOfTenant", "", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "granteesToAdd", "", "Lde/justsoftware/admin/model/itemid/impl/GranteeId;", "createTenant", "Lde/justsoftware/admin/domain/tenant/model/Tenant;", "name", "", "authContext", "Lde/justsoftware/admin/authorization/AuthorizationContext;", "deleteTenant", "fetchAndPublishNewTenant", "tenant", "tenantSettings", "Lde/justsoftware/admin/domain/tenant/model/TenantSettings;", "tenantInvitation", "Lde/justsoftware/admin/domain/tenant/model/TenantInvitation;", "tenantManagers", "", "allAppSettings", "Lde/justsoftware/admin/domain/appsettings/model/AppSettings;", "fetchAndPublishUpdatedTenant", "findOne", "id", "authorizationContext", "findPermissionsBy", "Lde/justsoftware/admin/domain/tenant/model/TenantPermission;", "getAllTenants", "getOne", "getTenantInvitation", "getTenantSettings", "resetAppColors", "resetGlobalHighlightColor", "setLogo", "logoId", "setTenantInvitationActive", "isInvitationActive", "", "updateColorTheme", "input", "Lde/justsoftware/admin/application/web/model/ColorThemeInput;", "updateDeeplKey", "deeplKey", "updatePermissions", "adds", "", "removes", "updateTenantName", "admin-service"})
@SourceDebugExtension(value={"SMAP\nTenantApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TenantApplicationService.kt\nde/justsoftware/admin/application/web/TenantApplicationService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,357:1\n11335#2:358\n11670#2,3:359\n1549#3:362\n1620#3,3:363\n1549#3:366\n1620#3,3:367\n*S KotlinDebug\n*F\n+ 1 TenantApplicationService.kt\nde/justsoftware/admin/application/web/TenantApplicationService\n*L\n106#1:358\n106#1:359,3\n249#1:362\n249#1:363,3\n326#1:366\n326#1:367,3\n*E\n"})
public class TenantApplicationService {
    @NotNull
    private final DeletedTenantService deletedTenantService;
    @NotNull
    private final TenantService tenantService;
    @NotNull
    private final TenantPermissionService tenantPermissionService;
    @NotNull
    private final TenantInvitationService tenantInvitationService;
    @NotNull
    private final PermissionRequestConnector permissionRequestConnector;
    @NotNull
    private final AppSettingsService appSettingsService;
    @NotNull
    private final Publisher publisher;
    @NotNull
    private final ServerConfigService serverConfigService;
    @NotNull
    private final TransactionSupport transactionSupport;

    public TenantApplicationService(@NotNull DeletedTenantService deletedTenantService, @NotNull TenantService tenantService, @NotNull TenantPermissionService tenantPermissionService, @NotNull TenantInvitationService tenantInvitationService, @NotNull PermissionRequestConnector permissionRequestConnector, @NotNull AppSettingsService appSettingsService, @NotNull Publisher publisher, @NotNull ServerConfigService serverConfigService, @NotNull TransactionSupport transactionSupport) {
        Intrinsics.checkNotNullParameter((Object)deletedTenantService, (String)"deletedTenantService");
        Intrinsics.checkNotNullParameter((Object)tenantService, (String)"tenantService");
        Intrinsics.checkNotNullParameter((Object)tenantPermissionService, (String)"tenantPermissionService");
        Intrinsics.checkNotNullParameter((Object)tenantInvitationService, (String)"tenantInvitationService");
        Intrinsics.checkNotNullParameter((Object)permissionRequestConnector, (String)"permissionRequestConnector");
        Intrinsics.checkNotNullParameter((Object)appSettingsService, (String)"appSettingsService");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)serverConfigService, (String)"serverConfigService");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        this.deletedTenantService = deletedTenantService;
        this.tenantService = tenantService;
        this.tenantPermissionService = tenantPermissionService;
        this.tenantInvitationService = tenantInvitationService;
        this.permissionRequestConnector = permissionRequestConnector;
        this.appSettingsService = appSettingsService;
        this.publisher = publisher;
        this.serverConfigService = serverConfigService;
        this.transactionSupport = transactionSupport;
    }

    @Transactional
    @NotNull
    public Tenant createTenant(@NotNull String name, @NotNull AuthorizationContext authContext) {
        boolean tenantExists;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkSuperAdmin();
        boolean bl = tenantExists = !((Collection)this.tenantService.getTenants()).isEmpty();
        if (tenantExists && !this.serverConfigService.isMultiTenantCreationEnabled()) {
            throw new NotAllowedException("Tenant creation is disabled.");
        }
        ProfileId currentUserId = authContext.getUserProfileId();
        Tenant tenant = TenantService.createTenant$default((TenantService)this.tenantService, (String)name, null, null, null, (int)14, null);
        ArrayList<GranteeId> tenantManagers = new ArrayList<GranteeId>();
        if (!Intrinsics.areEqual((Object)currentUserId, (Object)new ProfileId(0L))) {
            TenantPermission tenantPermission = this.tenantPermissionService.savePermission(new TenantPermission(tenant.getId(), (GranteeId)currentUserId, de.justsoftware.admin.model.Role.MANAGER));
            tenantManagers.add(tenantPermission.getGranteeId());
        }
        List allDefaultAppSettings = AppSettingsService.saveOrCreateDefault$default((AppSettingsService)this.appSettingsService, (TenantId)tenant.getId(), null, (int)2, null);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return tenant;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void deleteTenant(@NotNull TenantId tenantId, @NotNull AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager(tenantId);
        Tenant tenant = this.tenantService.getTenant(tenantId);
        List tenantPermissions = this.tenantPermissionService.findBy(tenantId);
        CoreApp[] coreAppArray = CoreApp.values();
        boolean $i$f$map = false;
        void var8_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var14_13 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.appSettingsService.deletePermissions(tenantId, (CoreApp)it));
        }
        List deletedAppPermissions = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        this.tenantService.deleteTenant(tenantId);
        this.deletedTenantService.create(new DeletedTenant(tenantId, tenant.getName(), authContext.getUserProfileId()));
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Transactional
    @NotNull
    public Tenant resetAppColors(@NotNull TenantId tenantId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager(tenantId);
        List allAppSettings = this.appSettingsService.resetAppColors(tenantId);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return this.tenantService.getTenant(tenantId);
    }

    @Transactional
    @NotNull
    public Tenant resetGlobalHighlightColor(@NotNull TenantId tenantId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager(tenantId);
        TenantSettings tenantSettings = this.tenantService.resetHighlightColor(tenantId);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return this.tenantService.getTenant(tenantId);
    }

    @Transactional
    @NotNull
    public Tenant updateColorTheme(@NotNull TenantId tenantId, @NotNull ColorThemeInput input, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager(tenantId);
        TenantSettings tenantSettings = input.getHighlight() != null ? this.tenantService.updateHighlightColor(tenantId, HexColor.Companion.fromString(input.getHighlight())) : this.tenantService.getSettings(tenantId);
        List allAppSettings = this.appSettingsService.updateAppColors(tenantId, input.toAppColorMap());
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return this.tenantService.getTenant(tenantId);
    }

    @NotNull
    public Tenant updateDeeplKey(@NotNull TenantId tenantId, @Nullable String deeplKey, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager(tenantId);
        this.tenantService.updateDeeplKey(tenantId, deeplKey);
        Tenant tenant = this.tenantService.getTenant(tenantId);
        TenantApplicationService.fetchAndPublishUpdatedTenant$default((TenantApplicationService)this, (TenantId)tenantId, (Tenant)tenant, null, null, null, (int)28, null);
        return tenant;
    }

    @NotNull
    public List<Tenant> getAllTenants(@NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkSuperAdmin();
        return this.tenantService.getTenants();
    }

    @Transactional
    @NotNull
    public Tenant updateTenantName(@NotNull TenantId id, @NotNull String name, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(id);
        Tenant tenant = this.tenantService.updateName(id, name);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return tenant;
    }

    @Nullable
    public Tenant findOne(@NotNull TenantId id, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(id);
        return this.tenantService.findTenant(id);
    }

    @NotNull
    public Tenant getOne(@NotNull TenantId id, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(id);
        return this.tenantService.getTenant(id);
    }

    @NotNull
    public List<TenantPermission> findPermissionsBy(@NotNull TenantId tenantId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager(tenantId);
        return this.tenantPermissionService.findBy(tenantId);
    }

    @Transactional
    @NotNull
    public Tenant updatePermissions(@NotNull TenantId tenantId, @NotNull Set<TenantPermission> adds, @NotNull Set<TenantPermission> removes, @NotNull AuthorizationContext authContext) {
        TenantPermission it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter(adds, (String)"adds");
        Intrinsics.checkNotNullParameter(removes, (String)"removes");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager(tenantId);
        Iterable $this$map$iv = adds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TenantPermission tenantPermission = (TenantPermission)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getGranteeId());
        }
        $this$map$iv = removes;
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (TenantPermission)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getGranteeId());
        }
        List affectedGranteeIds = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        this.checkAllGranteesAreMemberOfTenant(tenantId, (Collection)affectedGranteeIds);
        this.tenantPermissionService.update(tenantId, adds, removes);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return this.tenantService.getTenant(tenantId);
    }

    @NotNull
    public TenantSettings getTenantSettings(@NotNull TenantId tenantId, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(tenantId);
        return this.tenantService.getSettings(tenantId);
    }

    @Transactional
    @NotNull
    public Tenant setLogo(@NotNull TenantId tenantId, @Nullable String logoId, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(tenantId);
        TenantSettings tenantSettings = this.tenantService.setLogo(tenantId, logoId, authorizationContext.getUserProfileId());
        Tenant tenant = this.tenantService.getTenant(tenantId);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return tenant;
    }

    @Nullable
    public TenantInvitation getTenantInvitation(@NotNull TenantId tenantId, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(tenantId);
        return (TenantInvitation)CollectionsKt.firstOrNull((List)this.tenantInvitationService.getTenantInvitations(tenantId));
    }

    @Transactional
    @NotNull
    public Tenant setTenantInvitationActive(@NotNull TenantId tenantId, boolean isInvitationActive, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(tenantId);
        this.tenantInvitationService.setTenantInvitationActive(tenantId, isInvitationActive);
        Tenant tenant = this.tenantService.getTenant(tenantId);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return tenant;
    }

    /*
     * WARNING - void declaration
     */
    private void checkAllGranteesAreMemberOfTenant(TenantId tenantId, Collection<? extends GranteeId> granteesToAdd) {
        void $this$mapTo$iv$iv;
        if (granteesToAdd.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = granteesToAdd;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GranteeId granteeId = (GranteeId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Role.create((String)it.asItemId()));
        }
        Set granteeRoles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (!this.permissionRequestConnector.allHaveRole(Role.read((String)tenantId.asItemId()), granteeRoles)) {
            throw new NotAllowedException("Not all users are members of " + tenantId);
        }
    }

    private void fetchAndPublishNewTenant(TenantId tenantId, Tenant tenant, TenantSettings tenantSettings, TenantInvitation tenantInvitation, List<? extends GranteeId> tenantManagers, List<AppSettings> allAppSettings) {
        this.publisher.publishNewTenant(tenant, tenantSettings, allAppSettings, tenantManagers, tenantInvitation);
    }

    static /* synthetic */ void fetchAndPublishNewTenant$default(TenantApplicationService tenantApplicationService, TenantId tenantId, Tenant tenant, TenantSettings tenantSettings, TenantInvitation tenantInvitation, List list, List list2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fetchAndPublishNewTenant");
        }
        if ((n & 2) != 0) {
            tenant = tenantApplicationService.tenantService.getTenant(tenantId);
        }
        if ((n & 4) != 0) {
            tenantSettings = tenantApplicationService.tenantService.getSettings(tenantId);
        }
        if ((n & 8) != 0) {
            tenantInvitation = (TenantInvitation)CollectionsKt.firstOrNull((List)tenantApplicationService.tenantInvitationService.getTenantInvitations(tenantId));
        }
        if ((n & 0x20) != 0) {
            list2 = tenantApplicationService.appSettingsService.getSettingsList(tenantId);
        }
        tenantApplicationService.fetchAndPublishNewTenant(tenantId, tenant, tenantSettings, tenantInvitation, list, list2);
    }

    private void fetchAndPublishUpdatedTenant(TenantId tenantId, Tenant tenant, TenantSettings tenantSettings, TenantInvitation tenantInvitation, List<AppSettings> allAppSettings) {
        this.publisher.publishUpdatedTenant(tenant, tenantSettings, tenantInvitation, allAppSettings);
    }

    static /* synthetic */ void fetchAndPublishUpdatedTenant$default(TenantApplicationService tenantApplicationService, TenantId tenantId, Tenant tenant, TenantSettings tenantSettings, TenantInvitation tenantInvitation, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fetchAndPublishUpdatedTenant");
        }
        if ((n & 2) != 0) {
            tenant = tenantApplicationService.tenantService.getTenant(tenantId);
        }
        if ((n & 4) != 0) {
            tenantSettings = tenantApplicationService.tenantService.getSettings(tenantId);
        }
        if ((n & 8) != 0) {
            tenantInvitation = (TenantInvitation)CollectionsKt.firstOrNull((List)tenantApplicationService.tenantInvitationService.getTenantInvitations(tenantId));
        }
        if ((n & 0x10) != 0) {
            list = tenantApplicationService.appSettingsService.getSettingsList(tenantId);
        }
        tenantApplicationService.fetchAndPublishUpdatedTenant(tenantId, tenant, tenantSettings, tenantInvitation, list);
    }

    public static final /* synthetic */ Publisher access$getPublisher$p(TenantApplicationService $this) {
        return $this.publisher;
    }
}

