/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.web;

import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.authorization.exceptions.NotAllowedException;
import de.justsoftware.admin.connector.superoperty.SuperopertyConnector;
import de.justsoftware.admin.domain.tenant.TenantIdpConfigService;
import de.justsoftware.admin.domain.tenant.model.AddIdentityProviderInput;
import de.justsoftware.admin.domain.tenant.model.IdpConfiguration;
import de.justsoftware.admin.domain.tenant.model.UpdateIdentityProviderInput;
import de.justsoftware.admin.kafka.publisher.Publisher;
import de.justsoftware.admin.model.itemid.impl.ClientRegistrationId;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0012J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/justsoftware/admin/application/web/IdpApplicationService;", "", "tenantIdpConfigService", "Lde/justsoftware/admin/domain/tenant/TenantIdpConfigService;", "superopertyConnector", "Lde/justsoftware/admin/connector/superoperty/SuperopertyConnector;", "publisher", "Lde/justsoftware/admin/kafka/publisher/Publisher;", "(Lde/justsoftware/admin/domain/tenant/TenantIdpConfigService;Lde/justsoftware/admin/connector/superoperty/SuperopertyConnector;Lde/justsoftware/admin/kafka/publisher/Publisher;)V", "addIdp", "Lde/justsoftware/admin/domain/tenant/model/IdpConfiguration;", "input", "Lde/justsoftware/admin/domain/tenant/model/AddIdentityProviderInput;", "authContext", "Lde/justsoftware/admin/authorization/AuthorizationContext;", "errorIfIdpManagementNotActive", "", "getIdps", "", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "removeDefaultProviderForTenant", "removeIdp", "id", "Lde/justsoftware/admin/model/itemid/impl/ClientRegistrationId;", "setAsDefaultId", "updateIdp", "Lde/justsoftware/admin/domain/tenant/model/UpdateIdentityProviderInput;", "admin-service"})
@SourceDebugExtension(value={"SMAP\nIdpApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdpApplicationService.kt\nde/justsoftware/admin/application/web/IdpApplicationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n1855#2,2:161\n1855#2,2:163\n*S KotlinDebug\n*F\n+ 1 IdpApplicationService.kt\nde/justsoftware/admin/application/web/IdpApplicationService\n*L\n137#1:161,2\n150#1:163,2\n*E\n"})
public class IdpApplicationService {
    @NotNull
    private final TenantIdpConfigService tenantIdpConfigService;
    @NotNull
    private final SuperopertyConnector superopertyConnector;
    @NotNull
    private final Publisher publisher;

    public IdpApplicationService(@NotNull TenantIdpConfigService tenantIdpConfigService, @NotNull SuperopertyConnector superopertyConnector, @NotNull Publisher publisher) {
        Intrinsics.checkNotNullParameter((Object)tenantIdpConfigService, (String)"tenantIdpConfigService");
        Intrinsics.checkNotNullParameter((Object)superopertyConnector, (String)"superopertyConnector");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        this.tenantIdpConfigService = tenantIdpConfigService;
        this.superopertyConnector = superopertyConnector;
        this.publisher = publisher;
    }

    @NotNull
    public Set<IdpConfiguration> getIdps(@NotNull TenantId tenantId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.errorIfIdpManagementNotActive();
        authContext.checkTenantManager(tenantId);
        return this.tenantIdpConfigService.getIdpConfigurationsForTenant(tenantId);
    }

    @NotNull
    public IdpConfiguration addIdp(@NotNull AddIdentityProviderInput input, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.errorIfIdpManagementNotActive();
        authContext.checkTenantManager();
        TenantId tenantId = authContext.getTenantId();
        if (tenantId == null) {
            throw new IllegalArgumentException();
        }
        TenantId tenantId2 = tenantId;
        ClientRegistrationId clientRegistrationId = ClientRegistrationId.Companion.random();
        String string = input.getClientId();
        String string2 = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
        String string3 = input.getClientSecret();
        String string4 = string3 != null ? ((Object)StringsKt.trim((CharSequence)string3)).toString() : null;
        String string5 = ((Object)StringsKt.trim((CharSequence)input.getIdpName())).toString();
        String string6 = input.getUserNameAttribute();
        String string7 = string6 != null ? ((Object)StringsKt.trim((CharSequence)string6)).toString() : null;
        AuthorizationGrantType authorizationGrantType = AuthorizationGrantType.AUTHORIZATION_CODE;
        Intrinsics.checkNotNullExpressionValue((Object)authorizationGrantType, (String)"AUTHORIZATION_CODE");
        String string8 = input.getScope();
        String string9 = input.getIssuerUri();
        String string10 = input.getAuthorizationUri();
        String string11 = input.getTokenUri();
        String string12 = input.getUserInfoUri();
        String string13 = input.getJwkSetUri();
        IdpConfiguration configuration = new IdpConfiguration(clientRegistrationId, tenantId2, string2, string4, string5, string7, authorizationGrantType, string8 != null ? ((Object)StringsKt.trim((CharSequence)string8)).toString() : null, string9 != null ? ((Object)StringsKt.trim((CharSequence)string9)).toString() : null, string10 != null ? ((Object)StringsKt.trim((CharSequence)string10)).toString() : null, string11 != null ? ((Object)StringsKt.trim((CharSequence)string11)).toString() : null, string12 != null ? ((Object)StringsKt.trim((CharSequence)string12)).toString() : null, string13 != null ? ((Object)StringsKt.trim((CharSequence)string13)).toString() : null, ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)input.getTargets(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null))).toString(), input.getAutomaticMode(), input.getDefaultProvider(), input.getEnabled());
        IdpConfiguration addedConfig = this.tenantIdpConfigService.upsertIdpConfiguration(configuration);
        this.publisher.publishOAuthClientChange(addedConfig);
        return addedConfig;
    }

    @NotNull
    public IdpConfiguration updateIdp(@NotNull UpdateIdentityProviderInput input, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.errorIfIdpManagementNotActive();
        ClientRegistrationId configId = ClientRegistrationId.Companion.fromString(input.getId());
        IdpConfiguration idpConfiguration = this.tenantIdpConfigService.findIdpConfiguration(configId);
        if (idpConfiguration == null) {
            throw new IllegalArgumentException();
        }
        IdpConfiguration currentConfig = idpConfiguration;
        authContext.checkTenantManager(currentConfig.getTenantId());
        ClientRegistrationId clientRegistrationId = ClientRegistrationId.Companion.fromString(input.getId());
        TenantId tenantId = currentConfig.getTenantId();
        String string = input.getClientId();
        String string2 = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
        String string3 = input.getClientSecret();
        String string4 = string3 != null ? ((Object)StringsKt.trim((CharSequence)string3)).toString() : null;
        String string5 = ((Object)StringsKt.trim((CharSequence)input.getIdpName())).toString();
        String string6 = input.getUserNameAttribute();
        String string7 = string6 != null ? ((Object)StringsKt.trim((CharSequence)string6)).toString() : null;
        AuthorizationGrantType authorizationGrantType = AuthorizationGrantType.AUTHORIZATION_CODE;
        Intrinsics.checkNotNullExpressionValue((Object)authorizationGrantType, (String)"AUTHORIZATION_CODE");
        String string8 = input.getScope();
        String string9 = input.getIssuerUri();
        String string10 = input.getAuthorizationUri();
        String string11 = input.getTokenUri();
        String string12 = input.getUserInfoUri();
        String string13 = input.getJwkSetUri();
        IdpConfiguration configuration = new IdpConfiguration(clientRegistrationId, tenantId, string2, string4, string5, string7, authorizationGrantType, string8 != null ? ((Object)StringsKt.trim((CharSequence)string8)).toString() : null, string9 != null ? ((Object)StringsKt.trim((CharSequence)string9)).toString() : null, string10 != null ? ((Object)StringsKt.trim((CharSequence)string10)).toString() : null, string11 != null ? ((Object)StringsKt.trim((CharSequence)string11)).toString() : null, string12 != null ? ((Object)StringsKt.trim((CharSequence)string12)).toString() : null, string13 != null ? ((Object)StringsKt.trim((CharSequence)string13)).toString() : null, ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)input.getTargets(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null))).toString(), input.getAutomaticMode(), input.getDefaultProvider(), input.getEnabled());
        IdpConfiguration updatedConfig = this.tenantIdpConfigService.upsertIdpConfiguration(configuration);
        this.publisher.publishOAuthClientChange(updatedConfig);
        return updatedConfig;
    }

    public void removeIdp(@NotNull ClientRegistrationId id, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.errorIfIdpManagementNotActive();
        IdpConfiguration idpConfiguration = this.tenantIdpConfigService.findIdpConfiguration(id);
        if (idpConfiguration == null) {
            return;
        }
        IdpConfiguration toDelete = idpConfiguration;
        authContext.checkTenantManager(toDelete.getTenantId());
        this.tenantIdpConfigService.removeIdpConfiguration(id);
        this.publisher.publishOAuthClientDeletion(id);
    }

    @NotNull
    public Set<IdpConfiguration> setAsDefaultId(@NotNull ClientRegistrationId id, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.errorIfIdpManagementNotActive();
        authContext.checkTenantManager();
        TenantId tenantId = authContext.getTenantId();
        if (tenantId == null) {
            throw new NotAllowedException("not logged in");
        }
        TenantId tenantId2 = tenantId;
        Set allTenantIdps = this.tenantIdpConfigService.setAsDefaultIdpForTenant(id, tenantId2);
        Iterable $this$forEach$iv = allTenantIdps;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IdpConfiguration idp = (IdpConfiguration)element$iv;
            boolean bl = false;
            this.publisher.publishOAuthClientChange(idp);
        }
        return allTenantIdps;
    }

    @NotNull
    public Set<IdpConfiguration> removeDefaultProviderForTenant(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.errorIfIdpManagementNotActive();
        authContext.checkTenantManager();
        TenantId tenantId = authContext.getTenantId();
        if (tenantId == null) {
            throw new NotAllowedException("not logged in");
        }
        TenantId tenantId2 = tenantId;
        Set allTenantIdps = this.tenantIdpConfigService.removeDefaultIdpForTenant(tenantId2);
        Iterable $this$forEach$iv = allTenantIdps;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IdpConfiguration idp = (IdpConfiguration)element$iv;
            boolean bl = false;
            this.publisher.publishOAuthClientChange(idp);
        }
        return allTenantIdps;
    }

    private void errorIfIdpManagementNotActive() {
        if (!this.superopertyConnector.isIdpConfigurationEnabled()) {
            throw new NotAllowedException("Identity provider configuration is not enabled.");
        }
    }
}

