/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.web;

import de.justsoftware.admin.application.util.TransactionSupport;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.domain.appsettings.AppSettingsService;
import de.justsoftware.admin.domain.appsettings.model.AppPermission;
import de.justsoftware.admin.domain.appsettings.model.AppSettings;
import de.justsoftware.admin.domain.appsettings.model.CoreApp;
import de.justsoftware.admin.domain.appsettings.model.PermissionChanges;
import de.justsoftware.admin.kafka.publisher.Publisher;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J4\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00162\u0006\u0010\u0018\u001a\u00020\u000fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/admin/application/web/AppSettingsApplicationService;", "", "appSettingsService", "Lde/justsoftware/admin/domain/appsettings/AppSettingsService;", "publisher", "Lde/justsoftware/admin/kafka/publisher/Publisher;", "transactionSupport", "Lde/justsoftware/admin/application/util/TransactionSupport;", "(Lde/justsoftware/admin/domain/appsettings/AppSettingsService;Lde/justsoftware/admin/kafka/publisher/Publisher;Lde/justsoftware/admin/application/util/TransactionSupport;)V", "getAppPermissions", "", "Lde/justsoftware/admin/domain/appsettings/model/AppPermission;", "app", "Lde/justsoftware/admin/domain/appsettings/model/CoreApp;", "authorizationContext", "Lde/justsoftware/admin/authorization/AuthorizationContext;", "getAppSettings", "Lde/justsoftware/admin/domain/appsettings/model/AppSettings;", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "updatePermissions", "add", "", "remove", "authContext", "admin-service"})
@SourceDebugExtension(value={"SMAP\nAppSettingsApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppSettingsApplicationService.kt\nde/justsoftware/admin/application/web/AppSettingsApplicationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1549#2:74\n1620#2,3:75\n*S KotlinDebug\n*F\n+ 1 AppSettingsApplicationService.kt\nde/justsoftware/admin/application/web/AppSettingsApplicationService\n*L\n38#1:74\n38#1:75,3\n*E\n"})
public class AppSettingsApplicationService {
    @NotNull
    private final AppSettingsService appSettingsService;
    @NotNull
    private final Publisher publisher;
    @NotNull
    private final TransactionSupport transactionSupport;

    public AppSettingsApplicationService(@NotNull AppSettingsService appSettingsService, @NotNull Publisher publisher, @NotNull TransactionSupport transactionSupport) {
        Intrinsics.checkNotNullParameter((Object)appSettingsService, (String)"appSettingsService");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        this.appSettingsService = appSettingsService;
        this.publisher = publisher;
        this.transactionSupport = transactionSupport;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public AppSettings updatePermissions(@NotNull CoreApp app, @NotNull Set<AppPermission> add, @NotNull Set<AppPermission> remove, @NotNull AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter(add, (String)"add");
        Intrinsics.checkNotNullParameter(remove, (String)"remove");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        TenantId tenantId = authContext.getTenantId();
        if (tenantId == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        TenantId tenantId2 = tenantId;
        authContext.checkTenantManager();
        Iterable iterable = SetsKt.plus(add, (Iterable)remove);
        AuthorizationContext authorizationContext = authContext;
        boolean $i$f$map = false;
        void var8_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AppPermission appPermission = (AppPermission)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getGranteeId());
        }
        authorizationContext.checkAllTenantReader((Collection)((List)destination$iv$iv));
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return this.appSettingsService.setPermissions(tenantId2, app, new PermissionChanges((Collection)add, (Collection)remove));
    }

    @NotNull
    public List<AppSettings> getAppSettings(@NotNull TenantId tenantId, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(tenantId);
        return this.appSettingsService.getSettingsList(tenantId);
    }

    @NotNull
    public AppSettings getAppSettings(@NotNull TenantId tenantId, @NotNull CoreApp app, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(tenantId);
        return this.appSettingsService.getSettings(tenantId, app);
    }

    @NotNull
    public List<AppPermission> getAppPermissions(@NotNull CoreApp app, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager();
        TenantId tenantId = authorizationContext.getTenantId();
        if (tenantId == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        TenantId tenantId2 = tenantId;
        return this.appSettingsService.getPermissions(tenantId2, app);
    }

    public static final /* synthetic */ Publisher access$getPublisher$p(AppSettingsApplicationService $this) {
        return $this.publisher;
    }
}

