/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.internal.controller;

import de.justsoftware.admin.application.internal.RepublishApplicationService;
import de.justsoftware.admin.domain.tenant.TenantService;
import de.justsoftware.admin.domain.tenant.model.TenantSettings;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/internal"})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0011\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0013J\b\u0010\u000b\u001a\u00020\fH\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/justsoftware/admin/application/internal/controller/InternalController;", "", "republishApplicationService", "Lde/justsoftware/admin/application/internal/RepublishApplicationService;", "tenantService", "Lde/justsoftware/admin/domain/tenant/TenantService;", "(Lde/justsoftware/admin/application/internal/RepublishApplicationService;Lde/justsoftware/admin/domain/tenant/TenantService;)V", "getTenantSettings", "Lde/justsoftware/admin/domain/tenant/model/TenantSettings;", "tenantId", "", "postRepublish", "", "admin-service"})
public class InternalController {
    @NotNull
    private final RepublishApplicationService republishApplicationService;
    @NotNull
    private final TenantService tenantService;

    public InternalController(@NotNull RepublishApplicationService republishApplicationService, @NotNull TenantService tenantService) {
        Intrinsics.checkNotNullParameter((Object)republishApplicationService, (String)"republishApplicationService");
        Intrinsics.checkNotNullParameter((Object)tenantService, (String)"tenantService");
        this.republishApplicationService = republishApplicationService;
        this.tenantService = tenantService;
    }

    @GetMapping(value={"/tenant/{tenantId}"})
    private TenantSettings getTenantSettings(@PathVariable String tenantId) {
        return this.tenantService.getSettings(TenantId.Companion.parse(tenantId));
    }

    @PostMapping(value={"/republish-tenants"})
    @ResponseStatus(value=HttpStatus.OK)
    private void postRepublish() {
        this.republishApplicationService.republishAllTenants();
    }
}

