/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.internal;

import de.justsoftware.admin.domain.appsettings.AppSettingsService;
import de.justsoftware.admin.domain.tenant.TenantInvitationService;
import de.justsoftware.admin.domain.tenant.TenantPermissionService;
import de.justsoftware.admin.domain.tenant.TenantService;
import de.justsoftware.admin.domain.tenant.model.Tenant;
import de.justsoftware.admin.domain.tenant.model.TenantInvitation;
import de.justsoftware.admin.domain.user.UserService;
import de.justsoftware.admin.kafka.publisher.producer.PermissionProducer;
import de.justsoftware.admin.kafka.publisher.producer.TenantProducer;
import de.justsoftware.admin.model.itemid.ItemType;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0012J\u0016\u0010\u0014\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0012J\u0016\u0010\u0018\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0012J\u0016\u0010\u0019\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0016H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/justsoftware/admin/application/internal/RepublishApplicationService;", "", "appSettingsService", "Lde/justsoftware/admin/domain/appsettings/AppSettingsService;", "tenantService", "Lde/justsoftware/admin/domain/tenant/TenantService;", "tenantPermissionService", "Lde/justsoftware/admin/domain/tenant/TenantPermissionService;", "tenantInvitationService", "Lde/justsoftware/admin/domain/tenant/TenantInvitationService;", "permissionProducer", "Lde/justsoftware/admin/kafka/publisher/producer/PermissionProducer;", "tenantProducer", "Lde/justsoftware/admin/kafka/publisher/producer/TenantProducer;", "userService", "Lde/justsoftware/admin/domain/user/UserService;", "(Lde/justsoftware/admin/domain/appsettings/AppSettingsService;Lde/justsoftware/admin/domain/tenant/TenantService;Lde/justsoftware/admin/domain/tenant/TenantPermissionService;Lde/justsoftware/admin/domain/tenant/TenantInvitationService;Lde/justsoftware/admin/kafka/publisher/producer/PermissionProducer;Lde/justsoftware/admin/kafka/publisher/producer/TenantProducer;Lde/justsoftware/admin/domain/user/UserService;)V", "republishAllTenants", "", "republishAppRoles", "republishApps", "allTenantIds", "", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "republishTenantRoles", "republishTenants", "allTenants", "Lde/justsoftware/admin/domain/tenant/model/Tenant;", "admin-service"})
@SourceDebugExtension(value={"SMAP\nRepublishApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepublishApplicationService.kt\nde/justsoftware/admin/application/internal/RepublishApplicationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1549#2:107\n1620#2,3:108\n1855#2,2:111\n*S KotlinDebug\n*F\n+ 1 RepublishApplicationService.kt\nde/justsoftware/admin/application/internal/RepublishApplicationService\n*L\n43#1:107\n43#1:108,3\n90#1:111,2\n*E\n"})
public class RepublishApplicationService {
    @NotNull
    private final AppSettingsService appSettingsService;
    @NotNull
    private final TenantService tenantService;
    @NotNull
    private final TenantPermissionService tenantPermissionService;
    @NotNull
    private final TenantInvitationService tenantInvitationService;
    @NotNull
    private final PermissionProducer permissionProducer;
    @NotNull
    private final TenantProducer tenantProducer;
    @NotNull
    private final UserService userService;

    public RepublishApplicationService(@NotNull AppSettingsService appSettingsService, @NotNull TenantService tenantService, @NotNull TenantPermissionService tenantPermissionService, @NotNull TenantInvitationService tenantInvitationService, @NotNull PermissionProducer permissionProducer, @NotNull TenantProducer tenantProducer, @NotNull UserService userService) {
        Intrinsics.checkNotNullParameter((Object)appSettingsService, (String)"appSettingsService");
        Intrinsics.checkNotNullParameter((Object)tenantService, (String)"tenantService");
        Intrinsics.checkNotNullParameter((Object)tenantPermissionService, (String)"tenantPermissionService");
        Intrinsics.checkNotNullParameter((Object)tenantInvitationService, (String)"tenantInvitationService");
        Intrinsics.checkNotNullParameter((Object)permissionProducer, (String)"permissionProducer");
        Intrinsics.checkNotNullParameter((Object)tenantProducer, (String)"tenantProducer");
        Intrinsics.checkNotNullParameter((Object)userService, (String)"userService");
        this.appSettingsService = appSettingsService;
        this.tenantService = tenantService;
        this.tenantPermissionService = tenantPermissionService;
        this.tenantInvitationService = tenantInvitationService;
        this.permissionProducer = permissionProducer;
        this.tenantProducer = tenantProducer;
        this.userService = userService;
    }

    /*
     * WARNING - void declaration
     */
    public void republishAllTenants() {
        void $this$mapTo$iv$iv;
        List allTenants = this.tenantService.getTenants();
        if (allTenants.isEmpty()) {
            throw new IllegalStateException("Tenant migration need to be executed first! Abort to prevent deletion of toro permissions");
        }
        Iterable $this$map$iv = allTenants;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Tenant tenant = (Tenant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List allTenantIds = (List)destination$iv$iv;
        this.republishTenants(allTenants);
        this.republishApps(allTenantIds);
        this.republishTenantRoles(allTenantIds);
        this.republishAppRoles();
    }

    private void republishAppRoles() {
        this.permissionProducer.republishAppRoles$admin_service((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void republishTenantRoles(List<TenantId> allTenantIds) {
        List allUserGroups = this.userService.getAllUserGroups();
        this.permissionProducer.republishTenantRoles$admin_service((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void republishApps(List<TenantId> allTenantIds) {
        this.permissionProducer.republishItems$admin_service(ItemType.APP, (Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void republishTenants(List<Tenant> allTenants) {
        Iterable $this$forEach$iv = allTenants;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Tenant tenant = (Tenant)element$iv;
            boolean bl = false;
            TenantInvitation tenantInvitation = (TenantInvitation)CollectionsKt.firstOrNull((List)this.tenantInvitationService.getTenantInvitations(tenant.getId()));
            this.tenantProducer.publish$admin_service(tenant, CollectionsKt.toSet((Iterable)this.appSettingsService.getSettingsList(tenant.getId())), this.tenantService.getSettings(tenant.getId()), tenantInvitation != null ? tenantInvitation.getTenantInvitationCode() : null);
        }
        this.permissionProducer.republishItems$admin_service(ItemType.TENANT, (Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static final /* synthetic */ AppSettingsService access$getAppSettingsService$p(RepublishApplicationService $this) {
        return $this.appSettingsService;
    }

    public static final /* synthetic */ PermissionProducer access$getPermissionProducer$p(RepublishApplicationService $this) {
        return $this.permissionProducer;
    }

    public static final /* synthetic */ TenantPermissionService access$getTenantPermissionService$p(RepublishApplicationService $this) {
        return $this.tenantPermissionService;
    }
}

