--liquibase formatted sql
--preconditions dbms:oracle

--changeset tsubklewe:postprocessing_update_shadow_triggers runAlways:true
create or replace function
    simple_join(s1 varchar2, sep varchar2, s2 varchar2)
    return varchar2 is
begin
if (length(s1) > 0 and length(s2) > 0) then
    return s1 || sep || s2;
else
    return s1 || s2;
end if;
end simple_join;
/

create or replace function
    compare_tables(table1 varchar2, table2 varchar2, filter_col varchar2)
    return varchar2 is
    obsolete_columns varchar2(4000 char) := '';
begin
for obs_col in (
    select table1 || '.' || column_name as obs_col_name
    from user_tab_columns
    where table_name = table1
    minus
    select table1 || '.' || column_name as obs_col_name
    from user_tab_columns
    where table_name = table2
  )
  loop
    if (length(filter_col) = 0 or obs_col.obs_col_name <> table1 || '.' || filter_col) then
      obsolete_columns := simple_join(obsolete_columns, ', ', obs_col.obs_col_name);
end if;
end loop;

return obsolete_columns;
end compare_tables;
/

create or replace procedure
    check_for_obsolete_columns
is
    obsolete_columns varchar2(4000 char) := '';
begin
for sh_rec in
    (select table_name, shadow_table_name from shadow_table)
  loop
    obsolete_columns := simple_join(obsolete_columns, ', ', compare_tables(sh_rec.table_name, sh_rec.shadow_table_name, ''));
obsolete_columns := simple_join(obsolete_columns, ', ', compare_tables(sh_rec.shadow_table_name, sh_rec.table_name, 'DELETE_ACTION_ID'));
end loop;

if length(obsolete_columns) > 0 then
    raise_application_error(-20001, 'Unexpected columns found: ' || obsolete_columns);
end if;
end check_for_obsolete_columns;
/

create or replace procedure
    update_shadow_triggers
is
    tr_name varchar2(30 char);
stmt varchar2(4000 char);
insert_cols varchar2(4000 char);
insert_vals varchar2(4000 char);
begin
for sh_rec in
    (select table_name, shadow_table_name, delete_action_mandatory from shadow_table)
  loop
    tr_name := substr(sh_rec.shadow_table_name, 4) || '_BD';
stmt := 'create or replace trigger ' || tr_name || ' before delete on "' || sh_rec.table_name || '" for each row' || chr(10);
stmt := stmt || 'declare del_ac_id number;'  || chr(10);
stmt := stmt || 'begin'  || chr(10);
stmt := stmt || '  select id into del_ac_id from delete_action where transaction_id = dbms_transaction.local_transaction_id and transaction_id is not null and archive_data = ''t'';'  || chr(10);
stmt := stmt || '  insert into ' || sh_rec.shadow_table_name || '(';

insert_cols := '';
insert_vals := '';
for col_rec in
      (select column_name from user_tab_columns where table_name = sh_rec.table_name order by column_id)
    loop
      insert_cols := insert_cols || '"' || col_rec.column_name || '", ';
insert_vals := insert_vals || ':OLD."' || col_rec.column_name || '", ';
end loop;

stmt := stmt || insert_cols || 'DELETE_ACTION_ID)' || chr(10);
stmt := stmt || '  values (' || insert_vals || 'del_ac_id);' || chr(10);
stmt := stmt || 'exception when no_data_found then' || chr(10);
if sh_rec.delete_action_mandatory = 't' then
      stmt := stmt || '  raise_application_error(-20001, ''No delete action for current transaction found while trying to delete from ' || sh_rec.table_name || ''');' || chr(10);
else
      stmt := stmt || '  null;' || chr(10);
end if;
stmt := stmt || 'end;';

execute immediate stmt;
end loop;
end update_shadow_triggers;
/

begin
check_for_obsolete_columns;
update_shadow_triggers;
end;
/
