--liquibase formatted sql
--preconditions dbms:oracle


--changeset tsubklewe:insert_initial_structure
--preconditions onFail:MARK_RAN onError:HALT
--precondition-sql-check expectedResult:0 select count(*) from all_objects where object_type in ('TABLE','VIEW') and object_name = 'JUCO_VERSION';
create sequence SEQ_BASE_PROPERTY
    nocache
/

create sequence SEQ_DOMAIN_PROPERTY
    nocache
/

create sequence ENTITY_SEQ
    nocache
/

create sequence ENTITY_NAV_LINK_SEQ
    nocache
/

create sequence MDL_ALBUM_SEQ
    nocache
/

create sequence MDL_ALBUM_IMAGE_SEQ
    nocache
/

create sequence MDL_COMMENT_SEQ
    nocache
/

create sequence MDL_DOCUMENT_VERSION_SEQ
    nocache
/

create sequence MDL_DOCUMENT_SEQ
    nocache
/

create sequence MDL_VIDEO_LINK_SEQ
    nocache
/

create sequence NEWS_BLOG_SEQ
    nocache
/

create sequence PERSON_SEQ
    nocache
/

create sequence RAWEDITOR_SEQ
    nocache
/

create sequence RAWEDITOR_VERSION_SEQ
    nocache
/

create sequence SURVEY_SEQ
    nocache
/

create sequence SURVEY_PREDEFINED_ANSWER_SEQ
    nocache
/

create sequence SURVEY_QUESTION_SEQ
    nocache
/

create sequence UNIVERSITY_SEQ
    nocache
/

create sequence WIKI_EDITOR_SEQ
    nocache
/

create sequence WIKI_EDITOR_VERSION_SEQ
    nocache
/

create sequence WORKSTREAM_ENTRY_SEQ
    nocache
/

create sequence SEARCH_INDEX_QUEUE_SEQ
    minvalue 0
    nocache
/

create sequence ITEM_EVENT_QUEUE_SEQ
    minvalue 0
    nocache
/

create sequence MULTI_WIKI_SEQ
    nocache
/

create sequence MULTI_WIKI_VERSION_SEQ
    nocache
/

create sequence MULTI_WIKI_VERSION_SECTION_SEQ
    nocache
/

create sequence ENTITY_VERSION_SEQ
    minvalue 0
    nocache
/

create sequence MULTI_WIKI_SECTION_SEQ
    nocache
/

create sequence ENTITY_NAV_SUBLINK_SEQ
    nocache
/

create sequence AUDIT_LOG_SEQ
    minvalue 0
    nocache
/

create sequence DELETE_ACTION_SEQ
    minvalue 0
    nocache
/

create sequence ENTITY_DEFAULT_DESIGN_SEQ
    nocache
/

create sequence ITEM_VISIBILITY_QUEUE_SEQ
    minvalue 0
    nocache
/

create sequence LINK_SEQ
    minvalue 0
    nocache
/

create sequence NOTIFICATION_SEQ
    minvalue 0
    nocache
/

create sequence THEME_SEQ
    minvalue 0
    nocache
/

create sequence ENTITY_WAITLIST_ORDER_SEQ
    nocache
/

create sequence ENTITY_STATUS_SEQ
    minvalue 0
    nocache
/

create sequence CONVERSATION_SEQ
    minvalue 0
    nocache
/

create sequence CONVERSATION_MESSAGE_SEQ
    minvalue 0
    nocache
/

create sequence EXPORT_ITEM_EVENT_QUEUE_SEQ
    minvalue 0
    nocache
/

create sequence JUCO_VERSION_SEQ
    minvalue 0
    nocache
/

create sequence PUSH_TARGET_APP_SEQ
    minvalue 0
    nocache
/

create sequence CHAT_SEARCH_QUEUE_SEQ
    minvalue 0
    nocache
/

create sequence CONVERSATION_SEARCH_QUEUE_SEQ
    minvalue 0
    nocache
/

create sequence PROFILE_ATTRIBUTE_SEQ
    minvalue 0
    nocache
/

create sequence ITEM_VISIBILITY_ROLE_SEQ
/

create sequence SEARCH_FILTER_SEQ
    minvalue 0
    nocache
/

create sequence CONVERSATION_CHANGE_SEQ
    nocache
/

create sequence CONVERSATION_ATTACHMENT_SEQ
    minvalue 0
    nocache
/

create table DELETE_ACTION
(
    ID             NUMBER(19)                 not null
        constraint DELETE_ACTION_PK
            primary key,
    PERSON_ID      NUMBER(19)                 not null,
    DELETED_AT     TIMESTAMP(6) default systimestamp,
    TRANSACTION_ID VARCHAR2(4000 char)
        constraint DELETE_ACTION_TRN_ID_UQ
            unique,
    DESCRIPTOR     VARCHAR2(255 char)         not null,
    ARCHIVE_DATA   CHAR         default ('t') not null,
    ITEM_ID        VARCHAR2(255 char)         not null
)
/

create index DELETE_ACTION_DELAT_ID_IDX
    on DELETE_ACTION (DELETED_AT, ID)
/

create trigger DELETE_ACTION_BRI
    before insert
    on DELETE_ACTION
    for each row
DECLARE
    tn_id varchar2(4000 CHAR);
BEGIN
tn_id := dbms_transaction.local_transaction_id(TRUE);
:NEW.transaction_id := tn_id;
END;
/

create table SHADOW_TABLE
(
    TABLE_NAME              VARCHAR2(30 char) not null
        constraint SHADOW_TABLE_PK
            primary key,
    SHADOW_TABLE_NAME       VARCHAR2(30 char) not null,
    DELETE_ACTION_MANDATORY CHAR(1 char)      not null
)
/

create table SH_DEFAULT_ALBUM
(
    ITEM_ID          NUMBER(19),
    ITEM_TYPE        VARCHAR2(32 char),
    ALBUM_ID         NUMBER(19),
    DELETE_ACTION_ID NUMBER(19) not null
        references DELETE_ACTION
)
/

create table SH_EMAIL_NOTIFICATION_SETTING
(
    PERSON_ID             NUMBER(19) not null
        primary key,
    CREATE_DATE           TIMESTAMP(6),
    MODIFY_DATE           TIMESTAMP(6),
    NOTIFICATIONS_ENABLED CHAR(1 char),
    DELETE_ACTION_ID      NUMBER(19) not null
        references DELETE_ACTION
)
/

create table SH_ENTITY
(
    ID                          NUMBER(19) not null
        primary key,
    NAME                        VARCHAR2(255 char),
    START_AT                    TIMESTAMP(6),
    END_AT                      TIMESTAMP(6),
    CLOSING_DATE                TIMESTAMP(6),
    TIMEZONE                    VARCHAR2(255 char),
    DESCRIPTION                 CLOB,
    LOCATION                    VARCHAR2(255 char),
    TAGS                        CLOB,
    SUBDOMAIN                   VARCHAR2(255 char),
    SUBDOMAIN_DEACTIVATED       CHAR(1 char),
    EXTERNAL_DOMAIN             VARCHAR2(255 char),
    LOGO                        VARCHAR2(255 char),
    ICON                        VARCHAR2(255 char),
    CREATE_DATE                 TIMESTAMP(6),
    MODIFY_DATE                 TIMESTAMP(6),
    USE_PARENT_ADMIN_AS_COADMIN CHAR(1 char),
    ENTITY_TYPE                 VARCHAR2(255 char),
    DELETE_ACTION_ID            NUMBER(19) not null
        references DELETE_ACTION,
    SLIDESHOW_IMAGE             VARCHAR2(255),
    PARTICIPANT_LIMIT           NUMBER(19),
    ASSIGNEE_ID                 NUMBER(19),
    DEFAULT_ENTITY_TAB          VARCHAR2(256 char),
    DEFAULT_NAVIGATION          CHAR,
    LAST_DRIVE_CHANGE           NUMBER(10)
)
/

create table SH_ENTITY_TENANT
(
    ENTITY_ID NUMBER(19)                        not null,
    TENANT_ID RAW(16)                           not null,
    CTIME     TIMESTAMP(6) default systimestamp not null,
    MTIME     TIMESTAMP(6) default systimestamp not null
)
/

create table SH_ENTITY_COMPONENT
(
    ENTITY_ID        NUMBER(19)         not null,
    COMPONENT_TYPE   VARCHAR2(255 char) not null,
    "position"       NUMBER(19),
    "order"          NUMBER,
    VISIBLE          CHAR(1 char),
    "open"           CHAR(1 char),
    CUSTOMIZED_TITLE CLOB,
    DELETE_ACTION_ID NUMBER(19)         not null
        references DELETE_ACTION,
    primary key (ENTITY_ID, COMPONENT_TYPE)
)
/

create table SH_PERSON_TENANT
(
    PERSON_ID NUMBER(19)                        not null,
    TENANT_ID RAW(16)                           not null,
    CTIME     TIMESTAMP(6) default systimestamp not null,
    MTIME     TIMESTAMP(6) default systimestamp not null
)
/

create table SH_ENTITY_COMPONENT_OPEN_FOR
(
    ENTITY_ID        NUMBER(19)         not null,
    COMPONENT_TYPE   VARCHAR2(255 char) not null,
    AUTHORITY_NAME   VARCHAR2(50 char)  not null,
    DELETE_ACTION_ID NUMBER(19)         not null
        references DELETE_ACTION,
    primary key (ENTITY_ID, COMPONENT_TYPE, AUTHORITY_NAME)
)
/

create table SH_ENTITY_RECOMMENDATION
(
    PERSON_ID         NUMBER(19)          not null,
    ENTITY_ID         NUMBER(19)          not null,
    RECOMMENDER_ID    NUMBER(19),
    RECOMMEND_MESSAGE VARCHAR2(4000 char) not null,
    CREATE_DATE       TIMESTAMP(6),
    DELETE_ACTION_ID  NUMBER(19)          not null
        references DELETE_ACTION,
    primary key (ENTITY_ID, PERSON_ID)
)
/

create table SH_SUBSCRIPTIONS
(
    SUBSCRIBER_ID      NUMBER(19),
    SUBSCRIPTION_TYPE  VARCHAR2(32 char),
    SUBSCRIPTION_STATE VARCHAR2(32 char),
    CREATED_AT         TIMESTAMP(6),
    MODIFIED_AT        TIMESTAMP(6),
    DELETE_ACTION_ID   NUMBER(19)
        references DELETE_ACTION,
    ITEM_ID            VARCHAR2(255 char)
)
/

create table SH_TASKS
(
    ID               RAW(16),
    NAME             VARCHAR2(2048 char),
    DESCRIPTION      CLOB,
    OWNER_ID         NUMBER(19),
    ASSIGNEE_ID      NUMBER(19),
    STATUS           VARCHAR2(255 char),
    CREATE_DATE      TIMESTAMP(6),
    MODIFY_DATE      TIMESTAMP(6),
    PARENT_TASK_ID   RAW(16),
    DELETE_ACTION_ID NUMBER(19)
        constraint SH_TASKS_DELETE_ACTION_ID_FK
            references DELETE_ACTION,
    ATTACHMENT_NAME  VARCHAR2(255 char),
    ATTACHMENT_URL   VARCHAR2(255 char),
    TASK_LIST_ID     RAW(16),
    DUE_DATE         TIMESTAMP(6)
)
/

create table SH_TASK_LIST
(
    ID               RAW(16),
    NAME             VARCHAR2(255 char),
    CREATE_DATE      TIMESTAMP(6),
    MODIFY_DATE      TIMESTAMP(6),
    DELETE_ACTION_ID NUMBER(19)
        constraint SH_T_L_DELETE_ACTION_ID_FK
            references DELETE_ACTION
)
/

create table SH_TASK_LIST_PERMISSIONS
(
    TASK_LIST_ID     RAW(16),
    ROLE             VARCHAR2(64 char),
    TASK_RIGHT       VARCHAR2(64 char),
    CTIME            TIMESTAMP(6),
    MTIME            TIMESTAMP(6),
    DELETE_ACTION_ID NUMBER(19)
        constraint SH_T_L_P_DELETE_ACTION_ID_FK
            references DELETE_ACTION
)
/

create table SH_PROFILE_ATTRIBUTE
(
    ID               NUMBER(19),
    PERSON_ID        NUMBER(19),
    NAME             VARCHAR2(255 char),
    VALUE            CLOB,
    VALUE_ORDER      NUMBER(10),
    BLOCK_ORDER      NUMBER(10),
    DELETE_ACTION_ID NUMBER(19)
        constraint SH_PRFL_ATTR_DEL_ACTION_ID_FK
            references DELETE_ACTION,
    CREATE_DATE      TIMESTAMP(6)
)
/

create table SH_CONVERSATION
(
    ID                  NUMBER(19) not null
        primary key,
    TYPE                VARCHAR2(255 char),
    CREATE_DATE         TIMESTAMP(6),
    TITLE               VARCHAR2(1024 char),
    LAST_MESSAGE_DATE   TIMESTAMP(6),
    DELETE_ACTION_ID    NUMBER(19) not null
        references DELETE_ACTION,
    CREATION_ID         VARCHAR2(100 char),
    LAST_MESSAGE_UPDATE TIMESTAMP(6)
)
/

create table SH_CONVERSATION_MESSAGE
(
    ID               NUMBER(19) not null
        primary key,
    CONVERSATION_ID  NUMBER(19),
    FROM_PERSON_ID   NUMBER(19),
    CREATE_DATE      TIMESTAMP(6),
    MESSAGE          CLOB,
    MESSAGE_TYPE     VARCHAR2(32 char),
    DELETE_ACTION_ID NUMBER(19) not null
        references DELETE_ACTION,
    CREATION_ID      VARCHAR2(100 char),
    MODIFY_DATE      TIMESTAMP(6),
    DELETE_DATE      TIMESTAMP(6)
)
/

create table SH_CONVERSATION_PARTICIPANT
(
    CONVERSATION_ID           NUMBER(19),
    PARTICIPANT_ID            NUMBER(19),
    CREATE_DATE               TIMESTAMP(6),
    MODIFY_DATE               TIMESTAMP(6),
    READ_DATE                 TIMESTAMP(6),
    DELETED                   CHAR(1 char),
    LAST_MAIL_SENT            TIMESTAMP(6),
    DELETED_WITH_CONVERSATION CHAR(1 char),
    DELETE_ACTION_ID          NUMBER(19) not null
        references DELETE_ACTION
)
/

create table SH_CONVERSATION_SETTINGS
(
    CONVERSATION_ID  NUMBER(19) not null,
    PARTICIPANT_ID   NUMBER(19) not null,
    MUTED            CHAR(1 char),
    CREATE_DATE      TIMESTAMP(6),
    MODIFY_DATE      TIMESTAMP(6),
    HIDDEN           CHAR(1 char),
    DELETE_ACTION_ID NUMBER(19) not null
        references DELETE_ACTION,
    primary key (CONVERSATION_ID, PARTICIPANT_ID)
)
/

create table SH_ENTITY_MEMBER_ROLE
(
    PERSON_ID        NUMBER(19)   not null,
    ENTITY_ID        NUMBER(19)   not null,
    ROLE             VARCHAR2(50) not null,
    CREATE_DATE      TIMESTAMP(6),
    DELETE_ACTION_ID NUMBER(19)   not null
        constraint SH_E_M_R_DELETE_FK
            references DELETE_ACTION,
    WORKFLOW         VARCHAR2(16),
    constraint SH_E_M_R_PK
        primary key (ENTITY_ID, PERSON_ID, ROLE, DELETE_ACTION_ID)
)
/

create table SH_ENTITY_WAITLIST
(
    ENTITY_ID        NUMBER(19),
    PERSON_ID        NUMBER(19),
    WAITLIST_ORDER   NUMBER(19),
    DELETE_ACTION_ID NUMBER(19)
        references DELETE_ACTION
)
/

create table SH_ENTITY_INTERNAL_INVITATION
(
    PERSON_ID        NUMBER(19) not null,
    ENTITY_ID        NUMBER(19) not null,
    INVITER_ID       NUMBER(19),
    INVITE_MESSAGE   CLOB,
    CREATE_DATE      TIMESTAMP(6),
    DELETE_ACTION_ID NUMBER(19) not null
        constraint SH_E_I_I_DELETE_FK
            references DELETE_ACTION,
    constraint SH_E_I_I_PK
        primary key (ENTITY_ID, PERSON_ID, DELETE_ACTION_ID)
)
/

create table SH_CONVERSATION_ATTACHMENT
(
    ID                  NUMBER(19) not null
        primary key,
    MESSAGE_ID          NUMBER(19),
    DOCUMENT_ID         VARCHAR2(255 char),
    DOCUMENT_VERSION_ID VARCHAR2(255 char),
    FILENAME            VARCHAR2(255 char),
    FILE_SIZE           NUMBER(19),
    CONTENT_TYPE        VARCHAR2(255 char),
    VERSION             VARCHAR2(255 char),
    ATTACHMENT_TYPE     VARCHAR2(255 char),
    IMAGE_HEIGHT        NUMBER(10),
    IMAGE_WIDTH         NUMBER(10),
    CREATE_DATE         TIMESTAMP(6),
    DELETE_ACTION_ID    NUMBER(19) not null
        references DELETE_ACTION
)
/

create table SH_USER_SETTING
(
    PERSON_ID        NUMBER(10)        not null,
    KEY              VARCHAR2(30 char) not null,
    VALUE            VARCHAR2(4000 char),
    CREATE_DATE      TIMESTAMP(6),
    MODIFY_DATE      TIMESTAMP(6),
    DELETE_ACTION_ID NUMBER(19)        not null
        references DELETE_ACTION,
    primary key (PERSON_ID, KEY)
)
/

create table SH_ENTITY_DYNAMIC_ATTRIBUTE
(
    ENTITY_ID        NUMBER,
    ATTRIBUTE_ID     VARCHAR2(255 char),
    ATTRIBUTE_VALUE  CLOB,
    POSITION         NUMBER,
    DELETE_ACTION_ID NUMBER(19) not null
        references DELETE_ACTION
)
/

create table SH_ENTITY_LINK
(
    ENTITY_ID        NUMBER(19) not null,
    LINKED_ENTITY_ID NUMBER(19) not null,
    CREATE_DATE      TIMESTAMP(6),
    MODIFY_DATE      TIMESTAMP(6),
    DELETE_ACTION_ID NUMBER(19) not null
        references DELETE_ACTION,
    INHERIT_ADMIN    CHAR default NULL,
    INHERIT_MEMBER   CHAR default NULL,
    primary key (ENTITY_ID, LINKED_ENTITY_ID)
)
/

create table SH_ENTITY_PRIVACY
(
    ENTITY_ID        NUMBER(19),
    PRIVACY_TYPE     VARCHAR2(50 char),
    AUTHORITY_NAME   VARCHAR2(50 char),
    CREATE_DATE      TIMESTAMP(6),
    MODIFY_DATE      TIMESTAMP(6),
    DELETE_ACTION_ID NUMBER(19) not null
        references DELETE_ACTION
)
/

create table SH_ENTITY_TO_ENTITY_TYPE_PRIVA
(
    ENTITY_ID        NUMBER(19)         not null,
    ENTITY_TYPE      VARCHAR2(255 char) not null,
    AUTHORITY_NAME   VARCHAR2(50 char)  not null,
    CREATE_DATE      TIMESTAMP(6),
    MODIFY_DATE      TIMESTAMP(6),
    DELETE_ACTION_ID NUMBER(19)         not null
        references DELETE_ACTION,
    primary key (ENTITY_ID, ENTITY_TYPE, AUTHORITY_NAME)
)
/

create table SH_ENTITY_VERSION
(
    ID                    NUMBER(19) not null
        primary key,
    ENTITY_ID             NUMBER(19),
    PERSON_ID             NUMBER(19),
    MAJOR_VERSION         NUMBER,
    MINOR_VERSION         NUMBER,
    DRAFT_VERSION         NUMBER,
    VERSION_TYPE          VARCHAR2(255 char),
    TARGET_TYPE           VARCHAR2(255 char),
    VERSION_STATUS        VARCHAR2(255 char),
    RELEASE_DATE          TIMESTAMP(6),
    EXPIRATION_DATE       TIMESTAMP(6),
    CHANGE_MESSAGE        VARCHAR2(512 char),
    COMMENT_FOR_REVIEWERS VARCHAR2(255 char),
    READ_DATE             DATE,
    DECLINE_MESSAGE       VARCHAR2(255 char),
    CREATE_DATE           TIMESTAMP(6),
    MODIFY_DATE           TIMESTAMP(6),
    DELETE_ACTION_ID      NUMBER(19) not null
        references DELETE_ACTION,
    ENTITY_STATUS_ID      NUMBER(19)
)
/

create table SH_ENTITY_VERSION_COMPONENTS
(
    ENTITY_VERSION_ID     NUMBER(19),
    MULTI_WIKI_VERSION_ID NUMBER(19),
    DELETE_ACTION_ID      NUMBER(19) not null
        references DELETE_ACTION
)
/

create table SH_ENTITY_VERSION_REVIEW
(
    ENTITY_VERSION_ID NUMBER(19) not null,
    REVIEWER_ID       NUMBER(19) not null,
    INVITER_ID        NUMBER(19),
    REVIEW_STATUS     VARCHAR2(255 char),
    REVIEW_ORDER      NUMBER(19),
    DELETE_ACTION_ID  NUMBER(19) not null
        references DELETE_ACTION,
    primary key (ENTITY_VERSION_ID, REVIEWER_ID)
)
/

create table SH_EXTERNAL_INVITATION
(
    INVITER_ID       NUMBER(19),
    EMAIL            VARCHAR2(100 char),
    HASH             VARCHAR2(100 char) not null
        primary key,
    ENTITY_ID        NUMBER(19),
    DELETE_ACTION_ID NUMBER(19)         not null
        references DELETE_ACTION
)
/

create table SH_LIKE_TABLE
(
    LIKER_ID         NUMBER(19),
    CREATED_AT       TIMESTAMP(6),
    MODIFIED_AT      TIMESTAMP(6),
    RECENT           CHAR(1 char),
    DELETE_ACTION_ID NUMBER(19) not null
        references DELETE_ACTION,
    ITEM_ID          VARCHAR2(255 char)
)
/

create table SH_MAP_PERSON_PERSON
(
    PERSON_ID        NUMBER(19) not null,
    FRIEND_ID        NUMBER(19) not null,
    DELETE_ACTION_ID NUMBER(19) not null
        references DELETE_ACTION,
    primary key (PERSON_ID, FRIEND_ID)
)
/

create table SH_MAP_PERSON_PERSON_INVITE
(
    PERSON_ID        NUMBER(19) not null,
    FRIEND_ID        NUMBER(19) not null,
    MESSAGE          CLOB,
    DELETE_ACTION_ID NUMBER(19) not null
        references DELETE_ACTION,
    primary key (PERSON_ID, FRIEND_ID)
)
/

create table SH_MDL_ALBUM
(
    ID               NUMBER(19) not null
        primary key,
    PARENT_ITEM_ID   NUMBER(19),
    PARENT_ITEM_TYPE VARCHAR2(32 char),
    MODULE           CHAR(1 char),
    OWNER_ID         NUMBER(19),
    CREATE_DATE      TIMESTAMP(6),
    EDIT_DATE        TIMESTAMP(6),
    TITLE            VARCHAR2(255 char),
    DESCRIPTION      CLOB,
    LOCATION         VARCHAR2(80 char),
    FRIENDS_ONLY     CHAR(1 char),
    OLD_ALBUM_ID     NUMBER(19),
    DELETE_ACTION_ID NUMBER(19) not null
        references DELETE_ACTION
)
/

create table SH_MDL_ALBUM_IMAGE
(
    ID                 NUMBER(19) not null
        primary key,
    TITLE              VARCHAR2(255 char),
    ALBUM_ID           NUMBER(19),
    FILENAME           VARCHAR2(255 char),
    OWNER_ID           NUMBER(19),
    CREATE_DATE        TIMESTAMP(6),
    EDIT_DATE          TIMESTAMP(6),
    OLD_ALBUM_IMAGE_ID NUMBER(19),
    DELETE_ACTION_ID   NUMBER(19) not null
        references DELETE_ACTION
)
/

create table SH_MDL_COMMENT
(
    ID               NUMBER(19) not null
        primary key,
    AUTHOR_ID        NUMBER(19),
    POSTED_AT        TIMESTAMP(6),
    CUSTOM_INFO      VARCHAR2(255 char),
    DELETE_ACTION_ID NUMBER(19) not null
        references DELETE_ACTION,
    TEXT             CLOB,
    EDITOR_ID        NUMBER(19),
    EDITED_AT        TIMESTAMP(6),
    PARENT_ITEM_ID   VARCHAR2(255 char),
    EDITOR_MODEL     CLOB
)
/

create table SH_MDL_DOCUMENT
(
    ID                NUMBER(19) not null
        primary key,
    PARENT_ITEM_ID    NUMBER(19),
    PARENT_ITEM_TYPE  VARCHAR2(32 char),
    DESCRIPTION       VARCHAR2(1024 char),
    KEYWORDS          CLOB,
    DOWNLOAD_COUNT    NUMBER(19),
    CHECKED_OUT_BY    NUMBER(19),
    CHECKED_OUT_AT    TIMESTAMP(6),
    STATUS            NUMBER,
    STATUS_CHANGED_BY NUMBER(19),
    STATUS_CHANGED_AT TIMESTAMP(6),
    DELETE_ACTION_ID  NUMBER(19) not null
        references DELETE_ACTION,
    MODIFIED_AT       TIMESTAMP(6)
)
/

create table SH_MDL_DOCUMENT_VERSION
(
    ID               NUMBER(19)                 not null
        primary key,
    VERSION          NUMBER,
    FILENAME         VARCHAR2(256 char),
    DOCUMENT_ID      NUMBER(19),
    URL              VARCHAR2(1024 char),
    UPLOADED_BY      NUMBER(19),
    UPLOADED_AT      TIMESTAMP(6),
    "size"           NUMBER(19),
    FILE_TYPE_ID     NUMBER(19),
    RESTORED_FROM    NUMBER,
    DELETE_ACTION_ID NUMBER(19)                 not null
        references DELETE_ACTION,
    NOTIFIED_OTHERS  CHAR(1 char) default ('t') not null
)
/

create table SH_MDL_VIDEO_LINK
(
    ID               NUMBER(19) not null
        primary key,
    PARENT_ITEM_ID   NUMBER(19),
    PARENT_ITEM_TYPE VARCHAR2(32 char),
    TITLE            VARCHAR2(255 char),
    URL              VARCHAR2(255 char),
    EDIT_DATE        TIMESTAMP(6),
    CREATE_DATE      TIMESTAMP(6),
    AUTHOR_ID        NUMBER(19),
    "public"         CHAR(1 char),
    VIDEO_FILE       VARCHAR2(256 char),
    DELETE_ACTION_ID NUMBER(19) not null
        references DELETE_ACTION
)
/

create table SH_MULTI_WIKI
(
    ID               NUMBER(19) not null
        primary key,
    ENTITY_ID        NUMBER(19),
    CREATE_DATE      TIMESTAMP(6),
    MODIFY_DATE      TIMESTAMP(6),
    DELETE_ACTION_ID NUMBER(19) not null
        references DELETE_ACTION
)
/

create table SH_MULTI_WIKI_SECTION_VISIBILI
(
    VERSION_SECTION_ID NUMBER(19)        not null,
    AUTHORITY_NAME     VARCHAR2(50 char) not null,
    CREATE_DATE        TIMESTAMP(6),
    MODIFY_DATE        TIMESTAMP(6),
    DELETE_ACTION_ID   NUMBER(19)        not null
        references DELETE_ACTION,
    primary key (VERSION_SECTION_ID, AUTHORITY_NAME)
)
/

create table SH_MULTI_WIKI_VERSION
(
    ID               NUMBER(19) not null
        primary key,
    WIKI_ID          NUMBER(19),
    CREATE_DATE      TIMESTAMP(6),
    MODIFY_DATE      TIMESTAMP(6),
    DELETE_ACTION_ID NUMBER(19) not null
        references DELETE_ACTION
)
/

create table SH_MULTI_WIKI_VERSION_SECTION
(
    ID               NUMBER(19) not null
        primary key,
    VERSION_ID       NUMBER(19),
    HEADLINE         VARCHAR2(256 char),
    HTML             CLOB,
    CREATE_DATE      TIMESTAMP(6),
    MODIFY_DATE      TIMESTAMP(6),
    SECTION_ID       NUMBER(19),
    SECTION_ORDER    NUMBER(10),
    DELETE_ACTION_ID NUMBER(19) not null
        references DELETE_ACTION
)
/

create table SH_NEWS_BLOG
(
    ID               NUMBER(19) not null
        primary key,
    PARENT_ITEM_ID   NUMBER(19),
    PARENT_ITEM_TYPE VARCHAR2(32 char),
    HEADLINE         VARCHAR2(255 char),
    CREATE_DATE      TIMESTAMP(6),
    EDIT_DATE        TIMESTAMP(6),
    AUTHOR_ID        NUMBER(19),
    SOURCE_TEXT      VARCHAR2(255 char),
    SOURCE_HREF      VARCHAR2(255 char),
    KEYWORDS         VARCHAR2(255 char),
    TEXT             CLOB,
    IMAGE_ID         NUMBER(19),
    DRAFT            CHAR(1 char),
    DELETE_ACTION_ID NUMBER(19) not null
        references DELETE_ACTION
)
/

create table SH_PERSON
(
    ID                  NUMBER(19) not null
        primary key,
    LAST_LOGIN          TIMESTAMP(6),
    SHOW_TEMPSTARTPAGE  CHAR(1 char),
    ACCOUNT_ACTIVE      CHAR(1 char),
    TITLE               VARCHAR2(255 char),
    FIRSTNAME           VARCHAR2(50 char),
    SURNAME             VARCHAR2(100 char),
    EMAIL               VARCHAR2(100 char),
    NEWMAIL             VARCHAR2(100 char),
    BIRTHDAY            DATE,
    PASSWORD_HASH       VARCHAR2(4000),
    KEYWORDS            VARCHAR2(255 char),
    LANGUAGE_ID         CHAR(2 char),
    PASSWORD_QUESTION   VARCHAR2(255 char),
    PASSWORD_ANSWER     VARCHAR2(255 char),
    REGISTERDATE        TIMESTAMP(6),
    TERMS_ACCEPTED      CHAR(1 char),
    IMAGE               VARCHAR2(64 char),
    BLOCKED             CHAR(1 char),
    DEFAULT_TIMEZONE    VARCHAR2(100 char),
    MODIFIED_AT         TIMESTAMP(6),
    CREATED_AT          TIMESTAMP(6),
    BIRTHDAY_VISIBILITY VARCHAR2(64 char),
    HASHED_ID           VARCHAR2(32 char),
    ADDITIONAL_TITLE    VARCHAR2(255 char),
    DELETED             CHAR(1 char),
    DELETE_ACTION_ID    NUMBER(19) not null
        references DELETE_ACTION
)
/

create table SH_PERSON_EXTERNAL_IDS
(
    PERSON_ID          NUMBER(19)        not null,
    EXTERNAL_PERSON_ID VARCHAR2(4000 char),
    EXTERNAL_SYSTEM_ID VARCHAR2(50 char) not null,
    DELETE_ACTION_ID   NUMBER(19)        not null
        references DELETE_ACTION,
    primary key (PERSON_ID, EXTERNAL_SYSTEM_ID)
)
/

create table SH_PERSON_TO_ROLE
(
    PERSON_ID        NUMBER(19)        not null,
    ROLE_NAME        VARCHAR2(15 char) not null,
    CREATE_DATE      TIMESTAMP(6),
    MODIFY_DATE      TIMESTAMP(6),
    DELETE_ACTION_ID NUMBER(19)        not null
        references DELETE_ACTION,
    primary key (PERSON_ID, ROLE_NAME)
)
/

create table SH_PROFILE_COMPONENT
(
    PERSON_ID        NUMBER(19)         not null,
    COMPONENT_TYPE   VARCHAR2(255 char) not null,
    "position"       NUMBER(19),
    "order"          NUMBER,
    CREATE_DATE      TIMESTAMP(6),
    MODIFY_DATE      TIMESTAMP(6),
    DELETE_ACTION_ID NUMBER(19)         not null
        references DELETE_ACTION,
    primary key (PERSON_ID, COMPONENT_TYPE)
)
/

create table SH_RAWEDITOR_VERSION
(
    ID               NUMBER(19) not null
        primary key,
    RAWEDITOR_ID     NUMBER(19),
    PARENT_ITEM_ID   NUMBER(19),
    PARENT_ITEM_TYPE VARCHAR2(32 char),
    EDITOR_TYPE      VARCHAR2(255 char),
    VERSION          NUMBER,
    TEXT             CLOB,
    CREATE_DATE      TIMESTAMP(6),
    AUTHOR_ID        NUMBER(19),
    DELETE_ACTION_ID NUMBER(19) not null
        references DELETE_ACTION
)
/

create table SH_SURVEY
(
    ID                     NUMBER(19) not null
        primary key,
    PARENT_ITEM_ID         NUMBER(19),
    PARENT_ITEM_TYPE       VARCHAR2(32 char),
    TITLE                  VARCHAR2(255 char),
    EXPIRED_DATE           TIMESTAMP(6),
    OWNER_ID               NUMBER(19),
    RESULT_VISIBILTY       NUMBER,
    ANONYM                 CHAR(1 char),
    PARTICIPANT_MAY_MODIFY CHAR(1 char),
    AUTO_DELETE_ANSWERS    CHAR(1 char),
    CREATE_DATE            TIMESTAMP(6),
    MODIFY_DATE            TIMESTAMP(6),
    DELETE_ACTION_ID       NUMBER(19) not null
        references DELETE_ACTION,
    REDIRECT_ON_NEW_MEMBER CHAR(1 char)
)
/

create table SH_SURVEY_PARTICIPANT_ANSWER
(
    PARTICIPANT_ID              NUMBER(19),
    SURVEY_QUESTION_ID          NUMBER(19),
    SURVEY_PREDEFINED_ANSWER_ID NUMBER(19),
    FREETEXT_ANSWER             CLOB,
    CREATE_DATE                 TIMESTAMP(6),
    MODIFY_DATE                 TIMESTAMP(6),
    DELETE_ACTION_ID            NUMBER(19) not null
        references DELETE_ACTION
)
/

create table SH_SURVEY_PREDEFINED_ANSWER
(
    ID                 NUMBER(19) not null
        primary key,
    SURVEY_QUESTION_ID NUMBER(19),
    ANSWER             CLOB,
    "order"            NUMBER,
    CREATE_DATE        TIMESTAMP(6),
    MODIFY_DATE        TIMESTAMP(6),
    DELETE_ACTION_ID   NUMBER(19) not null
        references DELETE_ACTION
)
/

create table SH_SURVEY_QUESTION
(
    ID               NUMBER(19) not null
        primary key,
    SURVEY_ID        NUMBER(19),
    QUESTION         CLOB,
    "order"          NUMBER,
    FREETEXT_ANSWER  CHAR(1 char),
    MIN_ANSWER       NUMBER,
    MAX_ANSWER       NUMBER,
    CREATE_DATE      TIMESTAMP(6),
    MODIFY_DATE      TIMESTAMP(6),
    DELETE_ACTION_ID NUMBER(19) not null
        references DELETE_ACTION
)
/

create table SH_WIKI_EDITOR
(
    ID               NUMBER(19) not null
        primary key,
    PARENT_ITEM_ID   NUMBER(19),
    PARENT_ITEM_TYPE VARCHAR2(32 char),
    OLD_GROUP_ID     NUMBER(19),
    DELETE_ACTION_ID NUMBER(19) not null
        references DELETE_ACTION
)
/

create table SH_WIKI_EDITOR_BACKUP
(
    WIKI_EDITOR_ID   NUMBER(19) not null
        primary key,
    WIKI_TEXT        CLOB,
    AUTHOR_ID        NUMBER(19),
    CREATE_DATE      TIMESTAMP(6),
    DELETE_ACTION_ID NUMBER(19) not null
        references DELETE_ACTION
)
/

create table SH_WIKI_EDITOR_VERSION
(
    ID               NUMBER(19) not null
        primary key,
    WIKI_EDITOR_ID   NUMBER(19),
    WIKI_TEXT        CLOB,
    VERSION          NUMBER,
    AUTHOR_ID        NUMBER(19),
    CREATE_DATE      TIMESTAMP(6),
    OLD_PAGE_ID      NUMBER(19),
    DELETE_ACTION_ID NUMBER(19) not null
        references DELETE_ACTION,
    RESTORED_VERSION NUMBER
)
/

create table SH_WORKSTREAM_ATTACHMENT
(
    ENTRY_ID         NUMBER(19),
    DELETE_ACTION_ID NUMBER(19)         not null
        references DELETE_ACTION,
    POSITION         NUMBER(10),
    ITEM_ID          VARCHAR2(255 char) not null
        constraint SH_WA_PK
            primary key
)
/

create table SH_WORKSTREAM_ENTRY
(
    ID               NUMBER(19)   not null
        primary key,
    TYPE             VARCHAR2(32 char),
    CREATED_AT       TIMESTAMP(6),
    MODIFIED_AT      TIMESTAMP(6),
    DELETE_ACTION_ID NUMBER(19)   not null
        references DELETE_ACTION,
    ORIGIN_ITEM_ID   VARCHAR2(255 char),
    SUBJECT_ITEM_ID  VARCHAR2(255 char),
    AUTHOR_ID        VARCHAR2(255 char),
    PINNED           CHAR(1 char),
    PIN_AUTHOR       NUMBER(19),
    PIN_DATE         TIMESTAMP(6),
    PUBLISHED        CHAR(1 char) not null,
    PUBLISHED_AT     TIMESTAMP(6)
)
/

create table SH_WORKSTREAM_ENTRY_ATTRIBUTE
(
    ENTRY_ID         NUMBER(19),
    KEY              VARCHAR2(24 char),
    VALUE            CLOB,
    DELETE_ACTION_ID NUMBER(19) not null
        references DELETE_ACTION
)
/

create table BASE_PROPERTY
(
    ID                NUMBER(19)                              not null
        constraint BASE_PROPERTY_PK
            primary key,
    PROPERTY_NAME     VARCHAR2(255 char)                      not null,
    CONVERTER_CLASS   VARCHAR2(255 char),
    CONVERTER_CONFIG  VARCHAR2(255 char),
    DESCRIPTION       VARCHAR2(1000 char)                     not null,
    DEFAULT_VALUE     CLOB,
    INHERITANCE_TYPE  VARCHAR2(255 char)                      not null,
    CONTAINER_NAME    VARCHAR2(255 char)                      not null,
    LAST_CHANGED      TIMESTAMP(6)       default systimestamp not null,
    CHANGE_USER       VARCHAR2(255 char),
    CREATE_AT         TIMESTAMP(6)       default systimestamp not null,
    CREATED_VERSION   VARCHAR2(255 char) default ('unknown')  not null,
    LAST_USED_VERSION VARCHAR2(255 char) default ('unknown')  not null,
    constraint BASE_PROPERTY_NAME_CONTAINE_UK
        unique (PROPERTY_NAME, CONTAINER_NAME)
)
/

create table CUSTOMER_DOMAIN
(
    CUSTOMER_DOMAIN_NAME VARCHAR2(255 char) not null
        constraint CUSTOMER_DOMAIN_PK
            primary key
)
/

create table DOMAIN_PROPERTY
(
    ID               NUMBER(19)                        not null
        constraint DOMAIN_PROPERTY_PK
            primary key,
    BASE_PROPERTY    NUMBER(19)                        not null
        constraint D_P__B_P__BASE_PROPERTY_FK
            references BASE_PROPERTY,
    "domain"         VARCHAR2(255 char)                not null,
    OVERRIDDEN_VALUE CLOB,
    LAST_CHANGED     TIMESTAMP(6) default systimestamp,
    CHANGE_USER      VARCHAR2(255 char),
    CREATE_AT        TIMESTAMP(6) default systimestamp not null,
    constraint DOMAIN_PROPERTY_PROP_DOMAIN_UK
        unique (BASE_PROPERTY, "domain")
)
/

create table FILE_TYPE
(
    ID          NUMBER(19)                                            not null
        constraint FILE_TYPE_PK
            primary key,
    EXTENSION   VARCHAR2(32 char)
        constraint FILE_TYPE_EXTENSION_UK
            unique,
    MIME_TYPE   VARCHAR2(128 char) default 'application/octet-stream' not null,
    DESCRIPTION VARCHAR2(1024 char)                                   not null,
    ICON_URL    VARCHAR2(1024 char)                                   not null
)
/

create table LANGUAGE
(
    ID         CHAR(2) not null
        constraint LANGUAGE_PK
            primary key,
    NAME       VARCHAR2(50 char),
    TRANSLATED CHAR default ('f')
)
/

create table NATIVE
(
    ID     NUMBER(19) not null
        constraint NATIVE_PK
            primary key,
    NATIVE VARCHAR2(255 char)
)
/

create table PERSON
(
    ID                  NUMBER(19)                             not null
        constraint PERSON_PK
            primary key,
    LAST_LOGIN          TIMESTAMP(6)      default systimestamp not null,
    SHOW_TEMPSTARTPAGE  CHAR              default ('t')        not null,
    ACCOUNT_ACTIVE      CHAR                                   not null,
    TITLE               VARCHAR2(255 char),
    FIRSTNAME           VARCHAR2(50 char)                      not null,
    SURNAME             VARCHAR2(100 char)                     not null,
    EMAIL               VARCHAR2(100 char)
        constraint PERSON_EMAIL_UK
            unique,
    NEWMAIL             VARCHAR2(100 char)
        constraint PERSON_NEWMAIL_UK
            unique,
    BIRTHDAY            DATE,
    PASSWORD_HASH       VARCHAR2(4000),
    KEYWORDS            VARCHAR2(255 char),
    LANGUAGE_ID         CHAR(2)
        constraint PER__LAN__LANGUAGE_FK
            references LANGUAGE,
    PASSWORD_QUESTION   VARCHAR2(255 char),
    PASSWORD_ANSWER     VARCHAR2(255 char),
    REGISTERDATE        TIMESTAMP(6)      default systimestamp,
    TERMS_ACCEPTED      CHAR,
    IMAGE               VARCHAR2(64 char),
    BLOCKED             CHAR              default ('f')        not null,
    DEFAULT_TIMEZONE    VARCHAR2(100 char),
    MODIFIED_AT         TIMESTAMP(6)      default systimestamp not null,
    CREATED_AT          TIMESTAMP(6)      default systimestamp not null,
    BIRTHDAY_VISIBILITY VARCHAR2(64 char) default 'NONE',
    HASHED_ID           VARCHAR2(32 char)                      not null
        constraint PERSON_HASHED_ID_UK
            unique,
    ADDITIONAL_TITLE    VARCHAR2(255 char),
    DELETED             CHAR(1 char)      default ('f')        not null
)
/

create table EMAIL_NOTIFICATION_SETTING
(
    PERSON_ID             NUMBER(19)                 not null
        constraint EMAIL_NOTIFICATION_SETTING_PK
            primary key
        constraint E_N_S__PER__PERSON_FK
            references PERSON
                on delete cascade,
    CREATE_DATE           TIMESTAMP(6) default systimestamp,
    MODIFY_DATE           TIMESTAMP(6) default systimestamp,
    NOTIFICATIONS_ENABLED CHAR         default ('t') not null
)
/

create trigger EMAIL_NOTIFICATION_SETTING_BD
    before delete
    on EMAIL_NOTIFICATION_SETTING
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_EMAIL_NOTIFICATION_SETTING("PERSON_ID", "CREATE_DATE", "MODIFY_DATE", "NOTIFICATIONS_ENABLED",
                                              DELETE_ACTION_ID)
    values (:OLD."PERSON_ID", :OLD."CREATE_DATE", :OLD."MODIFY_DATE", :OLD."NOTIFICATIONS_ENABLED", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table GREETING
(
    SENDER_ID    NUMBER(19)                        not null
        constraint GRE__PER__SENDER_FK
            references PERSON
                on delete cascade,
    RECIPIENT_ID NUMBER(19)                        not null
        constraint GRE__PER__RECIPIENT_FK
            references PERSON
                on delete cascade,
    CREATE_DATE  TIMESTAMP(6) default systimestamp not null,
    constraint GREETING_PK
        primary key (SENDER_ID, RECIPIENT_ID)
)
/

create index IDX_GREETING__RECIPIENT
    on GREETING (RECIPIENT_ID)
/

create table JABBER_SYNCED
(
    PERSON_ID   NUMBER(19) not null
        constraint JABBER_SYNCED_PK
            primary key
        constraint J_S__PER__PERSON_FK
            references PERSON
                on delete cascade,
    IN_PROGRESS CHAR       not null
)
/

create index IDX_JABBER_SYN__IN_PROGRESS
    on JABBER_SYNCED (IN_PROGRESS)
/

create table JABBER_TEMP_PASSWORD
(
    PERSON_ID   NUMBER(19)          not null
        constraint J_T_P__PER__PERSON_FK
            references PERSON
                on delete cascade,
    TYPE        VARCHAR2(4000 char) not null,
    PASSWORD    VARCHAR2(4000 char) not null,
    VALID_UNTIL TIMESTAMP(6)        not null,
    constraint JABBER_TEMP_PASSWORD_UK
        unique (PERSON_ID, TYPE)
)
/

create table LIKE_TABLE
(
    LIKER_ID    NUMBER(19)                 not null
        constraint L_T__PER__LIKER_FK
            references PERSON
                on delete cascade,
    CREATED_AT  TIMESTAMP(6) default systimestamp,
    MODIFIED_AT TIMESTAMP(6) default systimestamp,
    RECENT      CHAR         default ('f') not null,
    ITEM_ID     VARCHAR2(255 char)         not null,
    constraint LIKE_TABLE_PK
        primary key (ITEM_ID, LIKER_ID)
)
/

create index IDX_LIKE_TAB__LIKER
    on LIKE_TABLE (LIKER_ID)
/

create index LIKE_CREATED_AT_IDX
    on LIKE_TABLE (ITEM_ID, CREATED_AT)
/

create index LIKE_RECENT_IDX
    on LIKE_TABLE (ITEM_ID, RECENT)
/

create trigger LIKE_TABLE_BD
    before delete
    on LIKE_TABLE
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_LIKE_TABLE("LIKER_ID", "CREATED_AT", "MODIFIED_AT", "RECENT", "ITEM_ID", DELETE_ACTION_ID)
    values (:OLD."LIKER_ID", :OLD."CREATED_AT", :OLD."MODIFIED_AT", :OLD."RECENT", :OLD."ITEM_ID", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table MAP_PERSON_PERSON
(
    PERSON_ID NUMBER(19) not null
        constraint M_P_P__PER__PERSON_FK
            references PERSON
                on delete cascade,
    FRIEND_ID NUMBER(19) not null
        constraint M_P_P__PER__FRIEND_FK
            references PERSON
                on delete cascade,
    constraint MAP_PERSON_PERSON_PK
        primary key (PERSON_ID, FRIEND_ID)
)
/

create trigger MAP_PERSON_PERSON_BD
    before delete
    on MAP_PERSON_PERSON
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_MAP_PERSON_PERSON("PERSON_ID", "FRIEND_ID", DELETE_ACTION_ID)
    values (:OLD."PERSON_ID", :OLD."FRIEND_ID", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table MAP_PERSON_PERSON_INVITE
(
    PERSON_ID NUMBER(19) not null
        constraint M_P_P_I__PER__PERSON_FK
            references PERSON
                on delete cascade,
    FRIEND_ID NUMBER(19) not null
        constraint M_P_P_I__PER__FRIEND_FK
            references PERSON
                on delete cascade,
    MESSAGE   CLOB,
    constraint MAP_PERSON_PERSON_INVITE_PK
        primary key (PERSON_ID, FRIEND_ID)
)
/

create trigger MAP_PERSON_PERSON_INVITE_BD
    before delete
    on MAP_PERSON_PERSON_INVITE
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_MAP_PERSON_PERSON_INVITE("PERSON_ID", "FRIEND_ID", "MESSAGE", DELETE_ACTION_ID)
    values (:OLD."PERSON_ID", :OLD."FRIEND_ID", :OLD."MESSAGE", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table MDL_ALBUM
(
    ID               NUMBER(19)                             not null
        constraint MDL_ALBUM_PK
            primary key,
    PARENT_ITEM_ID   NUMBER(19)                             not null,
    PARENT_ITEM_TYPE VARCHAR2(32 char)                      not null,
    MODULE           CHAR              default ('t')        not null,
    OWNER_ID         NUMBER(19)        default (-1)
        constraint M_A__PER__OWNER_FK
            references PERSON
                on delete set null,
    CREATE_DATE      TIMESTAMP(6)      default systimestamp not null,
    EDIT_DATE        TIMESTAMP(6)      default systimestamp not null,
    TITLE            VARCHAR2(255 char)                     not null,
    DESCRIPTION      CLOB              default ('$EMPTY$'),
    LOCATION         VARCHAR2(80 char) default ('$EMPTY$'),
    FRIENDS_ONLY     CHAR              default ('t')        not null,
    OLD_ALBUM_ID     NUMBER(19)
)
/

create table DEFAULT_ALBUM
(
    ITEM_ID   NUMBER(19)        not null,
    ITEM_TYPE VARCHAR2(32 char) not null,
    ALBUM_ID  NUMBER(19)        not null
        constraint D_A__M_A__ALBUM_FK
            references MDL_ALBUM
                on delete cascade,
    constraint DEFAULT_ALBUM_ITEM_TYPE_UK
        unique (ITEM_ID, ITEM_TYPE)
)
/

create trigger DEFAULT_ALBUM_BD
    before delete
    on DEFAULT_ALBUM
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_DEFAULT_ALBUM("ITEM_ID", "ITEM_TYPE", "ALBUM_ID", DELETE_ACTION_ID)
    values (:OLD."ITEM_ID", :OLD."ITEM_TYPE", :OLD."ALBUM_ID", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create index IDX_MDL_ALB__PA_IT_PA_IT_TY_MD
    on MDL_ALBUM (PARENT_ITEM_ID, PARENT_ITEM_TYPE, MODULE)
/

create trigger MDL_ALBUM_BD
    before delete
    on MDL_ALBUM
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_MDL_ALBUM("ID", "PARENT_ITEM_ID", "PARENT_ITEM_TYPE", "MODULE", "OWNER_ID", "CREATE_DATE",
                             "EDIT_DATE", "TITLE", "DESCRIPTION", "LOCATION", "FRIENDS_ONLY", "OLD_ALBUM_ID",
                             DELETE_ACTION_ID)
    values (:OLD."ID", :OLD."PARENT_ITEM_ID", :OLD."PARENT_ITEM_TYPE", :OLD."MODULE", :OLD."OWNER_ID",
            :OLD."CREATE_DATE", :OLD."EDIT_DATE", :OLD."TITLE", :OLD."DESCRIPTION", :OLD."LOCATION",
            :OLD."FRIENDS_ONLY", :OLD."OLD_ALBUM_ID", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table MDL_ALBUM_IMAGE
(
    ID                 NUMBER(19)                        not null
        constraint MDL_ALBUM_IMAGE_PK
            primary key,
    TITLE              VARCHAR2(255 char)                not null,
    ALBUM_ID           NUMBER(19)                        not null
        constraint M_A_I__M_A__ALBUM_FK
            references MDL_ALBUM
                on delete cascade,
    FILENAME           VARCHAR2(255 char)                not null,
    OWNER_ID           NUMBER(19)   default (-1)         not null
        constraint M_A_I__PER__OWNER_FK
            references PERSON
                on delete set null,
    CREATE_DATE        TIMESTAMP(6) default systimestamp not null,
    EDIT_DATE          TIMESTAMP(6) default systimestamp not null,
    OLD_ALBUM_IMAGE_ID NUMBER(19)
)
/

create trigger MDL_ALBUM_IMAGE_BRI
    before insert
    on MDL_ALBUM_IMAGE
    for each row
    when (new.id IS NULL)
BEGIN
    SELECT mdl_album_image_seq.nextval
    INTO :new.id
    FROM dual;
END mdl_album_image_bri;
/

create trigger MDL_ALBUM_IMAGE_BD
    before delete
    on MDL_ALBUM_IMAGE
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_MDL_ALBUM_IMAGE("ID", "TITLE", "ALBUM_ID", "FILENAME", "OWNER_ID", "CREATE_DATE", "EDIT_DATE",
                                   "OLD_ALBUM_IMAGE_ID", DELETE_ACTION_ID)
    values (:OLD."ID", :OLD."TITLE", :OLD."ALBUM_ID", :OLD."FILENAME", :OLD."OWNER_ID", :OLD."CREATE_DATE",
            :OLD."EDIT_DATE", :OLD."OLD_ALBUM_IMAGE_ID", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table MDL_COMMENT
(
    ID             NUMBER(19)                        not null
        constraint MDL_COMMENT_PK
            primary key,
    AUTHOR_ID      NUMBER(19)   default (-1)
        constraint M_C__PER__AUTHOR_FK
            references PERSON
                on delete set null,
    POSTED_AT      TIMESTAMP(6) default systimestamp not null,
    CUSTOM_INFO    VARCHAR2(255 char),
    TEXT           CLOB         default 'x'          not null,
    EDITOR_ID      NUMBER(19)
        constraint MDL_COMMENTS_EDITOR_FK
            references PERSON,
    EDITED_AT      TIMESTAMP(6),
    PARENT_ITEM_ID VARCHAR2(255 char)                not null,
    EDITOR_MODEL   CLOB
)
/

create index MDL_COMMENTS_PARENT_IDX
    on MDL_COMMENT (PARENT_ITEM_ID)
/

create trigger MDL_COMMENT_BRI
    before insert
    on MDL_COMMENT
    for each row
    when (new.id IS NULL)
BEGIN
    SELECT mdl_comment_seq.nextval
    INTO :new.id
    FROM dual;
END mdl_comment_bri;
/

create trigger MDL_COMMENT_BD
    before delete
    on MDL_COMMENT
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_MDL_COMMENT("ID", "AUTHOR_ID", "POSTED_AT", "CUSTOM_INFO", "TEXT", "EDITOR_ID", "EDITED_AT",
                               "PARENT_ITEM_ID", "EDITOR_MODEL", DELETE_ACTION_ID)
    values (:OLD."ID", :OLD."AUTHOR_ID", :OLD."POSTED_AT", :OLD."CUSTOM_INFO", :OLD."TEXT", :OLD."EDITOR_ID",
            :OLD."EDITED_AT", :OLD."PARENT_ITEM_ID", :OLD."EDITOR_MODEL", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table MDL_DOCUMENT
(
    ID                NUMBER(19)           not null
        constraint MDL_DOCUMENT_FILE_PK
            primary key,
    PARENT_ITEM_ID    NUMBER(19)           not null,
    PARENT_ITEM_TYPE  VARCHAR2(32 char)    not null,
    DESCRIPTION       VARCHAR2(1024 char),
    KEYWORDS          CLOB,
    DOWNLOAD_COUNT    NUMBER(19) default 0 not null
        constraint MDL_DOC_FILES_POS_DL_COUNT
            check ((download_count >= 0)),
    CHECKED_OUT_BY    NUMBER(19) default (-1)
        constraint M_D__PER__CHECKED_OUT_BY_FK
            references PERSON
                on delete set null,
    CHECKED_OUT_AT    TIMESTAMP(6),
    STATUS            NUMBER     default 0 not null,
    STATUS_CHANGED_BY NUMBER(19) default (-1)
        constraint M_D__PER__STATUS_CHANGED_BY_FK
            references PERSON
                on delete set null,
    STATUS_CHANGED_AT TIMESTAMP(6),
    MODIFIED_AT       TIMESTAMP(6)         not null
)
/

create table MDL_DOCUMENT_VERSION
(
    ID              NUMBER(19)                        not null
        constraint MDL_DOCUMENT_VERSION_PK
            primary key,
    VERSION         NUMBER       default 0            not null,
    FILENAME        VARCHAR2(256 char)                not null,
    DOCUMENT_ID     NUMBER(19)                        not null
        constraint M_D_V__M_D__DOCUMENT_FK
            references MDL_DOCUMENT,
    URL             VARCHAR2(1024 char)               not null,
    UPLOADED_BY     NUMBER(19)   default (-1)         not null
        constraint M_D_V__PER__UPLOADED_BY_FK
            references PERSON
                on delete set null,
    UPLOADED_AT     TIMESTAMP(6) default systimestamp not null,
    "size"          NUMBER(19)                        not null
        constraint MDL_DOCUMENT_VERSION_POS_SIZE
            check ("size" >= 0),
    FILE_TYPE_ID    NUMBER(19)                        not null
        constraint M_D_V__F_T__FILE_T_FK
            references FILE_TYPE,
    RESTORED_FROM   NUMBER,
    NOTIFIED_OTHERS CHAR(1 char) default ('t')        not null,
    constraint MDL_DOCUMENT_VERSION_DOC_VE_UK
        unique (VERSION, DOCUMENT_ID)
)
/

create index IDX_MDL_DOC_VER__DOCUMENT
    on MDL_DOCUMENT_VERSION (DOCUMENT_ID)
/

create trigger MDL_DOCUMENT_VERSION_BRI
    before insert
    on MDL_DOCUMENT_VERSION
    for each row
    when (new.id IS NULL)
BEGIN
    SELECT mdl_document_version_seq.nextval
    INTO :new.id
    FROM dual;
END mdl_document_version_bri;
/

create trigger MDL_DOCUMENT_VERSION_BD
    before delete
    on MDL_DOCUMENT_VERSION
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_MDL_DOCUMENT_VERSION("ID", "VERSION", "FILENAME", "DOCUMENT_ID", "URL", "UPLOADED_BY", "UPLOADED_AT",
                                        "size", "FILE_TYPE_ID", "RESTORED_FROM", "NOTIFIED_OTHERS", DELETE_ACTION_ID)
    values (:OLD."ID", :OLD."VERSION", :OLD."FILENAME", :OLD."DOCUMENT_ID", :OLD."URL", :OLD."UPLOADED_BY",
            :OLD."UPLOADED_AT", :OLD."size", :OLD."FILE_TYPE_ID", :OLD."RESTORED_FROM", :OLD."NOTIFIED_OTHERS",
            del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create trigger MDL_DOCUMENT_BRI
    before insert
    on MDL_DOCUMENT
    for each row
    when (new.id IS NULL)
BEGIN
    SELECT mdl_document_seq.nextval
    INTO :new.id
    FROM dual;
END mdl_document_bri;
/

create trigger MDL_DOCUMENT_BD
    before delete
    on MDL_DOCUMENT
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_MDL_DOCUMENT("ID", "PARENT_ITEM_ID", "PARENT_ITEM_TYPE", "DESCRIPTION", "KEYWORDS", "DOWNLOAD_COUNT",
                                "CHECKED_OUT_BY", "CHECKED_OUT_AT", "STATUS", "STATUS_CHANGED_BY", "STATUS_CHANGED_AT",
                                "MODIFIED_AT", DELETE_ACTION_ID)
    values (:OLD."ID", :OLD."PARENT_ITEM_ID", :OLD."PARENT_ITEM_TYPE", :OLD."DESCRIPTION", :OLD."KEYWORDS",
            :OLD."DOWNLOAD_COUNT", :OLD."CHECKED_OUT_BY", :OLD."CHECKED_OUT_AT", :OLD."STATUS",
            :OLD."STATUS_CHANGED_BY", :OLD."STATUS_CHANGED_AT", :OLD."MODIFIED_AT", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table MDL_VIDEO_LINK
(
    ID               NUMBER(19)                        not null
        constraint MDL_VIDEOLINK_PK
            primary key,
    PARENT_ITEM_ID   NUMBER(19)                        not null,
    PARENT_ITEM_TYPE VARCHAR2(32 char)                 not null,
    TITLE            VARCHAR2(255 char)                not null,
    URL              VARCHAR2(255 char)                not null,
    EDIT_DATE        TIMESTAMP(6) default systimestamp not null,
    CREATE_DATE      TIMESTAMP(6) default systimestamp not null,
    AUTHOR_ID        NUMBER(19)   default (-1)         not null
        constraint M_V_L__PER__AUTHOR_FK
            references PERSON
                on delete set null,
    "public"         CHAR         default ('t')        not null,
    VIDEO_FILE       VARCHAR2(256 char)
)
/

create index IDX_MDL_VID__PA_IT_PA_IT_TY
    on MDL_VIDEO_LINK (PARENT_ITEM_ID, PARENT_ITEM_TYPE)
/

create trigger MDL_VIDEO_LINK_BRI
    before insert
    on MDL_VIDEO_LINK
    for each row
    when (new.id IS NULL)
BEGIN
    SELECT mdl_video_link_seq.nextval
    INTO :new.id
    FROM dual;
END mdl_video_link_bri;
/

create trigger MDL_VIDEO_LINK_BD
    before delete
    on MDL_VIDEO_LINK
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_MDL_VIDEO_LINK("ID", "PARENT_ITEM_ID", "PARENT_ITEM_TYPE", "TITLE", "URL", "EDIT_DATE",
                                  "CREATE_DATE", "AUTHOR_ID", "public", "VIDEO_FILE", DELETE_ACTION_ID)
    values (:OLD."ID", :OLD."PARENT_ITEM_ID", :OLD."PARENT_ITEM_TYPE", :OLD."TITLE", :OLD."URL", :OLD."EDIT_DATE",
            :OLD."CREATE_DATE", :OLD."AUTHOR_ID", :OLD."public", :OLD."VIDEO_FILE", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table NEWS_BLOG
(
    ID               NUMBER(19)                              not null
        constraint NEWSBLOG_PK
            primary key,
    PARENT_ITEM_ID   NUMBER(19)                              not null,
    PARENT_ITEM_TYPE VARCHAR2(32 char)                       not null,
    HEADLINE         VARCHAR2(255 char)                      not null,
    CREATE_DATE      TIMESTAMP(6)       default systimestamp not null,
    EDIT_DATE        TIMESTAMP(6)       default systimestamp not null,
    AUTHOR_ID        NUMBER(19)         default (-1)         not null
        constraint NBG__PER__AUTHOR_FK
            references PERSON
                on delete set null,
    SOURCE_TEXT      VARCHAR2(255 char) default ('$EMPTY$'),
    SOURCE_HREF      VARCHAR2(255 char) default ('$EMPTY$'),
    KEYWORDS         VARCHAR2(255 char) default ('$EMPTY$'),
    TEXT             CLOB                                    not null,
    IMAGE_ID         NUMBER(19)
        constraint NBG__M_A_I__IMAGE_FK
            references MDL_ALBUM_IMAGE
                on delete set null,
    DRAFT            CHAR               default ('f')        not null
)
/

create index IDX_NEWSBLOG__P_IT_P_IT_TY_A_D
    on NEWS_BLOG (PARENT_ITEM_ID, PARENT_ITEM_TYPE, AUTHOR_ID, DRAFT)
/

create index IDX_NEWSBLOG__P_IT_P_IT_TY_D
    on NEWS_BLOG (PARENT_ITEM_ID, PARENT_ITEM_TYPE, DRAFT)
/

create trigger NEWS_BLOG_BRI
    before insert
    on NEWS_BLOG
    for each row
    when (new.id IS NULL)
BEGIN
    SELECT news_blog_seq.nextval
    INTO :new.id
    FROM dual;
END news_blog_bri;
/

create trigger NEWS_BLOG_BD
    before delete
    on NEWS_BLOG
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_NEWS_BLOG("ID", "PARENT_ITEM_ID", "PARENT_ITEM_TYPE", "HEADLINE", "CREATE_DATE", "EDIT_DATE",
                             "AUTHOR_ID", "SOURCE_TEXT", "SOURCE_HREF", "KEYWORDS", "TEXT", "IMAGE_ID", "DRAFT",
                             DELETE_ACTION_ID)
    values (:OLD."ID", :OLD."PARENT_ITEM_ID", :OLD."PARENT_ITEM_TYPE", :OLD."HEADLINE", :OLD."CREATE_DATE",
            :OLD."EDIT_DATE", :OLD."AUTHOR_ID", :OLD."SOURCE_TEXT", :OLD."SOURCE_HREF", :OLD."KEYWORDS", :OLD."TEXT",
            :OLD."IMAGE_ID", :OLD."DRAFT", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table OPEN_SOCIAL_APP_DATA
(
    ID        NUMBER(10)         not null
        constraint OPEN_SOCIAL_APP_DATA_PK
            primary key,
    KEY       VARCHAR2(100 char) not null,
    VALUE     CLOB               not null,
    KADGET_ID NUMBER(19),
    PERSON_ID NUMBER(19)         not null
        constraint O_S_A_D__PER__PERSON_FK
            references PERSON
                on delete cascade
)
/

create unique index IDX_PERSON__EMAIL
    on PERSON (LOWER("EMAIL"))
/

create trigger PERSON_BRI
    before insert
    on PERSON
    for each row
    when (new.id IS NULL)
BEGIN
    SELECT person_seq.nextval
    INTO :new.id
    FROM dual;
END person_bri;
/

create trigger PERSON_BD
    before delete
    on PERSON
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_PERSON("ID", "LAST_LOGIN", "SHOW_TEMPSTARTPAGE", "ACCOUNT_ACTIVE", "TITLE", "FIRSTNAME", "SURNAME",
                          "EMAIL", "NEWMAIL", "BIRTHDAY", "PASSWORD_HASH", "KEYWORDS", "LANGUAGE_ID",
                          "PASSWORD_QUESTION", "PASSWORD_ANSWER", "REGISTERDATE", "TERMS_ACCEPTED", "IMAGE", "BLOCKED",
                          "DEFAULT_TIMEZONE", "MODIFIED_AT", "CREATED_AT", "BIRTHDAY_VISIBILITY", "HASHED_ID",
                          "ADDITIONAL_TITLE", "DELETED", DELETE_ACTION_ID)
    values (:OLD."ID", :OLD."LAST_LOGIN", :OLD."SHOW_TEMPSTARTPAGE", :OLD."ACCOUNT_ACTIVE", :OLD."TITLE",
            :OLD."FIRSTNAME", :OLD."SURNAME", :OLD."EMAIL", :OLD."NEWMAIL", :OLD."BIRTHDAY", :OLD."PASSWORD_HASH",
            :OLD."KEYWORDS", :OLD."LANGUAGE_ID", :OLD."PASSWORD_QUESTION", :OLD."PASSWORD_ANSWER", :OLD."REGISTERDATE",
            :OLD."TERMS_ACCEPTED", :OLD."IMAGE", :OLD."BLOCKED", :OLD."DEFAULT_TIMEZONE", :OLD."MODIFIED_AT",
            :OLD."CREATED_AT", :OLD."BIRTHDAY_VISIBILITY", :OLD."HASHED_ID", :OLD."ADDITIONAL_TITLE", :OLD."DELETED",
            del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table PERSON_ROLE
(
    ROLE_NAME   VARCHAR2(15 char) not null
        constraint PERSON_ROLE_PK
            primary key,
    CREATE_DATE TIMESTAMP(6) default systimestamp
)
/

create table PERSON_TO_ROLE
(
    PERSON_ID   NUMBER(19)        not null
        constraint P_T_R__PER__PERSON_FK
            references PERSON
                on delete cascade,
    ROLE_NAME   VARCHAR2(15 char) not null
        constraint P_T_R__P_R__ROLE_NAME_FK
            references PERSON_ROLE,
    CREATE_DATE TIMESTAMP(6) default systimestamp,
    MODIFY_DATE TIMESTAMP(6) default systimestamp,
    constraint PERSON_TO_ROLE_PK
        primary key (PERSON_ID, ROLE_NAME)
)
/

create trigger PERSON_TO_ROLE_BD
    before delete
    on PERSON_TO_ROLE
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_PERSON_TO_ROLE("PERSON_ID", "ROLE_NAME", "CREATE_DATE", "MODIFY_DATE", DELETE_ACTION_ID)
    values (:OLD."PERSON_ID", :OLD."ROLE_NAME", :OLD."CREATE_DATE", :OLD."MODIFY_DATE", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table PROFILE_ALLOWED_COMPONENT
(
    COMPONENT_TYPE        VARCHAR2(100 char) not null
        constraint PROFILE_ALLOWED_COMPONENT_PK
            primary key,
    "position"            NUMBER(19)         not null,
    DEFAULT_ORDER         NUMBER             not null,
    DEFAULT_VISIBILITY    NUMBER             not null,
    MAY_MODIFY_VISIBILITY CHAR               not null,
    CREATE_DATE           TIMESTAMP(6) default systimestamp,
    MODIFY_DATE           TIMESTAMP(6) default systimestamp
)
/

create table PROFILE_COMPONENT
(
    PERSON_ID      NUMBER(19)    not null
        constraint P_C__PER__PERSON_FK
            references PERSON
                on delete cascade,
    COMPONENT_TYPE VARCHAR2(255) not null,
    "position"     NUMBER(19)    not null,
    "order"        NUMBER        not null,
    CREATE_DATE    TIMESTAMP(6) default systimestamp,
    MODIFY_DATE    TIMESTAMP(6) default systimestamp,
    constraint PROFILE_COMPONENT_PK
        primary key (PERSON_ID, COMPONENT_TYPE)
)
/

create trigger PROFILE_COMPONENT_BD
    before delete
    on PROFILE_COMPONENT
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_PROFILE_COMPONENT("PERSON_ID", "COMPONENT_TYPE", "position", "order", "CREATE_DATE", "MODIFY_DATE",
                                     DELETE_ACTION_ID)
    values (:OLD."PERSON_ID", :OLD."COMPONENT_TYPE", :OLD."position", :OLD."order", :OLD."CREATE_DATE",
            :OLD."MODIFY_DATE", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table PROPERTIES_TMP
(
    PROPERTY_NAME VARCHAR2(255 char) not null
)
/

create table RAWEDITOR_VERSION
(
    ID               NUMBER(19)                        not null
        constraint RAWEDITOR_VERSION_PK
            primary key,
    RAWEDITOR_ID     NUMBER(19)                        not null,
    PARENT_ITEM_ID   NUMBER(19)                        not null,
    PARENT_ITEM_TYPE VARCHAR2(32 char)                 not null,
    EDITOR_TYPE      VARCHAR2(255)                     not null,
    VERSION          NUMBER                            not null,
    TEXT             CLOB                              not null,
    CREATE_DATE      TIMESTAMP(6) default systimestamp not null,
    AUTHOR_ID        NUMBER(19)   default (-1)         not null
        constraint R_V__PER__AUTHOR_FK
            references PERSON
                on delete set null,
    constraint RAWEDITOR_VERSION_REDIT_VER_UK
        unique (RAWEDITOR_ID, VERSION),
    constraint RAWEDITOR_VERSION_UK
        unique (PARENT_ITEM_ID, PARENT_ITEM_TYPE, EDITOR_TYPE, VERSION)
)
/

create trigger RAWEDITOR_VERSION_BRI
    before insert
    on RAWEDITOR_VERSION
    for each row
    when (new.id IS NULL)
BEGIN
    SELECT raweditor_version_seq.nextval
    INTO :new.id
    FROM dual;
END raweditor_version_bri;
/

create trigger RAWEDITOR_VERSION_BD
    before delete
    on RAWEDITOR_VERSION
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_RAWEDITOR_VERSION("ID", "RAWEDITOR_ID", "PARENT_ITEM_ID", "PARENT_ITEM_TYPE", "EDITOR_TYPE",
                                     "VERSION", "TEXT", "CREATE_DATE", "AUTHOR_ID", DELETE_ACTION_ID)
    values (:OLD."ID", :OLD."RAWEDITOR_ID", :OLD."PARENT_ITEM_ID", :OLD."PARENT_ITEM_TYPE", :OLD."EDITOR_TYPE",
            :OLD."VERSION", :OLD."TEXT", :OLD."CREATE_DATE", :OLD."AUTHOR_ID", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table SURVEY
(
    ID                     NUMBER(19)                not null
        constraint SURVEY_PK
            primary key,
    PARENT_ITEM_ID         NUMBER(19)                not null,
    PARENT_ITEM_TYPE       VARCHAR2(32 char)         not null,
    TITLE                  VARCHAR2(255 char)        not null,
    EXPIRED_DATE           TIMESTAMP(6),
    OWNER_ID               NUMBER(19)   default (-1) not null
        constraint SUR__PER__OWNER_FK
            references PERSON
                on delete set null,
    RESULT_VISIBILTY       NUMBER                    not null,
    ANONYM                 CHAR                      not null,
    PARTICIPANT_MAY_MODIFY CHAR                      not null,
    AUTO_DELETE_ANSWERS    CHAR                      not null,
    CREATE_DATE            TIMESTAMP(6) default systimestamp,
    MODIFY_DATE            TIMESTAMP(6) default systimestamp,
    REDIRECT_ON_NEW_MEMBER CHAR(1 char) default 'f'  not null
)
/

create index IDX_SURVEY__P_ITEM_ID_PARENT_I
    on SURVEY (PARENT_ITEM_ID, PARENT_ITEM_TYPE)
/

create trigger SURVEY_BRI
    before insert
    on SURVEY
    for each row
    when (new.id IS NULL)
BEGIN
    SELECT survey_seq.nextval
    INTO :new.id
    FROM dual;
END survey_bri;
/

create trigger SURVEY_BD
    before delete
    on SURVEY
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_SURVEY("ID", "PARENT_ITEM_ID", "PARENT_ITEM_TYPE", "TITLE", "EXPIRED_DATE", "OWNER_ID",
                          "RESULT_VISIBILTY", "ANONYM", "PARTICIPANT_MAY_MODIFY", "AUTO_DELETE_ANSWERS", "CREATE_DATE",
                          "MODIFY_DATE", "REDIRECT_ON_NEW_MEMBER", DELETE_ACTION_ID)
    values (:OLD."ID", :OLD."PARENT_ITEM_ID", :OLD."PARENT_ITEM_TYPE", :OLD."TITLE", :OLD."EXPIRED_DATE",
            :OLD."OWNER_ID", :OLD."RESULT_VISIBILTY", :OLD."ANONYM", :OLD."PARTICIPANT_MAY_MODIFY",
            :OLD."AUTO_DELETE_ANSWERS", :OLD."CREATE_DATE", :OLD."MODIFY_DATE", :OLD."REDIRECT_ON_NEW_MEMBER",
            del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table SURVEY_QUESTION
(
    ID              NUMBER(19) not null
        constraint SURVEY_QUESTION_PK
            primary key,
    SURVEY_ID       NUMBER(19) not null
        constraint S_Q__SUR__SURVEY_FK
            references SURVEY
                on delete cascade,
    QUESTION        CLOB       not null,
    "order"         NUMBER,
    FREETEXT_ANSWER CHAR       not null,
    MIN_ANSWER      NUMBER,
    MAX_ANSWER      NUMBER,
    CREATE_DATE     TIMESTAMP(6) default systimestamp,
    MODIFY_DATE     TIMESTAMP(6) default systimestamp
)
/

create table SURVEY_PREDEFINED_ANSWER
(
    ID                 NUMBER(19) not null
        constraint SURVEY_PREDEFINED_ANSWER_PK
            primary key,
    SURVEY_QUESTION_ID NUMBER(19) not null
        constraint S_PRE_A__S_Q__QUESTION_FK
            references SURVEY_QUESTION
                on delete cascade,
    ANSWER             CLOB       not null,
    "order"            NUMBER,
    CREATE_DATE        TIMESTAMP(6) default systimestamp,
    MODIFY_DATE        TIMESTAMP(6) default systimestamp
)
/

create table SURVEY_PARTICIPANT_ANSWER
(
    PARTICIPANT_ID              NUMBER(19)   default (-1)
        constraint S_PAR_A__PER__PARTICIPANT_FK
            references PERSON
                on delete set null,
    SURVEY_QUESTION_ID          NUMBER(19) not null
        constraint S_PAR_A__S_Q__QUESTION_FK
            references SURVEY_QUESTION
                on delete cascade,
    SURVEY_PREDEFINED_ANSWER_ID NUMBER(19)
        constraint S_PAR_A__S_PRE_A__PRE_ANSW_FK
            references SURVEY_PREDEFINED_ANSWER
                on delete cascade,
    FREETEXT_ANSWER             CLOB,
    CREATE_DATE                 TIMESTAMP(6) default systimestamp,
    MODIFY_DATE                 TIMESTAMP(6) default systimestamp
)
/

create trigger SURVEY_PARTICIPANT_ANSWER_BD
    before delete
    on SURVEY_PARTICIPANT_ANSWER
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_SURVEY_PARTICIPANT_ANSWER("PARTICIPANT_ID", "SURVEY_QUESTION_ID", "SURVEY_PREDEFINED_ANSWER_ID",
                                             "FREETEXT_ANSWER", "CREATE_DATE", "MODIFY_DATE", DELETE_ACTION_ID)
    values (:OLD."PARTICIPANT_ID", :OLD."SURVEY_QUESTION_ID", :OLD."SURVEY_PREDEFINED_ANSWER_ID",
            :OLD."FREETEXT_ANSWER", :OLD."CREATE_DATE", :OLD."MODIFY_DATE", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create trigger SURVEY_PREDEFINED_ANSWER_BRI
    before insert
    on SURVEY_PREDEFINED_ANSWER
    for each row
    when (new.id IS NULL)
BEGIN
    SELECT survey_predefined_answer_seq.nextval
    INTO :new.id
    FROM dual;
END survey_predefined_answer_bri;
/

create trigger SURVEY_PREDEFINED_ANSWER_BD
    before delete
    on SURVEY_PREDEFINED_ANSWER
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_SURVEY_PREDEFINED_ANSWER("ID", "SURVEY_QUESTION_ID", "ANSWER", "order", "CREATE_DATE", "MODIFY_DATE",
                                            DELETE_ACTION_ID)
    values (:OLD."ID", :OLD."SURVEY_QUESTION_ID", :OLD."ANSWER", :OLD."order", :OLD."CREATE_DATE", :OLD."MODIFY_DATE",
            del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create trigger SURVEY_QUESTION_BRI
    before insert
    on SURVEY_QUESTION
    for each row
    when (new.id IS NULL)
BEGIN
    SELECT survey_question_seq.nextval
    INTO :new.id
    FROM dual;
END survey_question_bri;
/

create trigger SURVEY_QUESTION_BD
    before delete
    on SURVEY_QUESTION
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_SURVEY_QUESTION("ID", "SURVEY_ID", "QUESTION", "order", "FREETEXT_ANSWER", "MIN_ANSWER",
                                   "MAX_ANSWER", "CREATE_DATE", "MODIFY_DATE", DELETE_ACTION_ID)
    values (:OLD."ID", :OLD."SURVEY_ID", :OLD."QUESTION", :OLD."order", :OLD."FREETEXT_ANSWER", :OLD."MIN_ANSWER",
            :OLD."MAX_ANSWER", :OLD."CREATE_DATE", :OLD."MODIFY_DATE", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table TRANSLATION
(
    LANGUAGE_ID CHAR(2)    not null
        constraint TRA__LAN__LANGUAGE_FK
            references LANGUAGE,
    NATIVE_ID   NUMBER(19) not null
        constraint TRA__NAT__NATIVE_FK
            references NATIVE,
    TRANSLATION VARCHAR2(255 char),
    constraint TRANSLATION_PK
        primary key (LANGUAGE_ID, NATIVE_ID)
)
/

create table VERSION
(
    ID          NUMBER(19)         not null,
    RELEASE     VARCHAR2(255 char) not null,
    NAME        VARCHAR2(255 char),
    TYPE        VARCHAR2(255 char),
    DESCRIPTION CLOB,
    "date"      TIMESTAMP(6),
    constraint VERSION_PK
        primary key (ID, RELEASE)
)
/

create table WIKI_EDITOR
(
    ID               NUMBER(19)        not null
        constraint WIKI_EDITOR_PK
            primary key,
    PARENT_ITEM_ID   NUMBER(19)        not null,
    PARENT_ITEM_TYPE VARCHAR2(32 char) not null,
    OLD_GROUP_ID     NUMBER(19),
    constraint WIKI_EDITOR_PARENT_ITEM_UK
        unique (PARENT_ITEM_ID, PARENT_ITEM_TYPE)
)
/

create trigger WIKI_EDITOR_BRI
    before insert
    on WIKI_EDITOR
    for each row
    when (new.id IS NULL)
BEGIN
    SELECT wiki_editor_seq.nextval
    INTO :new.id
    FROM dual;
END wiki_editor_bri;
/

create trigger WIKI_EDITOR_BD
    before delete
    on WIKI_EDITOR
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_WIKI_EDITOR("ID", "PARENT_ITEM_ID", "PARENT_ITEM_TYPE", "OLD_GROUP_ID", DELETE_ACTION_ID)
    values (:OLD."ID", :OLD."PARENT_ITEM_ID", :OLD."PARENT_ITEM_TYPE", :OLD."OLD_GROUP_ID", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table WIKI_EDITOR_BACKUP
(
    WIKI_EDITOR_ID NUMBER(19)                        not null
        constraint WIKI_EDITOR_BACKUP_PK
            primary key
        constraint W_E_B__W_E__WIKI_EDITOR_FK
            references WIKI_EDITOR
                on delete cascade,
    WIKI_TEXT      CLOB                              not null,
    AUTHOR_ID      NUMBER(19)                        not null
        constraint W_E_B__PER__AUTHOR_FK
            references PERSON
                on delete cascade,
    CREATE_DATE    TIMESTAMP(6) default systimestamp not null
)
/

create trigger WIKI_EDITOR_BACKUP_BD
    before delete
    on WIKI_EDITOR_BACKUP
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_WIKI_EDITOR_BACKUP("WIKI_EDITOR_ID", "WIKI_TEXT", "AUTHOR_ID", "CREATE_DATE", DELETE_ACTION_ID)
    values (:OLD."WIKI_EDITOR_ID", :OLD."WIKI_TEXT", :OLD."AUTHOR_ID", :OLD."CREATE_DATE", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table WIKI_EDITOR_VERSION
(
    ID               NUMBER(19)                        not null
        constraint WIKI_EDITOR_VERSION_PK
            primary key,
    WIKI_EDITOR_ID   NUMBER(19)                        not null
        constraint W_E_V__W_E__WIKI_EDITOR_FK
            references WIKI_EDITOR
                on delete cascade,
    WIKI_TEXT        CLOB                              not null,
    VERSION          NUMBER       default 0            not null,
    AUTHOR_ID        NUMBER(19)   default (-1)         not null
        constraint W_E_V__PER__AUTHOR_FK
            references PERSON
                on delete set null,
    CREATE_DATE      TIMESTAMP(6) default systimestamp not null,
    OLD_PAGE_ID      NUMBER(19),
    RESTORED_VERSION NUMBER,
    constraint WIKI_EDITOR_VERSION_UK
        unique (VERSION, WIKI_EDITOR_ID)
)
/

create index IDX_WIKI_EDI_VER__WIKIEDITOR
    on WIKI_EDITOR_VERSION (WIKI_EDITOR_ID)
/

create trigger WIKI_EDITOR_VERSION_BRI
    before insert
    on WIKI_EDITOR_VERSION
    for each row
    when (new.id IS NULL)
BEGIN
    SELECT wiki_editor_version_seq.nextval
    INTO :new.id
    FROM dual;
END wiki_editor_version_bri;
/

create trigger WIKI_EDITOR_VERSION_BD
    before delete
    on WIKI_EDITOR_VERSION
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_WIKI_EDITOR_VERSION("ID", "WIKI_EDITOR_ID", "WIKI_TEXT", "VERSION", "AUTHOR_ID", "CREATE_DATE",
                                       "OLD_PAGE_ID", "RESTORED_VERSION", DELETE_ACTION_ID)
    values (:OLD."ID", :OLD."WIKI_EDITOR_ID", :OLD."WIKI_TEXT", :OLD."VERSION", :OLD."AUTHOR_ID", :OLD."CREATE_DATE",
            :OLD."OLD_PAGE_ID", :OLD."RESTORED_VERSION", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table WORKSTREAM_ENTRY
(
    ID              NUMBER(19)                 not null
        constraint WORKSTREAM_ENTRY_PK
            primary key,
    TYPE            VARCHAR2(32 char)          not null,
    CREATED_AT      TIMESTAMP(6) default NULL  not null,
    MODIFIED_AT     TIMESTAMP(6) default NULL  not null,
    ORIGIN_ITEM_ID  VARCHAR2(255 char)         not null,
    SUBJECT_ITEM_ID VARCHAR2(255 char)         not null,
    AUTHOR_ID       VARCHAR2(255 char)         not null,
    PINNED          CHAR(1 char) default ('f') not null,
    PIN_AUTHOR      NUMBER(19),
    PIN_DATE        TIMESTAMP(6),
    PUBLISHED       CHAR(1 char)               not null,
    PUBLISHED_AT    TIMESTAMP(6)
)
/

create table WORKSTREAM_ATTACHMENT
(
    ENTRY_ID NUMBER(19)           not null
        constraint W_A__W_E__ENTRY_FK
            references WORKSTREAM_ENTRY
                on delete cascade,
    POSITION NUMBER(10) default 0 not null,
    ITEM_ID  VARCHAR2(255 char)   not null
        constraint WA_PK
            primary key,
    constraint WA_ENTRY_POSITION_UK
        unique (ENTRY_ID, POSITION)
)
/

create trigger WORKSTREAM_ATTACHMENT_BD
    before delete
    on WORKSTREAM_ATTACHMENT
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_WORKSTREAM_ATTACHMENT("ENTRY_ID", "POSITION", "ITEM_ID", DELETE_ACTION_ID)
    values (:OLD."ENTRY_ID", :OLD."POSITION", :OLD."ITEM_ID", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create index WE_MODIFIED_IDX
    on WORKSTREAM_ENTRY (MODIFIED_AT desc)
/

create index WE_TYPE_IDS
    on WORKSTREAM_ENTRY (TYPE)
/

create index WORKSTREAM_ENTRY_AUTHOR_IDX
    on WORKSTREAM_ENTRY (AUTHOR_ID, TYPE, ORIGIN_ITEM_ID)
/

create index WE_ORIG_ITEM_IDX
    on WORKSTREAM_ENTRY (ORIGIN_ITEM_ID, TYPE)
/

create index WORKSTREAM_ENTRY_SUBJECT_IDX
    on WORKSTREAM_ENTRY (SUBJECT_ITEM_ID, TYPE, ORIGIN_ITEM_ID)
/

create index WE_PINNED_IDX
    on WORKSTREAM_ENTRY (PINNED)
/

create index WORKSTREAM_ENTRY_CREATED_IDX
    on WORKSTREAM_ENTRY (CREATED_AT desc)
/

create trigger WORKSTREAM_ENTRY_BRI
    before insert
    on WORKSTREAM_ENTRY
    for each row
    when (new.id IS NULL)
BEGIN
    SELECT workstream_entry_seq.nextval
    INTO :new.id
    FROM dual;
END workstream_entry_bri;
/

create trigger WORKSTREAM_ENTRY_BD
    before delete
    on WORKSTREAM_ENTRY
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_WORKSTREAM_ENTRY("ID", "TYPE", "CREATED_AT", "MODIFIED_AT", "ORIGIN_ITEM_ID", "SUBJECT_ITEM_ID",
                                    "AUTHOR_ID", "PINNED", "PIN_AUTHOR", "PIN_DATE", "PUBLISHED", "PUBLISHED_AT",
                                    DELETE_ACTION_ID)
    values (:OLD."ID", :OLD."TYPE", :OLD."CREATED_AT", :OLD."MODIFIED_AT", :OLD."ORIGIN_ITEM_ID",
            :OLD."SUBJECT_ITEM_ID", :OLD."AUTHOR_ID", :OLD."PINNED", :OLD."PIN_AUTHOR", :OLD."PIN_DATE",
            :OLD."PUBLISHED", :OLD."PUBLISHED_AT", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table WORKSTREAM_ENTRY_ATTRIBUTE
(
    ENTRY_ID NUMBER(19)        not null
        constraint W_E_A__W_E__ENTRY_FK
            references WORKSTREAM_ENTRY
                on delete cascade,
    KEY      VARCHAR2(24 char) not null,
    VALUE    CLOB              not null,
    primary key (ENTRY_ID, KEY)
)
/

create trigger WORKSTREAM_ENTRY_ATTRIBUTE_BD
    before delete
    on WORKSTREAM_ENTRY_ATTRIBUTE
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_WORKSTREAM_ENTRY_ATTRIBUTE("ENTRY_ID", "KEY", "VALUE", DELETE_ACTION_ID)
    values (:OLD."ENTRY_ID", :OLD."KEY", :OLD."VALUE", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table SEARCH_INDEX_QUEUE
(
    ID          NUMBER(19)                              not null
        constraint SEARCH_INDEX_QUEUE_PK
            primary key,
    ITEM_TYPE   VARCHAR2(32 char)                       not null,
    CREATED_AT  TIMESTAMP(6)       default systimestamp not null,
    IN_PROGRESS CHAR               default ('f')        not null,
    MODIFIED_AT TIMESTAMP(6)       default systimestamp,
    INDEX_TYPE  VARCHAR2(100 char) default ('ALL')      not null,
    ITEM_ID     VARCHAR2(255 char)                      not null
)
/

create trigger SEARCH_INDEX_QUEUE_BRI
    before insert
    on SEARCH_INDEX_QUEUE
    for each row
    when (new.id IS NULL)
BEGIN
    SELECT search_index_queue_seq.nextval
    INTO :new.id
    FROM dual;
END search_index_queue_bri;
/

create table ITEM_EVENT_QUEUE
(
    ID         NUMBER(19)                        not null
        constraint ITEM_EVENT_QUEUE_PK
            primary key,
    TYPE       VARCHAR2(32 char)                 not null,
    STATE      VARCHAR2(32 char)                 not null,
    CREATED_AT TIMESTAMP(6) default systimestamp not null,
    ITEM_ID    VARCHAR2(255 char)                not null
)
/

create trigger ITEM_EVENT_QUEUE_BRI
    before insert
    on ITEM_EVENT_QUEUE
    for each row
    when (new.id IS NULL)
BEGIN
    SELECT item_event_queue_seq.nextval
    INTO :new.id
    FROM dual;
END item_event_queue_bri;
/

create table ENTITY_TYPE_NAME
(
    NAME VARCHAR2(255 char) not null
        constraint ENTITY_TYPE_NAME_PK
            primary key
)
/

create table ENTITY
(
    ID                          NUMBER(19)                 not null
        constraint ENTITY_PK
            primary key,
    NAME                        VARCHAR2(255 char)         not null,
    START_AT                    TIMESTAMP(6),
    END_AT                      TIMESTAMP(6),
    CLOSING_DATE                TIMESTAMP(6),
    TIMEZONE                    VARCHAR2(255 char),
    DESCRIPTION                 CLOB                       not null,
    LOCATION                    VARCHAR2(255 char),
    TAGS                        CLOB,
    SUBDOMAIN                   VARCHAR2(255 char)
        constraint ENTITY_SUBDOMAIN_UK
            unique,
    SUBDOMAIN_DEACTIVATED       CHAR         default ('f') not null,
    EXTERNAL_DOMAIN             VARCHAR2(255 char)
        constraint ENTITY_EXTERNAL_DOMAIN_UK
            unique,
    LOGO                        VARCHAR2(255 char),
    ICON                        VARCHAR2(255 char),
    CREATE_DATE                 TIMESTAMP(6) default systimestamp,
    MODIFY_DATE                 TIMESTAMP(6) default systimestamp,
    USE_PARENT_ADMIN_AS_COADMIN CHAR         default ('t') not null,
    ENTITY_TYPE                 VARCHAR2(255 char)         not null
        constraint ENT__E_T__NAME_FK
            references ENTITY_TYPE_NAME,
    SLIDESHOW_IMAGE             VARCHAR2(255),
    PARTICIPANT_LIMIT           NUMBER(19)   default -1    not null,
    ASSIGNEE_ID                 NUMBER(19)
        constraint ENTITY_ASSIGNEE_PERS_FK
            references PERSON
                on delete set null,
    DEFAULT_ENTITY_TAB          VARCHAR2(256 char),
    DEFAULT_NAVIGATION          CHAR         default ('t') not null,
    LAST_DRIVE_CHANGE           NUMBER(10)
)
/

create index IDX__ENT__E_T
    on ENTITY (ENTITY_TYPE)
/

create trigger ENTITY_BRI
    before insert
    on ENTITY
    for each row
    when (new.id IS NULL)
BEGIN
    SELECT entity_seq.nextval
    INTO :new.id
    FROM dual;
END entity_bri;
/

create trigger ENTITY_BD
    before delete
    on ENTITY
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_ENTITY("ID", "NAME", "START_AT", "END_AT", "CLOSING_DATE", "TIMEZONE", "DESCRIPTION", "LOCATION",
                          "TAGS", "SUBDOMAIN", "SUBDOMAIN_DEACTIVATED", "EXTERNAL_DOMAIN", "LOGO", "ICON",
                          "CREATE_DATE", "MODIFY_DATE", "USE_PARENT_ADMIN_AS_COADMIN", "ENTITY_TYPE", "SLIDESHOW_IMAGE",
                          "PARTICIPANT_LIMIT", "ASSIGNEE_ID", "DEFAULT_ENTITY_TAB", "DEFAULT_NAVIGATION",
                          "LAST_DRIVE_CHANGE", DELETE_ACTION_ID)
    values (:OLD."ID", :OLD."NAME", :OLD."START_AT", :OLD."END_AT", :OLD."CLOSING_DATE", :OLD."TIMEZONE",
            :OLD."DESCRIPTION", :OLD."LOCATION", :OLD."TAGS", :OLD."SUBDOMAIN", :OLD."SUBDOMAIN_DEACTIVATED",
            :OLD."EXTERNAL_DOMAIN", :OLD."LOGO", :OLD."ICON", :OLD."CREATE_DATE", :OLD."MODIFY_DATE",
            :OLD."USE_PARENT_ADMIN_AS_COADMIN", :OLD."ENTITY_TYPE", :OLD."SLIDESHOW_IMAGE", :OLD."PARTICIPANT_LIMIT",
            :OLD."ASSIGNEE_ID", :OLD."DEFAULT_ENTITY_TAB", :OLD."DEFAULT_NAVIGATION", :OLD."LAST_DRIVE_CHANGE",
            del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table ENTITY_COMPONENT
(
    ENTITY_ID        NUMBER(19)         not null
        constraint E_COM__ENT__ENTITY_FK
            references ENTITY
                on delete cascade,
    COMPONENT_TYPE   VARCHAR2(255)      not null,
    "position"       NUMBER(19)         not null,
    "order"          NUMBER             not null,
    VISIBLE          CHAR default ('t') not null,
    "open"           CHAR default ('t') not null,
    CUSTOMIZED_TITLE CLOB,
    constraint ENTITY_COMPONENT_PK
        primary key (ENTITY_ID, COMPONENT_TYPE)
)
/

create index IDX_ENTITY_COM__ENTITY
    on ENTITY_COMPONENT (ENTITY_ID)
/

create trigger ENTITY_COMPONENT_BD
    before delete
    on ENTITY_COMPONENT
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_ENTITY_COMPONENT("ENTITY_ID", "COMPONENT_TYPE", "position", "order", "VISIBLE", "open",
                                    "CUSTOMIZED_TITLE", DELETE_ACTION_ID)
    values (:OLD."ENTITY_ID", :OLD."COMPONENT_TYPE", :OLD."position", :OLD."order", :OLD."VISIBLE", :OLD."open",
            :OLD."CUSTOMIZED_TITLE", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table ENTITY_COMPONENT_OPEN_FOR
(
    ENTITY_ID      NUMBER(19)        not null
        constraint E_C_O_F__ENT__ENTITY_FK
            references ENTITY
                on delete cascade,
    COMPONENT_TYPE VARCHAR2(255)     not null,
    AUTHORITY_NAME VARCHAR2(50 char) not null,
    constraint ENTITY_COMPONENT_OPEN_FOR_PK
        primary key (ENTITY_ID, COMPONENT_TYPE, AUTHORITY_NAME)
)
/

create trigger ENTITY_COMPONENT_OPEN_FOR_BD
    before delete
    on ENTITY_COMPONENT_OPEN_FOR
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_ENTITY_COMPONENT_OPEN_FOR("ENTITY_ID", "COMPONENT_TYPE", "AUTHORITY_NAME", DELETE_ACTION_ID)
    values (:OLD."ENTITY_ID", :OLD."COMPONENT_TYPE", :OLD."AUTHORITY_NAME", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table ENTITY_LINK
(
    ENTITY_ID        NUMBER(19)               not null
        constraint E_L__ENT__ENTITY_FK
            references ENTITY
                on delete cascade,
    LINKED_ENTITY_ID NUMBER(19)               not null
        constraint E_L__ENT__LINKED_ENTITY_FK
            references ENTITY
                on delete cascade,
    CREATE_DATE      TIMESTAMP(6) default systimestamp,
    MODIFY_DATE      TIMESTAMP(6) default systimestamp,
    INHERIT_ADMIN    CHAR         default 'f' not null,
    INHERIT_MEMBER   CHAR         default 'f' not null,
    constraint ENTITY_LINK_PK
        primary key (ENTITY_ID, LINKED_ENTITY_ID)
)
/

create trigger ENTITY_LINK_BD
    before delete
    on ENTITY_LINK
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_ENTITY_LINK("ENTITY_ID", "LINKED_ENTITY_ID", "CREATE_DATE", "MODIFY_DATE", "INHERIT_ADMIN",
                               "INHERIT_MEMBER", DELETE_ACTION_ID)
    values (:OLD."ENTITY_ID", :OLD."LINKED_ENTITY_ID", :OLD."CREATE_DATE", :OLD."MODIFY_DATE", :OLD."INHERIT_ADMIN",
            :OLD."INHERIT_MEMBER", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table ENTITY_TO_ENTITY_TYPE_PRIVACY
(
    ENTITY_ID      NUMBER(19)         not null
        constraint E_T_E_T_P__ENT__ENTITY_FK
            references ENTITY
                on delete cascade,
    ENTITY_TYPE    VARCHAR2(255 char) not null
        constraint E_T_E_T_P__E_T__NAME_FK
            references ENTITY_TYPE_NAME,
    AUTHORITY_NAME VARCHAR2(50 char)  not null,
    CREATE_DATE    TIMESTAMP(6) default systimestamp,
    MODIFY_DATE    TIMESTAMP(6) default systimestamp,
    constraint ENTITY_TO_ENTITY_TYPE_PRIVA_PK
        primary key (ENTITY_ID, ENTITY_TYPE, AUTHORITY_NAME)
)
/

create trigger ENTITY_TO_ENTITY_TYPE_PRIVA_BD
    before delete
    on ENTITY_TO_ENTITY_TYPE_PRIVACY
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_ENTITY_TO_ENTITY_TYPE_PRIVA("ENTITY_ID", "ENTITY_TYPE", "AUTHORITY_NAME", "CREATE_DATE",
                                               "MODIFY_DATE", DELETE_ACTION_ID)
    values (:OLD."ENTITY_ID", :OLD."ENTITY_TYPE", :OLD."AUTHORITY_NAME", :OLD."CREATE_DATE", :OLD."MODIFY_DATE",
            del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table ENTITY_PRIVACY
(
    ENTITY_ID      NUMBER(19)        not null
        constraint E_P__ENT__ENTITY_FK
            references ENTITY
                on delete cascade,
    PRIVACY_TYPE   VARCHAR2(50 char) not null,
    AUTHORITY_NAME VARCHAR2(50 char) not null,
    CREATE_DATE    TIMESTAMP(6) default systimestamp,
    MODIFY_DATE    TIMESTAMP(6) default systimestamp
)
/

create trigger ENTITY_PRIVACY_BD
    before delete
    on ENTITY_PRIVACY
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_ENTITY_PRIVACY("ENTITY_ID", "PRIVACY_TYPE", "AUTHORITY_NAME", "CREATE_DATE", "MODIFY_DATE",
                                  DELETE_ACTION_ID)
    values (:OLD."ENTITY_ID", :OLD."PRIVACY_TYPE", :OLD."AUTHORITY_NAME", :OLD."CREATE_DATE", :OLD."MODIFY_DATE",
            del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table EXTERNAL_INVITATION
(
    INVITER_ID NUMBER(19)         not null
        constraint E_I__PER__INVITER_FK
            references PERSON
                on delete cascade,
    EMAIL      VARCHAR2(100 char) not null,
    HASH       VARCHAR2(100 char) not null
        constraint EXTERNAL_INVITATION_PK
            primary key,
    ENTITY_ID  NUMBER(19)
        constraint E_I__ENT__ENTITY_FK
            references ENTITY
                on delete cascade,
    constraint EXTERNAL_INVITATION_EMAIL_UK
        unique (EMAIL, ENTITY_ID)
)
/

create index IDX_EXTERNAL_INV__ENTITY
    on EXTERNAL_INVITATION (ENTITY_ID)
/

create trigger EXTERNAL_INVITATION_BD
    before delete
    on EXTERNAL_INVITATION
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_EXTERNAL_INVITATION("INVITER_ID", "EMAIL", "HASH", "ENTITY_ID", DELETE_ACTION_ID)
    values (:OLD."INVITER_ID", :OLD."EMAIL", :OLD."HASH", :OLD."ENTITY_ID", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table IMPORTEDENTITY
(
    EXTERNALID VARCHAR2(100) not null
        unique,
    INTERNALID NUMBER(19)
        unique
        references ENTITY
            on delete cascade
)
/

create index IDX_IMPORTEDENTITIES_EXTID
    on IMPORTEDENTITY (LOWER("EXTERNALID"))
/

create table MULTI_WIKI
(
    ID          NUMBER(19)                        not null
        constraint MULTI_WIKI_PK
            primary key,
    ENTITY_ID   NUMBER(19)                        not null
        constraint MULTI_WIKI_PARENT_UNQ
            unique
        references ENTITY
            on delete cascade,
    CREATE_DATE TIMESTAMP(6) default systimestamp not null,
    MODIFY_DATE TIMESTAMP(6) default systimestamp not null
)
/

create trigger MULTI_WIKI_BD
    before delete
    on MULTI_WIKI
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_MULTI_WIKI("ID", "ENTITY_ID", "CREATE_DATE", "MODIFY_DATE", DELETE_ACTION_ID)
    values (:OLD."ID", :OLD."ENTITY_ID", :OLD."CREATE_DATE", :OLD."MODIFY_DATE", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table MULTI_WIKI_VERSION
(
    ID          NUMBER(19)                        not null
        constraint MULTI_WIKI_VERSION_PK
            primary key,
    WIKI_ID     NUMBER(19)                        not null
        references MULTI_WIKI
            on delete cascade,
    CREATE_DATE TIMESTAMP(6) default systimestamp not null,
    MODIFY_DATE TIMESTAMP(6) default systimestamp not null
)
/

create trigger MULTI_WIKI_VERSION_BD
    before delete
    on MULTI_WIKI_VERSION
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_MULTI_WIKI_VERSION("ID", "WIKI_ID", "CREATE_DATE", "MODIFY_DATE", DELETE_ACTION_ID)
    values (:OLD."ID", :OLD."WIKI_ID", :OLD."CREATE_DATE", :OLD."MODIFY_DATE", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table MULTI_WIKI_VERSION_SECTION
(
    ID            NUMBER(19)                        not null
        constraint MULTI_WIKI_SECTION_PK
            primary key,
    VERSION_ID    NUMBER(19)                        not null
        references MULTI_WIKI_VERSION
            on delete cascade,
    HEADLINE      VARCHAR2(256 char)                not null,
    HTML          CLOB                              not null,
    CREATE_DATE   TIMESTAMP(6) default systimestamp not null,
    MODIFY_DATE   TIMESTAMP(6) default systimestamp not null,
    SECTION_ID    NUMBER(19)   default 0            not null,
    SECTION_ORDER NUMBER(10)   default 0            not null,
    unique (SECTION_ID, VERSION_ID)
)
/

create index MWVS_VERSION_ID_IDX
    on MULTI_WIKI_VERSION_SECTION (VERSION_ID)
/

create trigger MULTI_WIKI_VERSION_SECTION_BD
    before delete
    on MULTI_WIKI_VERSION_SECTION
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_MULTI_WIKI_VERSION_SECTION("ID", "VERSION_ID", "HEADLINE", "HTML", "CREATE_DATE", "MODIFY_DATE",
                                              "SECTION_ID", "SECTION_ORDER", DELETE_ACTION_ID)
    values (:OLD."ID", :OLD."VERSION_ID", :OLD."HEADLINE", :OLD."HTML", :OLD."CREATE_DATE", :OLD."MODIFY_DATE",
            :OLD."SECTION_ID", :OLD."SECTION_ORDER", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table IMPORTEDPERSON
(
    EXTERNALID  VARCHAR2(100)                     not null
        unique,
    INTERNALID  NUMBER(19)
        unique
        references PERSON
            on delete cascade,
    IMPORT_DATE TIMESTAMP(6) default systimestamp not null
)
/

create index IDX_IMPORTEDPERSON_EXTID
    on IMPORTEDPERSON (LOWER("EXTERNALID"))
/

create table MIGRATION_MAPPING
(
    MIGRATION_NAME  VARCHAR2(4000 char) not null,
    MIGRATION_KEY   VARCHAR2(4000 char) not null,
    MIGRATION_VALUE VARCHAR2(4000 char) not null
)
/

create index IDX_MIGRATION_MAPPING_NAME
    on MIGRATION_MAPPING (MIGRATION_NAME)
/

create table MULTI_WIKI_SECTION_VISIBILITY
(
    VERSION_SECTION_ID NUMBER(19)                        not null
        constraint MULTI_WIKI_SECT_VISIBILITY_FK
            references MULTI_WIKI_VERSION_SECTION
                on delete cascade,
    AUTHORITY_NAME     VARCHAR2(50 char)                 not null,
    CREATE_DATE        TIMESTAMP(6) default systimestamp not null,
    MODIFY_DATE        TIMESTAMP(6) default systimestamp not null,
    constraint MULTI_WIKI_SECT_VISIBILITY_PK
        primary key (VERSION_SECTION_ID, AUTHORITY_NAME)
)
/

create trigger MULTI_WIKI_SECTION_VISIBILI_BD
    before delete
    on MULTI_WIKI_SECTION_VISIBILITY
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_MULTI_WIKI_SECTION_VISIBILI("VERSION_SECTION_ID", "AUTHORITY_NAME", "CREATE_DATE", "MODIFY_DATE",
                                               DELETE_ACTION_ID)
    values (:OLD."VERSION_SECTION_ID", :OLD."AUTHORITY_NAME", :OLD."CREATE_DATE", :OLD."MODIFY_DATE", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table PERSON_EXTERNAL_IDS
(
    PERSON_ID          NUMBER(19)          not null
        constraint PERSON_ID_FKEY
            references PERSON
                on delete cascade,
    EXTERNAL_PERSON_ID VARCHAR2(4000 char) not null,
    EXTERNAL_SYSTEM_ID VARCHAR2(50 char)   not null,
    constraint PERSON_EXTERNAL_IDS_PKEY
        primary key (PERSON_ID, EXTERNAL_SYSTEM_ID)
)
/

create trigger PERSON_EXTERNAL_IDS_BD
    before delete
    on PERSON_EXTERNAL_IDS
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_PERSON_EXTERNAL_IDS("PERSON_ID", "EXTERNAL_PERSON_ID", "EXTERNAL_SYSTEM_ID", DELETE_ACTION_ID)
    values (:OLD."PERSON_ID", :OLD."EXTERNAL_PERSON_ID", :OLD."EXTERNAL_SYSTEM_ID", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table ENTITY_DYNAMIC_ATTRIBUTE
(
    ENTITY_ID       NUMBER             not null
        constraint EDA_ENTITY_FK
            references ENTITY
                on delete cascade,
    ATTRIBUTE_ID    VARCHAR2(255 char) not null,
    ATTRIBUTE_VALUE CLOB,
    POSITION        NUMBER             not null,
    constraint ENTITY_DYNAMIC_ATTRIBUTE_PKEY
        unique (ENTITY_ID, ATTRIBUTE_ID, POSITION)
)
/

create trigger ENTITY_DYNAMIC_ATTRIBUTE_BD
    before delete
    on ENTITY_DYNAMIC_ATTRIBUTE
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_ENTITY_DYNAMIC_ATTRIBUTE("ENTITY_ID", "ATTRIBUTE_ID", "ATTRIBUTE_VALUE", "POSITION",
                                            DELETE_ACTION_ID)
    values (:OLD."ENTITY_ID", :OLD."ATTRIBUTE_ID", :OLD."ATTRIBUTE_VALUE", :OLD."POSITION", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table AUDIT_LOG
(
    ID            NUMBER(19)         not null
        constraint AUDIT_LOG_PK
            primary key,
    PERSON_ID     NUMBER(19),
    CHANGE_DATE   TIMESTAMP(6)       not null,
    CHANGE_CALL   VARCHAR2(255 char) not null,
    CHANGE_RESULT CLOB               not null
)
/

create table AUDIT_LOG_PARAM
(
    AUDIT_ID NUMBER(19)         not null
        constraint AUDIT_LOG_PARAM_AUDIT_ID_FK
            references AUDIT_LOG
                on delete cascade,
    POSITION NUMBER(10)         not null,
    NAME     VARCHAR2(255 char) not null,
    VALUE    CLOB               not null,
    constraint AUDIT_LOG_PARAM_PK
        primary key (AUDIT_ID, POSITION)
)
/

create table SYNC_APP
(
    ID             VARCHAR2(36 char)  not null
        constraint SYNC_APP_PK
            primary key,
    TOKEN          VARCHAR2(36 char)  not null,
    PERSON_ID      NUMBER(19)
        constraint SYNC_APP_PERSON_ID_FK
            references PERSON
                on delete cascade,
    CLIENT_VERSION VARCHAR2(32 char),
    CLIENT_USER    VARCHAR2(255 char) not null,
    CLIENT_SYSTEM  VARCHAR2(255 char) not null,
    CREATE_DATE    TIMESTAMP(6)       not null,
    MODIFY_DATE    TIMESTAMP(6)       not null
)
/

create table ENTITY_PARENTS
(
    CREATED_AT TIMESTAMP(6) default systimestamp,
    ENTITY_ID  VARCHAR2(255 char) not null,
    PARENT_ID  VARCHAR2(255 char) not null,
    constraint ENTITY_PARENTS_PK
        primary key (ENTITY_ID, PARENT_ID)
)
/

create unique index ENTITY_PARENTS_PARENT_IDX
    on ENTITY_PARENTS (PARENT_ID, ENTITY_ID)
/

create table ITEM_VISIBILITY_ROLE
(
    ROLE_NAME   VARCHAR2(15 char)  not null,
    CREATED_AT  TIMESTAMP(6) default systimestamp,
    ORIGIN_TYPE VARCHAR2(255 char) not null,
    ID          NUMBER(19)         not null
        constraint ITM_VIS_ROLE_PK
            primary key,
    ITEM_ID     VARCHAR2(255 char) not null
)
/

create index ITM_VIS_ROLE_ROLE_IDX
    on ITEM_VISIBILITY_ROLE (ROLE_NAME, ITEM_ID, ORIGIN_TYPE)
/

create index ITM_VIS_ROLE_IID_IDX
    on ITEM_VISIBILITY_ROLE (ITEM_ID)
/

create table ITEM_VISIBILITY_QUEUE
(
    ID          NUMBER(19)                        not null
        constraint ITM_VIS_Q_PK
            primary key,
    ITEM_ID     NUMBER(19)                        not null,
    ITEM_TYPE   VARCHAR2(32 char)                 not null,
    CREATED_AT  TIMESTAMP(6) default systimestamp not null,
    IN_PROGRESS CHAR         default 'f'          not null,
    MODIFIED_AT TIMESTAMP(6) default systimestamp not null,
    LOCK_ID     NUMBER(19)
)
/

create index ITM_VIS_Q_DATE_IDX
    on ITEM_VISIBILITY_QUEUE (CREATED_AT)
/

create index ITM_VIS_Q_ITM_IDX_IP_CA_IDX
    on ITEM_VISIBILITY_QUEUE (ITEM_ID, ITEM_TYPE, IN_PROGRESS, CREATED_AT)
/

create index ITM_VIS_Q_ID_LC_IP_IDX
    on ITEM_VISIBILITY_QUEUE (ID, LOCK_ID, IN_PROGRESS)
/

create index ITM_VIS_Q_MOD_IDX
    on ITEM_VISIBILITY_QUEUE (MODIFIED_AT)
/

create index ITM_VIS_Q_IP_MOD_IDX
    on ITEM_VISIBILITY_QUEUE (IN_PROGRESS, MODIFIED_AT)
/

create table ITEM_VISIBILITY_QUEUE_EVENT
(
    ITEM_VISIBILITY_QUEUE_ID NUMBER(19)        not null
        constraint ITM_VIS_Q_E_IVQ_FK
            references ITEM_VISIBILITY_QUEUE
                on delete cascade,
    EVENT_TYPE               VARCHAR2(50 char) not null,
    constraint ITM_VIS_Q_E_PK
        primary key (ITEM_VISIBILITY_QUEUE_ID, EVENT_TYPE)
)
/

create table ENTITY_MEMBER_ROLE_NAME
(
    NAME        VARCHAR2(50)                      not null
        constraint E_M_R_N_PK
            primary key,
    CREATE_DATE TIMESTAMP(6) default systimestamp not null,
    WORKFLOW    VARCHAR2(16)                      not null,
    constraint E_M_R_N_WORKFLOW_UQ
        unique (NAME, WORKFLOW)
)
/

create table ENTITY_MEMBER_ROLE
(
    PERSON_ID   NUMBER(19)                        not null
        constraint E_M_PERSON_FK
            references PERSON
                on delete cascade,
    ENTITY_ID   NUMBER(19)                        not null
        constraint E_M_ENTITY_FK
            references ENTITY
                on delete cascade,
    ROLE        VARCHAR2(50)                      not null,
    CREATE_DATE TIMESTAMP(6) default systimestamp not null,
    WORKFLOW    VARCHAR2(16)                      not null,
    constraint E_M_R_PK
        primary key (ENTITY_ID, PERSON_ID, ROLE),
    constraint E_M_R_WORKFLOW_UQ
        unique (ENTITY_ID, PERSON_ID, WORKFLOW),
    constraint E_M_R_ROLE_FK
        foreign key (ROLE, WORKFLOW) references ENTITY_MEMBER_ROLE_NAME (NAME, WORKFLOW)
)
/

create index E_M_R_PERSON_ROLE_IDX
    on ENTITY_MEMBER_ROLE (PERSON_ID, ROLE)
/

create index E_M_R_ENTITY_ROLE_IDX
    on ENTITY_MEMBER_ROLE (ENTITY_ID, ROLE)
/

create index E_M_R_ROLE_IDX
    on ENTITY_MEMBER_ROLE (ROLE)
/

create trigger ENTITY_MEMBER_ROLE_BD
    before delete
    on ENTITY_MEMBER_ROLE
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_ENTITY_MEMBER_ROLE("PERSON_ID", "ENTITY_ID", "ROLE", "CREATE_DATE", "WORKFLOW", DELETE_ACTION_ID)
    values (:OLD."PERSON_ID", :OLD."ENTITY_ID", :OLD."ROLE", :OLD."CREATE_DATE", :OLD."WORKFLOW", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table ENTITY_INTERNAL_INVITATION
(
    PERSON_ID      NUMBER(19)                        not null
        constraint E_I_I_PERSON_FK
            references PERSON
                on delete cascade,
    ENTITY_ID      NUMBER(19)                        not null
        constraint E_I_I_ENTITY_FK
            references ENTITY
                on delete cascade,
    INVITER_ID     NUMBER(19)                        not null
        constraint E_I_I_INVITER_FK
            references PERSON,
    INVITE_MESSAGE CLOB                              not null,
    CREATE_DATE    TIMESTAMP(6) default systimestamp not null,
    constraint E_I_I_PK
        primary key (ENTITY_ID, PERSON_ID)
)
/

create trigger ENTITY_INTERNAL_INVITATION_BD
    before delete
    on ENTITY_INTERNAL_INVITATION
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_ENTITY_INTERNAL_INVITATION("PERSON_ID", "ENTITY_ID", "INVITER_ID", "INVITE_MESSAGE", "CREATE_DATE",
                                              DELETE_ACTION_ID)
    values (:OLD."PERSON_ID", :OLD."ENTITY_ID", :OLD."INVITER_ID", :OLD."INVITE_MESSAGE", :OLD."CREATE_DATE",
            del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table SECRET
(
    SECRET_KEY   VARCHAR2(4000 char) not null
        constraint SECRET_PK
            primary key,
    SECRET_VALUE VARCHAR2(4000 char) not null
)
/

create table ENTITY_RECOMMENDATION
(
    PERSON_ID         NUMBER(19)                        not null
        constraint ENT_REC_PERSON_FK
            references PERSON,
    ENTITY_ID         NUMBER(19)                        not null
        constraint ENT_REC_ENTITY_FK
            references ENTITY,
    RECOMMENDER_ID    NUMBER(19)                        not null
        constraint ENT_REC_RECOMMENDER_FK
            references PERSON,
    RECOMMEND_MESSAGE VARCHAR2(4000 char)               not null,
    CREATE_DATE       TIMESTAMP(6) default systimestamp not null,
    constraint ENT_REC_PK
        primary key (ENTITY_ID, PERSON_ID)
)
/

create trigger ENTITY_RECOMMENDATION_BD
    before delete
    on ENTITY_RECOMMENDATION
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_ENTITY_RECOMMENDATION("PERSON_ID", "ENTITY_ID", "RECOMMENDER_ID", "RECOMMEND_MESSAGE", "CREATE_DATE",
                                         DELETE_ACTION_ID)
    values (:OLD."PERSON_ID", :OLD."ENTITY_ID", :OLD."RECOMMENDER_ID", :OLD."RECOMMEND_MESSAGE", :OLD."CREATE_DATE",
            del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table LINK
(
    ID          NUMBER(19)                        not null
        constraint LINK_PK
            primary key,
    URL         VARCHAR2(4000 char)               not null,
    TITLE       VARCHAR2(4000 char),
    CREATE_DATE TIMESTAMP(6) default systimestamp not null,
    MODIFY_DATE TIMESTAMP(6) default systimestamp
)
/

create table DOCUMENT_VERSION_JUDO_ID
(
    VERSION_ID NUMBER(19)                        not null
        primary key
        references MDL_DOCUMENT_VERSION
            on delete cascade,
    JUDO_ID    VARCHAR2(40 char)                 not null,
    CREATED_AT TIMESTAMP(6) default systimestamp not null
)
/

create table OAUTH_CLIENT_DETAILS
(
    CLIENT_ID               VARCHAR2(256 char) not null
        primary key,
    RESOURCE_IDS            VARCHAR2(256 char),
    CLIENT_SECRET           VARCHAR2(4000),
    SCOPE                   VARCHAR2(256 char),
    AUTHORIZED_GRANT_TYPES  VARCHAR2(256 char),
    WEB_SERVER_REDIRECT_URI VARCHAR2(256 char),
    AUTHORITIES             VARCHAR2(256 char),
    ACCESS_TOKEN_VALIDITY   NUMBER,
    REFRESH_TOKEN_VALIDITY  NUMBER,
    ADDITIONAL_INFORMATION  VARCHAR2(4000 char),
    AUTOAPPROVE             VARCHAR2(256 char)
)
/

create table OAUTH_ACCESS_TOKEN
(
    TOKEN_ID          VARCHAR2(256 char) not null
        constraint OAUTH_ACCESS_TOKEN_PK
            primary key,
    AUTHENTICATION_ID VARCHAR2(256 char),
    USER_NAME         VARCHAR2(256 char),
    CLIENT_ID         VARCHAR2(256 char),
    REFRESH_TOKEN     VARCHAR2(256 char),
    TOKEN             CLOB,
    AUTHENTICATION    CLOB
)
/

create index IDX_OAUTH_ACCESS_TOKEN_AUTH
    on OAUTH_ACCESS_TOKEN (AUTHENTICATION_ID)
/

create index IDX_OAUTH_ACCESS_TOKEN_REFRESH
    on OAUTH_ACCESS_TOKEN (REFRESH_TOKEN)
/

create index IDX_OAUTH_ACCESS_TOKEN_USER
    on OAUTH_ACCESS_TOKEN (CLIENT_ID, USER_NAME)
/

create table OAUTH_REFRESH_TOKEN
(
    TOKEN_ID       VARCHAR2(256 char) not null
        constraint OAUTH_REFRESH_TOKEN_PK
            primary key,
    TOKEN          CLOB,
    AUTHENTICATION CLOB
)
/

create table NOTIFICATION
(
    ID                NUMBER(19)                         not null
        constraint NOTI_PK
            primary key,
    NOTIFICATION_TYPE VARCHAR2(255 char)                 not null,
    STATE             VARCHAR2(255)                      not null,
    ORIGINATOR_ID     NUMBER(19)                         not null
        constraint NOTI_ORG_FK
            references PERSON,
    RECEIVER_ID       NUMBER(19)                         not null
        constraint NOTI_REC_FK
            references PERSON,
    ENTITY_ID         NUMBER(19),
    CREATE_DATE       TIMESTAMP(6)  default systimestamp not null,
    MODIFY_DATE       TIMESTAMP(6)  default systimestamp,
    ENTITY_TYPE       VARCHAR2(255) default null,
    SUBJECT_ID        VARCHAR2(255 char)
)
/

create index IDX_NOTIFICATION_KEY
    on NOTIFICATION (RECEIVER_ID, STATE)
/

create index NOTI_O_T_E_S_IDX
    on NOTIFICATION (ORIGINATOR_ID, NOTIFICATION_TYPE, ENTITY_ID, STATE)
/

create index NOTI_SUB_TYPE_IDX
    on NOTIFICATION (SUBJECT_ID, NOTIFICATION_TYPE)
/

create table THEME
(
    ID            NUMBER(19)                        not null
        constraint THEME_PK
            primary key,
    NAME          VARCHAR2(255),
    SHARED        CHAR         default ('f')        not null,
    DEFAULT_THEME CHAR         default ('f')        not null,
    CREATE_DATE   TIMESTAMP(6) default systimestamp not null,
    MODIFY_DATE   TIMESTAMP(6) default systimestamp
)
/

create table THEME_ATTRIBUTE
(
    THEME_ID        NUMBER(19)         not null
        constraint THEME_ELEMENT_THEME_FK
            references THEME
                on delete cascade,
    ATTRIBUTE_TYPE  VARCHAR2(255 char) not null,
    ATTRIBUTE_VALUE VARCHAR2(255 char),
    constraint THEME_ELEMENT_PKEY
        unique (THEME_ID, ATTRIBUTE_TYPE)
)
/

create table ENTITY_THEME
(
    THEME_ID  NUMBER(19) not null
        constraint ENTITY_THEME_THEME_FK
            references THEME
                on delete cascade,
    ENTITY_ID NUMBER(19) not null
        constraint ENTITY_THEME_PK
            primary key
        constraint ENTITY_THEME_ENTITY_ID_FK
            references ENTITY
                on delete cascade
)
/

create table ENTITY_WAITLIST
(
    ENTITY_ID      NUMBER(19) not null
        constraint ENTITY_WAITLIST_ENTITY_FK
            references ENTITY
                on delete cascade,
    PERSON_ID      NUMBER(19) not null
        constraint ENTITY_WAITLIST_PERSON_FK
            references PERSON
                on delete cascade,
    WAITLIST_ORDER NUMBER(19) not null,
    constraint ENTITY_WAITLIST_PK
        primary key (ENTITY_ID, PERSON_ID)
)
/

create trigger ENTITY_WAITLIST_BD
    before delete
    on ENTITY_WAITLIST
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_ENTITY_WAITLIST("ENTITY_ID", "PERSON_ID", "WAITLIST_ORDER", DELETE_ACTION_ID)
    values (:OLD."ENTITY_ID", :OLD."PERSON_ID", :OLD."WAITLIST_ORDER", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table JABBER_SYSTEM_USER_PASSWORD
(
    USERNAME    VARCHAR2(255 char)                not null,
    SERVER      VARCHAR2(255 char)                not null,
    PASSWORD    VARCHAR2(255 char)                not null,
    MODIFY_AT   TIMESTAMP(6) default systimestamp not null,
    VALID_UNTIL TIMESTAMP(6),
    constraint JABBER_SYSTEM_USER_PASSWORD_PK
        primary key (USERNAME, SERVER)
)
/

create table ENTITY_STATUS
(
    ID               NUMBER(19)                        not null
        constraint ENTITY_STATUS_PK
            primary key,
    ENTITY_TYPE      VARCHAR2(255)                     not null,
    STATUS_NAME      VARCHAR2(255)                     not null,
    DEFAULT_STATUS   CHAR         default ('f')        not null,
    CREATE_DATE      TIMESTAMP(6) default systimestamp not null,
    MODIFY_DATE      TIMESTAMP(6) default systimestamp,
    PUBLISHED_STATUS CHAR         default ('f')        not null,
    ARCHIVED_STATUS  CHAR         default ('f')        not null,
    ICON_TYPE        VARCHAR2(255)                     not null,
    STATUS_ORDER     NUMBER(19)   default 0            not null,
    constraint ENTITY_STATUS_UQ
        unique (ENTITY_TYPE, STATUS_NAME)
)
/

create table ENTITY_VERSION
(
    ID                    NUMBER(19)                        not null
        constraint ENTITY_VERSION_PK
            primary key,
    ENTITY_ID             NUMBER(19)                        not null
        constraint ENTITY_VERSION_ENTITY_ID_FK
            references ENTITY
                on delete cascade,
    PERSON_ID             NUMBER(19)                        not null
        constraint ENTITY_VERSION_PERSON_ID_FK
            references PERSON
                on delete cascade,
    MAJOR_VERSION         NUMBER       default 0,
    MINOR_VERSION         NUMBER       default 0,
    DRAFT_VERSION         NUMBER       default 0,
    VERSION_TYPE          VARCHAR2(255 char)                not null,
    TARGET_TYPE           VARCHAR2(255 char),
    VERSION_STATUS        VARCHAR2(255 char)                not null,
    RELEASE_DATE          TIMESTAMP(6),
    EXPIRATION_DATE       TIMESTAMP(6),
    CHANGE_MESSAGE        VARCHAR2(512 char),
    COMMENT_FOR_REVIEWERS VARCHAR2(255 char),
    READ_DATE             DATE,
    DECLINE_MESSAGE       VARCHAR2(255 char),
    CREATE_DATE           TIMESTAMP(6) default systimestamp not null,
    MODIFY_DATE           TIMESTAMP(6) default systimestamp not null,
    ENTITY_STATUS_ID      NUMBER(19)                        not null
        constraint ENTITY_VERSION_STATUS_FK
            references ENTITY_STATUS,
    constraint ENTITY_VERSION_VERSION_UQ
        unique (ENTITY_ID, MAJOR_VERSION, MINOR_VERSION, DRAFT_VERSION)
)
/

create index ENTVERSION_EID_ESID_ID_IDX
    on ENTITY_VERSION (ENTITY_ID, ENTITY_STATUS_ID, ID)
/

create trigger ENTITY_VERSION_BD
    before delete
    on ENTITY_VERSION
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_ENTITY_VERSION("ID", "ENTITY_ID", "PERSON_ID", "MAJOR_VERSION", "MINOR_VERSION", "DRAFT_VERSION",
                                  "VERSION_TYPE", "TARGET_TYPE", "VERSION_STATUS", "RELEASE_DATE", "EXPIRATION_DATE",
                                  "CHANGE_MESSAGE", "COMMENT_FOR_REVIEWERS", "READ_DATE", "DECLINE_MESSAGE",
                                  "CREATE_DATE", "MODIFY_DATE", "ENTITY_STATUS_ID", DELETE_ACTION_ID)
    values (:OLD."ID", :OLD."ENTITY_ID", :OLD."PERSON_ID", :OLD."MAJOR_VERSION", :OLD."MINOR_VERSION",
            :OLD."DRAFT_VERSION", :OLD."VERSION_TYPE", :OLD."TARGET_TYPE", :OLD."VERSION_STATUS", :OLD."RELEASE_DATE",
            :OLD."EXPIRATION_DATE", :OLD."CHANGE_MESSAGE", :OLD."COMMENT_FOR_REVIEWERS", :OLD."READ_DATE",
            :OLD."DECLINE_MESSAGE", :OLD."CREATE_DATE", :OLD."MODIFY_DATE", :OLD."ENTITY_STATUS_ID", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table ENTITY_VERSION_REVIEW
(
    ENTITY_VERSION_ID NUMBER(19)         not null
        constraint ENTITY_VERSION_ID_FK
            references ENTITY_VERSION
                on delete cascade,
    REVIEWER_ID       NUMBER(19)         not null
        constraint ENTITY_VERSION_REVIEWER_FK
            references PERSON
                on delete cascade,
    INVITER_ID        NUMBER(19)         not null
        constraint ENTITY_VERSION_INVITER_FK
            references PERSON
                on delete cascade,
    REVIEW_STATUS     VARCHAR2(255 char) not null,
    REVIEW_ORDER      NUMBER(19)         not null,
    constraint ENTITY_VERSION_REVIEW_PK
        primary key (ENTITY_VERSION_ID, REVIEWER_ID),
    constraint ENTITY_VERSION_REVIEW_ORDER_UQ
        unique (ENTITY_VERSION_ID, REVIEW_ORDER)
)
/

create trigger ENTITY_VERSION_REVIEW_BD
    before delete
    on ENTITY_VERSION_REVIEW
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_ENTITY_VERSION_REVIEW("ENTITY_VERSION_ID", "REVIEWER_ID", "INVITER_ID", "REVIEW_STATUS",
                                         "REVIEW_ORDER", DELETE_ACTION_ID)
    values (:OLD."ENTITY_VERSION_ID", :OLD."REVIEWER_ID", :OLD."INVITER_ID", :OLD."REVIEW_STATUS", :OLD."REVIEW_ORDER",
            del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table ENTITY_VERSION_COMPONENTS
(
    ENTITY_VERSION_ID     NUMBER(19) not null
        constraint ENTITY_VERSION_COMPONENTS_PKEY
            unique
        constraint ENTITY_VERSION_FKEY
            references ENTITY_VERSION,
    MULTI_WIKI_VERSION_ID NUMBER(19) not null
        constraint MULTI_WIKI_VERSION_FKEY
            references MULTI_WIKI_VERSION
)
/

create trigger ENTITY_VERSION_COMPONENTS_BD
    before delete
    on ENTITY_VERSION_COMPONENTS
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_ENTITY_VERSION_COMPONENTS("ENTITY_VERSION_ID", "MULTI_WIKI_VERSION_ID", DELETE_ACTION_ID)
    values (:OLD."ENTITY_VERSION_ID", :OLD."MULTI_WIKI_VERSION_ID", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table CONVERSATION
(
    ID                  NUMBER(19)                        not null
        constraint CONVERSATION_PK
            primary key,
    TYPE                VARCHAR2(255 char)                not null,
    CREATE_DATE         TIMESTAMP(6) default systimestamp not null,
    TITLE               VARCHAR2(1024 char),
    LAST_MESSAGE_DATE   TIMESTAMP(6) default systimestamp not null,
    CREATION_ID         VARCHAR2(100 char)
        unique,
    LAST_MESSAGE_UPDATE TIMESTAMP(6) default systimestamp not null
)
/

create index IDX_CONVERSATION_TYPE
    on CONVERSATION (TYPE)
/

create index CNV_LMD_IDX
    on CONVERSATION (LAST_MESSAGE_DATE desc)
/

create trigger CONVERSATION_BD
    before delete
    on CONVERSATION
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_CONVERSATION("ID", "TYPE", "CREATE_DATE", "TITLE", "LAST_MESSAGE_DATE", "CREATION_ID",
                                "LAST_MESSAGE_UPDATE", DELETE_ACTION_ID)
    values (:OLD."ID", :OLD."TYPE", :OLD."CREATE_DATE", :OLD."TITLE", :OLD."LAST_MESSAGE_DATE", :OLD."CREATION_ID",
            :OLD."LAST_MESSAGE_UPDATE", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table CONVERSATION_PARTICIPANT
(
    CONVERSATION_ID           NUMBER(19)                        not null
        constraint CONV_PARTICIPANT_CONV_FK
            references CONVERSATION
                on delete cascade,
    PARTICIPANT_ID            NUMBER(19)                        not null
        constraint CONV_PARTICIPANT_PART_FK
            references PERSON
                on delete cascade,
    CREATE_DATE               TIMESTAMP(6) default systimestamp not null,
    MODIFY_DATE               TIMESTAMP(6) default systimestamp not null,
    READ_DATE                 TIMESTAMP(6) default systimestamp not null,
    DELETED                   CHAR(1 char) default ('f')        not null,
    LAST_MAIL_SENT            TIMESTAMP(6),
    DELETED_WITH_CONVERSATION CHAR(1 char) default ('f')        not null,
    constraint CONV_PARTICIPANT_PK
        unique (CONVERSATION_ID, PARTICIPANT_ID)
)
/

create trigger CONVERSATION_PARTICIPANT_BD
    before delete
    on CONVERSATION_PARTICIPANT
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_CONVERSATION_PARTICIPANT("CONVERSATION_ID", "PARTICIPANT_ID", "CREATE_DATE", "MODIFY_DATE",
                                            "READ_DATE", "DELETED", "LAST_MAIL_SENT", "DELETED_WITH_CONVERSATION",
                                            DELETE_ACTION_ID)
    values (:OLD."CONVERSATION_ID", :OLD."PARTICIPANT_ID", :OLD."CREATE_DATE", :OLD."MODIFY_DATE", :OLD."READ_DATE",
            :OLD."DELETED", :OLD."LAST_MAIL_SENT", :OLD."DELETED_WITH_CONVERSATION", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table CONVERSATION_MESSAGE
(
    ID              NUMBER(19)                               not null
        constraint CONV_MESSAGE_PK
            primary key,
    CONVERSATION_ID NUMBER(19)                               not null
        constraint CONV_MESSAGE_CONV_FK
            references CONVERSATION
                on delete cascade,
    FROM_PERSON_ID  NUMBER(19)                               not null
        constraint CONV_MESSAGE_PERS_FK
            references PERSON
                on delete cascade,
    CREATE_DATE     TIMESTAMP(6)      default systimestamp   not null,
    MESSAGE         CLOB,
    MESSAGE_TYPE    VARCHAR2(32 char) default 'CHAT_MESSAGE' not null,
    CREATION_ID     VARCHAR2(100 char)
        unique,
    MODIFY_DATE     TIMESTAMP(6)      default systimestamp   not null,
    DELETE_DATE     TIMESTAMP(6)
)
/

create index CM_CREATE_DATE_IDX
    on CONVERSATION_MESSAGE (CREATE_DATE desc)
/

create index CM_CONVID_CDATE_IDX
    on CONVERSATION_MESSAGE (CONVERSATION_ID asc, CREATE_DATE desc)
/

create index CM_MODIFY_DATE_IDX
    on CONVERSATION_MESSAGE (MODIFY_DATE)
/

create trigger CONVERSATION_MESSAGE_BD
    before delete
    on CONVERSATION_MESSAGE
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_CONVERSATION_MESSAGE("ID", "CONVERSATION_ID", "FROM_PERSON_ID", "CREATE_DATE", "MESSAGE",
                                        "MESSAGE_TYPE", "CREATION_ID", "MODIFY_DATE", "DELETE_DATE", DELETE_ACTION_ID)
    values (:OLD."ID", :OLD."CONVERSATION_ID", :OLD."FROM_PERSON_ID", :OLD."CREATE_DATE", :OLD."MESSAGE",
            :OLD."MESSAGE_TYPE", :OLD."CREATION_ID", :OLD."MODIFY_DATE", :OLD."DELETE_DATE", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table SUBSCRIPTIONS
(
    SUBSCRIBER_ID      NUMBER(19)         not null
        references PERSON
            on delete cascade,
    SUBSCRIPTION_TYPE  VARCHAR2(32 char)  not null,
    SUBSCRIPTION_STATE VARCHAR2(32 char)  not null,
    CREATED_AT         TIMESTAMP(6)       not null,
    MODIFIED_AT        TIMESTAMP(6)       not null,
    ITEM_ID            VARCHAR2(255 char) not null,
    constraint SUBSCRIPTIONS_PK
        primary key (ITEM_ID, SUBSCRIBER_ID)
)
/

create unique index SUBS_SID_IID_STATE_IDX
    on SUBSCRIPTIONS (SUBSCRIBER_ID, ITEM_ID, SUBSCRIPTION_STATE)
/

create trigger SUBSCRIPTIONS_BD
    before delete
    on SUBSCRIPTIONS
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_SUBSCRIPTIONS("SUBSCRIBER_ID", "SUBSCRIPTION_TYPE", "SUBSCRIPTION_STATE", "CREATED_AT",
                                 "MODIFIED_AT", "ITEM_ID", DELETE_ACTION_ID)
    values (:OLD."SUBSCRIBER_ID", :OLD."SUBSCRIPTION_TYPE", :OLD."SUBSCRIPTION_STATE", :OLD."CREATED_AT",
            :OLD."MODIFIED_AT", :OLD."ITEM_ID", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table NOTIFICATION_ATTRIBUTE
(
    NOTIFICATION_ID NUMBER(19)        not null
        constraint NOTIFICATION_ID_FK
            references NOTIFICATION
                on delete cascade,
    ATTRIBUTE_KEY   VARCHAR2(24 char) not null,
    ATTRIBUTE_VALUE CLOB              not null
)
/

create table EXPORT_ITEM_EVENT_QUEUE
(
    ID         NUMBER(19)                        not null
        constraint EXPORT_ITEM_EVENT_QUEUE_PK
            primary key,
    TYPE       VARCHAR2(32 char)                 not null,
    STATE      VARCHAR2(32 char)                 not null,
    CREATED_AT TIMESTAMP(6) default systimestamp not null,
    ITEM_ID    VARCHAR2(255 char)                not null
)
/

create trigger EXPORT_ITEM_EVENT_QUEUE_BRI
    before insert
    on EXPORT_ITEM_EVENT_QUEUE
    for each row
    when (new.id IS NULL)
BEGIN
    SELECT export_item_event_queue_seq.nextval
    INTO :new.id
    FROM dual;
END export_item_event_queue_bri;
/

create table JUCO_VERSION
(
    ID        NUMBER(19)         not null
        constraint JUCO_VERSION_PK
            primary key,
    VERSION   VARCHAR2(256 char) not null,
    CREATE_AT TIMESTAMP(6) default systimestamp,
    HOSTNAME  VARCHAR2(256 char)
)
/

create table JUCO_VERSION_UPDATE_PROCESS
(
    VERSION_ID        NUMBER(19)             not null
        constraint J_V_U_P_J_VERSION_FK
            references JUCO_VERSION
                on delete cascade,
    PROCESS           VARCHAR2(100 char)     not null,
    STATUS            VARCHAR2(50 char)      not null,
    CREATE_AT         TIMESTAMP(6) default systimestamp,
    MODIFY_AT         TIMESTAMP(6) default systimestamp,
    PROCESSOR_VERSION NUMBER       default 0 not null,
    constraint J_V_U_P_PKEY
        primary key (VERSION_ID, PROCESS)
)
/

create table PUSH_TARGET_APP
(
    ID        NUMBER(19)         not null,
    TOKEN     VARCHAR2(256 char) not null,
    PROTOCOL  VARCHAR2(100 char) not null,
    PERSON_ID NUMBER(19)         not null
        constraint PUSH_TARGET_APP_PERSON_FK
            references PERSON
                on delete cascade,
    CREATE_AT TIMESTAMP(6) default systimestamp,
    MODIFY_AT TIMESTAMP(6) default systimestamp,
    APP_NAME  VARCHAR2(100 char) not null
)
/

create unique index P_N_DEVICE_PK
    on PUSH_TARGET_APP (ID)
/

create unique index P_N_DEVICE_UQ
    on PUSH_TARGET_APP (TOKEN, PROTOCOL)
/

create index PUSH_TARGET_APP_PERSON_IDX
    on PUSH_TARGET_APP (PERSON_ID)
/

alter table PUSH_TARGET_APP
    add constraint PUSH_TARGET_APP_PK
        primary key (ID)
/

alter table PUSH_TARGET_APP
    add constraint PUSH_TARGET_APP_UQ
        unique (TOKEN, PROTOCOL)
/

create table WORKSTREAM_READ
(
    PERSON_ID NUMBER(19)    not null
        constraint WORKSTREAM_READ_PID_FK
            references PERSON,
    READ_DATE TIMESTAMP(6)  not null,
    ITEM_ID   VARCHAR2(255) not null,
    constraint WORKSTREAM_READ_PKEY
        primary key (PERSON_ID, ITEM_ID)
)
/

create index WORKSTREAM_READ_PERSON_IDX
    on WORKSTREAM_READ (PERSON_ID)
/

create table CUSTOMER_CATEGORY
(
    CUSTOMERTYPE VARCHAR2(50 char) not null,
    CREATED_AT   TIMESTAMP(6)      not null,
    MODIFIED_AT  TIMESTAMP(6)      not null
)
/

create table OAUTH_TOKEN
(
    ACCESS_TOKEN         VARCHAR2(256 char)                not null
        constraint O_T_ACCESS_TOKEN_PK
            primary key,
    ACCESS_TOKEN_EXPIRY  TIMESTAMP(6)                      not null,
    REFRESH_TOKEN        VARCHAR2(256 char),
    REFRESH_TOKEN_EXPIRY TIMESTAMP(6),
    CLIENT_ID            VARCHAR2(256 char)                not null
        constraint O_T_CLIENT_FK
            references OAUTH_CLIENT_DETAILS
                on delete cascade,
    SCOPE                VARCHAR2(256 char)                not null,
    GRANT_TYPE           VARCHAR2(256 char)                not null,
    PERSON_ID            NUMBER(19)
        constraint O_T_PERSON_FK
            references PERSON
                on delete cascade,
    CREATE_DATE          TIMESTAMP(6) default systimestamp not null
)
/

create index IDX_OAUTH_TOKEN_REFRESH
    on OAUTH_TOKEN (REFRESH_TOKEN)
/

create index IDX_OAUTH_TOKEN_USER
    on OAUTH_TOKEN (PERSON_ID)
/

create index IDX_OAUTH_TOKEN_CLIENT
    on OAUTH_TOKEN (CLIENT_ID)
/

create table DEFAULT_LAYOUT_ENTITY
(
    PERSON_ID   NUMBER(19)                        not null
        constraint DEFAULT_LAYOUT_ENTITY_PK
            primary key,
    ENTITY_ID   NUMBER(19)                        not null
        constraint DEFAULT_LAYOUT_ENTITY_ID_FK
            references ENTITY
                on delete cascade,
    CREATE_DATE TIMESTAMP(6) default systimestamp not null
)
/

create table CHAT_SEARCH_QUEUE
(
    ID          NUMBER(19)                        not null
        constraint CHT_SRCH_Q_PK
            primary key,
    ITEM_ID     NUMBER(19)                        not null,
    ITEM_TYPE   VARCHAR2(32 char)                 not null,
    CREATED_AT  TIMESTAMP(6) default systimestamp not null,
    MODIFIED_AT TIMESTAMP(6) default systimestamp not null,
    IN_PROGRESS CHAR         default 'f'          not null,
    LOCK_ID     NUMBER(19)
)
/

create index CHT_SRCH_Q_ITM_IDX_IP_CA_IDX
    on CHAT_SEARCH_QUEUE (ITEM_ID, ITEM_TYPE, IN_PROGRESS, CREATED_AT)
/

create index CHT_SRCH_Q_ID_LC_IP_IDX
    on CHAT_SEARCH_QUEUE (ID, LOCK_ID, IN_PROGRESS)
/

create index CHT_SRCH_Q_MOD_IDX
    on CHAT_SEARCH_QUEUE (MODIFIED_AT)
/

create index CHT_SRCH_Q_CRT_IDX
    on CHAT_SEARCH_QUEUE (CREATED_AT)
/

create index CHT_SRCH_Q_IP_MOD_IDX
    on CHAT_SEARCH_QUEUE (IN_PROGRESS, MODIFIED_AT)
/

create table CONVERSATION_SEARCH_QUEUE
(
    ID                      NUMBER(19)                        not null
        constraint CNV_SRCH_Q_PK
            primary key,
    ITEM_ID                 NUMBER(19)                        not null,
    ITEM_TYPE               VARCHAR2(32 char)                 not null,
    CONVERSATION_INDEX_TYPE VARCHAR2(32 char)                 not null,
    CREATED_AT              TIMESTAMP(6) default systimestamp not null,
    MODIFIED_AT             TIMESTAMP(6) default systimestamp not null,
    IN_PROGRESS             CHAR         default 'f'          not null,
    LOCK_ID                 NUMBER(19)
)
/

create index CNV_SRCH_Q_ITM_IDX_IP_CA_IDX
    on CONVERSATION_SEARCH_QUEUE (ITEM_ID, ITEM_TYPE, IN_PROGRESS, CREATED_AT)
/

create index CNV_SRCH_Q_ID_LC_IP_IDX
    on CONVERSATION_SEARCH_QUEUE (ID, LOCK_ID, IN_PROGRESS)
/

create index CNV_SRCH_Q_MOD_IDX
    on CONVERSATION_SEARCH_QUEUE (MODIFIED_AT)
/

create index CNV_SRCH_Q_CRT_IDX
    on CONVERSATION_SEARCH_QUEUE (CREATED_AT)
/

create index CNV_SRCH_Q_IP_MOD_IDX
    on CONVERSATION_SEARCH_QUEUE (IN_PROGRESS, MODIFIED_AT)
/

create table VIEW_COUNT
(
    ITEM_ID VARCHAR2(255 char) not null,
    COUNTER NUMBER default 0   not null
)
/

create table DOCUMENT_ACCESS_TOKEN
(
    TOKEN        VARCHAR2(64 char) not null
        constraint DOC_ACC_T_PK
            primary key,
    TOKEN_EXPIRY TIMESTAMP(6)      not null,
    DOCUMENT_ID  VARCHAR2(64 char)
)
/

create table ENTITY_VERSION_DRIVE_CHANGE
(
    ENTITY_VERSION_ID NUMBER(19)        not null
        primary key
        constraint EVDC_ENTITY_VERSION_FK
            references ENTITY_VERSION,
    DRIVE_CHANGE_ID   VARCHAR2(64 char) not null
)
/

create table ICAL_ACCESS_TOKEN
(
    TOKEN     VARCHAR2(64 char)  not null
        constraint ICAL_ACC_T_TOKEN_UK
            unique,
    PERSON_ID NUMBER(19)         not null
        constraint ICAL_ACC_T_PK
            primary key
        constraint ICAL_ACC_T_PERSON_ID_FK
            references PERSON
                on delete cascade,
    ACTIVE    CHAR default ('f') not null
)
/

create table CONVERSATION_SETTINGS
(
    CONVERSATION_ID NUMBER(19)                        not null
        constraint CONV_SETTINGS_CONV_FK
            references CONVERSATION
                on delete cascade,
    PARTICIPANT_ID  NUMBER(19)                        not null
        constraint CONV_SETTINGS_PART_FK
            references PERSON
                on delete cascade,
    MUTED           CHAR(1 char) default ('f')        not null,
    CREATE_DATE     TIMESTAMP(6) default systimestamp not null,
    MODIFY_DATE     TIMESTAMP(6) default systimestamp not null,
    HIDDEN          CHAR(1 char) default 'f'          not null,
    constraint CONV_SETTINGS_PK
        primary key (CONVERSATION_ID, PARTICIPANT_ID)
)
/

create trigger CONVERSATION_SETTINGS_BD
    before delete
    on CONVERSATION_SETTINGS
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_CONVERSATION_SETTINGS("CONVERSATION_ID", "PARTICIPANT_ID", "MUTED", "CREATE_DATE", "MODIFY_DATE",
                                         "HIDDEN", DELETE_ACTION_ID)
    values (:OLD."CONVERSATION_ID", :OLD."PARTICIPANT_ID", :OLD."MUTED", :OLD."CREATE_DATE", :OLD."MODIFY_DATE",
            :OLD."HIDDEN", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table ENTITY_ANCHOR
(
    ENTITY_ID NUMBER(19)         not null,
    COMPONENT VARCHAR2(255 char) not null,
    ANCHOR    VARCHAR2(255 char) not null,
    constraint ENTITY_ANCHOR_PK
        primary key (ENTITY_ID, COMPONENT, ANCHOR)
)
/

create index ENTITY_ANCHOR_ID_ANCHOR_IDX
    on ENTITY_ANCHOR (ENTITY_ID, ANCHOR)
/

create table PROFILE_ATTRIBUTE
(
    ID          NUMBER(19)                        not null
        constraint PROFILE_ATTRIBUTE_PK
            primary key,
    PERSON_ID   NUMBER(19)                        not null
        constraint PROFILE_ATTRIBUTE_PID_FK
            references PERSON,
    NAME        VARCHAR2(255 char)                not null,
    VALUE       CLOB                              not null,
    VALUE_ORDER NUMBER(10)                        not null,
    BLOCK_ORDER NUMBER(10)                        not null,
    CREATE_DATE TIMESTAMP(6) default systimestamp not null
)
/

create index PROFILE_ATTRIBUTE_PERS_ID_IDX
    on PROFILE_ATTRIBUTE (PERSON_ID)
/

create trigger PROFILE_ATTRIBUTE_BD
    before delete
    on PROFILE_ATTRIBUTE
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_PROFILE_ATTRIBUTE("ID", "PERSON_ID", "NAME", "VALUE", "VALUE_ORDER", "BLOCK_ORDER", "CREATE_DATE",
                                     DELETE_ACTION_ID)
    values (:OLD."ID", :OLD."PERSON_ID", :OLD."NAME", :OLD."VALUE", :OLD."VALUE_ORDER", :OLD."BLOCK_ORDER",
            :OLD."CREATE_DATE", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table DRIVE_DOCUMENT_ITEM
(
    ID          VARCHAR2(255 char)                                    not null,
    NAME        VARCHAR2(255 char)                                    not null,
    PARENT      VARCHAR2(255 char)                                    not null,
    CREATE_DATE TIMESTAMP(6)       default systimestamp               not null,
    MIME_TYPE   VARCHAR2(255 char) default 'application/octet-stream' not null,
    FILE_SIZE   NUMBER(19)         default 0                          not null,
    CHANGE_DATE TIMESTAMP(6)       default sysdate                    not null,
    PUBLICITY   VARCHAR2(255 char)                                    not null,
    constraint DRIVE_DOCUMENT_ITEM_PK
        primary key (ID, PUBLICITY)
)
/

create table PROFILE_ATTRIBUTE_CONFIG
(
    CONFIG      CLOB                              not null,
    CREATE_DATE TIMESTAMP(6) default systimestamp not null
)
/

create table USER_SETTING
(
    PERSON_ID   NUMBER(10)          not null
        constraint USER_SETTING__PERSON_FK
            references PERSON
                on delete cascade,
    KEY         VARCHAR2(30 char)   not null,
    VALUE       VARCHAR2(4000 char) not null,
    CREATE_DATE TIMESTAMP(6) default systimestamp,
    MODIFY_DATE TIMESTAMP(6) default systimestamp,
    constraint USER_SETTING_PK
        primary key (PERSON_ID, KEY)
)
/

create trigger USER_SETTING_BD
    before delete
    on USER_SETTING
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_USER_SETTING("PERSON_ID", "KEY", "VALUE", "CREATE_DATE", "MODIFY_DATE", DELETE_ACTION_ID)
    values (:OLD."PERSON_ID", :OLD."KEY", :OLD."VALUE", :OLD."CREATE_DATE", :OLD."MODIFY_DATE", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table ENTITY_VERSION_ARCHIVE_NOTICE
(
    ID          NUMBER(19)                        not null
        constraint E_V_ARCHIVE_NOTICE_PK
            primary key,
    CREATE_DATE TIMESTAMP(6) default systimestamp not null
)
/

create table MIGRATED_ITEM
(
    ORIGIN_ID      VARCHAR2(255 char)                not null
        primary key,
    DESTINATION_ID VARCHAR2(255 char)                not null,
    CDATE          TIMESTAMP(6) default systimestamp not null
)
/

create table TASK_LIST
(
    ID          RAW(16)                           not null
        primary key,
    NAME        VARCHAR2(255 char)                not null,
    CREATE_DATE TIMESTAMP(6) default systimestamp not null,
    MODIFY_DATE TIMESTAMP(6) default systimestamp not null
)
/

create table TASKS
(
    ID              RAW(16)                                not null
        constraint TASKS_PK
            primary key,
    NAME            VARCHAR2(2048 char)                    not null,
    DESCRIPTION     CLOB                                   not null,
    OWNER_ID        NUMBER(19)                             not null,
    ASSIGNEE_ID     NUMBER(19),
    STATUS          VARCHAR2(255 char)                     not null,
    CREATE_DATE     TIMESTAMP(6)                           not null,
    MODIFY_DATE     TIMESTAMP(6)                           not null,
    PARENT_TASK_ID  RAW(16)
        references TASKS,
    ATTACHMENT_NAME VARCHAR2(255 char) default ('$EMPTY$') not null,
    ATTACHMENT_URL  VARCHAR2(255 char) default ('$EMPTY$') not null,
    TASK_LIST_ID    RAW(16)
        constraint TASK_LIST_ID_FKEY
            references TASK_LIST
                on delete cascade,
    DUE_DATE        TIMESTAMP(6),
    constraint TASKS_UNIQUE_PARENT
        check (task_list_id IS NULL OR parent_task_id IS NULL)
)
/

create index TASKS_ASSIGNEE_IDX
    on TASKS (ASSIGNEE_ID, STATUS)
/

create index TASKS_OWNER_IDX
    on TASKS (OWNER_ID, STATUS)
/

create index TASKS_PARENT_TASK_ASSIGNEE_IDX
    on TASKS (PARENT_TASK_ID, ASSIGNEE_ID)
/

create index TASKS_PARENT_TASK_OWNER_IDX
    on TASKS (PARENT_TASK_ID, OWNER_ID)
/

create index TASKS_TASK_LIST_ID_STATUS_IDX
    on TASKS (TASK_LIST_ID, STATUS)
/

create trigger TASKS_BD
    before delete
    on TASKS
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_TASKS("ID", "NAME", "DESCRIPTION", "OWNER_ID", "ASSIGNEE_ID", "STATUS", "CREATE_DATE", "MODIFY_DATE",
                         "PARENT_TASK_ID", "ATTACHMENT_NAME", "ATTACHMENT_URL", "TASK_LIST_ID", "DUE_DATE",
                         DELETE_ACTION_ID)
    values (:OLD."ID", :OLD."NAME", :OLD."DESCRIPTION", :OLD."OWNER_ID", :OLD."ASSIGNEE_ID", :OLD."STATUS",
            :OLD."CREATE_DATE", :OLD."MODIFY_DATE", :OLD."PARENT_TASK_ID", :OLD."ATTACHMENT_NAME",
            :OLD."ATTACHMENT_URL", :OLD."TASK_LIST_ID", :OLD."DUE_DATE", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table TASK_FILTER_ORDER
(
    FILTER_ID VARCHAR2(255 char) not null,
    TASK_ID   RAW(16)            not null
        constraint TASK_FILTER_ORDER_TASK_ID_FK
            references TASKS
                on delete cascade,
    POSITION  NUMBER(19)         not null,
    constraint TASK_FILTER_ORDER_PK
        primary key (FILTER_ID, TASK_ID),
    constraint TASK_FILTER_ORDER_POS_UK
        unique (FILTER_ID, POSITION)
            deferrable initially immediate
)
/

create index TASK_FILTER_ORDER_TASK_IDX
    on TASK_FILTER_ORDER (TASK_ID, FILTER_ID, POSITION)
/

create trigger TASK_LIST_BD
    before delete
    on TASK_LIST
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_TASK_LIST("ID", "NAME", "CREATE_DATE", "MODIFY_DATE", DELETE_ACTION_ID)
    values (:OLD."ID", :OLD."NAME", :OLD."CREATE_DATE", :OLD."MODIFY_DATE", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table TASK_LIST_PERMISSIONS
(
    TASK_LIST_ID RAW(16)                           not null
        references TASK_LIST
            on delete cascade,
    ROLE         VARCHAR2(64 char)                 not null,
    TASK_RIGHT   VARCHAR2(64 char)                 not null,
    CTIME        TIMESTAMP(6) default systimestamp not null,
    MTIME        TIMESTAMP(6) default systimestamp not null,
    constraint TASK_LIST_PERM_PK
        primary key (TASK_LIST_ID, ROLE)
)
/

create trigger TASK_LIST_PERMISSIONS_BD
    before delete
    on TASK_LIST_PERMISSIONS
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_TASK_LIST_PERMISSIONS("TASK_LIST_ID", "ROLE", "TASK_RIGHT", "CTIME", "MTIME", DELETE_ACTION_ID)
    values (:OLD."TASK_LIST_ID", :OLD."ROLE", :OLD."TASK_RIGHT", :OLD."CTIME", :OLD."MTIME", del_ac_id);
exception
    when no_data_found then
        null;
end;
/

create table SEARCH_FILTER
(
    ID          NUMBER(19)          not null
        constraint SEARCH_FILTER_PK
            primary key,
    PERSON_ID   NUMBER(19)          not null
        constraint SEARCH_FILTER_PERSON_ID_FK
            references PERSON,
    NAME        VARCHAR2(255 char)  not null,
    FILTER      VARCHAR2(2000 char) not null,
    CREATE_DATE TIMESTAMP(6)        not null
)
/

create table HOME_SCREEN_APPS
(
    PERSON_ID   NUMBER(19)                        not null
        constraint USER_APP_SETTING_PERSON_ID_FK
            references PERSON,
    APP_ID      VARCHAR2(255 char)                not null,
    APP_ORDER   NUMBER(10)                        not null,
    CREATE_DATE TIMESTAMP(6) default systimestamp not null,
    PAGE_NUMBER NUMBER(10)   default (0)          not null,
    constraint USER_APP_SETTING_PK
        primary key (PERSON_ID, APP_ID)
)
/

create table WORKSTREAM_PINNED_HIDE_DATE
(
    PERSON_ID      NUMBER(19)         not null
        constraint WS_PHD_PERSON_ID_FK
            references PERSON,
    ORIGIN_ITEM_ID VARCHAR2(255 char) not null,
    HIDE_DATE      TIMESTAMP(6)       not null,
    constraint WS_PHD_PK
        primary key (PERSON_ID, ORIGIN_ITEM_ID)
)
/

create table CONVERSATION_CHANGE
(
    ID              NUMBER(19)                        not null
        primary key,
    CONVERSATION_ID NUMBER(19)                        not null,
    PARTICIPANT_ID  NUMBER(19)                        not null
        constraint CCHNG_PARTICIPANT_ID_FK
            references PERSON
                on delete cascade,
    CHANGE_TYPE     VARCHAR2(255 char)                not null,
    CREATE_DATE     TIMESTAMP(6) default systimestamp not null,
    constraint CCHNG_UQ
        unique (CONVERSATION_ID, PARTICIPANT_ID, CHANGE_TYPE)
)
/

create index CCHNG_CREATE_DATE_IDX
    on CONVERSATION_CHANGE (CREATE_DATE)
/

create index CCHNG_PRTCPNT_CREATE_DATE_IDX
    on CONVERSATION_CHANGE (PARTICIPANT_ID, CREATE_DATE)
/

create table TENANT
(
    ID             RAW(16)                           not null
        primary key,
    DEFAULT_TENANT CHAR(1 char) default ('f')        not null,
    CTIME          TIMESTAMP(6) default systimestamp not null,
    MTIME          TIMESTAMP(6) default systimestamp not null,
    NAME           VARCHAR2(1024 char),
    LOGO_ID        VARCHAR2(1024 char)
)
/

create table ENTITY_TENANT
(
    ENTITY_ID NUMBER(19)                        not null
        constraint ENTITY_TENANT_PK
            primary key,
    TENANT_ID RAW(16)                           not null,
    CTIME     TIMESTAMP(6) default systimestamp not null,
    MTIME     TIMESTAMP(6) default systimestamp not null
)
/


create table PERSON_TENANT
(
    PERSON_ID NUMBER(19)                        not null
        constraint PERSON_TENANT_FK_P
            references PERSON,
    TENANT_ID RAW(16)                           not null
        constraint PERSON_TENANT_FK_T
            references TENANT,
    CTIME     TIMESTAMP(6) default systimestamp not null,
    MTIME     TIMESTAMP(6) default systimestamp not null,
    constraint PERSON_TENANT_PK
        primary key (PERSON_ID, TENANT_ID)
)
/

create table APP
(
    ID            VARCHAR2(32 char)                 not null
        primary key,
    NAME          VARCHAR2(100 char)                not null,
    IS_CORE_APP   CHAR(1 char)                      not null,
    DEFAULT_ORDER NUMBER(10)                        not null,
    CTIME         TIMESTAMP(6) default systimestamp not null,
    MTIME         TIMESTAMP(6) default systimestamp not null
)
/

create table ADDITIONAL_APP_INFO
(
    APP_ID        VARCHAR2(32 char)                 not null
        primary key
        constraint ADDITIONAL_APP_INFO_APP_ID_FK
            references APP
                on delete cascade,
    URL           VARCHAR2(4000 char)               not null,
    ICON_URL      VARCHAR2(4000 char),
    COLOR         VARCHAR2(16 char)                 not null,
    IS_IFRAME_APP CHAR(1 char)                      not null,
    CTIME         TIMESTAMP(6) default systimestamp not null,
    MTIME         TIMESTAMP(6) default systimestamp not null
)
/

create table TENANT_APP_VISIBILITY
(
    APP_ID           VARCHAR2(32 char)                 not null
        constraint TENANT_APP_VISIBILITY_FK
            references APP
                on delete cascade,
    TENANT_ID        RAW(16)                           not null,
    VISIBLE_FOR_ROLE VARCHAR2(100 char)                not null,
    VISIBILITY       VARCHAR2(64 char)                 not null,
    CTIME            TIMESTAMP(6) default systimestamp not null,
    MTIME            TIMESTAMP(6) default systimestamp not null,
    constraint TENANT_APP_VISIBILITY_PK
        primary key (APP_ID, TENANT_ID, VISIBLE_FOR_ROLE)
)
/

create table DEFAULT_APP_VISIBILITY
(
    APP_ID           VARCHAR2(32 char)                 not null
        constraint DEFAULT_APP_VISIBILITY_FK
            references APP
                on delete cascade,
    VISIBLE_FOR_ROLE VARCHAR2(100 char)                not null,
    VISIBILITY       VARCHAR2(64 char)                 not null,
    CTIME            TIMESTAMP(6) default systimestamp not null,
    MTIME            TIMESTAMP(6) default systimestamp not null,
    constraint DEFAULT_APP_VISIBILITY_PK
        primary key (APP_ID, VISIBLE_FOR_ROLE)
)
/

create table ENTITY_TYPE_APP_MAPPING
(
    ENTITY_TYPE VARCHAR2(32 char)                 not null
        constraint ENTITY_TYPE_APP_MAP_PK
            primary key
        constraint ENTITY_TYPE_APP_MAP_ETYPE_FK
            references ENTITY_TYPE_NAME
                on delete cascade,
    APP_ID      VARCHAR2(100 char)                not null
        constraint ENTITY_TYPE_APP_MAP_APP_ID_FK
            references APP
                on delete cascade,
    CTIME       TIMESTAMP(6) default systimestamp not null,
    MTIME       TIMESTAMP(6) default systimestamp not null
)
/

create table NOTIFICATION_MIGRATION_STATUS
(
    RUNNING                       CHAR(1 char)                      not null,
    MIGRATION_START_AT            TIMESTAMP(6) default systimestamp not null,
    LAST_MIGRATED_NOTIFICATION_ID NUMBER(19)
)
/

create table SCHEDULED_WORKSTREAM_ENTRY
(
    WORKSTREAM_ENTRY_ID NUMBER(19)                        not null
        constraint WORKSTREAM_ENTRY_FK
            references WORKSTREAM_ENTRY
                on delete cascade,
    PUBLISH_DATE        TIMESTAMP(6)                      not null,
    CTIME               TIMESTAMP(6) default SYSDATE      not null,
    MTIME               TIMESTAMP(6) default SYSTIMESTAMP not null
)
/

create trigger SCHEDULED_WORKSTREAM_ENTRY_T
    before update
    on SCHEDULED_WORKSTREAM_ENTRY
    for each row
BEGIN
    :new.mtime := SYSTIMESTAMP;
END;
/

create table NEWSZOOM_CONFIG
(
    TENANT_ID           RAW(16)                                 not null
        primary key,
    CYCLE_AUTOMATICALLY CHAR(1 char)       default ('t')        not null,
    OPEN_ON             VARCHAR2(255 char) default ('LOGIN')    not null,
    CTIME               TIMESTAMP(6)       default systimestamp not null,
    MTIME               TIMESTAMP(6)       default systimestamp not null
)
/

create table NEWSZOOM_SECTION
(
    ID               RAW(16)                           not null
        primary key,
    TENANT_ID        RAW(16)                           not null
        constraint TENANT_ID_FK
            references TENANT
                on delete cascade,
    NAME             VARCHAR2(100)                     not null,
    ORDER_INDEX      NUMBER                            not null,
    SHOW_ONLY_PINNED CHAR(1 char) default ('t')        not null,
    CTIME            TIMESTAMP(6) default systimestamp not null,
    MTIME            TIMESTAMP(6) default systimestamp not null
)
/

create table NEWSZOOM_SECTION_CHANNEL
(
    SECTION_ID RAW(16)                           not null
        constraint SECTION_ID_FK
            references NEWSZOOM_SECTION
                on delete cascade,
    CHANNEL_ID VARCHAR2(255)                     not null,
    CTIME      TIMESTAMP(6) default systimestamp not null,
    MTIME      TIMESTAMP(6) default systimestamp not null,
    constraint NEWSZOOM_SECTION_CHANNEL_PK
        primary key (SECTION_ID, CHANNEL_ID)
)
/

create table DB_PATCH_VERSION
(
    VERSION VARCHAR2(255 char)                not null
        primary key,
    CTIME   TIMESTAMP(6) default systimestamp not null
)
/

create table OAUTH_CODE
(
    CODE           VARCHAR2(256 char),
    AUTHENTICATION BLOB
)
/

create table ACCOUNT_LOCK
(
    PERSON_ID    NUMBER(19)                        not null
        primary key
        references PERSON
            on delete cascade,
    LOCKED_UNTIL TIMESTAMP(6)                      not null,
    CTIME        TIMESTAMP(6) default SYSDATE      not null,
    MTIME        TIMESTAMP(6) default SYSTIMESTAMP not null
)
/

create trigger ACCOUNT_LOCK_T
    before update
    on ACCOUNT_LOCK
    for each row
BEGIN
    :new.mtime := SYSTIMESTAMP;
END;
/

create table ACCOUNT_FAILED_LOGINS
(
    PERSON_ID     NUMBER(19)                        not null
        primary key
        references PERSON
            on delete cascade,
    COUNTED_SINCE TIMESTAMP(6)                      not null,
    FAILED_COUNT  NUMBER                            not null,
    CTIME         TIMESTAMP(6) default SYSDATE      not null,
    MTIME         TIMESTAMP(6) default SYSTIMESTAMP not null
)
/

create trigger ACCOUNT_FAILED_LOGINS_T
    before update
    on ACCOUNT_FAILED_LOGINS
    for each row
BEGIN
    :new.mtime := SYSTIMESTAMP;
END;
/

create table PERSON_PENDING_PASSWORD_RESET
(
    PERSON_ID   NUMBER(19)                        not null
        primary key
        references PERSON
            on delete cascade,
    EXPIRY_TIME TIMESTAMP(6)                      not null,
    CTIME       TIMESTAMP(6) default SYSDATE      not null,
    MTIME       TIMESTAMP(6) default SYSTIMESTAMP not null
)
/

create trigger PERSON_PENDING_PASSWORD_RESET_T
    before update
    on PERSON_PENDING_PASSWORD_RESET
    for each row
BEGIN
    :new.mtime := SYSTIMESTAMP;
END;
/

create table CONVERSATION_ATTACHMENT
(
    ID                  NUMBER(19)                        not null
        constraint CONV_ATTACHMENT_PK
            primary key,
    MESSAGE_ID          NUMBER(19)                        not null
        constraint CONV_ATTACHMENT_MSG_FK
            references CONVERSATION_MESSAGE
                on delete cascade,
    DOCUMENT_ID         VARCHAR2(255 char)                not null,
    DOCUMENT_VERSION_ID VARCHAR2(255 char)                not null,
    FILENAME            VARCHAR2(255 char)                not null,
    FILE_SIZE           NUMBER(19)   default 0            not null,
    CONTENT_TYPE        VARCHAR2(255 char)                not null,
    VERSION             VARCHAR2(255 char)                not null,
    ATTACHMENT_TYPE     VARCHAR2(255 char)                not null,
    IMAGE_HEIGHT        NUMBER(10),
    IMAGE_WIDTH         NUMBER(10),
    CREATE_DATE         TIMESTAMP(6) default systimestamp not null
)
/

create index CONV_ATTACHMENT_MSG_FK_IDX
    on CONVERSATION_ATTACHMENT (MESSAGE_ID)
/

create index CONV_ATTACHMENT_DOC_ID_IDX
    on CONVERSATION_ATTACHMENT (DOCUMENT_ID)
/

create trigger CONVERSATION_ATTACHMENT_BD
    before delete
    on CONVERSATION_ATTACHMENT
    for each row
declare
    del_ac_id number;
begin
    select id
    into del_ac_id
    from delete_action
    where transaction_id = dbms_transaction.local_transaction_id
      and transaction_id is not null
      and archive_data = 't';
    insert into SH_CONVERSATION_ATTACHMENT("ID", "MESSAGE_ID", "DOCUMENT_ID", "DOCUMENT_VERSION_ID", "FILENAME",
                                           "FILE_SIZE", "CONTENT_TYPE", "VERSION", "ATTACHMENT_TYPE", "IMAGE_HEIGHT",
                                           "IMAGE_WIDTH", "CREATE_DATE", DELETE_ACTION_ID)
    values (:OLD."ID", :OLD."MESSAGE_ID", :OLD."DOCUMENT_ID", :OLD."DOCUMENT_VERSION_ID", :OLD."FILENAME",
            :OLD."FILE_SIZE", :OLD."CONTENT_TYPE", :OLD."VERSION", :OLD."ATTACHMENT_TYPE", :OLD."IMAGE_HEIGHT",
            :OLD."IMAGE_WIDTH", :OLD."CREATE_DATE", del_ac_id);
exception
    when no_data_found then
        null;
end;
/


create table TENANT_THEME
(
    TENANT_ID       RAW(16)            not null
        references TENANT
            on delete cascade,
    THEME_ATTRIBUTE VARCHAR2(255 char) not null,
    THEME_VALUE     VARCHAR2(7 char)   not null,
    primary key (TENANT_ID, THEME_ATTRIBUTE)
)
/

create FUNCTION now
    RETURN DATE
AS
BEGIN
    return sysdate;
END now;
/

create FUNCTION clock_timestamp
    RETURN TIMESTAMP WITH TIME ZONE
AS
BEGIN
    return systimestamp;
END clock_timestamp;
/

create PROCEDURE ctime_mtime_columns(tname VARCHAR2)
    IS
BEGIN
    EXECUTE IMMEDIATE 'ALTER TABLE ' || tname ||
                      ' ADD (ctime TIMESTAMP DEFAULT SYSDATE NOT NULL,mtime TIMESTAMP DEFAULT SYSTIMESTAMP NOT NULL )';
    EXECUTE IMMEDIATE 'CREATE TRIGGER ' || tname || '_t BEFORE UPDATE ON ' || tname ||
                      ' FOR EACH ROW BEGIN :new.mtime := SYSTIMESTAMP; END;';
END ctime_mtime_columns;
/

create function
    simple_join(s1 varchar2, sep varchar2, s2 varchar2)
    return varchar2 is
begin
    if (length(s1) > 0 and length(s2) > 0) then
        return s1 || sep || s2;
    else
        return s1 || s2;
    end if;
end simple_join;
/

create function
    compare_tables(table1 varchar2, table2 varchar2, filter_col varchar2)
    return varchar2 is
    obsolete_columns varchar2(4000 char) := '';
begin
    for obs_col in (
        select table1 || '.' || column_name as obs_col_name
        from user_tab_columns
        where table_name = table1
        minus
        select table1 || '.' || column_name as obs_col_name
        from user_tab_columns
        where table_name = table2
        )
        loop
            if (length(filter_col) = 0 or obs_col.obs_col_name <> table1 || '.' || filter_col) then
                obsolete_columns := simple_join(obsolete_columns, ', ', obs_col.obs_col_name);
            end if;
        end loop;

    return obsolete_columns;
end compare_tables;
/

create procedure
    check_for_obsolete_columns
    is
    obsolete_columns varchar2(4000 char) := '';
begin
    for sh_rec in
        (select table_name, shadow_table_name from shadow_table)
        loop
            obsolete_columns := simple_join(obsolete_columns, ', ',
                                            compare_tables(sh_rec.table_name, sh_rec.shadow_table_name, ''));
            obsolete_columns := simple_join(obsolete_columns, ', ',
                                            compare_tables(sh_rec.shadow_table_name, sh_rec.table_name,
                                                           'DELETE_ACTION_ID'));
        end loop;

    if length(obsolete_columns) > 0 then
        raise_application_error(-20001, 'Unexpected columns found: ' || obsolete_columns);
    end if;
end check_for_obsolete_columns;
/

create procedure
    update_shadow_triggers
    is
    tr_name     varchar2(30 char);
    stmt        varchar2(4000 char);
    insert_cols varchar2(4000 char);
    insert_vals varchar2(4000 char);
begin
    for sh_rec in
        (select table_name, shadow_table_name, delete_action_mandatory from shadow_table)
        loop
            tr_name := substr(sh_rec.shadow_table_name, 4) || '_BD';
            stmt := 'create or replace trigger ' || tr_name || ' before delete on "' || sh_rec.table_name ||
                    '" for each row' || chr(10);
            stmt := stmt || 'declare del_ac_id number;' || chr(10);
            stmt := stmt || 'begin' || chr(10);
            stmt := stmt ||
                    '  select id into del_ac_id from delete_action where transaction_id = dbms_transaction.local_transaction_id and transaction_id is not null and archive_data = ''t'';' ||
                    chr(10);
            stmt := stmt || '  insert into ' || sh_rec.shadow_table_name || '(';

            insert_cols := '';
            insert_vals := '';
            for col_rec in
                (select column_name from user_tab_columns where table_name = sh_rec.table_name order by column_id)
                loop
                    insert_cols := insert_cols || '"' || col_rec.column_name || '", ';
                    insert_vals := insert_vals || ':OLD."' || col_rec.column_name || '", ';
                end loop;

            stmt := stmt || insert_cols || 'DELETE_ACTION_ID)' || chr(10);
            stmt := stmt || '  values (' || insert_vals || 'del_ac_id);' || chr(10);
            stmt := stmt || 'exception when no_data_found then' || chr(10);
            if sh_rec.delete_action_mandatory = 't' then
                stmt := stmt ||
                        '  raise_application_error(-20001, ''No delete action for current transaction found while trying to delete from ' ||
                        sh_rec.table_name || ''');' || chr(10);
            else
                stmt := stmt || '  null;' || chr(10);
            end if;
            stmt := stmt || 'end;';

            execute immediate stmt;
        end loop;
end update_shadow_triggers;
/

