-- dropAll des not work for Oracle thus we have to drop everything manually

-- truncate databasechangelog
BEGIN
    FOR c IN ( SELECT table_name FROM user_tables WHERE table_name = 'DATABASECHANGELOG' )
    LOOP
        EXECUTE IMMEDIATE 'TRUNCATE TABLE ' || c.table_name;
    END LOOP;
END;
/

-- drop all tables except DATABASECHANGELOG*
BEGIN
    FOR c IN ( SELECT table_name FROM user_tables WHERE table_name NOT LIKE 'DATABASECHANGELOG%' )
    LOOP
        EXECUTE IMMEDIATE 'DROP TABLE ' || c.table_name || ' CASCADE CONSTRAINTS';
    END LOOP;
END;
/

-- drop all procedures, functions and sequences
BEGIN
    FOR cur_rec IN (SELECT object_name, object_type FROM user_objects WHERE object_type IN ('PROCEDURE', 'FUNCTION','SEQUENCE'))
    LOOP
        EXECUTE IMMEDIATE 'DROP ' || cur_rec.object_type || ' "' || cur_rec.object_name || '"';
    END LOOP;
END;
/