<#include "genericmacros.ftl" />
<#include "plaintext.ftl" />
<#assign line_length=67 >
<#assign newline="
" />
<#assign nonbreakingspace=" " />
<#macro br>${newline}</#macro>
<#macro nbsp>${nonbreakingspace}</#macro>
<#macro hr>${""?right_pad(line_length, "-")}<@br /></#macro>
<#macro hrbold>${""?right_pad(line_length, "=")}<@br /></#macro>
<#function string_to_lines s><#return (""+s)?split("\n") /></#function>
<#function line_to_words s>
    <#return s?split("[ \t\r\n]",'r') />
</#function>

<#function safe_seq_get seq pos def = seq[seq?size-1]>
    <#if ( pos < seq?size ) >
        <#return seq[pos] />
    <#else>
        <#return def />
    </#if>
</#function>

<#function string_to_limited_lines s max_line_length>
    <#local result="" />
    <#list string_to_lines(s) as line>
        <#local result_line="" />
        <#local words = 0 />
        <#list line_to_words(line) as word>
            <#if ( word?length > 0 )>
                <#local words = words + 1>
                <#if ( result_line?length == 0 )>
                    <#-- we are at start of line, just insert word -->
                    <#local result_line = word />
                <#elseif ( result_line?length + word?length >= max_line_length )>
                    <#-- line will be too long, break line and start new line with word -->
                    <#local result = result + result_line + newline />
                    <#local result_line = word />
                <#else>
                    <#-- append word with space -->
                    <#local result_line = result_line + " " + word />
                </#if>
            </#if>
        </#list>
        <#if ( result_line?length > 0 || words == 0 )>
            <#-- last line not yet append, append it -->
            <#local result = result + result_line />
            <#if ( line_has_next )>
                <#local result = result + newline />
            </#if>
        </#if>
    </#list>
    <#return result />
</#function>

<#function table_row contents col_widths delimiter = " | " >
    <#local cols=[] />
    <#local row_count = 0 />

    <#list contents as content>
        <#local limited_string = string_to_limited_lines(content, safe_seq_get(col_widths,content_index)) />
        <#local cell_lines = string_to_lines( limited_string ) />
        <#-- trace the row_count -->
        <#if ( cell_lines?size > row_count ) >
            <#local row_count = cell_lines?size>
        </#if>
        <#local cols = cols + [ cell_lines ] />
    </#list>

    <#-- early exit and safety -->
    <#if (row_count <= 0) >
        <#return "" />
    </#if>

    <#local result="" />
    <#list 0..row_count - 1 as i>
        <#list cols as col>
            <#local result = result + safe_seq_get(col, i, "")?right_pad(safe_seq_get(col_widths,col_index)) />
            <#-- if not last column, insert delimiter -->
            <#if col_has_next >
                <#local result = result + delimiter />
            </#if>
        </#list>
        <#-- if not last row, insert a newline -->
        <#if i_has_next>
            <#local result = result + newline />
        </#if>
    </#list>
    <#return result />
</#function>

<#macro tr content cols delimiter = " | ">${table_row(content, cols, delimiter)}<@br /></#macro>

<#macro h1>-= <#nested /> =-<@br /></#macro>

<#macro indent depth=3><#local content><#nested /></#local>${table_row(["",content], [depth,line_length-depth], "")}<@br /></#macro>
<#macro ab><#local content><#nested /></#local>${table_row(["",content], [0,line_length], "")}<@br /></#macro>
