<#macro container subject=subject >
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>

    <#-- Define Charset -->
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />

    <#-- Responsive Meta Tag -->
    <meta name="viewport" content="width=device-width; initial-scale=1.0; maximum-scale=1.0;" />

    <meta name="color-scheme" content="light" />
    <meta name="supported-color-schemes" content="light" />

    <#-- link href='http://fonts.googleapis.com/css?family=Source+Sans+Pro:400,300,700' rel='stylesheet' type='text/css'>
    <link href='http://fonts.googleapis.com/css?family=Ubuntu:400,300italic,300,700' rel='stylesheet' type='text/css' -->

    <title><@escape value=subject /></title><#-- Responsive Styles and Valid Styles -->

    <style type="text/css">

        body{
            background-color: #ffffff;
            margin:0;
            padding:0;
            -webkit-font-smoothing: antialiased;
            mso-margin-top-alt:0px; mso-margin-bottom-alt:0px; mso-padding-alt: 0px 0px 0px 0px;
        }

        @media (prefers-color-scheme: dark) {
          body {
            background-color: #ffffff;
          }
        }

        ul{margin: 0; padding: 0;}
        a {
            color: ${theme.linkColor} !important;
            text-decoration: none !important;
        }
        .lightlinktextcolor,
        .lightlinktextcolor a,
        a.lightlinktextcolor {
            color: ${theme.lightLinkTextColor} !important;
        }
        .button,
        .button a,
        .button a.button-link,
        a.button,
        a.button-link {
            color: ${theme.buttonTextColor} !important;
        }
        table{
            border: 0;
        }

        <#-- responsivity -->
        @media only screen and (max-width: 640px){
            body[yahoo] .body-table {min-width:460px !important;}
            <#-- top header -->
            body[yahoo] .main-header{line-height: 28px !important;}
            body[yahoo] .main-subheader{line-height: 28px !important;}

            <#-- logo -->
            body[yahoo] .logo{min-width:128px!important;width: 128px !important;}

            <#-- main image -->
            body[yahoo] .main-image img{min-width:440px!important;width: 440px !important; height: auto !important;}
            body[yahoo] .hide-for-iphone{display: none !important;}
            body[yahoo] .sideba-table{height: auto !important;}

            <#-- blog -->
            body[yahoo] .blogSection{min-width:330px!important;width: 330px !important;}

            <#-- divider -->
            body[yahoo] .divider img{min-width:420px!important;width: 420px !important; height: 1px !important;}

            <#-- banner -->
            body[yahoo] .banner{max-width:440px!important;width:auto!important;height:auto!important;}
            <#-- container -->
            body[yahoo] .container590{min-width:440px!important;width: 440px !important;}
            body[yahoo] .container580{min-width:420px!important;width: 420px !important;}
            body[yahoo] .container440{min-width:230px!important;width: 230px !important;}
            body[yahoo] .container300{min-width:215px!important;width: 215px !important;}
            body[yahoo] .container-microblog-right{min-width:346px!important;width:346px!important;}
            body[yahoo] .container-chat-right{min-width:346px!important;width:346px!important;}
            body[yahoo] .container-attachment-right{min-width:300px!important;width:300px!important;}

            <#-- secions -->
            body[yahoo] .section-item{min-width:420px!important;width: 420px !important;}
            body[yahoo] .section-img img{min-width:440px!important;width: 440px !important; height: auto !important;}

            body[yahoo] .cta-header{line-height: 26px !important;}

            <#-- socials -->
            body[yahoo] .social-container{min-width:215px!important;width: 215px !important;}

        }

        @media only screen and (max-width: 479px){
            body[yahoo] .body-table {min-width:300px !important;}
            <#-- top header-->
            body[yahoo] .main-header{line-height: 28px !important;}
            body[yahoo] .main-subheader{line-height: 28px !important;}

            <#-- logo -->
            body[yahoo] .logo{min-width:280px!important;width: 280px !important;}
            body[yahoo] .date{min-width:280px!important;width: 280px !important;}
            body[yahoo] .date-inside{min-width:150px!important;width: 150px !important;}
            body[yahoo] .hideforiphone{display: none !important;}

            <#-- main image -->
            body[yahoo] .main-image img{min-width:280px!important;width: 280px !important; height: auto !important;}
            body[yahoo] .hide-for-iphone{display: none !important;}
            body[yahoo] .sideba-table{height: auto !important;}

            <#-- blog -->
            body[yahoo] .blogSection{min-width:220px!important;width: 220px !important;}
            body[yahoo] .containerDate{min-width:30px!important;width: 40px !important;}
            body[yahoo] .blog-title{font-size: 15px !important;}

            <#-- divider -->
            body[yahoo] .divider img{min-width:260px!important;width: 260px !important; height: 1px !important;}

            <#-- banner -->
            body[yahoo] .banner{max-width:280px!important;width:auto!important;height:auto!important;}

            <#-- container -->
            body[yahoo] .container590{min-width:280px!important;width: 280px !important;}
            body[yahoo] .container580{min-width:260px!important;width: 260px !important;}
            body[yahoo] .container300{min-width:280px!important;width: 280px !important;}
            body[yahoo] .container560{min-width:260px!important;width: 260px !important;}
            body[yahoo] .container440{min-width:265px!important;width: 265px !important;}
            body[yahoo] .container-microblog-right{min-width:156px!important;width:156px!important;}
            body[yahoo] .container-chat-right{min-width:156px!important;width:156px!important;}
            body[yahoo] .container-attachment-left-td{display:none;}
            body[yahoo] .container-attachment-right{min-width:260px!important;width: 260px !important;}

            <#-- secions -->
            body[yahoo] .section-item{min-width:260px!important;width: 260px !important;}
            body[yahoo] .section-img img{min-width:280px!important;width: 280px !important; height: auto !important;}
            body[yahoo] .section-img2 img{min-width:280px!important;width: 280px !important; height: auto !important;}
            body[yahoo] .section-img a{min-width:280px!important;width: 280px !important;}
            body[yahoo] .cta-header{line-height: 26px !important;}

            <#-- socials -->
            body[yahoo] .social-container{min-width:280px!important;width: 280px !important;}
        }

    </style>
</head>

<body leftmargin="0" yahoo="fix" topmargin="0" marginwidth="0" marginheight="0">
    <@table width="100%" minWidth="610px" style="min-width:610px;" class="body-table">
        <#nested />
    </@table>
</body>
</html>

</#macro>
