<#include "../htmlmacros.ftl">

<#macro importErrors errorMessage identifiers>
    ${errorMessage}<br />
    <#list identifiers as identifier>
        ${identifier}<br />
    </#list>
</#macro>

<@container>
    <#include "*/header_html.ftl">
    <@headerComponent />
    <@shortSummaryComponent>
        <@trans key="ImportMessages.statisticsSuccessMessage" params=[escapef(endDate),duration] /><br />
        <@trans key="ImportMessages.successfulImportsCount"/>${successfulImports}<br />
        <@trans key="ImportMessages.failedImportsCount"/>${failedImports}<br />
        <@trans key="ImportMessages.statisticsProcessedCount"/>${processed}<br />
        <@trans key="ImportMessages.statisticsInsertedCount"/>${inserted}<br />
        <@trans key="ImportMessages.statisticsUpdatedCount"/>${updated}<br />
        <@trans key="ImportMessages.statisticsSkippedCount"/>${skipped}<br />
        <@trans key="ImportMessages.statisticsFailedCount"/>${failed}<br />
        <br />
        <#list errors?keys as errorMessage>
            <@importErrors errorMessage=errorMessage identifiers=errors[errorMessage] /><br />
        </#list>
    </@shortSummaryComponent>
    <@footerComponent />
    <#include "*/footer_html.ftl">
</@container>
