#!/usr/bin/tclsh

# fuegt fehlende property eintrage hinzu.
# vorbedingung: die dateien *_de.properties muessen vorhanden sein
# und die dateien ohne sprachkuerzel (symlinks).
# welche property dateien bearbeitet werden sollen wird automatisch erkannt,
# nicht jedoch, welche sprachen es gibt.
# die property dateien muessen alle im gleichen verzeichnis liegen wie
# dieses skript

set DUMMY_VALUE " XXX // TO DO"
set langs {en de cz fr jp pl ru es it nl pt tr}

proc file2names {filename} {
    set res [list]    

    if {[catch {set srcfile [open "$filename" r]} errmsg]} {
        puts "open file failed; adding file - $errmsg"
        set srcfile [open "$filename" w]
        puts $srcfile ""
        close $srcfile
        return [list]
    } else {
        set srcContent [split [read $srcfile] "\n\r" ]
        # pay attention at lines ending with '\':
        set continuedLine false
        foreach line $srcContent {
            set nameVal [split $line "="]
            set name [string trim [lindex $nameVal 0]]
            set val [string trim [lindex $nameVal 1]]
            if {[string compare $name  ""]} then {
                if { ! $continuedLine } then {
                    lappend res $name
                }
            }
            set lastIndex [string last \\ $line]
            if {($lastIndex >= 0) && ($lastIndex == ([string length $line] - 1))} then {
#puts "YES continued line: $line"
                set continuedLine true
            } else {
#puts "NON continued line: $line" 
                set continuedLine false
            }
        }
        close $srcfile
        return $res
    }
}

proc appendNamesToFile {filename appendNames} {
    global DUMMY_VALUE

#check if we need a preceeding newline:
    set file [open "$filename" r]
    set content [read $file]
    close $file
    set needsAppend true
    if {[ string range "$content" end end] == "\n"} then {
        set needsAppend false
    }

    set file [open "$filename" a]
    if {$needsAppend} then {
        puts $file ""
    }
    foreach n $appendNames {
        puts $file "$n = $DUMMY_VALUE"
    }
    close $file    
}


proc checkConstants {filenamePrefix} {
    global langs
    set srcFilename "$filenamePrefix"
    append srcFilename ".properties"
    set srcVals [file2names "$srcFilename"]
    foreach l $langs {
        set filename "$filenamePrefix"
        append filename "_$l" ".properties"
        puts $filename
        set destVals [file2names $filename]
        set appendNames {}
        foreach srcVal $srcVals {
            set searchResult [lsearch -exact $destVals $srcVal]
            if {$searchResult != -1} then {
                #                puts "search for $srcVal in $filename returnt $searchResult"
            } else {
                puts "value $srcVal not found in $filename"
                lappend appendNames $srcVal
            }
        }
        appendNamesToFile $filename $appendNames
    }
}

proc getPropertyFilenames {} {
    set res [list]
    foreach f [glob "*_de.properties"] {
        set b [split "$f" "_"];
        lappend res [lindex "$b" 0]
    }
    return $res
}

foreach filename [getPropertyFilenames] {
    puts $filename
    checkConstants "$filename"
}
