/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.html.scan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.model.Attribute;
import org.owasp.validator.html.model.Tag;

public class Constants {
    public static final String DEFAULT_ENCODING_ALGORITHM = "UTF-8";
    public static final Tag BASIC_PARAM_TAG_RULE;
    public static List<String> defaultAllowedEmptyTags;
    public static List<String> defaultRequiresClosingTags;
    public static final String[] allowedEmptyTags;
    public static final String[] requiresClosingTags;
    public static final String DEFAULT_LOCALE_LANG = "en";
    public static final String DEFAULT_LOCALE_LOC = "US";
    public static final String big5CharsToEncode = "<>\"'&";
    public static final Set<Integer> big5CharsToEncodeSet;

    static {
        allowedEmptyTags = new String[]{"br", "hr", "a", "img", "link", "iframe", "script", "object", "applet", "frame", "base", "param", "meta", "input", "textarea", "embed", "basefont", "col", "area"};
        requiresClosingTags = new String[]{"iframe", "script", "link"};
        Attribute paramNameAttr = new Attribute("name");
        Attribute paramValueAttr = new Attribute("value");
        paramNameAttr.addAllowedRegExp(Policy.ANYTHING_REGEXP);
        paramValueAttr.addAllowedRegExp(Policy.ANYTHING_REGEXP);
        BASIC_PARAM_TAG_RULE = new Tag("param");
        BASIC_PARAM_TAG_RULE.addAttribute(paramNameAttr);
        BASIC_PARAM_TAG_RULE.addAttribute(paramValueAttr);
        BASIC_PARAM_TAG_RULE.setAction("validate");
        defaultAllowedEmptyTags = new ArrayList<String>();
        defaultAllowedEmptyTags.addAll(Arrays.asList(allowedEmptyTags));
        defaultRequiresClosingTags = new ArrayList<String>();
        defaultRequiresClosingTags.addAll(Arrays.asList(requiresClosingTags));
        big5CharsToEncodeSet = new HashSet<Integer>(){
            {
                for (int i = 0; i < Constants.big5CharsToEncode.length(); ++i) {
                    this.add(Integer.valueOf(Constants.big5CharsToEncode.charAt(i)));
                }
            }
        };
    }
}

