/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.superoperty;

import com.freiheit.simplegroup.Channel;
import com.freiheit.simplegroup.ChannelListener;
import com.freiheit.superoperty.BaseProperty;
import com.freiheit.superoperty.DomainProperty;
import com.freiheit.superoperty.MetaProperty;
import com.freiheit.superoperty.Property;
import com.freiheit.superoperty.PropertyStringConverter;
import com.freiheit.superoperty.SuperopertyContainer;
import com.freiheit.superoperty.configurator.SuperopertyConfigurator;
import com.freiheit.superoperty.event.ChangeType;
import com.freiheit.superoperty.event.SuperopertyChangeEvent;
import com.freiheit.superoperty.event.SuperopertyContainerListener;
import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.event.RowHandler;
import de.justsoftware.superoperty.IBaseProperty;
import de.justsoftware.superoperty.IDomainProperty;
import de.justsoftware.superoperty.IbatisBaseProperty;
import de.justsoftware.superoperty.IbatisDomainProperty;
import de.justsoftware.superoperty.ImmutableBaseProperty;
import de.justsoftware.superoperty.ImmutableDomainProperty;
import java.io.IOException;
import java.io.Serializable;
import java.net.SocketException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.orm.ibatis.SqlMapClientFactoryBean;

public class IbatisConfigurator
implements SuperopertyConfigurator,
ChannelListener {
    private static final String DOMAIN_PROPERTY = "DomainProperty.";
    private static final String BASE_PROPERTY = "BaseProperty.";
    private static final Logger LOG = LoggerFactory.getLogger(IbatisConfigurator.class);
    private SuperopertyContainer _container;
    private DataSource _dataSource;
    private SqlMapClient _sqlMapClient;
    private String _containerName;
    private String _peerGroupConfiguration;
    private int _groupPort = 4711;
    private String _databaseType = "postgresql";
    private Channel _groupChannel;
    private String _version = "unknown";
    private final ThreadLocal<Boolean> _changeHandlerActive = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.TRUE;
        }
    };
    private final ConcurrentMap<String, ImmutableBaseProperty> _basePropertiesByName = Maps.newConcurrentMap();
    private final ConcurrentMap<Long, ImmutableBaseProperty> _basePorpertiesById = Maps.newConcurrentMap();
    private final ConcurrentMap<ImmutableList<?>, ImmutableDomainProperty> _domainPropertiesByBasePropertyAndDomain = Maps.newConcurrentMap();
    private final SuperopertyContainerListener _changeListener = new SuperopertyContainerListener(){

        public void metaPropertyDefined(SuperopertyContainer source, MetaProperty meta) {
            if (IbatisConfigurator.this.isChangeHandlerActive()) {
                LOG.debug("ignoring change event because we are just loading..");
                return;
            }
            IbatisConfigurator.this.setPropertyActive(meta);
        }

        public void anyPropertyChange(SuperopertyContainer source, SuperopertyChangeEvent event) {
            if (IbatisConfigurator.this.isChangeHandlerActive()) {
                LOG.debug("ignoring change event because we are just loading..");
                return;
            }
            ChangeType eventType = event.getType();
            LOG.debug("handle event: {}", (Object)eventType);
            Property property = event.getSource();
            switch (eventType) {
                case ADDED: {
                    IbatisConfigurator.this.addOverrideProperty((DomainProperty)property);
                    break;
                }
                case REMOVED: {
                    IbatisConfigurator.this.removeOverrideProperty((DomainProperty)property);
                    break;
                }
                case MODIFIED: {
                    if (property instanceof DomainProperty) {
                        IbatisConfigurator.this.modifyProperty((DomainProperty)property);
                        break;
                    }
                    if (!(property instanceof BaseProperty)) break;
                    IbatisConfigurator.this.modifyProperty((BaseProperty)property);
                }
            }
        }
    };
    private int _pingTime = 42000;

    private boolean isChangeHandlerActive() {
        return !Boolean.TRUE.equals(this._changeHandlerActive.get());
    }

    private void modifyProperty(final @Nonnull DomainProperty property) {
        try {
            ImmutableDomainProperty res = this.executeTransaction(new DatabaseTransaction<ImmutableDomainProperty>(){

                @Override
                public ImmutableDomainProperty execute() throws SQLException {
                    LOG.debug("modify property " + property.getMetaProperty().getName());
                    return IbatisConfigurator.this.syncToDB(property);
                }
            });
            this.addToCache(res);
            this.notifyPeers(new DomainPropertyModifiedEvent(res));
        }
        catch (SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void modifyProperty(final @Nonnull BaseProperty property) {
        try {
            ImmutableBaseProperty res = this.executeTransaction(new DatabaseTransaction<ImmutableBaseProperty>(){

                @Override
                public ImmutableBaseProperty execute() throws SQLException {
                    LOG.debug("modify property " + property.getMetaProperty().getName());
                    return IbatisConfigurator.this.syncToDB(property, false);
                }
            });
            this.addToCache(res);
            this.notifyPeers(new BasePropertyModifiedEvent(res));
        }
        catch (SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void addOverrideProperty(final @Nonnull DomainProperty property) {
        try {
            ImmutableDomainProperty res = this.executeTransaction(new DatabaseTransaction<ImmutableDomainProperty>(){

                @Override
                public ImmutableDomainProperty execute() throws SQLException {
                    return IbatisConfigurator.this.syncToDB(property);
                }
            });
            this.addToCache(res);
            this.notifyPeers(new DomainPropertyModifiedEvent(res));
        }
        catch (SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void removeOverrideProperty(@Nonnull DomainProperty property) {
        String propertyName = property.getMetaProperty().getName();
        ImmutableBaseProperty base = (ImmutableBaseProperty)this._basePropertiesByName.get(propertyName);
        if (base != null) {
            String domain;
            Long basePropertyId = base.getId();
            final ImmutableDomainProperty domProp = (ImmutableDomainProperty)this._domainPropertiesByBasePropertyAndDomain.remove(IbatisConfigurator.cacheKeyOf(basePropertyId, domain = property.getDomain()));
            if (domProp != null) {
                try {
                    this.executeTransaction(new DatabaseTransaction<Integer>(){

                        @Override
                        public Integer execute() throws SQLException {
                            return IbatisConfigurator.this._sqlMapClient.delete("DomainProperty.delete", (Object)new IbatisDomainProperty(domProp));
                        }
                    });
                }
                catch (SQLException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
            this.notifyPeers(new RemoveOverridenPropertyEvent(basePropertyId, propertyName, domain));
        }
    }

    public void setContainerName(@Nonnull String containerName) {
        this._containerName = containerName;
    }

    public void setPeerGroupConfiguration(@Nonnull String peerGroupConfiguration) {
        this._peerGroupConfiguration = peerGroupConfiguration;
    }

    public void setGroupPort(int groupPort) {
        this._groupPort = groupPort;
    }

    public void setDataSource(@Nonnull DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public void setDatabaseType(@Nonnull String databaseType) {
        this._databaseType = databaseType;
    }

    public void setVersion(@Nonnull String version) {
        this._version = version;
    }

    public void init() throws SQLException, SocketException {
        LOG.info("initializing configurator..");
        this.doInitialConfiguration();
        if (Strings.isNullOrEmpty((String)this._peerGroupConfiguration)) {
            return;
        }
        LOG.info("initializing simplegroup with " + this._peerGroupConfiguration);
        this._groupChannel = new Channel(this._groupPort, "superoperty:" + this._containerName);
        this._groupChannel.addPeers(this._peerGroupConfiguration.split(","));
        this._groupChannel.setChannelListener((ChannelListener)this);
        this._groupChannel.setPingTime(this._pingTime);
    }

    private void doInitialConfiguration() throws SQLException {
        SqlMapClientFactoryBean factory = new SqlMapClientFactoryBean();
        factory.setConfigLocation((Resource)new ClassPathResource("de/justsoftware/superoperty/Superoperty-" + this._databaseType + ".xml"));
        factory.setDataSource(this._dataSource);
        try {
            factory.afterPropertiesSet();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new IllegalStateException(e);
        }
        this._sqlMapClient = factory.getObject();
        this.reset();
        LOG.debug("do initial configuration");
        this.loadAllProperties();
    }

    private void setPropertyActive(final @Nonnull MetaProperty meta) {
        try {
            ImmutableBaseProperty base = this.executeTransaction(new DatabaseTransaction<ImmutableBaseProperty>(){

                @Override
                public ImmutableBaseProperty execute() throws SQLException {
                    LOG.debug("initial sync to database for " + meta.getName());
                    ImmutableBaseProperty result = IbatisConfigurator.this.syncToDB(IbatisConfigurator.this._container.getBaseProperty(meta), true);
                    for (DomainProperty domProp : IbatisConfigurator.this._container.getDomainProperties(meta)) {
                        if (domProp.isValueInherited()) continue;
                        IbatisConfigurator.this.syncToDB(domProp);
                    }
                    return result;
                }
            });
            this.addToCache(base);
            this.notifyPeers(new MetaPropertyAddedEvent(base));
        }
        catch (SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Nonnull
    private ImmutableBaseProperty syncToDB(@Nonnull BaseProperty property, boolean withMeta) throws SQLException {
        ImmutableBaseProperty base = this.getOrLoadBaseProperty(property.getMetaProperty().getName());
        if (base == null) {
            return this.insertNewBaseProperty(property);
        }
        if (withMeta) {
            return this.updateMetaProperty(base, this.copy(property));
        }
        return this.updateBaseProperty(base, this.copy(property));
    }

    @CheckForNull
    private ImmutableBaseProperty getOrLoadBaseProperty(@Nonnull String propertyName) throws SQLException {
        ImmutableBaseProperty base = (ImmutableBaseProperty)this._basePropertiesByName.get(propertyName);
        if (base != null) {
            return base;
        }
        return this.loadBaseProperty(propertyName);
    }

    @CheckForNull
    @VisibleForTesting
    ImmutableBaseProperty loadBaseProperty(@Nonnull String propertyName) throws SQLException {
        IbatisBaseProperty newBase = new IbatisBaseProperty();
        newBase.setPropertyName(propertyName);
        newBase.setContainerName(this._containerName);
        IbatisBaseProperty b = (IbatisBaseProperty)this.queryFirst("BaseProperty.load", newBase);
        return b != null ? new ImmutableBaseProperty(b, b.getLastUsedVersion()) : null;
    }

    @CheckForNull
    private <T> T queryFirst(@Nonnull String id, @Nonnull Object object) throws SQLException {
        List l = this._sqlMapClient.queryForList(id, object, 0, 1);
        Object r = l != null ? Iterables.getFirst((Iterable)l, null) : null;
        return (T)r;
    }

    @Nonnull
    private ImmutableBaseProperty updateMetaProperty(@Nonnull ImmutableBaseProperty existingBase, @Nonnull IbatisBaseProperty updated) throws SQLException {
        updated.setLastUsedVersion(this._version);
        updated.setId(existingBase.getId());
        if (!IbatisConfigurator.metaEquals(existingBase, updated)) {
            this._sqlMapClient.update("BaseProperty.updateWithMeta", (Object)updated);
            return new ImmutableBaseProperty(updated, this._version);
        }
        return existingBase;
    }

    @Nonnull
    private ImmutableBaseProperty updateBaseProperty(@Nonnull ImmutableBaseProperty existingBase, @Nonnull IbatisBaseProperty updated) throws SQLException {
        updated.setId(existingBase.getId());
        if (!IbatisConfigurator.valueEquals(existingBase, updated)) {
            this._sqlMapClient.update("BaseProperty.update", (Object)updated);
            return new ImmutableBaseProperty(updated, updated.getLastUsedVersion());
        }
        return existingBase;
    }

    private static boolean valueEquals(@Nonnull IBaseProperty existingBase, @Nonnull IBaseProperty updated) {
        return Arrays.equals(IbatisConfigurator.getValueUpdateFields(existingBase), IbatisConfigurator.getValueUpdateFields(updated));
    }

    @Nonnull
    private static Object[] getValueUpdateFields(@Nonnull IBaseProperty b) {
        return new Object[]{b.getDefaultValue()};
    }

    private static boolean metaEquals(@Nonnull IBaseProperty existingBase, @Nonnull IBaseProperty updated) {
        return Arrays.equals(IbatisConfigurator.getMetaFields(existingBase), IbatisConfigurator.getMetaFields(updated));
    }

    @Nonnull
    private static Object[] getMetaFields(@Nonnull IBaseProperty b) {
        return new Object[]{b.getConverterClass(), b.getConverterConfig(), b.getDefaultValue(), b.getDescription(), b.getInheritanceType(), b.getPropertyName(), b.getLastUsedVersion()};
    }

    @Nonnull
    private ImmutableBaseProperty insertNewBaseProperty(@Nonnull BaseProperty baseProperty) throws SQLException {
        IbatisBaseProperty newBase = this.copy(baseProperty);
        newBase.setCreatedVersion(this._version);
        newBase.setLastUsedVersion(this._version);
        Long id = (Long)this._sqlMapClient.insert("BaseProperty.insert", (Object)newBase);
        newBase.setId(id);
        return new ImmutableBaseProperty(newBase, this._version);
    }

    @Nonnull
    private IbatisBaseProperty copy(@Nonnull BaseProperty property) {
        MetaProperty meta = property.getMetaProperty();
        IbatisBaseProperty r = new IbatisBaseProperty();
        r.setPropertyName(meta.getName());
        r.setContainerName(this._containerName);
        r.setConverterClass(meta.getConverterClass().getName());
        r.setConverterConfig(meta.getConverterConfiguration());
        r.setInheritanceType(meta.getInheritance());
        r.setDescription(meta.getDescription());
        r.setDefaultValue(property.getStringValue());
        return r;
    }

    @Nonnull
    private ImmutableDomainProperty syncToDB(@Nonnull DomainProperty property) throws SQLException {
        String domainName = property.getDomain();
        MetaProperty meta = property.getMetaProperty();
        ImmutableBaseProperty base = this.getOrLoadBaseProperty(meta.getName());
        if (base == null) {
            base = this.insertNewBaseProperty(this._container.getBaseProperty(meta));
        }
        this.addToCache(base);
        IbatisDomainProperty dbDomainProperty = new IbatisDomainProperty();
        dbDomainProperty.setBasePropertyId(base.getId());
        dbDomainProperty.setDomain(domainName);
        dbDomainProperty.setOverriddenValue(property.getStringValue());
        ImmutableDomainProperty domainProperty = (ImmutableDomainProperty)this._domainPropertiesByBasePropertyAndDomain.get(IbatisConfigurator.cacheKeyOf(base.getId(), domainName));
        if (domainProperty == null) {
            domainProperty = this.loadDomainProperty(dbDomainProperty);
        }
        if (domainProperty == null) {
            this._sqlMapClient.insert("DomainProperty.insert", (Object)dbDomainProperty);
        } else if (!Objects.equal((Object)domainProperty.getOverriddenValue(), (Object)property.getStringValue())) {
            this._sqlMapClient.update("DomainProperty.update", (Object)dbDomainProperty);
        }
        return new ImmutableDomainProperty(dbDomainProperty);
    }

    @CheckForNull
    @VisibleForTesting
    ImmutableDomainProperty loadDomainProperty(@Nonnull Long basePropertyId, @Nonnull String domainName) throws SQLException {
        IbatisDomainProperty dbDomainProperty = new IbatisDomainProperty();
        dbDomainProperty.setBasePropertyId(basePropertyId);
        dbDomainProperty.setDomain(domainName);
        return this.loadDomainProperty(dbDomainProperty);
    }

    @CheckForNull
    private ImmutableDomainProperty loadDomainProperty(@Nonnull IbatisDomainProperty dbDomainProperty) throws SQLException {
        IbatisDomainProperty db = (IbatisDomainProperty)this.queryFirst("DomainProperty.load", dbDomainProperty);
        return db != null ? new ImmutableDomainProperty(db) : null;
    }

    private void loadAllProperties() throws SQLException {
        this._changeHandlerActive.set(Boolean.FALSE);
        final ImmutableSet.Builder existingProperties = ImmutableSet.builder();
        try {
            this._sqlMapClient.queryWithRowHandler("BaseProperty.all", (Object)this._containerName, new RowHandler(){

                public void handleRow(Object valueObject) {
                    IbatisBaseProperty baseProp = (IbatisBaseProperty)valueObject;
                    String propertyName = baseProp.getPropertyName();
                    MetaProperty existingMeta = IbatisConfigurator.this._container.getMetaProperty(propertyName);
                    if (existingMeta != null && !IbatisConfigurator.this._version.equals(baseProp.getLastUsedVersion())) {
                        existingProperties.add((Object)baseProp.getId());
                        IbatisConfigurator.this.addToCache(new ImmutableBaseProperty(baseProp, IbatisConfigurator.this._version));
                    } else {
                        IbatisConfigurator.this.addToCache(new ImmutableBaseProperty(baseProp, baseProp.getLastUsedVersion()));
                    }
                    LOG.debug("load base: {} = {}", (Object)propertyName, (Object)baseProp.getDefaultValue());
                    IbatisConfigurator.this.modifyBaseProperty(baseProp, true);
                }
            });
            this._sqlMapClient.queryWithRowHandler("DomainProperty.all", (Object)this._containerName, new RowHandler(){

                public void handleRow(Object valueObject) {
                    IbatisDomainProperty dbDomainProperty = (IbatisDomainProperty)valueObject;
                    ImmutableDomainProperty domainProperty = IbatisConfigurator.this.addToCache(new ImmutableDomainProperty(dbDomainProperty));
                    IbatisConfigurator.this.modifyDomainProperty(domainProperty);
                }
            });
            IbatisDAOUtil.wrappedPartitionUpdate(this._sqlMapClient, "BaseProperty.updateLastVersionUsed", existingProperties.build(), IbatisDAOUtil.createParameterFunctionForIdsWithMapData("ids", ImmutableMap.of((Object)"lastUsedVersion", (Object)this._version)));
        }
        finally {
            this._changeHandlerActive.set(Boolean.TRUE);
        }
    }

    @CheckForNull
    private MetaProperty createMetaProperty(@Nonnull IBaseProperty baseProp) {
        try {
            Class<PropertyStringConverter> convClass = Class.forName(baseProp.getConverterClass()).asSubclass(PropertyStringConverter.class);
            return this._container.getOrCreateMetaProperty(baseProp.getPropertyName(), convClass, baseProp.getConverterConfig(), baseProp.getDescription(), baseProp.getInheritanceType());
        }
        catch (ClassNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Nonnull
    private ImmutableBaseProperty addToCache(@Nonnull ImmutableBaseProperty baseProp) {
        this._basePropertiesByName.put(baseProp.getPropertyName(), baseProp);
        this._basePorpertiesById.put(baseProp.getId(), baseProp);
        return baseProp;
    }

    @Nonnull
    private ImmutableDomainProperty addToCache(@Nonnull ImmutableDomainProperty res) {
        this._domainPropertiesByBasePropertyAndDomain.put(IbatisConfigurator.cacheKeyOf(res), res);
        return res;
    }

    @Nonnull
    private static ImmutableList<?> cacheKeyOf(@Nonnull IDomainProperty res) {
        return IbatisConfigurator.cacheKeyOf(res.getBasePropertyId(), res.getDomain());
    }

    @Nonnull
    private static ImmutableList<?> cacheKeyOf(@Nonnull Long basePropertyId, @Nonnull String domain) {
        return ImmutableList.of((Object)basePropertyId, (Object)domain);
    }

    private void notifyPeers(@Nonnull GroupChangeEvent event) {
        if (this.isChangeHandlerActive()) {
            LOG.debug("inhibit sending..");
            return;
        }
        try {
            if (this._groupChannel != null) {
                this._groupChannel.publish((Serializable)event);
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void reset() {
        this._domainPropertiesByBasePropertyAndDomain.clear();
        this._basePropertiesByName.clear();
        this._basePorpertiesById.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private <T> T executeTransaction(@Nonnull DatabaseTransaction<T> trans) throws SQLException {
        try {
            this._sqlMapClient.startTransaction();
            T result = trans.execute();
            this._sqlMapClient.commitTransaction();
            T t = result;
            return t;
        }
        finally {
            this._sqlMapClient.endTransaction();
        }
    }

    public void setConfigurationTarget(SuperopertyContainer container) {
        if (this._container != null) {
            throw new IllegalStateException("still attached to container");
        }
        this._container = container;
        this._container.addSuperopertyContainerListener(this._changeListener);
    }

    public void detach() {
        if (this._container == null) {
            throw new IllegalStateException("not attached to container");
        }
        if (this._groupChannel != null) {
            this._groupChannel.close();
        }
        this._container.removeSuperopertyContainerListener(this._changeListener);
        this._container = null;
    }

    private void modifyDomainProperty(@Nonnull IDomainProperty domainProperty) {
        ImmutableBaseProperty baseProperty = (ImmutableBaseProperty)this._basePorpertiesById.get(domainProperty.getBasePropertyId());
        if (baseProperty == null) {
            LOG.error("no base property with ID " + domainProperty.getBasePropertyId());
            return;
        }
        MetaProperty meta = this.getOrCreateMetaProperty(baseProperty);
        if (meta == null) {
            return;
        }
        String domain = domainProperty.getDomain();
        Property domainProp = this._container.getOrCreateProperty(meta, domain, null);
        String value = domainProperty.getOverriddenValue();
        LOG.debug("\tload domain " + domain + " = " + value);
        try {
            domainProp.setStringValue(value);
        }
        catch (RuntimeException e) {
            LOG.error("Unable to set Property to value property: " + meta.getName() + " domain: " + domain + " value: " + value, (Throwable)e);
        }
    }

    @CheckForNull
    private MetaProperty getOrCreateMetaProperty(@Nonnull IBaseProperty baseProperty) {
        MetaProperty meta = this._container.getMetaProperty(baseProperty.getPropertyName());
        return meta != null ? meta : this.createMetaProperty(baseProperty);
    }

    private void modifyBaseProperty(@Nonnull IBaseProperty baseProp, boolean createMeta) {
        MetaProperty meta;
        MetaProperty metaProperty = meta = createMeta ? this.createMetaProperty(baseProp) : this.getOrCreateMetaProperty(baseProp);
        if (meta == null) {
            return;
        }
        String value = baseProp.getDefaultValue();
        Property base = this._container.getOrCreateProperty(meta, null, value);
        try {
            base.setStringValue(value);
        }
        catch (RuntimeException e) {
            LOG.error("Unable to set Property to value property: " + meta.getName() + " value: " + value, (Throwable)e);
        }
    }

    public void messageReceived(Serializable s) {
        if (s instanceof GroupChangeEvent) {
            this._changeHandlerActive.set(Boolean.FALSE);
            try {
                ((GroupChangeEvent)s).handleEvent(this);
            }
            finally {
                this._changeHandlerActive.set(Boolean.TRUE);
            }
        }
    }

    public void setPingTime(int pingTime) {
        this._pingTime = pingTime;
        if (this._groupChannel != null) {
            this._groupChannel.setPingTime(pingTime);
        }
    }

    private static interface GroupChangeEvent
    extends Serializable {
        public void handleEvent(@Nonnull IbatisConfigurator var1);
    }

    static interface DatabaseTransaction<T> {
        @Nonnull
        public T execute() throws SQLException;
    }

    private static class BasePropertyModifiedEvent
    implements GroupChangeEvent {
        private static final long serialVersionUID = 1L;
        private final ImmutableBaseProperty _baseProperty;

        BasePropertyModifiedEvent(@Nonnull ImmutableBaseProperty res) {
            this._baseProperty = res;
        }

        @Override
        public void handleEvent(IbatisConfigurator configurator) {
            configurator.addToCache(this._baseProperty);
            configurator.modifyBaseProperty(this._baseProperty, false);
        }
    }

    private static class DomainPropertyModifiedEvent
    implements GroupChangeEvent {
        private static final long serialVersionUID = 1L;
        private final ImmutableDomainProperty _domainProperty;

        DomainPropertyModifiedEvent(@Nonnull ImmutableDomainProperty res) {
            this._domainProperty = res;
        }

        @Override
        public void handleEvent(IbatisConfigurator configurator) {
            configurator.modifyDomainProperty(this._domainProperty);
            configurator.addToCache(this._domainProperty);
        }
    }

    private static final class RemoveOverridenPropertyEvent
    implements GroupChangeEvent {
        private static final long serialVersionUID = 1L;
        private final String _propertyName;
        private final Long _basePropertyId;
        private final String _domain;

        public RemoveOverridenPropertyEvent(@Nonnull Long basePropertyId, @Nonnull String propertyName, @Nonnull String domain) {
            this._basePropertyId = basePropertyId;
            this._domain = domain;
            this._propertyName = propertyName;
        }

        @Override
        public void handleEvent(IbatisConfigurator configurator) {
            DomainProperty domain;
            configurator._domainPropertiesByBasePropertyAndDomain.remove(IbatisConfigurator.cacheKeyOf(this._basePropertyId, this._domain));
            MetaProperty meta = configurator._container.getMetaProperty(this._propertyName);
            if (meta != null && (domain = configurator._container.getDomainPropertyOrNull(meta, this._domain)) != null) {
                domain.clearLocalValue();
            }
        }
    }

    private static final class MetaPropertyAddedEvent
    implements GroupChangeEvent {
        private static final long serialVersionUID = 1L;
        private final ImmutableBaseProperty _baseProperty;

        public MetaPropertyAddedEvent(@Nonnull ImmutableBaseProperty baseProperties) {
            this._baseProperty = baseProperties;
        }

        @Override
        public void handleEvent(IbatisConfigurator configurator) {
            configurator.addToCache(this._baseProperty);
            configurator.modifyBaseProperty(this._baseProperty, true);
        }
    }
}

