/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.superoperty;

import com.freiheit.superoperty.InheritanceType;
import de.justsoftware.superoperty.IBaseProperty;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class IbatisBaseProperty
implements IBaseProperty {
    private Long _id;
    private String _propertyName;
    private String _converterClass;
    private String _converterConfig;
    private String _description;
    private String _defaultValue;
    private String _inheritanceType;
    private String _containerName;
    private String _createdVersion;
    private String _lastUsedVersion;

    public void setId(Long id) {
        this._id = id;
    }

    @Override
    public Long getId() {
        return this._id;
    }

    public void setDefaultValue(String defaultValue) {
        this._defaultValue = defaultValue;
    }

    @Override
    public String getDefaultValue() {
        return this._defaultValue;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    public void setPropertyName(String propertyName) {
        this._propertyName = propertyName;
    }

    @Override
    public String getPropertyName() {
        return this._propertyName;
    }

    public void setConverterClass(String converterClass) {
        this._converterClass = converterClass;
    }

    @Override
    public String getConverterClass() {
        return this._converterClass;
    }

    public void setConverterConfig(String converterConfig) {
        this._converterConfig = converterConfig;
    }

    @Override
    public String getConverterConfig() {
        return this._converterConfig;
    }

    public void setInheritanceTypeAsString(String inheritanceType) {
        this._inheritanceType = inheritanceType;
    }

    public String getInheritanceTypeAsString() {
        return this._inheritanceType;
    }

    @Override
    public InheritanceType getInheritanceType() {
        String t;
        if (this._inheritanceType != null && !(t = this._inheritanceType.trim()).isEmpty()) {
            switch (t.charAt(0)) {
                case 'F': 
                case 'f': {
                    return InheritanceType.FINAL;
                }
                case 'A': 
                case 'a': {
                    return InheritanceType.ABSTRACT;
                }
            }
        }
        return InheritanceType.OVERRIDABLE;
    }

    public void setInheritanceType(@Nullable InheritanceType inheritanceType) {
        this._inheritanceType = this.transformInheritanceType(inheritanceType);
    }

    @CheckForNull
    private String transformInheritanceType(@Nullable InheritanceType inheritanceType) {
        if (inheritanceType != null) {
            switch (inheritanceType) {
                case ABSTRACT: {
                    return "A";
                }
                case FINAL: {
                    return "F";
                }
                case OVERRIDABLE: {
                    return "O";
                }
            }
        }
        return null;
    }

    public void setContainerName(String containerName) {
        this._containerName = containerName;
    }

    public String getContainerName() {
        return this._containerName;
    }

    @Override
    public String getCreatedVersion() {
        return this._createdVersion;
    }

    public void setCreatedVersion(String createdVersion) {
        this._createdVersion = createdVersion;
    }

    @Override
    public String getLastUsedVersion() {
        return this._lastUsedVersion;
    }

    public void setLastUsedVersion(String lastUsedVersion) {
        this._lastUsedVersion = lastUsedVersion;
    }
}

