/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.polls.model;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.polls.model.PollAnswerId;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class PollAnswer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private PollAnswerId _id;
    private int _position;
    private String _text;
    private ImmutableSet<ProfileId> _votes;

    public PollAnswer() {
    }

    public PollAnswer(PollAnswerId id, int position, String text, Set<ProfileId> votes) {
        this._id = id;
        this._position = position;
        this._text = text;
        this._votes = ImmutableSet.copyOf(votes);
    }

    public PollAnswerId getId() {
        return this._id;
    }

    public int getPosition() {
        return this._position;
    }

    public String getText() {
        return this._text;
    }

    public ImmutableSet<ProfileId> getVotes() {
        return this._votes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PollAnswer that = (PollAnswer)o;
        if (this._position != that._position) {
            return false;
        }
        if (!this._id.equals(that._id)) {
            return false;
        }
        if (!this._text.equals(that._text)) {
            return false;
        }
        return this._votes.equals(that._votes);
    }

    public int hashCode() {
        return Objects.hash(this._id, this._position, this._text, this._votes);
    }

    public String toString() {
        return "PollAnswer{_id=" + this._id + ", _position=" + this._position + ", _text='" + this._text + "', _votes=" + this._votes + "}";
    }
}

