/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.polls.model;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.polls.model.PollAnswer;
import de.justsoftware.polls.model.pollid.PollId;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Poll
implements Serializable {
    private static final long serialVersionUID = 1L;
    private PollId _id;
    private String _question;
    private ImmutableSet<PollAnswer> _answers;
    private boolean _allowMultipleAnswers;
    private ItemId _parentId;
    private TenantId _tenantId;

    public Poll() {
    }

    public Poll(PollId id, String question, ImmutableSet<PollAnswer> answers, boolean allowMultipleAnswers, ItemId parentId, TenantId tenantId) {
        this._id = id;
        this._question = question;
        this._answers = answers;
        this._allowMultipleAnswers = allowMultipleAnswers;
        this._parentId = parentId;
        this._tenantId = tenantId;
    }

    public PollId getId() {
        return this._id;
    }

    public String getQuestion() {
        return this._question;
    }

    public ImmutableSet<PollAnswer> getAnswers() {
        return this._answers;
    }

    public boolean isAllowMultipleAnswers() {
        return this._allowMultipleAnswers;
    }

    public ItemId getParentId() {
        return this._parentId;
    }

    public TenantId getTenantId() {
        return this._tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Poll poll = (Poll)o;
        if (this._allowMultipleAnswers != poll._allowMultipleAnswers) {
            return false;
        }
        if (!this._id.equals(poll._id)) {
            return false;
        }
        if (!this._question.equals(poll._question)) {
            return false;
        }
        if (!this._answers.equals(poll._answers)) {
            return false;
        }
        if (!this._parentId.equals(poll._parentId)) {
            return false;
        }
        return this._tenantId.equals(poll._tenantId);
    }

    public int hashCode() {
        return Objects.hash(this._id, this._question, this._answers, this._allowMultipleAnswers, this._parentId, this._tenantId);
    }

    public String toString() {
        return "Poll{_id=" + this._id + ", _question='" + this._question + "', _answers=" + this._answers + ", _allowMultipleAnswers=" + this._allowMultipleAnswers + ", _parentId=" + this._parentId + ", _tenantId=" + this._tenantId + "}";
    }
}

