/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.polls;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.polls.model.Poll;
import de.justsoftware.polls.model.PollAnswer;
import de.justsoftware.polls.model.PollAnswerId;
import de.justsoftware.polls.model.pollid.PollId;
import de.justsoftware.polls.persistence.PollDAO;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@ParametersAreNonnullByDefault
@Service
public class PollService {
    private final PollDAO _pollDAO;

    @Autowired
    public PollService(PollDAO pollDAO) {
        this._pollDAO = pollDAO;
    }

    public Poll createPoll(String question, List<String> answers, boolean allowMultipleAnswers, ItemId parentId, TenantId tenantId) {
        if (answers.isEmpty()) {
            throw new IllegalArgumentException("At least 1 answer is required for a poll!");
        }
        AtomicInteger answerPosition = new AtomicInteger();
        return this._pollDAO.createPoll(new Poll(PollId.random(), question, (ImmutableSet<PollAnswer>)((ImmutableSet)answers.stream().map(text -> new PollAnswer(PollAnswerId.random(), answerPosition.getAndIncrement(), (String)text, Collections.emptySet())).collect(ImmutableSet.toImmutableSet())), allowMultipleAnswers, parentId, tenantId));
    }

    public PollId deletePoll(PollId pollId) {
        return this._pollDAO.deletePoll(pollId);
    }

    public Optional<Poll> findPoll(PollId pollId) {
        return this._pollDAO.findPoll(pollId);
    }

    public Poll getPoll(PollId pollId) {
        return this._pollDAO.getPoll(pollId);
    }

    public ItemId getPollParent(PollId pollId) {
        return this._pollDAO.getPollParent(pollId);
    }

    @Transactional
    public void vote(ProfileId profileId, PollId pollId, Set<PollAnswerId> checkedAnswers) {
        this._pollDAO.deleteVotes(pollId, profileId);
        this._pollDAO.createVotes(checkedAnswers, profileId);
    }
}

