/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.shared.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import de.justsoftware.onx.common.shared.util.Enums2;
import de.justsoftware.onx.workstream.shared.model.MultiWorkstreamFilterMessageType;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterMessageType;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public final class WorkstreamFilterMessageTypes {
    private static final ImmutableMap<String, WorkstreamFilterMessageType> MAP = ImmutableMap.builder().putAll((Map)Maps.uniqueIndex(WorkstreamMessageType.supportedValues(), Enum::name)).putAll((Map)Enums2.index((Enum[])MultiWorkstreamFilterMessageType.values())).put((Object)"DOCUMENT_COMMENT", (Object)WorkstreamMessageType.DRIVE_DOCUMENT_COMMENT).put((Object)"DOCUMENT_NEW_VERSION", (Object)WorkstreamMessageType.DRIVE_DOCUMENT_NEW_VERSION).build();

    private WorkstreamFilterMessageTypes() {
    }

    @CheckForNull
    public static ImmutableSet<WorkstreamMessageType> toMessageTypes(@Nullable Iterable<? extends WorkstreamFilterMessageType> filter) {
        return filter == null ? null : ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(filter, WorkstreamFilterMessageType.GET_MESSAGE_TYPES)));
    }

    @CheckForNull
    public static WorkstreamFilterMessageType valueOf(@Nullable String s) {
        return (WorkstreamFilterMessageType)MAP.get((Object)s);
    }
}

