/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.shared.model.messages;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import de.justsoftware.onx.workstream.shared.model.messages.AbstractActivityWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.MessageVisitor;
import java.util.Date;
import javax.annotation.Nonnull;

public class WikiVersionCreated
extends AbstractActivityWorkstreamMessage<EntityId> {
    private static final long serialVersionUID = 1L;
    private EntityType _entityType;
    private String _entityName;
    private final int _version;

    public WikiVersionCreated(PersonId authorId, EntityId originId, int version) {
        super(authorId, originId, new Date());
        this._version = version;
    }

    public WikiVersionCreated(@Nonnull DBWorkstreamMessage m, @Nonnull PersonTeaserModel author, @Nonnull ImmutableSet<Action> may, EntityType entityType, String entityName, int version) {
        super(m, author, may);
        this._entityType = entityType;
        this._entityName = entityName;
        this._version = version;
    }

    @Override
    public <T> T accept(MessageVisitor<T> v) {
        return v.visitWikiVersionCreated(this);
    }

    @Override
    public WorkstreamMessageType getType() {
        return WorkstreamMessageType.WIKI_VERSION_CREATED;
    }

    public EntityType getEntityType() {
        return this._entityType;
    }

    public String getEntityName() {
        return this._entityName;
    }

    public int getVersion() {
        return this._version;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entityType", (Object)this._entityType).add("entityName", (Object)this._entityName).add("version", this._version).toString();
    }
}

