/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.shared.model.messages;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.videolink.shared.model.VideolinkId;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import de.justsoftware.onx.workstream.shared.model.messages.AbstractActivityWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.MessageVisitor;
import java.util.Date;
import javax.annotation.Nonnull;

public class VideolinkCreated
extends AbstractActivityWorkstreamMessage<GlobalId> {
    public static final String VIDEOLINK_ID_KEY = "video_id";
    private static final long serialVersionUID = 1L;
    private final VideolinkId _videolinkId;
    private String _videoTitle;

    public VideolinkCreated(PersonId authorId, VideolinkId videolinkId, @Nonnull GlobalId originId) {
        super(authorId, originId, new Date());
        this._videolinkId = videolinkId;
    }

    public VideolinkCreated(@Nonnull DBWorkstreamMessage m, @Nonnull PersonTeaserModel author, @Nonnull ImmutableSet<Action> may, VideolinkId videolinkId, String videoTitle) {
        super(m, author, may);
        this._videoTitle = videoTitle;
        this._videolinkId = videolinkId;
    }

    @Override
    public <T> T accept(MessageVisitor<T> v) {
        return v.visitVideolinkCreated(this);
    }

    public VideolinkId getVideolinkId() {
        return this._videolinkId;
    }

    @Override
    public WorkstreamMessageType getType() {
        return WorkstreamMessageType.VIDEOLINK_CREATED;
    }

    public String getVideoTitle() {
        return this._videoTitle;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("videolinkId", (Object)this._videolinkId).add("videoTitle", (Object)this._videoTitle).toString();
    }
}

