/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.shared.model.messages;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.survey.shared.model.SurveyId;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import de.justsoftware.onx.workstream.shared.model.messages.AbstractActivityWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.MessageVisitor;
import java.util.Date;
import javax.annotation.Nonnull;

public class SurveyPublished
extends AbstractActivityWorkstreamMessage<EntityId> {
    public static final String SURVEY_ID_KEY = "survey_id";
    private static final long serialVersionUID = 1L;
    private final SurveyId _surveyId;
    private String _surveyTitle;

    public SurveyPublished(@Nonnull DBWorkstreamMessage m, @Nonnull PersonTeaserModel author, @Nonnull ImmutableSet<Action> may, String surveyTitle) {
        super(m, author, may);
        this._surveyId = SurveyId.parse(m.getAttribute(SURVEY_ID_KEY));
        this._surveyTitle = surveyTitle;
    }

    public SurveyPublished(@Nonnull PersonId authorId, @Nonnull EntityId originId, @Nonnull SurveyId surveyId) {
        super(authorId, originId, new Date());
        this._surveyId = surveyId;
    }

    @Override
    public <T> T accept(MessageVisitor<T> v) {
        return v.visitSurveyPublished(this);
    }

    @Override
    public WorkstreamMessageType getType() {
        return WorkstreamMessageType.SURVEY_PUBLISHED;
    }

    public String getSurveyTitle() {
        return this._surveyTitle;
    }

    public void setSurveyTitle(String surveyTitle) {
        this._surveyTitle = surveyTitle;
    }

    @Nonnull
    public SurveyId getSurveyId() {
        return this._surveyId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("surveyId", (Object)this._surveyId).add("surveyTitle", (Object)this._surveyTitle).toString();
    }
}

