/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.shared.model.messages;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.EntityVersionClientModel;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import de.justsoftware.onx.workstream.shared.model.messages.AbstractActivityWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.MessageVisitor;
import java.util.Date;
import javax.annotation.Nonnull;

public class EntityVersionPublished
extends AbstractActivityWorkstreamMessage<EntityId> {
    public static final String CHANGE_MESSAGE_KEY = "CHANGE_MESSAGE_KEY";
    public static final String VERSION_KEY = "VERSION_KEY";
    public static final String VERSION_ID_KEY = "VERSION_ID_KEY";
    private static final long serialVersionUID = 2L;
    private final EntityType _entityType;
    private final String _entityName;
    private final EntityVersionClientModel _version;
    private final String _versionString;

    public EntityVersionPublished(@Nonnull EntityVersionClientModel version, @Nonnull DBEntity entity, @Nonnull DBWorkstreamMessage msg, @Nonnull PersonTeaserModel author, @Nonnull ImmutableSet<Action> may) {
        super(msg, author, may);
        this._entityType = entity.getType();
        this._entityName = entity.getName();
        this._version = version;
        this._versionString = msg.getAttribute(VERSION_KEY, version.getVersionString());
    }

    public EntityVersionPublished(@Nonnull EntityVersionClientModel version, @Nonnull DBEntity entity, @Nonnull PersonId authorId) {
        super(authorId, entity.getId(), new Date());
        this._version = version;
        this._versionString = version.getVersionString();
        this._entityType = entity.getType();
        this._entityName = entity.getName();
    }

    @Override
    public <T> T accept(MessageVisitor<T> v) {
        return v.visitEntityVersionPublished(this);
    }

    @Override
    public WorkstreamMessageType getType() {
        return WorkstreamMessageType.ENTITY_VERSION_PUBLISHED;
    }

    @Nonnull
    public String getChangeMessage() {
        String changeMessage = this._version.getChangeMessage();
        if (changeMessage == null) {
            return "";
        }
        return changeMessage;
    }

    @Nonnull
    public String getVersionString() {
        return this._versionString;
    }

    @Nonnull
    public EntityType getEntityType() {
        return this._entityType;
    }

    @Nonnull
    public String getEntityName() {
        return this._entityName;
    }

    @Nonnull
    public EntityVersionId getVersionId() {
        return this._version.getId();
    }

    @Nonnull
    public EntityId getEntityId() {
        return this._version.getEntityId();
    }

    @Nonnull
    public EntityVersionClientModel getVersion() {
        return this._version;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", (Object)this._version).add("entityType", (Object)this._entityType).add("entityName", (Object)this._entityName).toString();
    }
}

