/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.shared.model.messages;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import de.justsoftware.onx.workstream.shared.model.messages.AbstractActivityWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.MessageVisitor;
import java.util.Date;
import javax.annotation.Nonnull;

public class EntityParentsChanged
extends AbstractActivityWorkstreamMessage<EntityId> {
    public static final String NEW_PARENT_IDS_KEY = "new_parent_ids";
    private static final long serialVersionUID = 1L;
    private final EntityType _entityType;
    private final String _entityName;
    private final ImmutableSet<EntityId> _newParents;

    public EntityParentsChanged(@Nonnull PersonId authorId, @Nonnull EntityId originId, @Nonnull String entityName, @Nonnull EntityType entityType, @Nonnull ImmutableSet<EntityId> newParents) {
        super(authorId, originId, new Date());
        this._entityName = entityName;
        this._entityType = entityType;
        this._newParents = newParents;
    }

    public EntityParentsChanged(@Nonnull DBWorkstreamMessage m, @Nonnull PersonTeaserModel author, @Nonnull ImmutableSet<Action> may, @Nonnull String entityName, @Nonnull EntityType entityType, @Nonnull ImmutableSet<EntityId> newParents) {
        super(m, author, may);
        this._entityName = entityName;
        this._entityType = entityType;
        this._newParents = newParents;
    }

    @Nonnull
    public EntityType getEntityType() {
        return this._entityType;
    }

    @Override
    public <T> T accept(MessageVisitor<T> v) {
        return v.visit(this);
    }

    @Override
    public WorkstreamMessageType getType() {
        return WorkstreamMessageType.ENTITY_PARENTS_CHANGED;
    }

    @Nonnull
    public String getEntityName() {
        return this._entityName;
    }

    @Nonnull
    public ImmutableSet<EntityId> getNewParents() {
        return this._newParents;
    }

    @Override
    public String toString() {
        return this.superToString().add("entityType", (Object)this._entityType).add("entityName", (Object)this._entityName).add("newParents", this._newParents).toString();
    }
}

