/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.shared.model.messages;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import de.justsoftware.onx.workstream.shared.model.messages.AbstractActivityWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.MessageVisitor;
import java.util.Date;
import javax.annotation.Nonnull;

public class EntityDescriptionUpdated
extends AbstractActivityWorkstreamMessage<EntityId> {
    private static final long serialVersionUID = 1L;
    private EntityType _entityType;
    private String _entityName;

    public EntityDescriptionUpdated(@Nonnull DBWorkstreamMessage m, @Nonnull PersonTeaserModel author, @Nonnull ImmutableSet<Action> may, @Nonnull DBEntity entity) {
        super(m, author, may);
        this.setEntityFields(entity);
    }

    public EntityDescriptionUpdated(PersonId personId, DBEntity entity) {
        super(personId, entity.getId(), new Date());
        this.setEntityFields(entity);
    }

    private void setEntityFields(DBEntity entity) {
        this._entityName = entity.getName();
        this._entityType = entity.getType();
    }

    @Override
    public <T> T accept(MessageVisitor<T> v) {
        return v.visitEntityDescriptionUpdated(this);
    }

    @Override
    public WorkstreamMessageType getType() {
        return WorkstreamMessageType.ENTITY_DESCRIPTION_UPDATED;
    }

    public EntityType getEntityType() {
        return this._entityType;
    }

    public String getEntityName() {
        return this._entityName;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entityType", (Object)this._entityType).add("entityName", (Object)this._entityName).toString();
    }
}

