/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.shared.model.messages;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import de.justsoftware.onx.workstream.shared.model.messages.AbstractActivityWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.MessageVisitor;
import java.util.Date;
import javax.annotation.Nonnull;

public class DriveDocumentComment
extends AbstractActivityWorkstreamMessage<GlobalId> {
    public static final String DOCUMENT_NAME_KEY = "document_name";
    private static final long serialVersionUID = 1L;
    private DriveDocumentId _documentId;
    private String _documentName;

    public DriveDocumentComment(@Nonnull DBWorkstreamMessage m, @Nonnull PersonTeaserModel author, @Nonnull ImmutableSet<Action> may, @Nonnull DriveDocumentId documentId, @Nonnull String documentName) {
        super(m, author, may);
        this._documentId = documentId;
        this._documentName = documentName;
    }

    public DriveDocumentComment(DriveDocumentId documentId, PersonId authorId, @Nonnull GlobalId originId, String documentName) {
        super(authorId, originId, new Date());
        this._documentId = documentId;
        this._documentName = documentName;
    }

    @Override
    public <T> T accept(MessageVisitor<T> v) {
        return v.visitDriveDocumentComment(this);
    }

    public DriveDocumentId getDocumentId() {
        return this._documentId;
    }

    public void setDocumentId(DriveDocumentId id) {
        this._documentId = id;
    }

    @Override
    public WorkstreamMessageType getType() {
        return WorkstreamMessageType.DRIVE_DOCUMENT_COMMENT;
    }

    public void setDocumentName(String documentName) {
        this._documentName = documentName;
    }

    public String getDocumentName() {
        return this._documentName;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("documentId", (Object)this._documentId).add("documentName", (Object)this._documentName).toString();
    }
}

