/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.shared.model.messages;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import de.justsoftware.onx.workstream.shared.model.messages.AbstractActivityWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.MessageVisitor;
import java.util.Date;
import javax.annotation.Nonnull;

public class AlbumImageCreated
extends AbstractActivityWorkstreamMessage<GlobalId> {
    public static final String ALBUM_ID_KEY = "album_id";
    public static final String IMAGE_ID_KEY = "image_id";
    private static final long serialVersionUID = 1L;
    private final AlbumImageId _imageId;
    private String _imageName;
    private final AlbumId _albumId;
    private String _albumName;

    public AlbumImageCreated(@Nonnull DBWorkstreamMessage m, @Nonnull PersonTeaserModel author, @Nonnull ImmutableSet<Action> may) {
        super(m, author, may);
        this._imageId = AlbumImageId.parse(m.getAttribute(IMAGE_ID_KEY));
        this._albumId = AlbumId.parse(m.getAttribute(ALBUM_ID_KEY));
    }

    public AlbumImageCreated(AlbumImageId imageId, AlbumId albumId, PersonId authorId, @Nonnull GlobalId originId) {
        super(authorId, originId, new Date());
        this._imageId = imageId;
        this._albumId = albumId;
    }

    @Override
    public <T> T accept(MessageVisitor<T> v) {
        return v.visitAlbumImageCreated(this);
    }

    @Override
    public WorkstreamMessageType getType() {
        return WorkstreamMessageType.ALBUM_IMAGE_CREATED;
    }

    public AlbumId getAlbumId() {
        return this._albumId;
    }

    public void setAlbumName(@Nonnull String name) {
        this._albumName = name;
    }

    @Nonnull
    public String getAlbumName() {
        return this._albumName;
    }

    public AlbumImageId getImageId() {
        return this._imageId;
    }

    public void setImageName(@Nonnull String name) {
        this._imageName = name;
    }

    @Nonnull
    public String getImageName() {
        return this._imageName;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("imageId", (Object)this._imageId).add("imageName", (Object)this._imageName).add("albumId", (Object)this._albumId).add("albumName", (Object)this._albumName).toString();
    }
}

