/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.shared.model.messages;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import de.justsoftware.onx.workstream.shared.model.messages.AbstractActivityWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.MessageVisitor;
import java.util.Date;
import javax.annotation.Nonnull;

public class AlbumCreated
extends AbstractActivityWorkstreamMessage<GlobalId> {
    public static final String ALBUM_ID_KEY = "album_id";
    private static final long serialVersionUID = 1L;
    private AlbumId _albumId;
    private String _albumTitle;

    public AlbumCreated(@Nonnull DBWorkstreamMessage m, @Nonnull PersonTeaserModel author, @Nonnull ImmutableSet<Action> may) {
        super(m, author, may);
        this.setAlbumId(AlbumId.parse(m.getAttribute(ALBUM_ID_KEY)));
    }

    public AlbumCreated(AlbumId albumId, PersonId authorId, @Nonnull GlobalId originId) {
        super(authorId, originId, new Date());
        this._albumId = albumId;
    }

    @Override
    public <T> T accept(MessageVisitor<T> v) {
        return v.visitAlbumCreated(this);
    }

    public void setAlbumId(AlbumId albumId) {
        this._albumId = albumId;
    }

    public AlbumId getAlbumId() {
        return this._albumId;
    }

    public void setAlbumTitle(String albumTitle) {
        this._albumTitle = albumTitle;
    }

    public String getAlbumTitle() {
        return this._albumTitle;
    }

    @Override
    public WorkstreamMessageType getType() {
        return WorkstreamMessageType.ALBUM_CREATED;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("albumId", (Object)this._albumId).add("albumTitle", (Object)this._albumTitle).toString();
    }
}

