/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.shared.model.messages;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.comments.shared.model.GenericComment;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.model.attachments.Attachment;
import de.justsoftware.onx.workstream.shared.model.messages.WorkstreamMessage;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractWorkstreamMessage<OID extends ItemId>
implements WorkstreamMessage {
    private static final long serialVersionUID = 1989791108195361661L;
    protected WorkstreamMessageId _id;
    protected Date _createdAt;
    protected Date _modifiedAt;
    protected Date _publishedAt;
    protected ListAndCount<GenericComment> _comments = new ListAndCount();
    private OID _originId;
    private final PersonId _authorId;
    private PersonTeaserModel _author;
    private ImmutableSet<Action> _may;
    private EntityType _originEntityType;
    private String _originName;
    private Boolean _isPubliclyVisible;
    private String _originImageUrl;
    private boolean _pinned = false;
    private PersonTeaserModel _pinAuthor;
    private Date _pinDate;

    public AbstractWorkstreamMessage(@Nonnull DBWorkstreamMessage m, @Nonnull PersonTeaserModel author, @Nullable PersonTeaserModel pinAuthor, @Nonnull ImmutableSet<Action> may) {
        this._author = author;
        this._authorId = (PersonId)author.getId();
        this._id = m.getId();
        this._createdAt = Dates.clone(m.getCreateDate());
        this._modifiedAt = Dates.clone(m.getModifyDate());
        this._publishedAt = Dates.clone(m.getPublishDate());
        ItemId typedOriginId = m.getOriginItemId();
        this._originId = typedOriginId;
        this._may = may;
        this._pinned = m.isPinned();
        this._pinAuthor = pinAuthor;
        this._pinDate = m.getPinDate();
    }

    public AbstractWorkstreamMessage(@Nullable PersonId authorId, @Nonnull OID originId) {
        this._originId = originId;
        this._authorId = authorId;
    }

    @Override
    public Date getPublishedAt() {
        return Dates.clone(this._publishedAt);
    }

    @Override
    public WorkstreamMessageId getId() {
        return this._id;
    }

    @Override
    public Date getCreatedAt() {
        return Dates.clone(this._createdAt);
    }

    @Override
    public Date getModifiedAt() {
        return Dates.clone(this._modifiedAt);
    }

    @Override
    public PersonId getAuthorId() {
        return this._authorId;
    }

    public OID getOriginId() {
        return this._originId;
    }

    public void setOriginId(@Nonnull OID originId) {
        this._originId = originId;
    }

    @Override
    public String getAuthorName() {
        return this._author.getFullName();
    }

    @Override
    public String getAuthorImageUrl() {
        return this._author.getLogo();
    }

    @Override
    public ListAndCount<GenericComment> getComments() {
        return this._comments;
    }

    public void setComments(@Nonnull ListAndCount<GenericComment> comments) {
        this._comments = comments;
    }

    @Override
    public ImmutableSet<Action> getMay() {
        return this._may;
    }

    @Override
    public EntityType getOriginEntityType() {
        return this._originEntityType;
    }

    @Override
    public void setOriginEntityType(@Nullable EntityType originEntityType) {
        this._originEntityType = originEntityType;
    }

    @Override
    public void setOriginName(String originName) {
        this._originName = originName;
    }

    @Override
    public String getOriginName() {
        return this._originName;
    }

    @Override
    public PersonTeaserModel getAuthor() {
        return this._author;
    }

    @Override
    public Boolean isPubliclyVisible() {
        return this._isPubliclyVisible;
    }

    @Override
    public void setPubliclyVisible(Boolean visible) {
        this._isPubliclyVisible = visible;
    }

    @Override
    public String getOriginImageUrl() {
        return this._originImageUrl;
    }

    @Override
    public void setOriginImageUrl(String url) {
        this._originImageUrl = url;
    }

    @Override
    public ImmutableList<? extends Attachment> getAttachments() {
        return ImmutableList.of();
    }

    @Override
    public boolean isPinned() {
        return this._pinned;
    }

    @Override
    public PersonTeaserModel getPinAuthor() {
        return this._pinAuthor;
    }

    @Override
    public Date getPinDate() {
        return Dates.clone(this._pinDate);
    }

    @Nonnull
    protected final MoreObjects.ToStringHelper superToString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("author", (Object)this._author).add("createdAt", this._createdAt.getTime()).add("modifiedAt", this._modifiedAt.getTime()).add("originId", this._originId).add("comments", this._comments).add("may", this._may).add("originEntityType", (Object)this._originEntityType).add("originImageUrl", (Object)this._originImageUrl).add("pinned", this._pinned).add("pinAuthor", (Object)this._pinAuthor).add("pinDate", (Object)this._pinDate);
    }

    public String toString() {
        return this.superToString().toString();
    }
}

