/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.shared.model;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterMessageType;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import java.util.EnumSet;
import javax.annotation.Nonnull;

public enum MultiWorkstreamFilterMessageType implements WorkstreamFilterMessageType
{
    ALBUM(WorkstreamMessageType.ALBUM_CREATED, WorkstreamMessageType.ALBUM_IMAGE_CREATED, WorkstreamMessageType.ALBUM_IMAGE_COMMENTED),
    WIKI(WorkstreamMessageType.WIKI_VERSION_CREATED),
    DOCUMENT(WorkstreamMessageType.DRIVE_DOCUMENT_NEW_VERSION, WorkstreamMessageType.DRIVE_DOCUMENT_COMMENT),
    VIDEO(WorkstreamMessageType.VIDEOLINK_CREATED, WorkstreamMessageType.VIDEOLINK_COMMENTED),
    MICROBLOG(WorkstreamMessageType.MICROBLOG_POSTING),
    SURVEY(WorkstreamMessageType.SURVEY_PUBLISHED),
    ALL_ACTIVITIES(MultiWorkstreamFilterMessageType.allButMicroblogPosting());

    private final ImmutableSet<WorkstreamMessageType> _messageTypes;

    private MultiWorkstreamFilterMessageType(WorkstreamMessageType ... messageTypes) {
        this((ImmutableSet<WorkstreamMessageType>)ImmutableSet.copyOf((Object[])messageTypes));
    }

    private MultiWorkstreamFilterMessageType(ImmutableSet<WorkstreamMessageType> messageTypes) {
        this._messageTypes = messageTypes;
    }

    @Nonnull
    private static ImmutableSet<WorkstreamMessageType> allButMicroblogPosting() {
        return ImmutableSet.copyOf(EnumSet.complementOf(EnumSet.of(WorkstreamMessageType.MICROBLOG_POSTING)));
    }

    @Override
    public ImmutableSet<WorkstreamMessageType> getMessageTypes() {
        return this._messageTypes;
    }
}

