/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.shared.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.shared.model.Identifiable;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DBWorkstreamMessage
implements Serializable,
Identifiable<WorkstreamMessageId> {
    public static final Function<DBWorkstreamMessage, PersonId> GET_AUTHOR_ID = new NullPermeableFunction<DBWorkstreamMessage, PersonId>(){

        @Override
        protected PersonId applySafe(DBWorkstreamMessage input) {
            return input.getAuthorId().asPersonId();
        }
    };
    public static final Function<DBWorkstreamMessage, WorkstreamMessageType> GET_TYPE = new NullPermeableFunction<DBWorkstreamMessage, WorkstreamMessageType>(){

        @Override
        protected WorkstreamMessageType applySafe(DBWorkstreamMessage input) {
            return input.getType();
        }
    };
    public static final Function<DBWorkstreamMessage, WorkstreamMessageId> GET_ID = new NullPermeableFunction<DBWorkstreamMessage, WorkstreamMessageId>(){

        @Override
        protected WorkstreamMessageId applySafe(DBWorkstreamMessage input) {
            return input.getId();
        }
    };
    public static final Function<DBWorkstreamMessage, ItemId> GET_ORIGIN_ITEM_ID = new NullPermeableFunction<DBWorkstreamMessage, ItemId>(){

        @Override
        protected ItemId applySafe(DBWorkstreamMessage input) {
            return input.getOriginItemId();
        }
    };
    private static final long serialVersionUID = 1L;
    private Map<String, String> _attributes = new HashMap<String, String>();
    private WorkstreamMessageId _id;
    private WorkstreamMessageType _type;
    private ProfileId _authorId;
    private ItemId _originItemId;
    private ItemId _subjectItemId;
    private Date _createDate;
    private Date _modifyDate;
    private Date _publishDate;
    private boolean _published;
    private boolean _pinned = false;
    private PersonId _pinAuthor;
    private Date _pinDate;

    @CheckForNull
    public Date getPublishDate() {
        return Dates.clone(this._publishDate);
    }

    public boolean isPublished() {
        return this._published;
    }

    public void setPublishDate(@Nullable Date publishDate) {
        this._publishDate = Dates.clone(publishDate);
    }

    public void setPublished(boolean published) {
        this._published = published;
    }

    @Nonnull
    public Map<String, String> getAttributes() {
        return this._attributes;
    }

    @CheckForNull
    public String getAttribute(@Nonnull String key) {
        return this._attributes.get(key);
    }

    @Nonnull
    public static Function<DBWorkstreamMessage, String> getAttributeFunction(final @Nonnull String key) {
        return new NullPermeableFunction<DBWorkstreamMessage, String>(){

            @Override
            protected String applySafe(DBWorkstreamMessage input) {
                return input.getAttribute(key);
            }
        };
    }

    @CheckForNull
    public String getAttribute(@Nonnull String key, @Nullable String def) {
        String value = this._attributes.get(key);
        return value == null ? def : value;
    }

    public void setAttribute(@Nonnull String key, @Nullable String value) {
        if (value == null) {
            this._attributes.remove(key);
        } else {
            this._attributes.put(key, value);
        }
    }

    public void setAttributes(@Nullable Map<String, String> attributes) {
        this._attributes = attributes == null ? new HashMap<String, String>() : attributes;
    }

    @Override
    public WorkstreamMessageId getId() {
        return this._id;
    }

    public void setId(@Nullable WorkstreamMessageId id) {
        this._id = id;
    }

    @Nonnull
    public WorkstreamMessageType getType() {
        return this._type;
    }

    public void setType(@Nonnull WorkstreamMessageType type) {
        this._type = type;
    }

    @Nonnull
    public ProfileId getAuthorId() {
        return this._authorId;
    }

    public void setAuthorId(@Nonnull ProfileId authorId) {
        this._authorId = authorId;
    }

    public void setOriginItemId(@Nonnull ItemId originItemId) {
        this._originItemId = originItemId;
    }

    @Nonnull
    public ItemId getOriginItemId() {
        return this._originItemId;
    }

    public ItemId getSubjectItemId() {
        return this._subjectItemId;
    }

    public void setSubjectItemId(@Nonnull ItemId subjectItemId) {
        this._subjectItemId = subjectItemId;
    }

    @Nonnull
    public Date getCreateDate() {
        return (Date)Preconditions.checkNotNull((Object)Dates.clone(this._createDate));
    }

    public void setCreateDate(@Nonnull Date createDate) {
        this._createDate = Dates.clone(createDate);
    }

    @Nonnull
    public Date getModifyDate() {
        return (Date)Preconditions.checkNotNull((Object)Dates.clone(this._modifyDate));
    }

    public void setModifyDate(@Nonnull Date modifyDate) {
        this._modifyDate = Dates.clone(modifyDate);
    }

    public boolean isPinned() {
        return this._pinned;
    }

    public void setPinned(boolean pinned) {
        this._pinned = pinned;
    }

    @CheckForNull
    public PersonId getPinAuthor() {
        return this._pinAuthor;
    }

    public void setPinAuthor(@Nullable PersonId pinAuthor) {
        this._pinAuthor = pinAuthor;
    }

    @CheckForNull
    public Date getPinDate() {
        return Dates.clone(this._pinDate);
    }

    public void setPinDate(@Nullable Date pinDate) {
        this._pinDate = Dates.clone(pinDate);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("attributes", this._attributes).add("id", (Object)this._id).add("type", (Object)this._type).add("authorId", (Object)this._authorId).add("originItemId", (Object)this._originItemId).add("subjectItemId", (Object)this._subjectItemId).add("createDate", (Object)this._createDate).add("modifyDate", (Object)this._modifyDate).add("publishDate", (Object)this._publishDate).add("published", this._published).add("pinned", this._pinned).add("pinAuthor", (Object)this._pinAuthor).add("pinDate", (Object)this._pinDate).toString();
    }
}

