/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.common.business.configfile.ConfigFileService;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.workstream.business.WorkstreamTypeAttributeValue;
import de.justsoftware.onx.workstream.business.model.WorkstreamMessagePublishedStateFilter;
import de.justsoftware.onx.workstream.integration.persistence.WorkstreamDAO;
import de.justsoftware.onx.workstream.integration.persistence.model.DBWorkstreamMessageAttachment;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterContext;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterModel;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import de.justsoftware.onx.workstream.shared.util.WorkstreamFilterMessageTypes;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Service
public class IbatisWorkstreamDAO
implements WorkstreamDAO {
    private final TransactionHelper _transactionHelper;
    private final ConfigFileService _configFileService;
    private final IbatisStatementBuilder _ibatisBuilder;

    @Autowired
    @ParametersAreNonnullByDefault
    public IbatisWorkstreamDAO(StatementBuilderFactory statementBuilderFactory, TransactionHelper transactionHelper, ConfigFileService configFileService) {
        this._transactionHelper = transactionHelper;
        this._configFileService = configFileService;
        this._ibatisBuilder = statementBuilderFactory.ibatistStatementBuilder("Workstream");
    }

    private void insertAttributesBatched(WorkstreamMessageId entryId, Map<String, String> attributes) {
        for (Map.Entry<String, String> e : attributes.entrySet()) {
            String k = e.getKey();
            this._ibatisBuilder.insert("insertAttribute").param("entry_id", entryId, "key", k, "value", e.getValue());
        }
    }

    private void updateAttributesBatched(WorkstreamMessageId entryId, Map<String, String> attributes) {
        for (Map.Entry<String, String> e : attributes.entrySet()) {
            String k = e.getKey();
            this._ibatisBuilder.insert("updateAttribute").param("entry_id", entryId, "key", k, "value", e.getValue());
        }
    }

    @Override
    public WorkstreamMessageId saveEntry(DBWorkstreamMessage entry) {
        return (WorkstreamMessageId)this._transactionHelper.doInTransaction(transactionStatus -> {
            WorkstreamMessageId entryId = (WorkstreamMessageId)this._ibatisBuilder.insert("insertWorkstreamEntry").param(entry).get();
            Map<String, String> attributes = entry.getAttributes();
            if (!attributes.isEmpty()) {
                this._ibatisBuilder.batch(sqlMapClient -> this.insertAttributesBatched(entryId, attributes));
            }
            return entryId;
        });
    }

    @Override
    public ImmutableSet<DBWorkstreamMessageAttachment> getAttachments(WorkstreamMessageId messageId) {
        return ((IbatisStandardResultBuilder)this._ibatisBuilder.select("getAttachmentsForWorkstreamMessage").param("entry_id", messageId.getId())).asSet();
    }

    @Override
    public void updateAttachments(WorkstreamMessageId messageId, Set<ItemId> newAttachments) {
        this.deleteAttachments(messageId, newAttachments);
        this._transactionHelper.doInTransactionWithoutResult(status -> this._ibatisBuilder.batch(sqlMapClient -> this.batchInsertAttachments(messageId, newAttachments)));
    }

    @Override
    public void saveAttachment(WorkstreamMessageId messageId, ItemId attachmentId, int attachmentPosition) {
        this.persistAttachment(new DBWorkstreamMessageAttachment(messageId, attachmentId, attachmentPosition));
    }

    @Override
    public void saveAttachments(WorkstreamMessageId messageId, Set<ItemId> attachmentIds) {
        this._transactionHelper.doInTransactionWithoutResult(status -> this._ibatisBuilder.batch(sqlMapClient -> this.batchInsertAttachments(messageId, attachmentIds)));
    }

    private void batchInsertAttachments(WorkstreamMessageId messageId, Set<ItemId> attachmentIds) {
        int index = 0;
        for (ItemId attachmentId : attachmentIds) {
            this.persistAttachment(new DBWorkstreamMessageAttachment(messageId, attachmentId, index));
            ++index;
        }
    }

    private void persistAttachment(@Nonnull DBWorkstreamMessageAttachment attachment) {
        this._ibatisBuilder.insert("insertAttachment").param("entry_id", attachment.getEntryId().getId(), "item_id", attachment.getItemId(), "position", attachment.getPosition());
    }

    @Override
    public ImmutableList<DBWorkstreamMessage> getWorkstream(ItemId itemId, WorkstreamMessagePublishedStateFilter publishedStateFilter, Boolean pinned, Date offset, Date sinceDate, Integer max, WorkstreamFilterModel filter, PersonId personId, Set<String> roles, ImmutableSet<ItemId> originIds) {
        if (roles.isEmpty()) {
            return ImmutableList.of();
        }
        HashMap<String, Object> params = this.packWorkstreamQueryParameters(itemId, publishedStateFilter, pinned, offset, sinceDate, max, filter, personId, roles, originIds);
        ImmutableList entries = this._ibatisBuilder.select("getWorkstream").param(params).asList();
        if (!entries.isEmpty()) {
            this.joinAttributes(Maps.uniqueIndex(entries, Identifiables.toId()));
        }
        return entries;
    }

    @Override
    public void publish(Set<WorkstreamMessageId> messageIds, Date publishDate) {
        this._ibatisBuilder.update("publishWorkstreamMessage").partition("ids", messageIds, "publishDate", publishDate);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    private HashMap<String, Object> packWorkstreamQueryParameters(ItemId itemId, WorkstreamMessagePublishedStateFilter publishedStateFilter, @Nullable Boolean pinned, @Nullable Date offset, @Nullable Date sinceDate, @Nullable Integer max, WorkstreamFilterModel filter, @Nullable PersonId personId, Set<String> roles, ImmutableSet<ItemId> originIds) {
        ImmutableSet<WorkstreamMessageType> filterMessageTypes;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("item_id", itemId);
        params.put("published", publishedStateFilter.equals((Object)WorkstreamMessagePublishedStateFilter.PUBLISHED));
        params.put("pinned", pinned);
        params.put("max", max);
        params.put("offset", offset);
        params.put("maxage", sinceDate);
        params.put("person_id", personId);
        params.put("roles", IbatisDAOUtil.toIbatisList(roles));
        params.put("originIds", IbatisDAOUtil.toIbatisList(originIds));
        params.put("filter_context", (Object)filter.getContext());
        this.addOriginsToParams(params, filter.getOrigins());
        if (filter.getContext() == WorkstreamFilterContext.DIRECT_SUBSCRIPTIONS || filter.getContext() == WorkstreamFilterContext.INDIRECT_SUBSCRIPTIONS) {
            params.put("filter_context_direct_or_indirect_subs", "t");
        }
        if (filter.getContext() == WorkstreamFilterContext.INDIRECT_ENTITY_SUBSCRIPTIONS || filter.getContext() == WorkstreamFilterContext.INDIRECT_SUBSCRIPTIONS) {
            params.put("filter_context_indirect_entity_or_indirect_subs", "t");
        }
        params.put("filter_message_types", (filterMessageTypes = WorkstreamFilterMessageTypes.toMessageTypes(filter.getMessageTypes())) == null ? null : IbatisDAOUtil.toIbatisList(filterMessageTypes));
        return params;
    }

    private void addOriginsToParams(@Nonnull HashMap<String, Object> params, @Nullable ImmutableSet<String> origins) {
        if (CollectionUtil.isEmpty(origins)) {
            return;
        }
        if (!origins.contains((Object)"ALL_ENTITIES") && !origins.containsAll(this.getAllEntityTypes())) {
            params.put("origins", IbatisDAOUtil.toIbatisList(origins));
        }
    }

    @Nonnull
    private ImmutableSet<String> getAllEntityTypes() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(this._configFileService.getConfigFile().getEntityTypes(), EntityType.TO_NAME));
    }

    @Override
    public ImmutableMap<WorkstreamMessageId, DBWorkstreamMessage> getEntries(Set<WorkstreamMessageId> ids) {
        ImmutableMap res = ((IbatisPartitionResultBuilder)this._ibatisBuilder.select("getEntries").partition(ids)).asMap("id", null);
        if (!res.isEmpty()) {
            this.joinAttributes((Map)res);
        }
        return res;
    }

    @Nonnull
    private <M extends Map<WorkstreamMessageId, DBWorkstreamMessage>> M joinAttributes(@Nonnull M res) {
        ((IbatisPartitionResultBuilder)this._ibatisBuilder.select("getAttributes").partition(res.keySet())).executeWithConsumer(att -> ((DBWorkstreamMessage)res.get(new WorkstreamMessageId(att.getEntryId()))).setAttribute(att.getKey(), att.getValue()));
        return res;
    }

    @Override
    public DBWorkstreamMessage getEntryByOriginAndType(ItemId originId, WorkstreamMessageType type) {
        DBWorkstreamMessage res = (DBWorkstreamMessage)((IbatisStandardResultBuilder)this._ibatisBuilder.select("getEntryByOriginAndType").param("type", type, "originId", originId)).asObject();
        if (res != null) {
            this.joinAttributes(ImmutableMap.of((Object)res.getId(), (Object)res));
        }
        return res;
    }

    @Override
    public ImmutableSet<WorkstreamMessageId> getMessagesByAttributes(Set<WorkstreamTypeAttributeValue> typeAndAttributes) {
        return ((IbatisPartitionResultBuilder)this._ibatisBuilder.select("getMessagesByAttributes").partition(typeAndAttributes)).asSet();
    }

    @Override
    public void updateModifiedAt(WorkstreamMessageId id, Date date) {
        this._ibatisBuilder.update("updateModifiedAt").param("id", id, "date", date);
    }

    @Override
    public void updatePinned(WorkstreamMessageId id, boolean pinned, PersonId pinAuthor, DateTime pinDate) {
        this._ibatisBuilder.update("updatePinned").param("id", id, "pinned", pinned, "pinAuthor", pinAuthor, "pinDate", pinDate);
    }

    @Override
    public void updatePinnedHideDate(ItemId originId, PersonId personId, DateTime hideDate) {
        Integer updated = (Integer)this._ibatisBuilder.update("updatePinnedHideDate").param("personId", personId, "originId", originId, "hideDate", hideDate);
        if (updated == 0) {
            this._ibatisBuilder.insert("insertPinnedHideDate").param("personId", personId, "originId", originId, "hideDate", hideDate);
        }
    }

    @Override
    public DateTime getPinnedHideDate(ItemId originId, PersonId personId) {
        return (DateTime)((IbatisStandardResultBuilder)this._ibatisBuilder.select("getPinnedHideDate").param("personId", personId, "originId", originId)).asObject();
    }

    @Override
    public void deletePinnedHideDate(ItemId originId, PersonId personId) {
        this._ibatisBuilder.delete("deletePinnedHideDate").param("personId", personId, "originId", originId);
    }

    @Override
    public void deletePinnedHideDatesByOrigins(Set<? extends ItemId> originIds) {
        this._ibatisBuilder.delete("deletePinnedHideDatesByOrigins").partition(originIds);
    }

    @Override
    public void deletePinnedHideDatesByPersons(Set<PersonId> personIds) {
        this._ibatisBuilder.delete("deletePinnedHideDatesByPersons").partition(personIds);
    }

    @Override
    public DBWorkstreamMessage getMessageAttachedTo(ItemId forItem) {
        DBWorkstreamMessage res = (DBWorkstreamMessage)((IbatisStandardResultBuilder)this._ibatisBuilder.select("getMessageAttachedTo").param("forItem", forItem)).asObject();
        if (res != null) {
            this.joinAttributes(ImmutableMap.of((Object)res.getId(), (Object)res));
        }
        return res;
    }

    @Override
    public ImmutableMap<ItemId, WorkstreamMessageId> getWorkstreamEntryIdsByAttachments(Set<? extends ItemId> attachmentIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisBuilder.select("getWorkstreamEntryIdsByAttachments").partition(attachmentIds)).asMap("key", "value");
    }

    @Override
    public ImmutableMap<ItemId, WorkstreamMessageId> getMicroblogEntryIdsByAttachments(Set<? extends ItemId> attachmentIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisBuilder.select("getMicroblogEntryIdsByAttachments").partition(attachmentIds)).asMap("key", "value");
    }

    @Override
    public ImmutableSet<WorkstreamMessageId> getWorkstreamMessageIdsByOrigins(Set<? extends ItemId> originIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisBuilder.select("getWorkstreamMessageIdsByOrigins").partition(originIds)).asSet();
    }

    @Override
    public ImmutableListMultimap<WorkstreamMessageId, ItemId> getAttachedItemIds(Set<WorkstreamMessageId> ids) {
        return ((IbatisPartitionResultBuilder)this._ibatisBuilder.select("getAttachments").partition(ids)).asListMultimap("key", "value");
    }

    @Override
    public void deleteEntriesByIds(Set<WorkstreamMessageId> ids) {
        this._ibatisBuilder.delete("deleteEntriesByIds").partition(ids);
    }

    @Override
    public ImmutableMap<WorkstreamMessageId, Date> getNewMessagesSince(ItemId itemId, Date sinceDate, WorkstreamFilterModel filter, PersonId personId, Set<String> roles) {
        if (roles.isEmpty()) {
            return ImmutableMap.of();
        }
        return this._ibatisBuilder.select("getNewMessagesSince").param(this.packWorkstreamQueryParameters(itemId, WorkstreamMessagePublishedStateFilter.PUBLISHED, Boolean.FALSE, null, sinceDate, null, filter, personId, roles, (ImmutableSet<ItemId>)ImmutableSet.of())).asMap("id", "date");
    }

    @Override
    @Nonnull
    public ImmutableSet<WorkstreamMessageId> getNewMessagesByOthersSince(ItemId itemId, @Nullable Date sinceDate, WorkstreamFilterModel filter, @Nullable PersonId personId, Set<String> roles) {
        if (roles.isEmpty()) {
            return ImmutableSet.of();
        }
        return this._ibatisBuilder.select("getNewMessagesByOthersSince").param(this.packWorkstreamQueryParameters(itemId, WorkstreamMessagePublishedStateFilter.PUBLISHED, null, null, sinceDate, null, filter, personId, roles, (ImmutableSet<ItemId>)ImmutableSet.of())).asSet();
    }

    @Override
    public void deleteAttachment(WorkstreamMessageId messageId, ItemId attachmentId) {
        this._ibatisBuilder.delete("deleteAttachment").param("entryId", messageId, "attachmentId", attachmentId);
    }

    @Override
    public void deleteAttachments(WorkstreamMessageId messageId, Set<ItemId> attachmentIds) {
        this._transactionHelper.doInTransactionWithoutResult(status -> this._ibatisBuilder.batch(sqlMapClient -> attachmentIds.forEach(attachmentId -> this.deleteAttachment(messageId, (ItemId)attachmentId))));
    }

    @Override
    public ImmutableMap<EntityId, DateTime> getNewestWorkstreamDateIndirect(Set<? extends EntityId> entityIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisBuilder.select("getNewestWorkstreamDateIndirect").partition(entityIds)).asMap("entityId", "lastModified");
    }

    @Override
    public ImmutableMap<EntityId, DateTime> getNewestWorkstreamDateDirect(Set<? extends EntityId> entityIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisBuilder.select("getNewestWorkstreamDateDirect").partition(entityIds)).asMap("entityId", "lastModified");
    }

    @Override
    public void updateAttributes(final WorkstreamMessageId msgId, final Map<String, String> attributes) {
        if (attributes.isEmpty()) {
            return;
        }
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                IbatisWorkstreamDAO.this._ibatisBuilder.batch(new IbatisStatementBuilder.BatchCallback(){

                    @Override
                    public void execute(SqlMapClient sqlMapClient) throws SQLException {
                        IbatisWorkstreamDAO.this.updateAttributesBatched(msgId, attributes);
                        IbatisWorkstreamDAO.this.insertAttributesBatched(msgId, attributes);
                    }
                });
            }
        });
    }

    @Override
    public ImmutableMap<WorkstreamMessageId, DBWorkstreamMessage> getMessagesForTypeAndSubject(Set<WorkstreamMessageType> types, Set<? extends ItemId> subjects) {
        if (types.isEmpty()) {
            return ImmutableMap.of();
        }
        return this.joinAttributes((Map)((IbatisPartitionResultBuilder)this._ibatisBuilder.select("getMessagesForTypeAndSubject").partition("subjects", subjects, "types", new ArrayList<WorkstreamMessageType>(types))).asMap(DBWorkstreamMessage::getId));
    }

    @Override
    public ImmutableMap<WorkstreamMessageId, DBWorkstreamMessage> getMessagesForTypeSubjectAndAttribute(WorkstreamMessageType type, ItemId subject, String attributeKey, String attribuateValue) {
        return this.joinAttributes((Map)((IbatisStandardResultBuilder)this._ibatisBuilder.selectDbSpecific("getMessagesForTypeSubjectAndAttribute").param("type", type, "subject", subject, "attributeKey", attributeKey, "attributeValue", attribuateValue)).asMap(DBWorkstreamMessage::getId));
    }

    @Override
    public int forAllWorkstreamImages(int chunkSize, Consumer<ImmutableMap<AlbumImageId, WorkstreamMessageId>> consumer) {
        return ((IbatisStandardResultBuilder)this._ibatisBuilder.select("getAttachedImageIds").noParam()).consumeChunkedMap(chunkSize, "imageId", "messageId", consumer);
    }

    @Override
    public ImmutableSetMultimap<EntityId, WorkstreamMessageId> getAllScheduledWorkstreamIds(Set<EntityId> parentIds) {
        return ((IbatisStandardResultBuilder)this._ibatisBuilder.select("selectAllScheduledPosts").param("originIds", new ArrayList<EntityId>(parentIds))).asSetMultimap("originId", "messageId");
    }

    @Override
    public void forAllPublishedWorkstreamMessages(int chunkSize, Set<EntityId> parentIds, Consumer<ImmutableSet<WorkstreamMessageId>> consumer) {
        ((IbatisStandardResultBuilder)this._ibatisBuilder.select("selectAllPublishedPosts").param("originIds", new ArrayList<EntityId>(parentIds))).consumeChunkedSet(chunkSize, consumer);
    }
}

