/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.freiheit.toro.common.shared.model.ValidationException;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.album.business.AlbumService;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.comments.business.events.CommentCreatedEvent;
import de.justsoftware.onx.comments.shared.model.db.DBComment;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.configfile.ConfigService;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.deletion.DeleteTransactionCallback;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.deletion.DeletionService;
import de.justsoftware.onx.common.shared.model.JCMediaContentId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.common.shared.model.StartpageId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.EntityTypeAppMappingService;
import de.justsoftware.onx.container.business.events.ItemDeletedEvent;
import de.justsoftware.onx.container.shared.model.DefaultItemIdVisitor;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.container.shared.model.ModuleData;
import de.justsoftware.onx.container.shared.model.ValueTooLargeException;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import de.justsoftware.onx.container.shared.server.model.NewsPostItem;
import de.justsoftware.onx.drive.business.DriveInternalApiConnector;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.link.business.LinkService;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.onx.util.server.QuillParseUtils;
import de.justsoftware.onx.videolink.business.VideolinkService;
import de.justsoftware.onx.videolink.shared.model.VideolinkId;
import de.justsoftware.onx.workstream.business.WorkstreamDataService;
import de.justsoftware.onx.workstream.business.WorkstreamFilterConfValidator;
import de.justsoftware.onx.workstream.business.WorkstreamHandlerForTypeService;
import de.justsoftware.onx.workstream.business.WorkstreamMessageHandler;
import de.justsoftware.onx.workstream.business.WorkstreamMessageVisibilityPublisher;
import de.justsoftware.onx.workstream.business.WorkstreamScheduleService;
import de.justsoftware.onx.workstream.business.WorkstreamService;
import de.justsoftware.onx.workstream.business.WorkstreamTypeAttributeValue;
import de.justsoftware.onx.workstream.business.event.MicroblogAttachmentDeletedEvent;
import de.justsoftware.onx.workstream.business.event.MicroblogPostingPublishedEvent;
import de.justsoftware.onx.workstream.business.event.MicroblogPostingSavedEvent;
import de.justsoftware.onx.workstream.business.event.MicroblogPostingUpdatedEvent;
import de.justsoftware.onx.workstream.business.impl.AttachmentSavingVisitor;
import de.justsoftware.onx.workstream.business.impl.DBWorkstreamMessageCreator;
import de.justsoftware.onx.workstream.business.impl.DriveDocumentAttachmentCreator;
import de.justsoftware.onx.workstream.business.model.WorkstreamMessagePublishedStateFilter;
import de.justsoftware.onx.workstream.integration.persistence.WorkstreamDAO;
import de.justsoftware.onx.workstream.integration.persistence.model.DBWorkstreamMessageAttachment;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.FeedId;
import de.justsoftware.onx.workstream.shared.model.MultiWorkstreamFilterMessageType;
import de.justsoftware.onx.workstream.shared.model.PinnedWorkstream;
import de.justsoftware.onx.workstream.shared.model.StringForMessageVisitor;
import de.justsoftware.onx.workstream.shared.model.Workstream;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterContext;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterListModel;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterMessageType;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterModel;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import de.justsoftware.onx.workstream.shared.model.WorkstreamModuleData;
import de.justsoftware.onx.workstream.shared.model.attachments.Attachment;
import de.justsoftware.onx.workstream.shared.model.messages.ActivityWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.MicroblogPosting;
import de.justsoftware.onx.workstream.shared.model.messages.MicroblogPostingCreateModel;
import de.justsoftware.onx.workstream.shared.model.messages.MicroblogPostingEditModel;
import de.justsoftware.onx.workstream.shared.model.messages.WorkstreamMessage;
import de.justsoftware.onx.workstream.shared.server.model.FeedItem;
import de.justsoftware.onx.workstream.shared.server.model.MessagesAndCount;
import de.justsoftware.onx.workstream.shared.server.model.WorkstreamItem;
import de.justsoftware.polls.PollService;
import de.justsoftware.polls.model.Poll;
import de.justsoftware.polls.model.PollCreateModel;
import de.justsoftware.polls.model.pollid.PollId;
import de.justsoftware.polls.model.pollid.item.PollItem;
import de.justsoftware.toolbox.clock.Clock;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="workstreamService")
public class WorkstreamServiceImpl
implements ServerEventHandler,
WorkstreamService {
    private static final Logger LOG = LoggerFactory.getLogger(WorkstreamServiceImpl.class);
    private static final ImmutableSet<StaticAction> MESSAGE_CHECK_ACTIONS = ImmutableSet.of((Object)StaticAction.WORKSTREAM_DELETE, (Object)StaticAction.WORKSTREAM_EDIT, (Object)StaticAction.COMMENT_CREATE, (Object)StaticAction.WORKSTREAM_PIN);
    @Autowired
    private WorkstreamDataService _workstreamDataService;
    @Autowired
    private WorkstreamHandlerForTypeService _handlerForTypeService;
    @Autowired
    private Settings _settings;
    @Autowired
    private PersonService _personService;
    @Autowired
    private ProfileTeaserService _profileTeaserService;
    @Autowired
    private I18nService _i18nService;
    @Autowired
    private EntityService _entityService;
    @Autowired
    private JCEventBus _eventBus;
    @Autowired
    private ConfigService _configService;
    @Autowired
    private DeletionService _deletionService;
    @Autowired
    private AlbumService _albumService;
    @Autowired
    private VideolinkService _videolinkService;
    @Autowired
    private TransactionHelper _transactionHelper;
    @Autowired
    private LinkService _linkService;
    @Autowired
    private DriveDocumentAttachmentCreator _driveAttachmentCreator;
    @Autowired
    private DriveInternalApiConnector _driveInternalApiConnector;
    @Autowired
    private Clock _clock;
    @Autowired
    private WorkstreamScheduleService _scheduleService;
    @Autowired
    private EntityTypeAppMappingService _entityTypeAppMappingService;
    @Autowired
    private WorkstreamMessageVisibilityPublisher _workstreamMessageVisibilityPublisher;
    @Autowired
    private PollService _pollService;
    @Autowired
    private WorkstreamDAO _workstreamDAO;

    @Nonnull
    private WorkstreamMessage aggregate(@Nonnull WorkstreamMessage newEntry, @Nonnull AuthorizationCheckContextWithLocale authorizationContext) {
        WorkstreamMessageHandler<WorkstreamMessage> handler = this.getHandler(newEntry);
        if (!handler.isAggregatePossible()) {
            return newEntry;
        }
        WorkstreamMessageType newType = newEntry.getType();
        WorkstreamMessage oldEntry = this.fillAndConvert(this._workstreamDataService.getEntryByOriginAndType(newEntry.getOriginId(), newType), authorizationContext);
        if (oldEntry == null) {
            return newEntry;
        }
        if (new DateTime((Object)oldEntry.getCreatedAt()).plus((ReadableDuration)this._settings.getWorkstreamAggregateTimeLimit()).isBefore((ReadableInstant)this._clock.now())) {
            return newEntry;
        }
        PersonId oldAuthorId = oldEntry.getAuthorId();
        WorkstreamMessageType oldType = oldEntry.getType();
        if (!com.google.common.base.Objects.equal((Object)oldAuthorId, (Object)newEntry.getAuthorId()) || !com.google.common.base.Objects.equal((Object)oldType, (Object)newType)) {
            return newEntry;
        }
        WorkstreamMessage aggregatedEntry = handler.aggregate(oldEntry, newEntry);
        if (aggregatedEntry != null) {
            DeleteTransactionCallback callback = this._workstreamDataService.deleteEntriesByIds((Set<WorkstreamMessageId>)ImmutableSet.of((Object)((WorkstreamMessageId)oldEntry.getId())));
            callback.afterCommit();
            return aggregatedEntry;
        }
        return newEntry;
    }

    @Nonnull
    private WorkstreamMessageHandler<?> getHandler(@Nonnull WorkstreamMessageType type) {
        return this._handlerForTypeService.getHandler(type);
    }

    @Nonnull
    private <W extends WorkstreamMessage> WorkstreamMessageHandler<W> getHandler(@Nonnull W message) {
        return this._handlerForTypeService.getHandler(message.getType());
    }

    @Override
    public void create(ComponentType componentType, Iterable<DBEntity> entities, ServerEventCollector eventCollector) {
    }

    @Override
    public ImmutableSet<WorkstreamMessageId> getWorkstreamMessageIdsByOrigins(Set<? extends ItemId> originIds) {
        return this._workstreamDataService.getWorkstreamMessageIdsByOrigins(originIds);
    }

    @Override
    public ImmutableSet<WorkstreamMessageId> getWorkstreamMessageIdsByAttributes(Set<? extends ItemId> itemIds) {
        ImmutableSet.Builder attributes = ImmutableSet.builder();
        for (WorkstreamMessageType type : WorkstreamMessageType.values()) {
            for (Map.Entry entry : this.getHandler((WorkstreamMessage)((Object)type)).attributesToDelete(itemIds).entries()) {
                attributes.add((Object)new WorkstreamTypeAttributeValue(type, (String)entry.getKey(), (String)entry.getValue()));
            }
        }
        return this._workstreamDataService.getMessagesByAttributes((Set<WorkstreamTypeAttributeValue>)attributes.build());
    }

    @Override
    public ModuleData getModuleData(SearchAuthorizationCheckContext authorizationContext, EntityItem entity, ComponentType componentType) {
        return this.getModuleData(entity);
    }

    @Nonnull
    private ModuleData getModuleData(@Nonnull Item<? extends GlobalId> parentItem) {
        return new WorkstreamModuleData((GlobalId)parentItem.getId());
    }

    @Override
    public WorkstreamMessageId addMessageToStream(ActivityWorkstreamMessage message, AuthorizationCheckContextWithLocale authorizationContext) {
        WorkstreamMessageType type = message.getType();
        if (FluentIterable.from(this._configService.getPreventActivityMessageTypes()).transformAndConcat(WorkstreamFilterMessageType.GET_MESSAGE_TYPES).firstMatch(Predicates.equalTo((Object)type)).isPresent()) {
            return null;
        }
        WorkstreamMessage aggregatedMessage = this.aggregate(message, authorizationContext);
        DBWorkstreamMessage dbAggregatedMessage = aggregatedMessage.accept(DBWorkstreamMessageCreator.INSTANCE);
        return this._workstreamDataService.saveEntry(dbAggregatedMessage, aggregatedMessage.getAttachments(), null, this.getAttachmentProcessorForMessage(message));
    }

    @Override
    public MessagesAndCount getStream(ItemId itemId, boolean pinned, Date offset, int max, WorkstreamFilterModel filter, Date maxAge, SearchAuthorizationCheckContext authContext) {
        return this.getStreamInternal(itemId, WorkstreamMessagePublishedStateFilter.PUBLISHED, pinned, offset, max, filter, maxAge, authContext);
    }

    @Nonnull
    private MessagesAndCount getStreamInternal(@Nonnull ItemId itemId, @Nonnull WorkstreamMessagePublishedStateFilter publishedStateFilter, @Nullable Boolean pinned, @Nullable Date offset, int max, @Nonnull WorkstreamFilterModel filter, @Nullable Date maxAge, @Nonnull SearchAuthorizationCheckContext authContext) {
        WorkstreamFilterConfValidator.INSTANCE.checkWorkstreamFilterIsValid(itemId.getType(), filter);
        WorkstreamFilterModel filterForAppFeed = this.getFilterForAppFeed(itemId, filter);
        List<DBWorkstreamMessage> workstream = this._workstreamDataService.getWorkstream(itemId, publishedStateFilter, pinned, offset, maxAge, max, filterForAppFeed, authContext.getUserId(), (Set<String>)authContext.getStaticUserRolesForSearchQuery(), (ImmutableSet<ItemId>)ImmutableSet.of());
        return new MessagesAndCount(this.getMessages(workstream, (AuthorizationCheckContextWithLocale)authContext), workstream.size());
    }

    @Override
    public DateTime getNewestMessageDateForUser(Item<? extends ItemId> item, SearchAuthorizationCheckContext authCtx) {
        DBWorkstreamMessage result = this.getNewestMessage(item, authCtx);
        return result != null ? new DateTime((Object)result.getModifyDate()) : null;
    }

    @CheckForNull
    private DBWorkstreamMessage getNewestMessage(@Nonnull Item<? extends ItemId> item, @Nonnull SearchAuthorizationCheckContext authCtx) {
        WorkstreamFilterModel filter = this._configService.getDefaultWorkstreamFilter(item);
        Object itemId = item.getId();
        WorkstreamFilterModel filterForAppFeed = this.getFilterForAppFeed((ItemId)itemId, filter);
        List<DBWorkstreamMessage> resultList = this._workstreamDataService.getWorkstream((ItemId)itemId, WorkstreamMessagePublishedStateFilter.PUBLISHED, null, null, null, 1, filterForAppFeed, authCtx.getUserId(), (Set<String>)authCtx.getStaticUserRolesForSearchQuery(), (ImmutableSet<ItemId>)ImmutableSet.of());
        return (DBWorkstreamMessage)Iterables.getFirst(resultList, null);
    }

    private int getMaxOrDefaultLimit(Integer max) {
        if (max == null) {
            return 10;
        }
        return max;
    }

    @Override
    public Workstream getWorkstream(Item<? extends ItemId> item, Date offset, int max, WorkstreamFilterId filterId, Boolean showAllEntries, SearchAuthorizationCheckContext authorizationContext) {
        authorizationContext.check(item, (Action)StaticAction.WORKSTREAM_READ);
        this.verifyWorkstreamModuleEnabled((ItemId)item.getId(), authorizationContext);
        int limit = this.getMaxOrDefaultLimit(max);
        WorkstreamFilterListModel filters = this._configService.getWorkstreamFilters(item);
        WorkstreamFilterModel filter = WorkstreamFilterModel.getByIdOrDefault(filterId, filters);
        if (Boolean.TRUE.equals(showAllEntries)) {
            return this.getWorkstreamInternal(item, WorkstreamMessagePublishedStateFilter.PUBLISHED, null, offset, limit, filter, filters, authorizationContext);
        }
        Boolean showPinnedEntries = this.isShowPinnedWorkstream(item) ? Boolean.FALSE : null;
        return this.getWorkstreamInternal(item, WorkstreamMessagePublishedStateFilter.PUBLISHED, showPinnedEntries, offset, limit, filter, filters, authorizationContext);
    }

    @Override
    public Workstream getWorkstreamForMobile(Item<? extends ItemId> item, Date offset, int max, boolean includePinnedPosts, SearchAuthorizationCheckContext authorizationContext) {
        authorizationContext.check(item, (Action)StaticAction.WORKSTREAM_READ);
        this.verifyWorkstreamModuleEnabled((ItemId)item.getId(), authorizationContext);
        int limit = this.getMaxOrDefaultLimit(max);
        WorkstreamFilterContext filterContext = item.getId().getType() == ItemType.FEED ? WorkstreamFilterContext.DIRECT_SUBSCRIPTIONS : WorkstreamFilterContext.HERE;
        WorkstreamFilterModel filter = new WorkstreamFilterModel(new WorkstreamFilterId("MOBILE_FEED"), filterContext, (ImmutableSet<String>)ImmutableSet.of(), (ImmutableSet<? extends WorkstreamFilterMessageType>)ImmutableSet.of((Object)MultiWorkstreamFilterMessageType.MICROBLOG), limit);
        return this.getWorkstreamInternal(item, WorkstreamMessagePublishedStateFilter.PUBLISHED, includePinnedPosts ? null : Boolean.FALSE, offset, limit, filter, null, authorizationContext);
    }

    @Override
    @Nonnull
    public Workstream getScheduledWorkstream(Item<? extends ItemId> item, int limit, SearchAuthorizationCheckContext authorizationContext) {
        authorizationContext.check(item, (Action)StaticAction.WORKSTREAM_READ);
        this.verifyWorkstreamModuleEnabled((ItemId)item.getId(), authorizationContext);
        return this.getWorkstreamInternal(item, WorkstreamMessagePublishedStateFilter.SCHEDULED, null, null, limit, WorkstreamFilterModel.ALL, null, authorizationContext);
    }

    @Override
    public ImmutableList<WorkstreamMessage> getWorkstreamForNewsZoom(Set<ItemId> workstreamIds, int limit, Boolean returnPinnedMessages, SearchAuthorizationCheckContext authorizationContext) {
        ImmutableSet<EntityType> entityTypesForApp = this._entityTypeAppMappingService.getEntityTypesForApp(CoreApp.ARCHIVED_NEWS);
        ImmutableSet entityTypes = (ImmutableSet)entityTypesForApp.stream().map(EntityType::getName).collect(ImmutableSet.toImmutableSet());
        WorkstreamFilterModel newsZoomFilter = new WorkstreamFilterModel(new WorkstreamFilterId("NEWSZOOM"), WorkstreamFilterContext.ALL, (ImmutableSet<String>)entityTypes, (ImmutableSet<? extends WorkstreamFilterMessageType>)ImmutableSet.of((Object)MultiWorkstreamFilterMessageType.MICROBLOG), limit);
        FeedId itemIdForFeed = new FeedId(CoreApp.ARCHIVED_NEWS.getAppId());
        ImmutableSet workstreamIdsWithoutFeedId = (ImmutableSet)workstreamIds.stream().filter(Objects::nonNull).filter(itemId -> !itemId.equals(itemIdForFeed)).collect(ImmutableSet.toImmutableSet());
        List<DBWorkstreamMessage> workstream = this._workstreamDataService.getWorkstream(itemIdForFeed, WorkstreamMessagePublishedStateFilter.PUBLISHED, returnPinnedMessages, null, null, limit, newsZoomFilter, authorizationContext.getUserId(), (Set<String>)authorizationContext.getStaticUserRolesForSearchQuery(), (ImmutableSet<ItemId>)workstreamIdsWithoutFeedId);
        return this.getMessages(workstream, (AuthorizationCheckContextWithLocale)authorizationContext);
    }

    @Nonnull
    private WorkstreamFilterModel getFilterForAppFeed(@Nonnull ItemId itemId, @Nonnull WorkstreamFilterModel filter) {
        if (itemId.getType() != ItemType.FEED) {
            return filter;
        }
        CoreApp appFromId = CoreApp.byAppId(((FeedId)itemId).getAppId());
        if (appFromId == null) {
            return filter;
        }
        ImmutableSet<EntityType> entityTypesForApp = this._entityTypeAppMappingService.getEntityTypesForApp(appFromId);
        ImmutableSet entityTypes = (ImmutableSet)entityTypesForApp.stream().map(EntityType::getName).collect(ImmutableSet.toImmutableSet());
        ImmutableSet origins = filter.getOrigins().isEmpty() ? entityTypes : (ImmutableSet)filter.getOrigins().stream().filter(arg_0 -> ((ImmutableSet)entityTypes).contains(arg_0)).collect(ImmutableSet.toImmutableSet());
        return filter.cloneWithOrigins((ImmutableSet<String>)origins);
    }

    @Override
    public PinnedWorkstream getPinnedWorkstream(Item<? extends ItemId> item, Date offset, int max, SearchAuthorizationCheckContext authorizationContext) {
        WorkstreamFilterModel filter;
        authorizationContext.check(item, (Action)StaticAction.WORKSTREAM_READ);
        if (!this.isShowPinnedWorkstream(item)) {
            return new PinnedWorkstream((ImmutableList<WorkstreamMessage>)ImmutableList.of(), false, null);
        }
        int limit = this.getMaxOrDefaultLimit(max);
        switch (item.getId().getType()) {
            case STARTPAGE: {
                filter = this._configService.getDefaultWorkstreamFilter(item);
                break;
            }
            case FEED: {
                filter = this._configService.getDefaultWorkstreamFilter(item);
                break;
            }
            default: {
                filter = WorkstreamFilterModel.HERE;
            }
        }
        Workstream workstream = this.getWorkstreamInternal(item, WorkstreamMessagePublishedStateFilter.PUBLISHED, Boolean.TRUE, offset, limit, filter, null, authorizationContext);
        DateTime hideDateTime = this._workstreamDataService.getPinnedHideDate((ItemId)item.getId(), authorizationContext.getUserId());
        Date hideDate = hideDateTime != null ? hideDateTime.toDate() : null;
        return new PinnedWorkstream(workstream.getMessages(), workstream.hasMore(), hideDate);
    }

    private boolean isShowPinnedWorkstream(@Nonnull Item<? extends ItemId> item) {
        switch (item.getId().getType()) {
            case FEED: 
            case ENTITY: {
                return true;
            }
            case STARTPAGE: {
                return this._configService.isShowPinnedWorkstreamOnStartpage();
            }
        }
        return false;
    }

    @Nonnull
    private Workstream getWorkstreamInternal(@Nonnull Item<? extends ItemId> item, @Nonnull WorkstreamMessagePublishedStateFilter publishedStateFilter, @Nullable Boolean pinned, @Nullable Date offset, int limit, @Nonnull WorkstreamFilterModel filter, @Nullable WorkstreamFilterListModel filters, @Nonnull SearchAuthorizationCheckContext authorizationContext) {
        WorkstreamFilterListModel allFilters;
        MessagesAndCount entries = this.getStreamInternal((ItemId)item.getId(), publishedStateFilter, pinned, offset, limit + 1, filter, null, authorizationContext);
        WorkstreamFilterListModel workstreamFilterListModel = allFilters = filters != null ? filters : this._configService.getWorkstreamFilters(item);
        if (entries.getDbCount() > limit) {
            return new Workstream((ImmutableList<WorkstreamMessage>)ImmutableList.copyOf((Collection)entries.getMessages().subList(0, entries.getMessages().size() - 1)), true, allFilters);
        }
        return new Workstream(entries.getMessages(), false, allFilters);
    }

    @Override
    public void updatePinned(WorkstreamMessageId id, boolean pinned, AuthorizationCheckContextWithUserId authContext) {
        authContext.check((ItemId)id, (Action)StaticAction.WORKSTREAM_PIN);
        this._workstreamDataService.updatePinned(id, pinned, authContext.getUserId(), this._clock.now());
    }

    @Override
    public Date hidePinnedWorkstream(ItemId itemId, AuthorizationCheckContextWithUserId authContext) {
        authContext.check(itemId, (Action)StaticAction.WORKSTREAM_READ);
        DateTime hideDate = this._clock.now();
        this._workstreamDataService.updatePinnedHideDate(itemId, authContext.getUserId(), hideDate);
        return hideDate.toDate();
    }

    @Override
    public void unhidePinnedWorkstream(ItemId itemId, AuthorizationCheckContextWithUserId authContext) {
        authContext.check(itemId, (Action)StaticAction.WORKSTREAM_READ);
        this._workstreamDataService.deletePinnedHideDate(itemId, authContext.getUserId());
    }

    @Override
    public WorkstreamMessageId postToMicroblog(MicroblogPostingCreateModel posting, AuthorizationCheckContextWithUserId authorizationContext) throws ValueTooLargeException, ValidationException {
        PollCreateModel pollCreateModel;
        authorizationContext.check(posting.getOriginId(), (ImmutableSet<? extends Action>)ImmutableSet.of((Object)StaticAction.WORKSTREAM_POST));
        this.verifyWorkstreamModuleEnabled(posting.getOriginId(), authorizationContext);
        this.checkValidPublishDate(posting.getScheduledPublishDate());
        PersonId author = authorizationContext.getUserId();
        DBWorkstreamMessage dbMsg = this.createMicroblogDBModel(posting, author);
        WorkstreamMessageId newMessageId = this._workstreamDataService.saveEntry(dbMsg, posting.getAttachments(), posting.getCoverPictureId(), this.getAttachmentProcessorForPostingCreateModel(posting, author));
        if (this._settings.isQuickPollsEnabled() && (pollCreateModel = posting.getPoll()) != null) {
            Poll poll = this._pollService.createPoll(pollCreateModel.getQuestion(), pollCreateModel.getAnswers(), pollCreateModel.isAllowMultipleAnswers(), newMessageId, authorizationContext.getTenantId());
            int attachmentPosition = posting.getAttachments().size();
            this._workstreamDAO.saveAttachment(newMessageId, poll.getId(), attachmentPosition);
        }
        if (posting.isPinned() && authorizationContext.may((ItemId)newMessageId, (Action)StaticAction.WORKSTREAM_PIN)) {
            this._workstreamDataService.updatePinned(newMessageId, true, author, this._clock.now());
        }
        this._eventBus.post(new MicroblogPostingSavedEvent(newMessageId, author));
        if (posting.getScheduledPublishDate().isPresent()) {
            this._scheduleService.scheduleWorkstreamMessageForPublication(newMessageId, posting.getScheduledPublishDate().get());
            this._workstreamMessageVisibilityPublisher.publishVisibilityForScheduledPost(newMessageId, posting.getOriginId());
        } else {
            this._eventBus.post(new MicroblogPostingPublishedEvent(newMessageId, this.getAddedMentionedPersons(null, posting.getQuillDelta())));
        }
        return newMessageId;
    }

    private ImmutableSet<PersonId> getAddedMentionedPersons(@Nullable String previousQuillDelta, String newQuillDelta) {
        ImmutableSet<ProfileId> previousMentionedPersons = QuillParseUtils.parseMentions(previousQuillDelta);
        ImmutableSet<ProfileId> currentMentionedPersons = QuillParseUtils.parseMentions(newQuillDelta);
        return (ImmutableSet)Sets.difference(currentMentionedPersons, previousMentionedPersons).stream().map(ProfileId::asPersonId).collect(ImmutableSet.toImmutableSet());
    }

    private WorkstreamDataService.AttachmentProcessor getAttachmentProcessorForMessage(WorkstreamMessage msg) {
        return (attachments, messageId) -> {
            AttachmentSavingVisitor attachmentSavingVisitor = new AttachmentSavingVisitor(messageId, this._albumService, this._videolinkService, this._linkService, msg.getAuthorId(), msg.getOriginId(), this._transactionHelper, this._driveAttachmentCreator);
            for (Attachment attachment : attachments) {
                attachment.accept(attachmentSavingVisitor);
            }
            return attachments;
        };
    }

    private WorkstreamDataService.AttachmentProcessor getAttachmentProcessorForPostingCreateModel(MicroblogPostingCreateModel msg, PersonId authorId) {
        return (attachments, messageId) -> {
            AttachmentSavingVisitor attachmentSavingVisitor = new AttachmentSavingVisitor(messageId, this._albumService, this._videolinkService, this._linkService, authorId, msg.getOriginId(), this._transactionHelper, this._driveAttachmentCreator);
            for (Attachment attachment : attachments) {
                attachment.accept(attachmentSavingVisitor);
            }
            return attachments;
        };
    }

    @Nonnull
    private DBWorkstreamMessage createMicroblogDBModel(@Nonnull MicroblogPostingCreateModel msg, PersonId authorId) {
        DBWorkstreamMessage dbMsg = new DBWorkstreamMessage();
        Date nowDate = this._clock.nowDate();
        dbMsg.setCreateDate(nowDate);
        dbMsg.setPublishDate(msg.getScheduledPublishDate().isPresent() ? null : nowDate);
        dbMsg.setPublished(!msg.getScheduledPublishDate().isPresent());
        dbMsg.setModifyDate(nowDate);
        dbMsg.setAuthorId(authorId.asProfileId());
        dbMsg.setOriginItemId(msg.getOriginId());
        dbMsg.setSubjectItemId(msg.getOriginId());
        dbMsg.setType(WorkstreamMessageType.MICROBLOG_POSTING);
        dbMsg.setAttribute("text", msg.getText());
        dbMsg.setAttribute("title", msg.getTitle());
        dbMsg.setAttribute("quill_delta", msg.getQuillDelta());
        return dbMsg;
    }

    private void checkValidPublishDate(Optional<Date> publishDate) throws ValidationException {
        if (publishDate.isPresent() && publishDate.get().before(this._clock.nowDate())) {
            throw new ValidationException("Posts can't be scheduled in the past.");
        }
    }

    private void verifyWorkstreamModuleEnabled(@Nonnull ItemId globalId, final @Nonnull AuthorizationCheckContextWithLocale authorizationContext) {
        globalId.accept(new DefaultItemIdVisitor<Object>(){

            @Override
            public Object visit(EntityId entityId) {
                return this.exceptionIfNotVisible(WorkstreamServiceImpl.this._entityService.isEntityComponentVisible(entityId, StaticComponentType.WORKSTREAM));
            }

            @Override
            public Object visit(ProfileId profileId) {
                return this.exceptionIfNotVisible(WorkstreamServiceImpl.this._personService.isProfileComponentVisible(profileId.asPersonId(), StaticComponentType.WORKSTREAM, authorizationContext));
            }

            @Nonnull
            private Object exceptionIfNotVisible(boolean visible) {
                if (!visible) {
                    throw new PermissionDeniedException();
                }
                return this;
            }

            @Override
            public Object visit(StartpageId startpageId) {
                return this;
            }

            @Override
            public Object visit(FeedId feedId) {
                return this;
            }

            @Override
            public Object visitDefault(ItemId gId) {
                throw new PermissionDeniedException();
            }
        });
    }

    @Override
    public WorkstreamMessage getMessage(WorkstreamMessageId id, AuthorizationCheckContextWithLocale authorizationContext) {
        Optional<DBWorkstreamMessage> entry = this._workstreamDataService.getEntry(id);
        if (!entry.isPresent()) {
            return null;
        }
        authorizationContext.check(new WorkstreamItem(entry.get()), (Action)StaticAction.WORKSTREAM_READ);
        return this.fillAndConvert(entry.get(), authorizationContext);
    }

    @Override
    public ImmutableMap<WorkstreamMessageId, WorkstreamMessage> getMessages(Set<WorkstreamMessageId> ids, AuthorizationCheckContextWithLocale authorizationContext) {
        ImmutableMap<WorkstreamMessageId, DBWorkstreamMessage> entries = this._workstreamDataService.getEntries(ids);
        return Maps.uniqueIndex(this.getMessages((Iterable<DBWorkstreamMessage>)entries.values(), authorizationContext), Identifiables.toId());
    }

    @CheckForNull
    private WorkstreamMessage fillAndConvert(@Nullable DBWorkstreamMessage dbMsg, @Nonnull AuthorizationCheckContextWithLocale authorizationContext) {
        if (dbMsg == null) {
            return null;
        }
        return (WorkstreamMessage)Iterables.getFirst(this.getMessages((Iterable<DBWorkstreamMessage>)ImmutableList.of((Object)dbMsg), authorizationContext), null);
    }

    @Override
    public Boolean isOriginPubliclyVisible(ItemId originId, AuthorizationCheckContextWithLocale authContext) {
        ImmutableSet<Role> workstreamPublicRoles = this._configService.getWorkstreamPublicRoles();
        if (workstreamPublicRoles.isEmpty()) {
            return null;
        }
        DBEntity originEntity = this._entityService.getById(EntityId.parse(originId.asString()));
        if (originEntity == null) {
            return null;
        }
        AuthorizationCheckContext publicRolesAuthContext = authContext.getContextForRoles(workstreamPublicRoles);
        ImmutableSet publicVisibleOrigins = publicRolesAuthContext.filterAllowedIds(ImmutableSet.of((Object)originEntity.getId()), StaticEntityAction.ENTITY_READ_DETAILS);
        return this.isPubliclyVisible((Set<Role>)workstreamPublicRoles, (Set<EntityId>)publicVisibleOrigins, originEntity);
    }

    @Override
    public ImmutableList<WorkstreamMessage> getMessages(Iterable<DBWorkstreamMessage> messages, AuthorizationCheckContextWithLocale authorizationContext) {
        ImmutableSet<EntityId> publicVisibleOrigins;
        Map<PersonId, PersonTeaserModel> personTeasers = this.loadPersons(messages, authorizationContext);
        Map<EntityId, DBEntity> originEntities = this.loadOriginEntities(messages);
        ImmutableSet<Role> workstreamPublicRoles = this._configService.getWorkstreamPublicRoles();
        if (workstreamPublicRoles.isEmpty()) {
            publicVisibleOrigins = ImmutableSet.of();
        } else {
            AuthorizationCheckContext publicRolesAuthContext = authorizationContext.getContextForRoles(workstreamPublicRoles);
            publicVisibleOrigins = publicRolesAuthContext.filterAllowedIds(originEntities.keySet(), StaticEntityAction.ENTITY_READ_DETAILS);
        }
        Iterable workstreamItems = Iterables.transform(messages, WorkstreamItem.FROM_DB_WORKSTREAM_MESSAGE);
        ImmutableSetMultimap workstreamPermissions = authorizationContext.may(workstreamItems, MESSAGE_CHECK_ACTIONS);
        ImmutableMap mappedByType = Multimaps.index((Iterable)Iterables.filter(messages, (Predicate)Predicates.compose((Predicate)Predicates.notNull(), DBWorkstreamMessage.GET_TYPE)), DBWorkstreamMessage.GET_TYPE).asMap();
        ImmutableMap.Builder mappedResultBuilder = ImmutableMap.builder();
        for (Map.Entry entry : mappedByType.entrySet()) {
            mappedResultBuilder.putAll(this._handlerForTypeService.getHandler((WorkstreamMessageType)entry.getKey()).convert((Iterable)entry.getValue(), personTeasers, workstreamPermissions, authorizationContext));
        }
        ImmutableMap mappedResult = mappedResultBuilder.build();
        ImmutableList.Builder result = ImmutableList.builder();
        for (DBWorkstreamMessage dbMsg : messages) {
            try {
                WorkstreamMessage res = (WorkstreamMessage)mappedResult.get((Object)dbMsg.getId());
                if (res == null) continue;
                this.fill(dbMsg, res, this.isPubliclyVisible((Set<Role>)workstreamPublicRoles, (Set<EntityId>)publicVisibleOrigins, originEntities.get(dbMsg.getOriginItemId())), personTeasers, originEntities);
                result.add((Object)res);
            }
            catch (RuntimeException e) {
                LOG.error("Error creating WorkstreamMessage", (Throwable)e);
            }
        }
        return result.build();
    }

    @CheckForNull
    private Boolean isPubliclyVisible(@Nonnull Set<Role> workstreamPublicRoles, @Nonnull Set<EntityId> publicVisibleOrigins, @Nullable DBEntity originEntity) {
        if (workstreamPublicRoles.isEmpty()) {
            return null;
        }
        if (originEntity != null) {
            return publicVisibleOrigins.contains(originEntity.getId());
        }
        return null;
    }

    private void fill(@Nonnull DBWorkstreamMessage dbMsg, @Nonnull WorkstreamMessage res, @Nullable Boolean isPubliclyVisible, final @Nonnull Map<PersonId, PersonTeaserModel> personTeasers, final @Nonnull Map<EntityId, DBEntity> originEntities) {
        ItemId originItemId = dbMsg.getOriginItemId();
        DBEntity originEntity = originEntities.get(originItemId);
        res.setPubliclyVisible(isPubliclyVisible);
        if (originEntity != null) {
            res.setOriginEntityType(originEntity.getType());
        }
        String s = (String)originItemId.accept(new OriginImageUrlVisitor(personTeasers, originEntities)).orNull();
        res.setOriginImageUrl(s);
        res.setOriginName((String)originItemId.accept(new DefaultItemIdVisitor<com.google.common.base.Optional<String>>(){

            @Override
            public com.google.common.base.Optional<String> visit(ProfileId profileId) {
                return this.visitPerson(profileId.asPersonId());
            }

            @Override
            public com.google.common.base.Optional<String> visit(EntityId entityId) {
                DBEntity entity = (DBEntity)originEntities.get(entityId);
                return com.google.common.base.Optional.fromNullable((Object)(entity != null ? entity.getName() : null));
            }

            @Override
            public com.google.common.base.Optional<String> visit(StartpageId startpageId) {
                return this.visitPerson(startpageId.asPersonId());
            }

            @Nonnull
            private com.google.common.base.Optional<String> visitPerson(@Nonnull PersonId personId) {
                PersonTeaserModel person = (PersonTeaserModel)personTeasers.get(personId);
                return com.google.common.base.Optional.fromNullable((Object)(person != null ? person.getFullName() : null));
            }

            @Override
            public com.google.common.base.Optional<String> visitDefault(ItemId globalId) {
                return com.google.common.base.Optional.absent();
            }
        }).orNull());
    }

    @Nonnull
    private Map<PersonId, PersonTeaserModel> loadPersons(@Nonnull Iterable<? extends DBWorkstreamMessage> messages, @Nonnull AuthorizationCheckContextWithLocale authorizationContext) {
        final HashSet personIds = Sets.newHashSet();
        for (DBWorkstreamMessage dBWorkstreamMessage : messages) {
            if (dBWorkstreamMessage == null) continue;
            personIds.add(dBWorkstreamMessage.getAuthorId().asPersonId());
            dBWorkstreamMessage.getOriginItemId().accept(new DefaultItemIdVisitor<Object>(){

                @Override
                public Object visit(StartpageId startpageId) {
                    personIds.add(startpageId.asPersonId());
                    return this;
                }

                @Override
                public Object visit(ProfileId profileId) {
                    personIds.add(profileId.asPersonId());
                    return this;
                }

                @Override
                public Object visitDefault(ItemId globalId) {
                    return this;
                }
            });
            personIds.addAll(com.google.common.base.Optional.fromNullable((Object)MicroblogPosting.getEditedBy(dBWorkstreamMessage)).asSet());
            PersonId pinAuthorId = dBWorkstreamMessage.getPinAuthor();
            if (pinAuthorId == null) continue;
            personIds.add(pinAuthorId);
        }
        return this._profileTeaserService.getPersonTeaserForUserWithFullNames(personIds, authorizationContext);
    }

    @Nonnull
    private Map<EntityId, DBEntity> loadOriginEntities(@Nonnull Iterable<? extends DBWorkstreamMessage> messages) {
        HashSet<EntityId> entityIds = new HashSet<EntityId>();
        for (DBWorkstreamMessage dBWorkstreamMessage : messages) {
            ItemId globalId = dBWorkstreamMessage.getOriginItemId();
            if (!(globalId instanceof EntityId)) continue;
            entityIds.add((EntityId)globalId);
        }
        return this._entityService.getByIds(entityIds);
    }

    @Override
    public ImmutableMap<WorkstreamMessageId, DBWorkstreamMessage> getWorkstreamEntries(Set<WorkstreamMessageId> typedIds) {
        return this._workstreamDataService.getEntries(typedIds);
    }

    @Override
    public void deleteMessage(WorkstreamMessageId id, AuthorizationCheckContextWithUserId authorizationContext) {
        WorkstreamMessage msg = this.getMessage(id, authorizationContext);
        if (!(msg instanceof MicroblogPosting)) {
            return;
        }
        authorizationContext.check((ItemId)id, (Action)StaticAction.WORKSTREAM_DELETE);
        FluentIterable attachmentIds = FluentIterable.from((Iterable)this.getAttachedItems((Set<WorkstreamMessageId>)ImmutableSet.of((Object)id)).get((Object)id));
        Iterable callbacks = this._deletionService.deleteInTransactionWithDeleteAction((ItemId)id, authorizationContext.getUserId(), (Set<? extends ItemId>)attachmentIds.toSet(), (status, deleteAction) -> {
            ImmutableList.Builder callbackCollector = ImmutableList.builder();
            this.deleteAttachedImages((FluentIterable<ItemId>)attachmentIds, (ImmutableList.Builder<DeleteTransactionCallback>)callbackCollector);
            this.deleteAttachedVideos((FluentIterable<ItemId>)attachmentIds, (ImmutableList.Builder<DeleteTransactionCallback>)callbackCollector, msg.getOriginId());
            attachmentIds.filter(PollId.class).forEach(pollId -> callbackCollector.add(() -> this._pollService.deletePoll((PollId)pollId)));
            callbackCollector.add((Object)this._workstreamDataService.deleteEntriesByIds((Set<WorkstreamMessageId>)ImmutableSet.of((Object)id)));
            return callbackCollector.build();
        });
        for (DeleteTransactionCallback callback : callbacks) {
            callback.afterCommit();
        }
        this._eventBus.post(new ItemDeletedEvent(id));
    }

    private void deleteAttachedImages(@Nonnull FluentIterable<ItemId> attachmentIdsToDelete, @Nonnull ImmutableList.Builder<DeleteTransactionCallback> callbackCollector) {
        ImmutableSet imageIds = attachmentIdsToDelete.filter(AlbumImageId.class).toSet();
        if (!imageIds.isEmpty()) {
            callbackCollector.add((Object)this._albumService.deleteDependentImages((Set<AlbumImageId>)imageIds));
        }
    }

    private void deleteAttachedVideos(@Nonnull FluentIterable<ItemId> attachmentIdsToDelete, @Nonnull ImmutableList.Builder<DeleteTransactionCallback> callbackCollector, @Nonnull ItemId origin) {
        ImmutableSet videoLinkIds = attachmentIdsToDelete.filter(VideolinkId.class).toSet();
        if (!videoLinkIds.isEmpty()) {
            callbackCollector.add((Object)this._videolinkService.deleteDependentVideolinks((Set<VideolinkId>)videoLinkIds, (Set<ItemId>)ImmutableSet.of((Object)origin)));
        }
    }

    @Override
    public void deleteDependentMessages(Set<WorkstreamMessageId> ids, DeletionContext deletionContext) {
        deletionContext.attach(this._workstreamDataService.deleteEntriesByIds(ids));
    }

    @Override
    public String getStringForMessage(WorkstreamMessage msg, String locale) {
        return msg.accept(new StringForMessageVisitor(this._i18nService.getLocalizedMessages(locale)));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onCommentCreated(@Nonnull CommentCreatedEvent ev) {
        WorkstreamMessageId parentMessageId;
        DBComment comment = ev.getComment();
        ItemId parentId = comment.getParentId();
        if (parentId instanceof WorkstreamMessageId) {
            this._workstreamDataService.updateModifiedAt((WorkstreamMessageId)parentId, comment.getPostedAt());
        } else if (parentId instanceof GlobalId && (parentMessageId = (WorkstreamMessageId)this.getMicroblogEntryIdsByAttachments((Set<? extends ItemId>)ImmutableSet.of((Object)((GlobalId)parentId))).get((Object)parentId)) != null) {
            this._workstreamDataService.updateModifiedAt(parentMessageId, comment.getPostedAt());
        }
    }

    @Override
    public ImmutableMap<ItemId, WorkstreamMessageId> getWorkstreamEntryIdsByAttachments(Set<? extends ItemId> attachmentIds) {
        return this._workstreamDataService.getWorkstreamEntryIdsByAttachments(attachmentIds);
    }

    @Override
    public ImmutableMap<ItemId, WorkstreamMessageId> getMicroblogEntryIdsByAttachments(Set<? extends ItemId> attachmentIds) {
        return this._workstreamDataService.getMicroblogEntryIdsByAttachments(attachmentIds);
    }

    @Override
    public WorkstreamMessageId getWorkstreamEntryIdByAttachment(ItemId attachmentId) {
        return (WorkstreamMessageId)this.getWorkstreamEntryIdsByAttachments((Set<? extends ItemId>)ImmutableSet.of((Object)attachmentId)).get((Object)attachmentId);
    }

    @Override
    public ImmutableListMultimap<WorkstreamMessageId, ItemId> getAttachedItems(Set<WorkstreamMessageId> ids) {
        return this._workstreamDataService.getAttachedItemIds(ids);
    }

    @Override
    public ImmutableList<JCMediaContentId> getOtherAttachmentsOnSameWorkstreamEntry(JCMediaContentId attachmentId) {
        WorkstreamMessageId workstreamMessageId = this.getWorkstreamEntryIdByAttachment(attachmentId);
        if (workstreamMessageId == null) {
            return ImmutableList.of();
        }
        return JCMediaContentId.DEFAULT_ORDERING.immutableSortedCopy(Iterables.filter((Iterable)this.getAttachedItems((Set<WorkstreamMessageId>)ImmutableSet.of((Object)workstreamMessageId)).get((Object)workstreamMessageId), JCMediaContentId.class));
    }

    @Override
    public ImmutableSet<WorkstreamMessageId> getAllNewMessagesByOthersSince(Item<? extends ItemId> item, Date offset, SearchAuthorizationCheckContext authContext) {
        authContext.check(item, (Action)StaticAction.WORKSTREAM_READ);
        Object itemId = item.getId();
        this.verifyWorkstreamModuleEnabled((ItemId)itemId, authContext);
        WorkstreamFilterListModel filterListModel = this._configService.getWorkstreamFilters(item);
        WorkstreamFilterModel filterModel = (WorkstreamFilterModel)filterListModel.getFilters().get((Object)filterListModel.getDefaultfilter());
        return this._workstreamDataService.getAllNewMessagesByOthersSince((ItemId)itemId, offset, this.getFilterForAppFeed((ItemId)itemId, filterModel), authContext.getUserId(), (Set<String>)authContext.getStaticUserRolesForSearchQuery());
    }

    @Override
    public ImmutableMap<WorkstreamMessageId, Date> getNewMicroblogMessagesSince(Item<? extends ItemId> item, Date offset, SearchAuthorizationCheckContext authContext) {
        authContext.check(item, (Action)StaticAction.WORKSTREAM_READ);
        Object itemId = item.getId();
        this.verifyWorkstreamModuleEnabled((ItemId)itemId, authContext);
        WorkstreamFilterModel filter = this._configService.getDefaultWorkstreamFilter(item).cloneWithMessageTypes((ImmutableSet<? extends WorkstreamFilterMessageType>)ImmutableSet.of((Object)MultiWorkstreamFilterMessageType.MICROBLOG));
        WorkstreamFilterModel filterForAppFeed = this.getFilterForAppFeed((ItemId)itemId, filter);
        return this._workstreamDataService.getNewMessagesSince((ItemId)itemId, offset, filterForAppFeed, authContext.getUserId(), (Set<String>)authContext.getStaticUserRolesForSearchQuery());
    }

    @Override
    public void detachAttachment(WorkstreamMessageId messageId, ItemId attachmentId, ServerEventCollector serverEventCollector) {
        this._workstreamDataService.deleteAttachment(messageId, attachmentId);
        serverEventCollector.add(new MicroblogAttachmentDeletedEvent(messageId, attachmentId));
    }

    @Override
    public ImmutableMap<ItemId, DateTime> getNewestWorkstreamMessageDates(Iterable<? extends Item<? extends ItemId>> items) {
        final ImmutableMap.Builder result = ImmutableMap.builder();
        final ImmutableSetMultimap.Builder entitiesBuilder = ImmutableSetMultimap.builder();
        for (Item<? extends ItemId> item : items) {
            item.accept(new ItemVisitor.DefaultItemVisitor<Object>(){

                @Override
                public Object visit(EntityItem entityItem) {
                    entitiesBuilder.put((Object)WorkstreamServiceImpl.this.isDirectFilter(entityItem), (Object)entityItem.getId());
                    return this;
                }

                @Override
                protected Object visitDefaultGlobalIdItem(Item<? extends GlobalId> globalIdItem) {
                    result.put(globalIdItem.getId(), (Object)WorkstreamServiceImpl.this._clock.now());
                    return this;
                }

                @Override
                public Object visit(FeedItem feedItem) {
                    result.put((Object)feedItem.getId(), (Object)WorkstreamServiceImpl.this._clock.now());
                    return this;
                }

                @Override
                public Object visit(PollItem pollItem) {
                    return this;
                }

                @Override
                public Object visit(NewsPostItem newsPostItem) {
                    return this;
                }

                @Override
                protected Object visitDefault(Item<?> defaultItem) {
                    return this;
                }
            });
        }
        ImmutableSetMultimap entities = entitiesBuilder.build();
        result.putAll(this._workstreamDataService.getNewestWorkstreamDateDirect((Set<EntityId>)entities.get((Object)Boolean.TRUE)));
        result.putAll(this._workstreamDataService.getNewestWorkstreamDateIndirect((Set<EntityId>)entities.get((Object)Boolean.FALSE)));
        return result.build();
    }

    private boolean isDirectFilter(@Nonnull EntityItem item) {
        WorkstreamFilterModel filter = this._configService.getDefaultWorkstreamFilter(item);
        WorkstreamFilterContext filterContext = filter.getContext();
        switch (filterContext) {
            case ALL: {
                return false;
            }
            case HERE: {
                return true;
            }
            case DIRECT_SUBSCRIPTIONS: 
            case INDIRECT_ENTITY_SUBSCRIPTIONS: 
            case INDIRECT_PROFILE_SUBSCRIPTIONS: 
            case INDIRECT_SUBSCRIPTIONS: {
                throw new IllegalStateException(filterContext + " is not allowed for entities");
            }
        }
        throw new UnsupportedOperationException(filterContext + " is not implemented yet");
    }

    @Override
    public boolean keepMessageWithNoAttachments(WorkstreamMessageType type) {
        return this.getHandler((WorkstreamMessage)((Object)type)).keepMessageWithNoAttachments();
    }

    @Override
    public void editMicroblogPosting(MicroblogPostingEditModel editModel, AuthorizationCheckContextWithUserId authCtx) throws ValidationException {
        boolean isPublished;
        PollCreateModel pollCreateModel;
        WorkstreamMessageId msgId = editModel.getMessageId();
        authCtx.check((ItemId)msgId, (Action)StaticAction.WORKSTREAM_EDIT);
        this.checkValidPublishDate(editModel.getScheduledPublishedDate());
        Set attachmentsOfArticle = this._workstreamDAO.getAttachments(msgId).stream().map(DBWorkstreamMessageAttachment::getItemId).collect(Collectors.toUnmodifiableSet());
        if (!attachmentsOfArticle.containsAll((Collection<?>)editModel.getDeletedAttachments())) {
            throw new PermissionDeniedException();
        }
        if (this._settings.isQuickPollsEnabled() && (pollCreateModel = editModel.getPoll()) != null) {
            Poll poll = this._pollService.createPoll(pollCreateModel.getQuestion(), pollCreateModel.getAnswers(), pollCreateModel.isAllowMultipleAnswers(), msgId, authCtx.getTenantId());
            int attachmentPosition = this._workstreamDAO.getAttachments(editModel.getMessageId()).size();
            this._workstreamDAO.saveAttachment(msgId, poll.getId(), attachmentPosition);
        }
        String previousQuillDelta = this._workstreamDataService.getEntry(msgId).map(m -> m.getAttribute("quill_delta")).orElse(null);
        PersonId currentUserId = authCtx.getUserId();
        ImmutableMap attributeMap = ImmutableMap.builder().put((Object)"title", (Object)editModel.getTitle()).put((Object)"text", (Object)editModel.getText()).put((Object)"quill_delta", (Object)editModel.getQuillDelta()).put((Object)"edited_at", (Object)String.valueOf(this._clock.nowMillis())).put((Object)"edited_by", (Object)String.valueOf(currentUserId.getId())).build();
        this._workstreamDataService.updateAttributes(msgId, (Map<String, String>)attributeMap);
        this.handleAttachmentUpdates(editModel, currentUserId);
        if (authCtx.may((ItemId)msgId, (Action)StaticAction.WORKSTREAM_PIN)) {
            this.updatePinnedState(msgId, currentUserId, editModel.getPinned());
        }
        if (!(isPublished = this._workstreamDataService.getEntry(editModel.getMessageId()).map(DBWorkstreamMessage::getPublishDate).isPresent())) {
            this.updateScheduledPublicationDateOrPublishInstantly(msgId, editModel.getScheduledPublishedDate().orElse(null));
        }
        this._eventBus.post(new MicroblogPostingUpdatedEvent(msgId, authCtx.getUserId(), isPublished ? this.getAddedMentionedPersons(previousQuillDelta, editModel.getQuillDelta()) : ImmutableSet.of()));
    }

    private void handleAttachmentUpdates(MicroblogPostingEditModel editModel, PersonId currentUser) {
        WorkstreamMessageId messageId = editModel.getMessageId();
        ImmutableSet<ItemId> deletedDocuments = this.deleteDocuments(editModel.getDeletedAttachments(), currentUser);
        ImmutableSet<ItemId> deletedPolls = this.deletePolls(editModel.getDeletedAttachments());
        ImmutableSet successfullyDeletedAttachments = ImmutableSet.builder().addAll(deletedDocuments).addAll(deletedPolls).build();
        WorkstreamDataService.AttachmentProcessorForEdits attachmentProcessor = this.getAttachmentProcessorForEditingPost(messageId, currentUser);
        this._workstreamDataService.updateAttachments(messageId, editModel.getCoverPictureId(), (ImmutableSet<ItemId>)successfullyDeletedAttachments, editModel.getAddedAttachments(), attachmentProcessor);
    }

    private void updatePinnedState(WorkstreamMessageId messageId, PersonId author, @Nullable Boolean shouldPin) {
        if (shouldPin == null) {
            return;
        }
        this._workstreamDataService.updatePinned(messageId, Boolean.TRUE.equals(shouldPin), author, this._clock.now());
    }

    private ImmutableSet<ItemId> deleteDocuments(ImmutableList<ItemId> itemIds, PersonId currentUser) {
        return (ImmutableSet)itemIds.stream().distinct().filter(itemId -> itemId.getType().equals(ItemType.DRIVE_DOCUMENT)).map(itemId -> (DriveDocumentId)itemId).filter(documentId -> this._driveInternalApiConnector.deleteDocument(currentUser, (DriveDocumentId)documentId)).collect(ImmutableSet.toImmutableSet());
    }

    private ImmutableSet<ItemId> deletePolls(ImmutableList<ItemId> itemIds) {
        return (ImmutableSet)itemIds.stream().filter(i -> i.getType().equals(ItemType.POLL)).map(itemId -> this._pollService.deletePoll(new PollId(itemId.asString()))).collect(ImmutableSet.toImmutableSet());
    }

    private WorkstreamDataService.AttachmentProcessorForEdits getAttachmentProcessorForEditingPost(WorkstreamMessageId editedPostId, PersonId uploaderId) {
        return (attachments, originId) -> {
            AttachmentSavingVisitor attachmentSavingVisitor = new AttachmentSavingVisitor(editedPostId, this._albumService, this._videolinkService, this._linkService, uploaderId, originId, this._transactionHelper, this._driveAttachmentCreator);
            for (Attachment attachment : attachments) {
                attachment.accept(attachmentSavingVisitor);
            }
            return attachments;
        };
    }

    @Override
    public void publishScheduledMicroblogPostings() {
        LOG.debug("Checking for new posts to publish...");
        Date publishDate = this._clock.nowDate();
        ImmutableSet<WorkstreamMessageId> messagesToPublish = this._scheduleService.getScheduledByPublishDate(publishDate);
        LOG.debug("Found {} messages to publish.", (Object)messagesToPublish.size());
        this.publishScheduledPosts((Set<WorkstreamMessageId>)messagesToPublish, publishDate);
    }

    @Override
    public ImmutableMap<WorkstreamMessageId, Date> getScheduledPublishDatesForMessages(Set<WorkstreamMessageId> msgIds) {
        return this._scheduleService.getScheduledMessagesByMessageIds(msgIds);
    }

    private void updateScheduledPublicationDateOrPublishInstantly(@Nonnull WorkstreamMessageId msgId, @Nullable Date scheduledPublishDate) {
        if (scheduledPublishDate != null) {
            this._scheduleService.scheduleWorkstreamMessageForPublication(msgId, scheduledPublishDate);
        } else {
            this.publishScheduledPosts((Set<WorkstreamMessageId>)ImmutableSet.of((Object)msgId), this._clock.nowDate());
        }
    }

    private void publishScheduledPosts(@Nonnull Set<WorkstreamMessageId> messageIds, @Nonnull Date publishDate) {
        this._transactionHelper.doInTransactionWithoutResult(status -> {
            this._workstreamDataService.publish(messageIds, publishDate);
            this._scheduleService.removeScheduledPublicationDates(messageIds);
        });
        this._workstreamDataService.getEntries(messageIds).values().forEach(message -> this._eventBus.post(new MicroblogPostingPublishedEvent(message.getId(), this.getAddedMentionedPersons(null, message.getAttribute("quill_delta")))));
    }

    private static class OriginImageUrlVisitor
    implements DefaultItemIdVisitor<com.google.common.base.Optional<String>> {
        final Map<PersonId, PersonTeaserModel> _personTeasers;
        final Map<EntityId, DBEntity> _originEntities;

        public OriginImageUrlVisitor(@Nonnull Map<PersonId, PersonTeaserModel> personTeasers, @Nonnull Map<EntityId, DBEntity> originEntities) {
            this._personTeasers = personTeasers;
            this._originEntities = originEntities;
        }

        @Override
        public com.google.common.base.Optional<String> visit(ProfileId profileId) {
            PersonTeaserModel person = this._personTeasers.get(profileId.asPersonId());
            return com.google.common.base.Optional.fromNullable((Object)(person != null ? person.getLogo() : null));
        }

        @Override
        public com.google.common.base.Optional<String> visit(EntityId entityId) {
            DBEntity entity = this._originEntities.get(entityId);
            return com.google.common.base.Optional.fromNullable((Object)(entity != null ? entity.getLogo() : null));
        }

        @Override
        public com.google.common.base.Optional<String> visit(StartpageId startpageId) {
            PersonTeaserModel person = this._personTeasers.get(startpageId.asPersonId());
            return com.google.common.base.Optional.fromNullable((Object)(person != null ? person.getLogo() : null));
        }

        @Override
        public com.google.common.base.Optional<String> visitDefault(ItemId globalId) {
            return com.google.common.base.Optional.absent();
        }
    }
}

