/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.AuthorizationContextWithUserId;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.container.business.ItemService;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.workstream.business.WorkstreamReadDataService;
import de.justsoftware.onx.workstream.business.WorkstreamReadMonitor;
import de.justsoftware.onx.workstream.business.WorkstreamReadService;
import de.justsoftware.onx.workstream.business.WorkstreamService;
import de.justsoftware.onx.workstream.shared.model.FeedId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamReadClientModel;
import de.justsoftware.onx.workstream.shared.model.WorkstreamReadConfig;
import de.justsoftware.toolbox.clock.Clock;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.base.AbstractInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkstreamReadServiceImpl
implements WorkstreamReadService {
    private final WorkstreamService _workstreamService;
    private final WorkstreamReadDataService _workstreamReadDataService;
    private final ItemService _itemService;
    private final Clock _clock;
    private final WorkstreamReadMonitor _workstreamReadMonitor;
    private final Settings _settings;

    @Autowired
    @ParametersAreNonnullByDefault
    public WorkstreamReadServiceImpl(WorkstreamService workstreamService, WorkstreamReadDataService workstreamReadDataService, ItemService itemService, Clock clock, WorkstreamReadMonitor workstreamReadMonitor, Settings settings) {
        this._workstreamService = workstreamService;
        this._workstreamReadDataService = workstreamReadDataService;
        this._itemService = itemService;
        this._clock = clock;
        this._workstreamReadMonitor = workstreamReadMonitor;
        this._settings = settings;
    }

    @Override
    public ImmutableMap<ItemId, WorkstreamReadClientModel> getUnreadWorkstreamEntries(Map<? extends ItemId, WorkstreamReadClientModel> existingEntriesUnfiltered, Set<? extends ItemId> unknownUnfiltered, SearchAuthorizationCheckContext authCtx) {
        WorkstreamReadConfig workstreamReadConfig = this._settings.getWorkstreamReadConfig();
        if (!workstreamReadConfig.isPollingEnabled()) {
            return ImmutableMap.of();
        }
        PersonId userId = authCtx.getUserId();
        Predicate filter = workstreamReadConfig == WorkstreamReadConfig.ONLY_STARTPAGE ? Predicates.instanceOf(FeedId.class) : Predicates.alwaysTrue();
        Map existingEntries = Maps.filterKeys(existingEntriesUnfiltered, (Predicate)filter);
        Set unknown = Sets.filter(unknownUnfiltered, (Predicate)filter);
        this._workstreamReadMonitor.count(WorkstreamReadMonitor.What.TOTAL_REQUESTS);
        this._workstreamReadMonitor.count(WorkstreamReadMonitor.What.TOTAL_REQUESTS_EXISTING_PARAMS, existingEntries.size());
        this._workstreamReadMonitor.count(WorkstreamReadMonitor.What.TOTAL_REQUESTS_UNKNOWN_PARAMS, unknown.size());
        Sets.SetView allItemIds = Sets.union(existingEntries.keySet(), (Set)unknown);
        ImmutableMap allItems = this._itemService.getByIds(allItemIds);
        ImmutableMap allowedItems = Maps.uniqueIndex(authCtx.filterAllowedItems(allItems.values(), StaticAction.WORKSTREAM_READ), Identifiables.toId());
        ImmutableMap.Builder result = ImmutableMap.builder();
        ImmutableSetMultimap personsAndItems = ImmutableSetMultimap.builder().putAll((Object)userId, (Iterable)allowedItems.keySet()).build();
        ImmutableMap readMarkers = this._workstreamReadDataService.getByPersonsAndItems((SetMultimap<? extends PersonId, ? extends ItemId>)personsAndItems).row((Object)userId);
        ImmutableCollection items = allowedItems.values();
        ImmutableMap<ItemId, DateTime> newestMessages = this._workstreamService.getNewestWorkstreamMessageDates((Iterable<? extends Item<? extends ItemId>>)items);
        for (Item item : allowedItems.values()) {
            Object id = item.getId();
            DateTime readDate = WorkstreamReadServiceImpl.maxDate(this._settings.getWorkstreamReadMinDate(), (DateTime)readMarkers.get(id));
            DateTime newestDate = (DateTime)newestMessages.get(id);
            WorkstreamReadClientModel existing = (WorkstreamReadClientModel)existingEntries.get(id);
            WorkstreamReadClientModel fastChecked = this.fastCheck(existing, readDate, newestDate);
            if (fastChecked != null) {
                this._workstreamReadMonitor.count(WorkstreamReadMonitor.What.FAST_CHECK);
                result.put(id, (Object)fastChecked);
                continue;
            }
            this._workstreamReadMonitor.count(WorkstreamReadMonitor.What.HANDLE_MISSING);
            result.put(id, (Object)this.handleMissing(authCtx, item, readDate, newestDate));
        }
        return result.build();
    }

    @Override
    public Date getLastWorkstreamReadDateForUser(ItemId itemId, SearchAuthorizationCheckContext authCtx) {
        authCtx.check(itemId, (Action)StaticAction.WORKSTREAM_READ);
        PersonId personId = authCtx.getUserId();
        ImmutableCollection readDates = this._workstreamReadDataService.getByPersonsAndItems((SetMultimap<? extends PersonId, ? extends ItemId>)ImmutableSetMultimap.of((Object)personId, (Object)itemId)).values();
        return readDates.stream().max(AbstractInstant::compareTo).map(AbstractInstant::toDate).orElse(null);
    }

    @Nonnull
    private static <T extends ReadableInstant> T maxDate(@Nonnull T a, @Nullable T b) {
        if (b == null) {
            return a;
        }
        return b.isAfter(a) ? b : a;
    }

    @Nonnull
    private WorkstreamReadClientModel handleMissing(@Nonnull SearchAuthorizationCheckContext authCtx, @Nonnull Item<? extends ItemId> item, @Nullable DateTime readDate, @Nullable DateTime newestDate) {
        DateTime newestMessageDateTime = this._workstreamService.getNewestMessageDateForUser(item, authCtx);
        boolean read = newestMessageDateTime == null || readDate != null && newestMessageDateTime.isBefore((ReadableInstant)readDate);
        return new WorkstreamReadClientModel(read, WorkstreamReadServiceImpl.toDate(newestMessageDateTime), WorkstreamReadServiceImpl.toDate(newestDate));
    }

    @CheckForNull
    private WorkstreamReadClientModel fastCheck(@Nullable WorkstreamReadClientModel existing, @Nonnull DateTime readDate, @Nullable DateTime newestDate) {
        if (newestDate == null) {
            return new WorkstreamReadClientModel(true, null, null);
        }
        if (readDate.isAfter((ReadableInstant)newestDate)) {
            return new WorkstreamReadClientModel(true, null, newestDate.toDate());
        }
        if (existing == null) {
            return null;
        }
        DateTime lastDate = WorkstreamReadServiceImpl.toDateTime(existing.getLastDate());
        if (newestDate.equals((Object)lastDate)) {
            return existing;
        }
        DateTime lastVisibleDate = WorkstreamReadServiceImpl.toDateTime(existing.getLastVisibleDate());
        if (lastVisibleDate != null && readDate.isBefore((ReadableInstant)lastVisibleDate)) {
            return new WorkstreamReadClientModel(false, lastVisibleDate.toDate(), newestDate.toDate());
        }
        return null;
    }

    @CheckForNull
    private static Date toDate(@Nullable DateTime newestMessageDateTime) {
        return newestMessageDateTime != null ? newestMessageDateTime.toDate() : null;
    }

    @CheckForNull
    private static DateTime toDateTime(@Nullable Date date) {
        return date != null ? new DateTime((Object)date) : null;
    }

    @Override
    public void markRead(ItemId id, AuthorizationContextWithUserId authCtx) {
        if (this._settings.getWorkstreamReadConfig().isMarkReadEnabled()) {
            PersonId userId = authCtx.getUserId();
            this._workstreamReadDataService.markRead(userId, id, this._clock.now());
        }
    }
}

