/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.business.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.workstream.business.WorkstreamReadDataService;
import de.justsoftware.onx.workstream.business.WorkstreamReadDeletionHandler;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkstreamReadDeletionHandlerImpl
implements WorkstreamReadDeletionHandler {
    private final WorkstreamReadDataService _workstreamReadDataService;

    @ParametersAreNonnullByDefault
    @Autowired
    public WorkstreamReadDeletionHandlerImpl(WorkstreamReadDataService workstreamReadDataService) {
        this._workstreamReadDataService = workstreamReadDataService;
    }

    @Override
    public void handleCascadeDelete(Set<? extends ItemId> parentIds, DeletionContext deletionContext) {
        ImmutableSet personIds = FluentIterable.from(parentIds).filter(ProfileId.class).transform(ProfileId.TO_PERSON_ID).toSet();
        ImmutableSet allIds = ImmutableSet.builder().addAll((Iterable)FluentIterable.from(parentIds).filter(GlobalId.class)).addAll(Iterables.transform((Iterable)personIds, PersonId.AS_STARTPAGE_ID)).build();
        this._workstreamReadDataService.deleteReadEntries((Set<PersonId>)personIds, (Set<? extends ItemId>)allIds);
    }
}

