/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.cache.ehcache.EhCacheName;
import com.freiheit.toro.cache.ehcache.EhcacheClient;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.SetMultimap;
import de.justsoftware.onx.common.cache.AbstractRelationalCacheAccessor;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.workstream.business.WorkstreamReadDataService;
import de.justsoftware.onx.workstream.business.WorkstreamReadMonitor;
import de.justsoftware.onx.workstream.integration.persistence.WorkstreamReadDAO;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkstreamReadDataServiceImpl
implements WorkstreamReadDataService {
    private final WorkstreamReadDAO _workstreamReadDAO;
    private final WorkstreamReadByPersonAndItemCacheAccessor _byPersonAndItemCacheAccessor;
    private final WorkstreamReadMonitor _workstreamReadMonitor;

    @Autowired
    @ParametersAreNonnullByDefault
    public WorkstreamReadDataServiceImpl(WorkstreamReadDAO workstreamReadDAO, EhcacheClient cache, WorkstreamReadMonitor workstreamReadMonitor, Settings settings) {
        this._workstreamReadDAO = workstreamReadDAO;
        this._workstreamReadMonitor = workstreamReadMonitor;
        this._byPersonAndItemCacheAccessor = new WorkstreamReadByPersonAndItemCacheAccessor(cache, workstreamReadDAO, workstreamReadMonitor);
        settings.getWorkstreamReadConfigProperty().addSuperopertyChangeListener(listener -> this._byPersonAndItemCacheAccessor.invalidateAll());
    }

    @Override
    public void markRead(PersonId personId, ItemId itemId, DateTime readDate) {
        this._workstreamReadMonitor.count(WorkstreamReadMonitor.What.WORKSTREAM_READ_MARK_READ);
        this._workstreamReadDAO.markRead(personId, itemId, readDate);
        this._byPersonAndItemCacheAccessor.invalidateKey(personId, itemId);
    }

    @Override
    public ImmutableTable<PersonId, ItemId, DateTime> getByPersonsAndItems(SetMultimap<? extends PersonId, ? extends ItemId> personsAndItems) {
        this._workstreamReadMonitor.count(WorkstreamReadMonitor.What.WORKSTREAM_READ_REQUEST);
        this._workstreamReadMonitor.count(WorkstreamReadMonitor.What.WORKSTREAM_READ_REQUEST_PARAMS, personsAndItems.size());
        return this._byPersonAndItemCacheAccessor.getTable(personsAndItems);
    }

    @Override
    public void deleteReadEntries(Set<PersonId> personIds, Set<? extends ItemId> itemIds) {
        this._workstreamReadMonitor.count(WorkstreamReadMonitor.What.WORKSTREAM_READ_DELETE);
        this._workstreamReadMonitor.count(WorkstreamReadMonitor.What.WORKSTREAM_READ_DELETE_PERSONS, personIds.size());
        this._workstreamReadMonitor.count(WorkstreamReadMonitor.What.WORKSTREAM_READ_DELETE_ITEMS, itemIds.size());
        if (personIds.isEmpty() && itemIds.isEmpty()) {
            return;
        }
        this._workstreamReadDAO.deleteReadEntries(personIds, itemIds);
    }

    private static class WorkstreamReadByPersonAndItemCacheAccessor
    extends AbstractRelationalCacheAccessor<WorkstreamReadEhcacheName, PersonId, ItemId, DateTime> {
        private final WorkstreamReadDAO _dao;
        private final WorkstreamReadMonitor _workstreamReadMonitor;

        protected WorkstreamReadByPersonAndItemCacheAccessor(@Nonnull EhcacheClient cache, @Nonnull WorkstreamReadDAO dao, @Nonnull WorkstreamReadMonitor workstreamReadMonitor) {
            super(cache, WorkstreamReadEhcacheName.BY_PERSON_AND_ITEM);
            this._dao = dao;
            this._workstreamReadMonitor = workstreamReadMonitor;
        }

        @Override
        protected String keyToString(PersonId left, ItemId right) {
            return left + "_" + right;
        }

        @Override
        public ImmutableTable<PersonId, ItemId, DateTime> getFromDatabase(ImmutableSetMultimap<PersonId, ItemId> param) {
            this._workstreamReadMonitor.count(WorkstreamReadMonitor.What.WORKSTREAM_READ_CACHE_MISS);
            this._workstreamReadMonitor.count(WorkstreamReadMonitor.What.WORKSTREAM_READ_CACHE_MISS_PARAMS, param.size());
            return this._dao.getByPersonsAndItems((SetMultimap<? extends PersonId, ? extends ItemId>)param);
        }
    }

    public static enum WorkstreamReadEhcacheName implements EhCacheName
    {
        BY_PERSON_AND_ITEM;


        @Override
        public String getCacheName() {
            return this.name();
        }

        @Override
        public int getMaxElements() {
            return 20000;
        }
    }
}

