/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.business.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.justsoftware.onx.common.business.events.ServerEvent;
import de.justsoftware.onx.common.business.events.util.CollectingServerEventCollector;
import de.justsoftware.onx.common.deletion.CascadeDeleteService;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.container.business.events.WorkstreamModuleDeletedEvent;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.workstream.business.WorkstreamDataService;
import de.justsoftware.onx.workstream.business.WorkstreamMessageDeletionHandler;
import de.justsoftware.onx.workstream.business.WorkstreamService;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkstreamMessageDeletionHandlerImpl
implements WorkstreamMessageDeletionHandler {
    @Autowired
    private WorkstreamService _workstreamService;
    @Autowired
    private WorkstreamDataService _workstreamDataService;
    @Autowired
    private CascadeDeleteService _cascadeDeleteService;

    @Override
    public void handleCascadeDelete(Set<? extends ItemId> parentIds, DeletionContext context) {
        ImmutableSet<WorkstreamMessageId> messageIdsToDeleteByAttributes = this.handleDeleteMessagesByOriginAndAttributes(parentIds, context);
        Set<WorkstreamMessageId> messageIdsToDeleteByAttachments = this.handleDeleteMessagesByAttachment((Set<? extends GlobalId>)FluentIterable.from(parentIds).filter(GlobalId.class).toSet(), context);
        Sets.SetView messageIdsToDelete = Sets.union(messageIdsToDeleteByAttachments, messageIdsToDeleteByAttributes);
        this._cascadeDeleteService.cascadeDelete((Set<? extends ItemId>)messageIdsToDelete, context);
        this._workstreamService.deleteDependentMessages((Set<WorkstreamMessageId>)messageIdsToDelete, context);
        this._workstreamDataService.deletePinnedHideDatesByOrigins(parentIds);
    }

    @Nonnull
    private ImmutableSet<WorkstreamMessageId> handleDeleteMessagesByOriginAndAttributes(@Nonnull Set<? extends ItemId> parentIds, @Nonnull DeletionContext context) {
        ImmutableSet<WorkstreamMessageId> originMessageIds = this._workstreamService.getWorkstreamMessageIdsByOrigins(parentIds);
        ImmutableSet<WorkstreamMessageId> attributeMessageIds = this._workstreamService.getWorkstreamMessageIdsByAttributes(parentIds);
        ImmutableSet messageIdsToDelete = context.filterItemsNotYetDeleted(Sets.union(originMessageIds, attributeMessageIds));
        context.addDeletedItems((Iterable<? extends ItemId>)messageIdsToDelete);
        if (!messageIdsToDelete.isEmpty()) {
            context.addServerEvent(new WorkstreamModuleDeletedEvent(messageIdsToDelete));
        }
        return messageIdsToDelete;
    }

    @Nonnull
    private Set<WorkstreamMessageId> handleDeleteMessagesByAttachment(@Nonnull Set<? extends GlobalId> parentIds, DeletionContext context) {
        ImmutableMap<ItemId, WorkstreamMessageId> messageIds = this._workstreamService.getWorkstreamEntryIdsByAttachments(parentIds);
        ImmutableMap<WorkstreamMessageId, DBWorkstreamMessage> messages = this._workstreamService.getWorkstreamEntries((Set<WorkstreamMessageId>)ImmutableSet.copyOf((Collection)messageIds.values()));
        HashSet messagesToCheck = Sets.newHashSet();
        CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        for (Map.Entry entry : messageIds.entrySet()) {
            this._workstreamService.detachAttachment((WorkstreamMessageId)entry.getValue(), (ItemId)entry.getKey(), eventCollector);
            if (this._workstreamService.keepMessageWithNoAttachments(((DBWorkstreamMessage)messages.get(entry.getValue())).getType())) continue;
            messagesToCheck.add((WorkstreamMessageId)entry.getValue());
        }
        for (ServerEvent serverEvent : eventCollector.getEvents()) {
            context.addServerEvent(serverEvent);
        }
        ImmutableListMultimap<WorkstreamMessageId, ItemId> attachedItems = this._workstreamDataService.getAttachedItemIds(messagesToCheck);
        return Sets.difference((Set)messagesToCheck, (Set)attachedItems.keySet());
    }
}

