/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.business.impl;

import com.google.common.base.Optional;
import de.justsoftware.onx.common.shared.server.util.TokenUtilServer;
import de.justsoftware.onx.common.shared.util.DefaultHistoryTokenVisitor;
import de.justsoftware.onx.common.shared.util.HistoryToken;
import de.justsoftware.onx.common.shared.util.HistoryTokenParser;
import de.justsoftware.onx.common.shared.util.TokenUtil;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.link.shared.server.model.LinkModel;
import de.justsoftware.onx.linkinfo.shared.model.LinkType;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import de.justsoftware.onx.workstream.shared.model.attachments.ExternalLinkAttachment;
import de.justsoftware.onx.workstream.shared.model.attachments.InternalLinkAttachment;
import de.justsoftware.onx.workstream.shared.model.attachments.LinkAttachment;
import de.justsoftware.onx.workstream.shared.model.attachments.MailToLinkAttachment;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class LinkAttachmentConverter
extends NullPermeableFunction<LinkModel, LinkAttachment> {
    private static final Logger LOG = LoggerFactory.getLogger(LinkAttachmentConverter.class);

    @Nonnull
    private ExternalLinkAttachment externalLinkAttachment(LinkModel link) {
        return new ExternalLinkAttachment(link.getId(), link.getUrl());
    }

    @Override
    protected LinkAttachment applySafe(LinkModel link) {
        String url = link.getUrl();
        LinkType linkType = LinkType.getLinkType(url);
        switch (linkType) {
            case EXTERNAL: {
                return this.externalLinkAttachment(link);
            }
            case INTERNAL: {
                try {
                    boolean isJustContextPreviewUrl = url.contains("?");
                    if (isJustContextPreviewUrl) {
                        return new InternalLinkAttachment(link.getId(), url, link.getTitle(), null);
                    }
                    HistoryTokenParser parsed = TokenUtilServer.INSTANCE.parse(url);
                    HistoryToken token = parsed.getToken();
                    List<HistoryTokenParser.TokenParam> params = parsed.getParams();
                    if (token != null && params.size() > 0) {
                        Optional<GlobalId> extractedId = token.accept(new InternalLinkExtractorVisitor(params));
                        return new InternalLinkAttachment(link.getId(), url, link.getTitle(), (GlobalId)extractedId.orNull());
                    }
                    return this.externalLinkAttachment(link);
                }
                catch (TokenUtil.TokenParseException e) {
                    LOG.warn(String.format("Failed to create internal link for url %s. Treating link as external link", url), (Throwable)e);
                    return this.externalLinkAttachment(link);
                }
            }
            case MAILTO: {
                return new MailToLinkAttachment(link.getId(), url);
            }
        }
        throw new UnsupportedOperationException("missing case for " + linkType);
    }

    private static class InternalLinkExtractorVisitor
    extends DefaultHistoryTokenVisitor<Optional<GlobalId>> {
        private final List<HistoryTokenParser.TokenParam> _parsedToken;

        public InternalLinkExtractorVisitor(@Nonnull List<HistoryTokenParser.TokenParam> parsedParams) {
            this._parsedToken = parsedParams;
        }

        @Override
        public Optional<GlobalId> visitEntity(HistoryToken historyToken) {
            return this.createGlobalId(ItemType.ENTITY);
        }

        @Override
        public Optional<GlobalId> visitProfile(HistoryToken historyToken) {
            return this.createGlobalId(ItemType.PROFILE);
        }

        @Nonnull
        private Optional<GlobalId> createGlobalId(@Nonnull ItemType itemType) {
            Long l = this._parsedToken.get(0).asLong();
            if (l == null) {
                return Optional.absent();
            }
            return Optional.of((Object)GlobalId.create(l, itemType));
        }

        @Override
        public Optional<GlobalId> visitDefault(HistoryToken historyToken) {
            return Optional.absent();
        }
    }
}

