/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.business.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.drive.business.model.DriveUploadResultModel;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestOperations;

@Service
@ParametersAreNonnullByDefault
public class DriveDocumentAttachmentCreator {
    private final String _apiUrl;
    private final RestOperations _restTemplate;

    @Autowired
    public DriveDocumentAttachmentCreator(@Value(value="${just-drive.internalApi.url}") String driveInternalApiUrl, @Qualifier(value="defaultRestTemplate") RestOperations restTemplate) {
        this._apiUrl = driveInternalApiUrl;
        this._restTemplate = restTemplate;
    }

    @Nonnull
    ImmutableMap<UUID, DriveDocumentId> attachTempFilesToWorkstreamItem(Set<UUID> tempDriveFileIds, WorkstreamMessageId messageId, PersonId ownerId, ItemId parentId) {
        TempFileMoveRequest postData = new TempFileMoveRequest((List<UUID>)ImmutableList.copyOf(tempDriveFileIds), messageId, parentId, ownerId);
        Map result = (Map)this._restTemplate.postForObject(this._apiUrl + "/tmp/move", (Object)postData, MoveAttachmentResult.class, new Object[0]);
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)result, DriveUploadResultModel::getId));
    }

    private static class MoveAttachmentResult
    extends HashMap<UUID, DriveUploadResultModel> {
        private static final long serialVersionUID = 1L;

        private MoveAttachmentResult() {
        }
    }

    @ParametersAreNonnullByDefault
    private static class TempFileMoveRequest {
        private final List<UUID> _tempFileIds;
        private final String _targetItemId;
        private final String _parentItemId;
        private final Long _ownerId;

        TempFileMoveRequest(List<UUID> tempFileIds, ItemId targetItemId, ItemId parentItemId, PersonId ownerId) {
            this._tempFileIds = tempFileIds;
            this._targetItemId = targetItemId.asString();
            this._parentItemId = parentItemId.asString();
            this._ownerId = ownerId.getId();
        }

        @JsonProperty(value="tempFileIds")
        @Nonnull
        public List<UUID> getTempFileIds() {
            return this._tempFileIds;
        }

        @JsonProperty(value="targetItemId")
        @Nonnull
        public String getTargetItemId() {
            return this._targetItemId;
        }

        @JsonProperty(value="parentItemId")
        @Nonnull
        public String getParentItemId() {
            return this._parentItemId;
        }

        @Nonnull
        @JsonProperty(value="ownerId")
        public Long getOwnerId() {
            return this._ownerId;
        }
    }
}

