/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.business.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.EverythingAllowedAuthorizationCheckContextWithLocale;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.deletion.DeleteTransactionCallback;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.shared.model.DefaultItemIdVisitor;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.drive.business.model.DriveChangePurpose;
import de.justsoftware.onx.drive.business.model.DriveRestorePurpose;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.kafka.KafkaConsumerContext;
import de.justsoftware.onx.workstream.business.WorkstreamDataService;
import de.justsoftware.onx.workstream.business.WorkstreamService;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import de.justsoftware.onx.workstream.shared.model.messages.DriveDocumentNewVersion;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.joda.time.base.AbstractInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class DriveChangeWorkstreamMessageCreator
implements DefaultItemIdVisitor<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DriveChangeWorkstreamMessageCreator.class);
    private static final ImmutableSet<DriveChangePurpose> NO_ACTIVITIY_PURPOSES = ImmutableSet.of((Object)DriveChangePurpose.IMPORT, (Object)DriveRestorePurpose.RESTORE_ENTITY_VERSION);
    private final ArrayNode _triggers;
    private final Optional<PersonId> _ownerId;
    private final WorkstreamService _workstreamService;
    private final WorkstreamDataService _wsDataService;
    private final EntityConfigService _entityConfigService;
    private final EntityService _entityService;
    private final Optional<DriveChangePurpose> _changePurpose;
    private final Optional<DateTime> _changeDate;
    private final KafkaConsumerContext _kafkaConsumerContext;

    DriveChangeWorkstreamMessageCreator(ArrayNode triggers, Optional<PersonId> ownerId, Optional<DateTime> changeDate, Optional<DriveChangePurpose> purpose, WorkstreamService workstreamService, WorkstreamDataService wsDataService, EntityConfigService entityConfigService, EntityService entityService, KafkaConsumerContext kafkaConsumerContext) {
        this._triggers = triggers;
        this._ownerId = ownerId;
        this._changePurpose = purpose;
        this._workstreamService = workstreamService;
        this._wsDataService = wsDataService;
        this._entityConfigService = entityConfigService;
        this._entityService = entityService;
        this._changeDate = changeDate;
        this._kafkaConsumerContext = kafkaConsumerContext;
    }

    @Override
    public Object visitDefault(ItemId i) {
        return this;
    }

    @Override
    public Object visit(WorkstreamMessageId workstreamMessageId) {
        DBWorkstreamMessage wsMessage = (DBWorkstreamMessage)this._wsDataService.getEntries((Set<WorkstreamMessageId>)ImmutableSet.of((Object)workstreamMessageId)).get((Object)workstreamMessageId);
        if (wsMessage == null || wsMessage.getOriginItemId() == null) {
            return this;
        }
        this.processTrigger(wsMessage.getOriginItemId(), true);
        return this;
    }

    @Override
    public Object visit(EntityId entityId) {
        DBEntity entity = this._entityService.getById(entityId);
        if (entity == null || this._entityConfigService.releaseProcessMandatory(entity.getType())) {
            return this;
        }
        this.processTrigger(entityId, false);
        return this;
    }

    private void processTrigger(ItemId itemId, boolean suppressFirstVersionMessage) {
        for (JsonNode triggerNode : this._triggers) {
            JsonNode docIdNode = triggerNode.path("documentId");
            if (docIdNode.isMissingNode()) {
                LOGGER.warn("Received a trigger node without 'documentId': " + triggerNode.toString());
                continue;
            }
            DriveDocumentId documentId = new DriveDocumentId(docIdNode.asText());
            switch (triggerNode.path("type").asText()) {
                case "NEW_FILE": {
                    this.newFile(itemId, triggerNode, documentId, suppressFirstVersionMessage);
                    break;
                }
                case "DELETED_FILE": {
                    ImmutableSet messageIds = this._wsDataService.getMessagesForTypeAndSubject((Set<WorkstreamMessageType>)ImmutableSet.of((Object)WorkstreamMessageType.DRIVE_DOCUMENT_NEW_VERSION, (Object)WorkstreamMessageType.DRIVE_DOCUMENT_COMMENT), (Set<? extends ItemId>)ImmutableSet.of((Object)documentId)).keySet();
                    this.delete((Set<WorkstreamMessageId>)messageIds);
                }
            }
        }
    }

    private void newFile(ItemId itemId, JsonNode triggerNode, DriveDocumentId documentId, boolean suppressFirstVersionMessage) {
        int version = triggerNode.path("version").asInt();
        if (NO_ACTIVITIY_PURPOSES.contains(this._changePurpose.orElse(null)) || suppressFirstVersionMessage && version < 2) {
            return;
        }
        String name = triggerNode.path("name").asText();
        ImmutableMap<WorkstreamMessageId, DBWorkstreamMessage> existingMessages = this._wsDataService.getMessagesForTypeSubjectAndAttribute(WorkstreamMessageType.DRIVE_DOCUMENT_NEW_VERSION, documentId, "document_version", String.valueOf(version));
        Date changeDate = Optional.ofNullable(triggerNode.get("changeDate")).map(JsonNode::asText).map(String::trim).map(Strings::emptyToNull).map(arg_0 -> ((DateTimeFormatter)ISODateTimeFormat.dateTimeParser().withOffsetParsed()).parseDateTime(arg_0)).map(AbstractInstant::toDate).orElseGet(() -> this._changeDate.map(AbstractInstant::toDate).orElse(null));
        PersonId ownerId = Optional.ofNullable(triggerNode.get("ownerId")).map(JsonNode::asLong).map(PersonId::valueOf).orElseGet(() -> this._ownerId.orElse(null));
        if (ownerId == null || changeDate == null) {
            LOGGER.warn("no ownerId or changeDate for drive change trigger {}", (Object)triggerNode);
            return;
        }
        Optional<WorkstreamMessageId> exactCopy = existingMessages.values().stream().filter(m -> Objects.equal((Object)m.getAuthorId(), (Object)ownerId.asProfileId()) && Objects.equal((Object)m.getOriginItemId(), (Object)itemId) && Objects.equal((Object)m.getCreateDate(), (Object)changeDate) && Objects.equal((Object)m.getModifyDate(), (Object)changeDate) && Objects.equal((Object)m.getAttribute("document_name"), (Object)name)).map(DBWorkstreamMessage::getId).findFirst();
        if (exactCopy.isPresent()) {
            this.delete(Sets.filter((Set)existingMessages.keySet(), id -> !((WorkstreamMessageId)exactCopy.get()).equals(id)));
        } else {
            this.delete((Set<WorkstreamMessageId>)existingMessages.keySet());
            DriveDocumentNewVersion documentNew = new DriveDocumentNewVersion(ownerId, itemId, documentId, name, version, changeDate);
            this._workstreamService.addMessageToStream(documentNew, EverythingAllowedAuthorizationCheckContextWithLocale.EN);
        }
    }

    private void delete(Set<WorkstreamMessageId> toDelete) {
        if (toDelete.isEmpty()) {
            return;
        }
        DeleteTransactionCallback callback = this._wsDataService.deleteEntriesByIds(toDelete);
        this._kafkaConsumerContext.afterCommit(callback::afterCommit);
    }
}

