/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.business.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.IdParseException;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.drive.business.model.DriveChangePurpose;
import de.justsoftware.onx.kafka.AbstractKafkaConsumer;
import de.justsoftware.onx.kafka.KafkaConfigurationProvider;
import de.justsoftware.onx.kafka.KafkaConsumerContext;
import de.justsoftware.onx.workstream.business.DriveChangeWorkstreamMessageCreatorFactory;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class DriveActivityMessageGenerator
extends AbstractKafkaConsumer<String, String> {
    private static final String TOPIC = "just.drive.changes";
    private static final Logger LOGGER = LoggerFactory.getLogger(DriveActivityMessageGenerator.class);
    private static final int MAX_CHUNK_SIZE = 10;
    private final DriveChangeWorkstreamMessageCreatorFactory _messageCreatorFactory;

    @Autowired
    public DriveActivityMessageGenerator(TransactionHelper transactionHelper, KafkaConfigurationProvider kafkaConfigurationProvider, DriveChangeWorkstreamMessageCreatorFactory messageCreatorFactory) {
        super(kafkaConfigurationProvider.stringConsumer("just.toro.DriveActivityGenerator", 10), transactionHelper, TOPIC);
        this._messageCreatorFactory = messageCreatorFactory;
    }

    @Override
    protected Logger getLog() {
        return LOGGER;
    }

    @Override
    protected void process(ConsumerRecords<String, String> records, KafkaConsumerContext kafkaConsumerContext) {
        for (ConsumerRecord record : records) {
            this.process((ConsumerRecord<String, String>)record, kafkaConsumerContext);
        }
    }

    @Override
    private void process(ConsumerRecord<String, String> record, KafkaConsumerContext kafkaConsumerContext) {
        ItemId itemId;
        String value = (String)record.value();
        LOGGER.debug((String)record.key() + ": " + value);
        if (value == null) {
            return;
        }
        JsonNode json = this.parseJson(value);
        if (json == null) {
            LOGGER.warn("unable to parse json: {}", (Object)value);
            return;
        }
        Optional<PersonId> ownerId = DriveActivityMessageGenerator.parseString(json, "ownerId").toJavaUtil().map(PersonId::parse);
        try {
            itemId = ItemId.parseSafe((String)DriveActivityMessageGenerator.parseString(json, "itemId").orNull());
        }
        catch (IdParseException e) {
            LOGGER.warn("Missing itemId: {}", (Object)json);
            return;
        }
        if (itemId == null) {
            LOGGER.warn("Missing itemId: {}", (Object)json);
            return;
        }
        com.google.common.base.Optional<DateTime> changeDate = DriveActivityMessageGenerator.parseDate(json, "changeDate");
        JsonNode triggerNode = json.path("triggers");
        if (!triggerNode.isArray()) {
            LOGGER.warn("Got change with invalid/missing triggers: {}", (Object)json);
            return;
        }
        com.google.common.base.Optional<DriveChangePurpose> purpose = DriveActivityMessageGenerator.parseChangePurpose(json, "purpose");
        itemId.accept(this._messageCreatorFactory.makeMessageCreator((ArrayNode)triggerNode, ownerId, changeDate.toJavaUtil(), purpose.toJavaUtil(), kafkaConsumerContext));
    }
}

