/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.business.impl;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.AlbumCreated;
import de.justsoftware.onx.workstream.shared.model.messages.AlbumImageCreated;
import de.justsoftware.onx.workstream.shared.model.messages.DriveDocumentComment;
import de.justsoftware.onx.workstream.shared.model.messages.DriveDocumentNewVersion;
import de.justsoftware.onx.workstream.shared.model.messages.EntityCreated;
import de.justsoftware.onx.workstream.shared.model.messages.EntityDescriptionUpdated;
import de.justsoftware.onx.workstream.shared.model.messages.EntityNewMembership;
import de.justsoftware.onx.workstream.shared.model.messages.EntityParentsChanged;
import de.justsoftware.onx.workstream.shared.model.messages.EntityVersionPublished;
import de.justsoftware.onx.workstream.shared.model.messages.ImageCommented;
import de.justsoftware.onx.workstream.shared.model.messages.MessageVisitor;
import de.justsoftware.onx.workstream.shared.model.messages.MicroblogPosting;
import de.justsoftware.onx.workstream.shared.model.messages.SurveyPublished;
import de.justsoftware.onx.workstream.shared.model.messages.VideolinkCommented;
import de.justsoftware.onx.workstream.shared.model.messages.VideolinkCreated;
import de.justsoftware.onx.workstream.shared.model.messages.WikiVersionCreated;
import de.justsoftware.onx.workstream.shared.model.messages.WorkstreamMessage;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class DBWorkstreamMessageCreator
implements MessageVisitor<DBWorkstreamMessage> {
    public static final DBWorkstreamMessageCreator INSTANCE = new DBWorkstreamMessageCreator();

    private DBWorkstreamMessageCreator() {
    }

    @CheckForNull
    private static String toAttributeValue(@Nullable GlobalId globalId) {
        return globalId == null ? null : globalId.asString();
    }

    @Nonnull
    private DBWorkstreamMessage generateBaseData(@Nonnull WorkstreamMessage msg) {
        DBWorkstreamMessage dbMsg = new DBWorkstreamMessage();
        dbMsg.setCreateDate(msg.getCreatedAt());
        dbMsg.setPublishDate(msg.getPublishedAt());
        dbMsg.setPublished(msg.getPublishedAt() != null);
        dbMsg.setModifyDate(msg.getModifiedAt());
        dbMsg.setAuthorId(msg.getAuthorId().asProfileId());
        dbMsg.setOriginItemId(msg.getOriginId());
        dbMsg.setSubjectItemId(msg.getOriginId());
        dbMsg.setType(msg.getType());
        return dbMsg;
    }

    @Override
    public DBWorkstreamMessage visitEntityCreated(EntityCreated m) {
        DBWorkstreamMessage msg = this.generateBaseData(m);
        return msg;
    }

    @Override
    public DBWorkstreamMessage visitEntityNewMembership(EntityNewMembership m) {
        DBWorkstreamMessage msg = this.generateBaseData(m);
        return msg;
    }

    @Override
    public DBWorkstreamMessage visitMicroblogPosting(MicroblogPosting m) {
        DBWorkstreamMessage msg = this.generateBaseData(m);
        msg.setAttribute("text", Strings.nullToEmpty((String)m.getText()));
        msg.setAttribute("title", Strings.nullToEmpty((String)m.getTitle()));
        msg.setAttribute("quill_delta", Strings.nullToEmpty((String)m.getQuillDelta()));
        return msg;
    }

    @Override
    public DBWorkstreamMessage visitAlbumCreated(AlbumCreated m) {
        DBWorkstreamMessage msg = this.generateBaseData(m);
        msg.setAttribute("album_id", DBWorkstreamMessageCreator.toAttributeValue(m.getAlbumId()));
        return msg;
    }

    @Override
    public DBWorkstreamMessage visitAlbumImageCreated(AlbumImageCreated m) {
        DBWorkstreamMessage msg = this.generateBaseData(m);
        msg.setSubjectItemId(m.getImageId());
        msg.setAttribute("album_id", DBWorkstreamMessageCreator.toAttributeValue(m.getAlbumId()));
        msg.setAttribute("image_id", DBWorkstreamMessageCreator.toAttributeValue(m.getImageId()));
        return msg;
    }

    @Override
    public DBWorkstreamMessage visitWikiVersionCreated(WikiVersionCreated m) {
        DBWorkstreamMessage db = this.generateBaseData(m);
        db.setAttribute("version", "" + m.getVersion());
        return db;
    }

    @Override
    public DBWorkstreamMessage visitVideolinkCreated(VideolinkCreated m) {
        DBWorkstreamMessage db = this.generateBaseData(m);
        db.setSubjectItemId(m.getVideolinkId());
        db.setAttribute("video_id", DBWorkstreamMessageCreator.toAttributeValue(m.getVideolinkId()));
        return db;
    }

    @Override
    public DBWorkstreamMessage visitVideolinkCommented(VideolinkCommented m) {
        DBWorkstreamMessage db = this.generateBaseData(m);
        db.setSubjectItemId(m.getVideolinkId());
        db.setAttribute("video_id", DBWorkstreamMessageCreator.toAttributeValue(m.getVideolinkId()));
        return db;
    }

    @Override
    public DBWorkstreamMessage visitImageCommented(ImageCommented m) {
        DBWorkstreamMessage db = this.generateBaseData(m);
        db.setSubjectItemId(m.getImageId());
        db.setAttribute("image_id", DBWorkstreamMessageCreator.toAttributeValue(m.getImageId()));
        return db;
    }

    @Override
    public DBWorkstreamMessage visitEntityDescriptionUpdated(EntityDescriptionUpdated m) {
        return this.generateBaseData(m);
    }

    @Override
    public DBWorkstreamMessage visitEntityVersionPublished(EntityVersionPublished m) {
        DBWorkstreamMessage db = this.generateBaseData(m);
        db.setAttribute("CHANGE_MESSAGE_KEY", m.getChangeMessage());
        db.setAttribute("VERSION_KEY", m.getVersionString());
        db.setAttribute("VERSION_ID_KEY", DBWorkstreamMessageCreator.toAttributeValue(m.getVersionId()));
        return db;
    }

    @Override
    public DBWorkstreamMessage visit(EntityParentsChanged msg) {
        DBWorkstreamMessage dbMsg = this.generateBaseData(msg);
        String newParentIds = Joiner.on((String)",").join(Iterables.transform(msg.getNewParents(), (Function)new Function<EntityId, String>(){

            public String apply(EntityId input) {
                return Long.toString(input.getId());
            }
        }));
        dbMsg.setAttribute("new_parent_ids", newParentIds);
        return dbMsg;
    }

    @Override
    public DBWorkstreamMessage visitSurveyPublished(SurveyPublished m) {
        DBWorkstreamMessage msg = this.generateBaseData(m);
        msg.setAttribute("survey_id", DBWorkstreamMessageCreator.toAttributeValue(m.getSurveyId()));
        return msg;
    }

    @Override
    public DBWorkstreamMessage visitDriveDocumentNewVersion(DriveDocumentNewVersion m) {
        DBWorkstreamMessage msg = this.generateBaseData(m);
        msg.setSubjectItemId(m.getDocumentId());
        msg.setAttribute("document_name", m.getDocumentName());
        msg.setAttribute("document_version", Integer.toString(m.getVersion()));
        return msg;
    }

    @Override
    public DBWorkstreamMessage visitDriveDocumentComment(DriveDocumentComment m) {
        DBWorkstreamMessage msg = this.generateBaseData(m);
        msg.setSubjectItemId(m.getDocumentId());
        msg.setAttribute("document_name", m.getDocumentName());
        return msg;
    }
}

